/*
 * Decompiled with CFR 0.152.
 */
package socket_server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import mailcost_main.Gui_PanelProject;
import mailcost_main.Tool_JTable_IO;
import message.Tool_SendList_IO;
import socket_common.Cost_Send;
import socket_common.Mail_Send;
import socket_common.Recieve;
import socket_server.Server_MasterSend;
import structure.File_and_Directory_Address;
import structure.Struct_Connect_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Entry_Project;
import structure.Struct_MasterFile;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_MasterFile_IO;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Server_socket {
    Socket sock = null;
    InputStream in = null;
    OutputStream out = null;
    private Tool_User_IO user_info;
    private Struct_User su;
    private File_and_Directory_Address addr = new File_and_Directory_Address();
    private Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    private Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    private byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];
    private byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    private int j;
    private int k;
    private boolean blnswitch = true;

    public Server_socket(Socket sock) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "socket open");
        this.sock = sock;
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "+++ Conected Information+++");
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "source      Address" + sock.getLocalAddress() + " on Port" + sock.getLocalPort());
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "destination Address" + sock.getInetAddress() + " on Port" + sock.getPort());
        try {
            this.in = sock.getInputStream();
            this.out = sock.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    public void start() {
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "start");
        short code = this.first_Contact();
        if (code < 0) {
            this.close();
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "000 or 050 connection Error");
            return;
        }
        if (code == 0) {
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "000 connection OK");
            this.conection_Answer((short)100);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "000->100 sended client-connection request anser OK ");
            Recieve rcv = new Recieve(this.sock, this.in, this.out);
            if (!rcv.submit()) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Recieve Error");
                this.close();
            }
        } else if (code == 50) {
            Server_MasterSend sms;
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "050 connection OK");
            this.conection_Answer((short)150);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "050->150 sended client-connection request anser OK ");
            Struct_Connect_Digest scnd = this.attestation_Answer();
            if (scnd == null) {
                this.close();
                this.blnswitch = false;
                return;
            }
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "client request user=" + scnd.getSender() + "project=" + scnd.getProject() + "lastupdate=" + scnd.getLastupdate());
            boolean masterupdate = false;
            Tool_MasterFile_IO tmf = new Tool_MasterFile_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_master());
            if (!tmf.loadXml()) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master File Access Error");
                this.close();
                return;
            }
            Struct_MasterFile smf = tmf.getSmf();
            if (smf == null || smf.getMasterdir() == null || smf.getMasterdir().length() == 0) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Dir Error");
                this.close();
                return;
            }
            String masterdir = smf.getMasterdir();
            if (scnd.isFirstproject()) {
                sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_config(), scnd.getLastupdate());
                if (sms.sendcheck()) {
                    this.conection_Answer((short)151, (short)2);
                    if (!sms.submit()) {
                        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                        this.close();
                        return;
                    }
                    masterupdate = true;
                }
                this.sleep();
                sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_eval_rank(), scnd.getLastupdate());
                if (sms.sendcheck()) {
                    this.conection_Answer((short)151, (short)2);
                    if (!sms.submit()) {
                        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                        this.close();
                        return;
                    }
                    masterupdate = true;
                }
                this.sleep();
                sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_position(), scnd.getLastupdate());
                if (sms.sendcheck()) {
                    this.conection_Answer((short)151, (short)2);
                    if (!sms.submit()) {
                        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                        this.close();
                        return;
                    }
                    masterupdate = true;
                }
                this.sleep();
                sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_pos_cost(), scnd.getLastupdate());
                if (sms.sendcheck()) {
                    this.conection_Answer((short)151, (short)2);
                    if (!sms.submit()) {
                        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                        this.close();
                        return;
                    }
                    masterupdate = true;
                }
                this.sleep();
                sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_business_year_days(), scnd.getLastupdate());
                if (sms.sendcheck()) {
                    this.conection_Answer((short)151, (short)2);
                    if (!sms.submit()) {
                        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                        this.close();
                        return;
                    }
                    masterupdate = true;
                }
                this.sleep();
            }
            if ((sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_com_all(), scnd.getLastupdate())).sendcheck()) {
                this.conection_Answer((short)151, (short)2);
                if (!sms.submit()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                    this.close();
                    return;
                }
                masterupdate = true;
            }
            this.sleep();
            boolean com_menber = false;
            sms = new Server_MasterSend(this.sock, this.in, this.out, String.valueOf(masterdir) + this.addr.getFile_com_menber(), scnd.getLastupdate());
            if (sms.sendcheck()) {
                com_menber = true;
                this.conection_Answer((short)151, (short)2);
                if (!sms.submit()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                    this.close();
                    return;
                }
                masterupdate = true;
            }
            this.sleep();
            if (com_menber) {
                long nowtime = System.currentTimeMillis();
                SimpleDateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
                String tempDir = "temp" + dfm.format(nowtime);
                if (!new File(String.valueOf(this.addr.getDir_current()) + tempDir).mkdir()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Community_select Temporary Directry Make Error");
                    this.close();
                    return;
                }
                String filepath = String.valueOf(this.addr.getDir_current()) + tempDir + this.addr.getFs() + this.addr.getFile_com_select();
                sms = new Server_MasterSend(this.sock, this.in, this.out, filepath, 0L);
                if (!sms.entryCommunityMake(masterdir, scnd.getProject(), scnd.getSender())) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Community_select Make Error");
                    new Tool_DirDel(String.valueOf(this.addr.getDir_current()) + tempDir).delete();
                    this.close();
                    return;
                }
                this.conection_Answer((short)151, (short)2);
                if (!sms.submit()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                    new Tool_DirDel(String.valueOf(this.addr.getDir_current()) + tempDir).delete();
                    this.close();
                    return;
                }
                new Tool_DirDel(String.valueOf(this.addr.getDir_current()) + tempDir).delete();
            }
            if (masterupdate) {
                Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(String.valueOf(masterdir) + this.addr.getFile_project_info());
                tep.loadXml();
                ArrayList array_project = tep.getdata();
                this.conection_Answer((short)151, (short)2);
                if (!this.send_timestamp((short)61, ((Struct_Entry_Project)array_project.get(0)).getLastupdate())) {
                    return;
                }
            }
            this.sleep();
            this.conection_Answer((short)151, (short)255);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "051->151 sended NO Data");
            this.sleep();
            String dir = String.valueOf(this.addr.getDir_current()) + this.addr.getDir_buff_relay();
            File fl = new File(dir);
            Tool_FileFilter ff = new Tool_FileFilter();
            ff.setSuffix(this.addr.getFile_digest());
            File[] files = fl.listFiles(ff);
            int i = 0;
            while (i < files.length) {
                byte sendkind = this.sendkind(files[i].getName());
                if (sendkind == 1) {
                    Tool_SendList_IO slm = new Tool_SendList_IO(files[i].getPath());
                    slm.loadXml();
                    int j = 0;
                    while (j < slm.datacount()) {
                        Struct_SendList data = slm.getdata(j);
                        if (!data.isSendend() && data.getTarget_user().equals(scnd.getSender()) && data.getTarget_project().equals(scnd.getProject())) {
                            this.conection_Answer((short)151, (short)1);
                            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "051->151 sended attestation anser OK ");
                            Mail_Send ms = new Mail_Send(this.sock, this.in, this.out, data, true, dir);
                            if (!ms.submit()) {
                                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Send Error");
                                this.close();
                                this.blnswitch = false;
                                return;
                            }
                            data.setSendend(true);
                            long nowtime = System.currentTimeMillis();
                            data.setSend_date(DateFormat.getDateTimeInstance().format(nowtime));
                            slm.putdata(data, j);
                            slm.saveXml_direct();
                        }
                        ++j;
                    }
                    if (slm.isAllSend()) {
                        File delfile = new File(slm.deleteFile(true));
                        if (!delfile.delete()) {
                            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + delfile.getAbsolutePath());
                        }
                        if (!files[i].delete()) {
                            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + files[i].getAbsolutePath());
                        }
                    }
                } else if (sendkind == 2) {
                    Tool_Cost_SendList_IO cslm = new Tool_Cost_SendList_IO(files[i].getPath());
                    cslm.loadXml();
                    Struct_Cost_SendList data = cslm.getdata();
                    if (data.getTarget_user().equals(scnd.getSender())) {
                        this.conection_Answer((short)151, (short)1);
                        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "051->151 sended attestation anser OK ");
                        Cost_Send cs = new Cost_Send(this.sock, this.in, this.out, data, true, dir);
                        if (!cs.submit()) {
                            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Send Error");
                            this.close();
                            this.blnswitch = false;
                            return;
                        }
                        File delfile = new File(String.valueOf(dir) + this.addr.getFs() + data.getFilename());
                        if (!delfile.delete()) {
                            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + delfile.getAbsolutePath());
                        }
                        if (!files[i].delete()) {
                            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + files[i].getAbsolutePath());
                        }
                    }
                }
                ++i;
            }
            this.conection_Answer((short)151, (short)255);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "051->151 sended NO Data");
        }
        this.blnswitch = false;
    }

    public short first_Contact() {
        try {
            this.k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            this.blnswitch = false;
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return -1;
        }
        if (this.k < 5) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Nothing Data Error");
            return -1;
        }
        short code = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != 0 && code != 50) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Code is Not 000 Error. code=" + code);
            return -1;
        }
        short len = (short)((this.buf_receive[2] << 8 & 0xFF00) + (this.buf_receive[3] & 0xFF));
        if (this.k - 4 != len) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Data Length Unmatch Error. info Length=" + len + " Real Length=" + (this.k - 4));
            return -1;
        }
        String userid = new String(this.buf_receive, 4, (int)len);
        this.user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        this.su = this.user_info.getStruct_User();
        String userown = this.su.getUserid();
        if (userown.equals(userid)) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:User Check OK");
            return code;
        }
        this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Confermation User Check NG");
        this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact: My  UserID=" + userown);
        this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact: Req UserID=" + userid);
        return -1;
    }

    public void conection_Answer(short code) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF)};
        this.send_Byte(send);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "Send Answer code:" + code);
    }

    public void conection_Answer(short code, short kind) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF), (byte)(kind >>> 8 & 0xFF), (byte)(kind >>> 0 & 0xFF)};
        this.send_Byte(send);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "Send Answer code:" + code + " kind:" + kind);
    }

    public void close() {
        this.blnswitch = false;
        try {
            this.sock.close();
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "socket close OK");
        }
        catch (IOException e) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "socket close NG");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            e.printStackTrace();
        }
    }

    public boolean getblnswitch() {
        return this.blnswitch;
    }

    public boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_Byte start");
        this.j = byte_send.length;
        try {
            this.out.write(byte_send, 0, this.j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_Byte end");
        return true;
    }

    public Struct_Connect_Digest attestation_Answer() {
        try {
            this.k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Second Contact:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return null;
        }
        if (this.k < 5) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Second Contact:Nothing Data Error");
            return null;
        }
        short code = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != 51) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "attestation Contact:Code is Not 051 Error. code=" + code);
            return null;
        }
        int len = (this.buf_receive[2] << 8 & 0xFF00) + (this.buf_receive[3] & 0xFF);
        if (this.k - 4 != len) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "attestation Contact:Data Length Unmatch Error. info Length=" + len + " Real Length=" + (this.k - 4));
            return null;
        }
        byte[] data = new byte[len];
        int j = 0;
        while (j < len) {
            data[j] = this.buf_receive[j + 4];
            ++j;
        }
        Struct_Connect_Digest scm = new Struct_Connect_Digest();
        scm.putByte(data);
        String project = scm.getProject();
        String userid = scm.getSender();
        long lastupdate = scm.getLastupdate();
        Gui_PanelProject pp = new Gui_PanelProject("nopanel");
        ArrayList ppl = pp.getProject();
        if (ppl.indexOf(project) == -1) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "attestation Contact:Target Project is not Entry project:" + project);
            return null;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "attestation Contact:Target Project is Entry project:" + project);
        String filename = String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getFile_com_menber();
        Tool_JTable_IO tc = new Tool_JTable_IO(filename);
        String[] columnames = new String[]{"\u30b3\u30df\u30e5\u30cb\u30c6\u30a3\u540d", "USER", "\u30e6\u30fc\u30b6\u30fc", "NODE"};
        tc.putColum(columnames);
        tc.loadXml();
        DefaultTableModel model = tc.getDefaultTableModele();
        int i = 0;
        while (i < model.getRowCount()) {
            if (model.getValueAt(i, 1).equals(userid)) {
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "attestation Contact:Check Target Project and User OK!");
                return scm;
            }
            ++i;
        }
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "attestation Contact:Check Target Project and User NG!");
        return null;
    }

    private byte sendkind(String filename) {
        if (filename.substring(0, 1).equals("C")) {
            return 2;
        }
        return 1;
    }

    private boolean send_timestamp(short code, long timestamp) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF), (byte)(timestamp >>> 56 & 0xFFL), (byte)(timestamp >>> 48 & 0xFFL), (byte)(timestamp >>> 40 & 0xFFL), (byte)(timestamp >>> 32 & 0xFFL), (byte)(timestamp >>> 24 & 0xFFL), (byte)(timestamp >>> 16 & 0xFFL), (byte)(timestamp >>> 8 & 0xFFL), (byte)(timestamp >>> 0 & 0xFFL)};
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "sended timestamp  code=" + code + " timestamp=" + timestamp);
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

