/*
 * Decompiled with CFR 0.152.
 */
package socket_client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import message.Tool_SendList_IO;
import socket_common.Mail_Send;
import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_Entry_Project;
import structure.Struct_Relay_Node;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import tool.Tool_Community_Diject_Status_Update;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client_Mail_Send {
    Socket sock = null;
    InputStream in = null;
    OutputStream out = null;
    String mode;
    String dir;
    String suffix;
    boolean send_direct;
    boolean send_direct_option;
    boolean send_direct_option_relay;
    boolean send_direct_option_server;
    ArrayList<Struct_Relay_Node> asrn;
    boolean relay;
    boolean server;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];

    public Client_Mail_Send(String mode, String dir, String suffix, boolean send_direct, boolean send_direct_option, boolean send_direct_option_relay, boolean send_direct_option_server, ArrayList<Struct_Relay_Node> asrn, boolean relay, boolean server) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.mode = mode;
        this.dir = dir;
        this.suffix = suffix;
        this.send_direct = send_direct;
        this.send_direct_option = send_direct_option;
        this.send_direct_option_relay = send_direct_option_relay;
        this.send_direct_option_server = send_direct_option_server;
        this.asrn = asrn;
        this.relay = relay;
        this.server = server;
    }

    public void mailsend(File fl, String filepath, Tool_FileFilter ff, File[] files, int i) {
        Tool_SendList_IO slm = new Tool_SendList_IO(filepath);
        slm.loadXml();
        int j = 0;
        while (j < slm.datacount()) {
            Struct_SendList data = slm.getdata(j);
            if (!data.isSendend()) {
                Mail_Send ms;
                int s;
                String node = new String();
                String userid = new String();
                boolean node_connect_success = false;
                boolean direct = true;
                if (this.relay) {
                    if (!this.server) {
                        node = data.getTarget_node();
                        if (this.node_connect(node, userid = data.getTarget_user())) {
                            node_connect_success = true;
                            direct = true;
                        }
                    } else {
                        Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
                        t.loadXml();
                        ArrayList array_Entry_Project = t.getdata();
                        s = 0;
                        while (s < array_Entry_Project.size()) {
                            if (((Struct_Entry_Project)array_Entry_Project.get(s)).getProject().equals(data.getTarget_project())) {
                                node = ((Struct_Entry_Project)array_Entry_Project.get(s)).getIp_address();
                            }
                            if (this.node_connect(node, userid = ((Struct_Entry_Project)array_Entry_Project.get(s)).getUserid())) {
                                node_connect_success = true;
                                direct = false;
                                break;
                            }
                            ++s;
                        }
                    }
                } else if (this.send_direct) {
                    node = data.getTarget_node();
                    if (this.node_connect(node, userid = data.getTarget_user())) {
                        node_connect_success = true;
                        direct = true;
                    } else if (this.send_direct_option) {
                        if (this.send_direct_option_relay) {
                            int k = 0;
                            while (k < this.asrn.size()) {
                                if (this.asrn.get(k).getProject().equals(data.getTarget_project()) && this.node_connect(node = this.asrn.get(k).getNode(), userid = this.asrn.get(k).getUserid())) {
                                    node_connect_success = true;
                                    direct = false;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (!node_connect_success && this.send_direct_option_server) {
                            Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
                            t.loadXml();
                            ArrayList array_Entry_Project = t.getdata();
                            s = 0;
                            while (s < array_Entry_Project.size()) {
                                if (((Struct_Entry_Project)array_Entry_Project.get(s)).getProject().equals(data.getTarget_project()) && this.node_connect(node = ((Struct_Entry_Project)array_Entry_Project.get(s)).getIp_address(), userid = ((Struct_Entry_Project)array_Entry_Project.get(s)).getUserid())) {
                                    node_connect_success = true;
                                    direct = false;
                                    break;
                                }
                                ++s;
                            }
                        }
                    }
                } else if (!this.send_direct) {
                    int k = 0;
                    while (k < this.asrn.size()) {
                        if (this.asrn.get(k).getProject().equals(data.getTarget_project()) && this.node_connect(node = this.asrn.get(k).getNode(), userid = this.asrn.get(k).getUserid())) {
                            node_connect_success = true;
                            direct = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (node_connect_success && (ms = new Mail_Send(this.sock, this.in, this.out, data, direct, this.dir)).submit()) {
                    this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "client socket close");
                    if (this.close()) {
                        data.setSendend(true);
                        long nowtime = System.currentTimeMillis();
                        data.setSend_date(DateFormat.getDateTimeInstance().format(nowtime));
                        slm.putdata(data, j);
                        slm.saveXml_direct();
                    }
                }
            }
            ++j;
        }
        if (slm.isAllSend()) {
            Struct_SendList ss = slm.getdata(0);
            Struct_Community_Digest scd = ss.getScd();
            String project = scd.getProject();
            String community = scd.getCommunity();
            long sendtime = scd.getSendnumber_integer();
            int sendnumber = scd.getSendnumber_integer();
            File delfile = new File(slm.deleteFile(this.relay));
            if (!delfile.delete()) {
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + delfile.getAbsolutePath());
            }
            if (!files[i].delete()) {
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "File delete failed:" + files[i].getAbsolutePath());
            }
            if (this.mode.equals("all")) {
                String flpth = files[i].getPath();
                int index_start = flpth.lastIndexOf("_");
                int index_end = flpth.length() - 1;
                String fl_suffix = flpth.substring(index_start, index_end);
                index_end = this.addr.getFile_BCCdigest().equals(fl_suffix) ? flpth.lastIndexOf(this.addr.getFile_BCCdigest()) - 2 : flpth.lastIndexOf(this.addr.getFile_digest()) - 2;
                String prefix_other = flpth.substring(0, index_end);
                Tool_FileFilter ff2 = new Tool_FileFilter();
                ff2.setPrefix(prefix_other);
                ff2.setSuffix(this.suffix);
                if (fl.listFiles(ff).length == 0) {
                    new Tool_Community_Diject_Status_Update(project, community, sendtime, sendnumber).sendCheck();
                }
            }
        }
    }

    public boolean conection_Recept(short code) {
        int k;
        try {
            this.sock.setSoTimeout(this.sysconfig.getTimer_out());
            k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        if (k < 0) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Time Out Error ");
            return false;
        }
        if (k != 2) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Data Length is not 2. length:" + k);
            return false;
        }
        short cd = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != cd) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Code Error code:" + cd + " request code:" + code);
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "First Contact OK");
        return true;
    }

    public boolean open(String ipadr) {
        try {
            this.sock = new Socket(ipadr, this.sysconfig.getPort());
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "+++ Conect Request Information++");
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "source      Address" + this.sock.getLocalAddress() + " on Port" + this.sock.getLocalPort());
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "destination Address" + this.sock.getInetAddress() + " on Port" + this.sock.getPort());
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (UnknownHostException e) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093");
            return false;
        }
        catch (IOException e) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093");
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f");
        return true;
    }

    public boolean close() {
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "+++ Conect off Information++");
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "source      Address" + this.sock.getLocalAddress() + " on Port" + this.sock.getLocalPort());
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "destination Address" + this.sock.getInetAddress() + " on Port" + this.sock.getPort());
        try {
            this.sock.close();
        }
        catch (IOException e) {
            System.out.println("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30bd\u30b1\u30c3\u30c8 \u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc");
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "\u5207\u65ad\u3057\u307e\u3057\u305f");
        return true;
    }

    public boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send start");
        int j = byte_send.length;
        try {
            this.out.write(byte_send, 0, j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send end");
        return true;
    }

    public void conection_Answer(short code) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF)};
        this.send_Byte(send);
        System.out.println("\u63a5\u7d9a\u8981\u6c42\u56de\u7b54\uff1a" + code);
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    private boolean node_connect(String node, String userid) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "client socket open");
        if (!this.open(node)) {
            return false;
        }
        this.sleep();
        if (!this.conection_Request((short)0, userid)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "000 sended client-connection request OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "100 waiting client-connection-request anser");
        if (!this.conection_Recept((short)100)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "100 recieved client-connection-request anser OK");
        this.sleep();
        return true;
    }

    public boolean conection_Request(short code, String userid) {
        short i = (short)userid.length();
        byte[] send = new byte[i + 4];
        send[0] = (byte)(code >>> 8 & 0xFF);
        send[1] = (byte)(code >>> 0 & 0xFF);
        send[2] = (byte)(i >>> 8 & 0xFF);
        send[3] = (byte)(i >>> 0 & 0xFF);
        byte[] buff = userid.getBytes();
        int j = 0;
        while (j < buff.length) {
            send[j + 4] = buff[j];
            ++j;
        }
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "First Contact Request. code:" + code + " user:" + userid);
        return true;
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

