/*
 * Decompiled with CFR 0.152.
 */
package socket_client;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Client_MasterRecieve {
    Socket sock = null;
    InputStream in = null;
    OutputStream out = null;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    String file_separator = System.getProperty("file.separator");
    String fs = String.valueOf(this.file_separator) + this.file_separator;
    private byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];
    private byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    private int j;
    private int k;
    private String filename = null;
    private long lastupdate;
    private String project = null;
    boolean masterfound;

    public Client_MasterRecieve(Socket sock, InputStream in, OutputStream out, String project) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.sock = sock;
        this.in = in;
        this.out = out;
        this.project = project;
    }

    public boolean submit() {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "(060,061) waiting master-send-permission-request");
        Object answer = this.masterfile_Contact();
        if (answer instanceof Boolean) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "(060,061) connection Error");
            return false;
        }
        if (answer instanceof Long) {
            String newfilepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_project_info().replaceAll(this.fs, "");
            String filepath = new File(newfilepath).exists() ? String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info() : newfilepath;
            Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
            t.loadXml();
            ArrayList sep = t.getdata();
            int i = 0;
            while (i < sep.size()) {
                if (this.project.equals(((Struct_Entry_Project)sep.get(i)).getProject())) {
                    ((Struct_Entry_Project)sep.get(i)).setLastupdate((Long)answer);
                    break;
                }
                ++i;
            }
            t = new Tool_Entry_Project_IO(newfilepath);
            t.putdata(sep);
            t.saveXml();
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "061 Project TimeStamp Update complete");
            return true;
        }
        if (answer instanceof String) {
            String filepath;
            this.filename = (String)answer;
            this.conection_Answer((short)110);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "110 sended master-send-permission-request anser  OK");
            if (this.filename.equals(this.addr.getFile_config().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_config().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_eval_rank().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_eval_rank().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_position().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_position().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_pos_cost().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_pos_cost().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_business_year_days().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.fs + "new_" + this.addr.getFile_business_year_days().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_com_all().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + this.fs + this.project + this.fs + "new_" + this.addr.getFile_com_all().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_com_menber().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + this.fs + this.project + this.fs + "new_" + this.addr.getFile_com_menber().replaceAll(this.fs, "");
            } else if (this.filename.equals(this.addr.getFile_com_select().replaceAll(this.fs, ""))) {
                filepath = String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + this.fs + this.project + this.fs + "new_" + this.addr.getFile_com_select().replaceAll(this.fs, "");
            } else {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "No Master File Error file=" + this.filename);
                return false;
            }
            if (!this.recieve_file(filepath)) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "011 file recieve Error");
                return false;
            }
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "011 file recieve OK");
            this.sleep();
            this.conection_Answer((short)112);
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "112 sended masterfile-send-complete OK");
            return true;
        }
        return false;
    }

    public void conection_Answer(short code) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF)};
        this.send_Byte(send);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "Send Answer code:" + code);
    }

    public int getport() {
        return this.sock.getPort();
    }

    public Object masterfile_Contact() {
        try {
            this.k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Second Contact:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        if (this.k < 5) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:Nothing Data Error");
            return false;
        }
        short code = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code == 61) {
            byte[] timebyte = new byte[8];
            int i = 0;
            while (i < 8) {
                timebyte[i] = this.buf_receive[i + 2];
                ++i;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(timebyte);
            DataInputStream din = new DataInputStream(bin);
            long timestamp = 0L;
            try {
                timestamp = din.readLong();
            }
            catch (IOException e) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:timestamp Binary To long Error");
                return false;
            }
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:timestamp=" + timestamp);
            return timestamp;
        }
        if (code != 60) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:Code is Not 060 Error. code=" + code);
            return false;
        }
        int len = (this.buf_receive[2] << 8 & 0xFF00) + (this.buf_receive[3] & 0xFF);
        if (this.k - 4 != len) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:Data Length Unmatch Error. info Length=" + len + " Real Length=" + (this.k - 4));
            return false;
        }
        byte[] data = new byte[len];
        int j = 0;
        while (j < len) {
            data[j] = this.buf_receive[j + 4];
            ++j;
        }
        String masterfile = new String(data);
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Second Contact:MasterFile=" + masterfile);
        return masterfile;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean recieve_file(String str_recieve) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file start");
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(str_recieve);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "recieve_file:FileOutputStream error");
            return false;
        }
        int recvMsgSize = 0;
        int totalByte = 0;
        try {
            short code;
            short edaban_save = 1;
            recvMsgSize = this.in.read(this.buf_receive);
            while (true) {
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file:Packet Total Size=" + recvMsgSize);
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file:Real   Data  Size=" + (recvMsgSize - 6));
                code = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
                if (code != 11) break;
                int len = (this.buf_receive[2] << 8 & 0xFF00) + (this.buf_receive[3] & 0xFF);
                short edaban = (short)((this.buf_receive[4] << 8 & 0xFF00) + (this.buf_receive[5] & 0xFF));
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file:Data Size Info.  =" + len);
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file:recieve mail parts edaban_save=" + edaban);
                if (edaban != edaban_save) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "recieve_file:edaban miss match Error. real edaban=" + edaban + " vs request edaban=" + edaban_save);
                    fout.close();
                    return false;
                }
                if (recvMsgSize - 6 < len) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "recieve_file:DADA too short Error.  real size=" + (recvMsgSize - 6) + "  vs  info size=" + len);
                    fout.close();
                    return false;
                }
                byte[] data = new byte[len];
                int i = 0;
                while (i < len) {
                    data[i] = this.buf_receive[i + 6];
                    ++i;
                }
                totalByte += len;
                fout.write(data, 0, len);
                if (recvMsgSize - 6 == len) {
                    recvMsgSize = 0;
                    this.sleep();
                    recvMsgSize = this.in.read(this.buf_receive);
                    if (recvMsgSize == -1) {
                        return false;
                    }
                } else {
                    byte[] buf = this.buf_receive;
                    int Arrival = recvMsgSize - (len + 6);
                    int i2 = 0;
                    while (i2 < Arrival) {
                        this.buf_receive[i2] = buf[len + 6 + i2];
                        ++i2;
                    }
                    if (Arrival == 6) {
                        recvMsgSize = Arrival;
                        continue;
                    }
                    recvMsgSize = 0;
                    recvMsgSize = this.in.read(this.buf_receive, Arrival, this.sysconfig.getBuffsize() - Arrival);
                    if (recvMsgSize == -1) {
                        return false;
                    }
                    this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "Arrival ahead bytes :Size=" + Arrival);
                }
                edaban_save = (short)(edaban_save + 1);
            }
            if (code == 12) {
                int size = (this.buf_receive[2] << 24 & 0xFF00) + (this.buf_receive[3] << 16 & 0xFF00) + (this.buf_receive[4] << 8 & 0xFF00) + (this.buf_receive[5] & 0xFF);
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file:recieved mail. file size:" + size);
                if (totalByte != size) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "recieve_file:File Length Miss Match Error.  real size=" + totalByte + "  vs  info size=" + size);
                    return false;
                }
                fout.close();
                this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "recieve_file end");
                return true;
            }
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "recieve_file:Code is not 012 Error. code=" + code);
            fout.close();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
    }

    public boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_Byte start");
        this.j = byte_send.length;
        try {
            this.out.write(byte_send, 0, this.j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_Byte end");
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

