/*
 * Decompiled with CFR 0.152.
 */
package socket_client;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import socket_client.Client_MasterRecieve;
import socket_common.Recieve;
import structure.File_and_Directory_Address;
import structure.Struct_Connect_Digest;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Client_Recieve {
    Socket sock = null;
    InputStream in = null;
    OutputStream out = null;
    String project = null;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];

    public Client_Recieve(String project) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.project = project;
    }

    public void recieve() {
        Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
        tep.loadXml();
        Struct_Entry_Project sep = tep.getdata(tep.getLine(this.project));
        if (!this.node_connect(sep.getIp_address(), sep.getUserid())) {
            return;
        }
        Tool_User_IO user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        Struct_User su = user_info.getStruct_User();
        boolean firstproject = tep.getLine(this.project) == 0;
        short sendkind = this.node_Attestation(su.getUserid(), this.project, sep.getLastupdate(), firstproject);
        if (sendkind < 0) {
            return;
        }
        if (sendkind != 255) {
            do {
                Client_MasterRecieve cmr;
                if (sendkind == 2 && !(cmr = new Client_MasterRecieve(this.sock, this.in, this.out, sep.getProject())).submit()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Master Update Error");
                    this.close();
                    return;
                }
                sendkind = this.kind_Recept((short)151);
                if (sendkind >= 0) continue;
                this.close();
                return;
            } while (sendkind != 255);
        }
        if ((sendkind = this.kind_Recept((short)151)) < 0) {
            this.close();
            return;
        }
        if (sendkind != 255) {
            do {
                Recieve rcv;
                if (sendkind == 1 && !(rcv = new Recieve(this.sock, this.in, this.out)).submit()) {
                    this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Recieve Error");
                    this.close();
                    return;
                }
                sendkind = this.kind_Recept((short)151);
                if (sendkind >= 0) continue;
                this.close();
                return;
            } while (sendkind != 255);
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "client socket close");
        this.close();
    }

    public boolean conection_Recept(short code) {
        int k;
        try {
            this.sock.setSoTimeout(this.sysconfig.getTimer_out());
            k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        if (k < 0) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Time Out Error ");
            return false;
        }
        if (k != 2) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "First Contact:Data Length is not 2. length:" + k);
            return false;
        }
        short cd = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != cd) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Code unmatch.  wait code=" + code + "  send code=" + cd);
            return false;
        }
        return true;
    }

    public short kind_Recept(short code) {
        int k;
        try {
            this.sock.setSoTimeout(this.sysconfig.getTimer_out());
            k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "send kind recept:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return -1;
        }
        if (k < 0) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "send kind recept:Time Out Error ");
            return -1;
        }
        if (k != 4) {
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "send kind recept:Data Length is not 2. length:" + k);
            return -1;
        }
        short cd = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != cd) {
            System.out.println("\u30b3\u30fc\u30c9\u30a8\u30e9\u30fc:" + cd);
            return -1;
        }
        short kind = (short)((this.buf_receive[2] << 8 & 0xFF00) + (this.buf_receive[3] & 0xFF));
        System.out.println("\u8981\u6c42\u53d7\u4ed8\uff2f\uff2b\uff1a" + cd);
        return kind;
    }

    public boolean open(String ipadr) {
        try {
            this.sock = new Socket(ipadr, this.sysconfig.getPort());
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "+++ Conect Request Information++");
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "source      Address" + this.sock.getLocalAddress() + " on Port" + this.sock.getLocalPort());
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "destination Address" + this.sock.getInetAddress() + " on Port" + this.sock.getPort());
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (UnknownHostException e) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093");
            return false;
        }
        catch (IOException e) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093");
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "\u63a5\u7d9a\u8981\u6c42\u30ce\u30fc\u30c9\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f");
        return true;
    }

    public boolean close() {
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "+++ Conect off Information++");
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "source      Address" + this.sock.getLocalAddress() + " on Port" + this.sock.getLocalPort());
        this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "destination Address" + this.sock.getInetAddress() + " on Port" + this.sock.getPort());
        try {
            this.sock.close();
        }
        catch (IOException e) {
            System.out.println("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30bd\u30b1\u30c3\u30c8 \u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc");
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "\u5207\u65ad\u3057\u307e\u3057\u305f");
        return true;
    }

    public boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send start");
        int j = byte_send.length;
        try {
            this.out.write(byte_send, 0, j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send end");
        return true;
    }

    public void conection_Answer(short code) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF)};
        this.send_Byte(send);
        System.out.println("\u63a5\u7d9a\u8981\u6c42\u56de\u7b54\uff1a" + code);
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    private boolean node_connect(String node, String userid) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "client socket open");
        if (!this.open(node)) {
            return false;
        }
        this.sleep();
        if (!this.conection_Request((short)50, userid)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "050 sended client-connection request OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "150 waiting client-connection-request anser");
        if (!this.conection_Recept((short)150)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "150 recieved client-connection-request anser OK");
        this.sleep();
        return true;
    }

    public boolean conection_Request(short code, String userid) {
        short i = (short)userid.length();
        byte[] send = new byte[i + 4];
        send[0] = (byte)(code >>> 8 & 0xFF);
        send[1] = (byte)(code >>> 0 & 0xFF);
        send[2] = (byte)(i >>> 8 & 0xFF);
        send[3] = (byte)(i >>> 0 & 0xFF);
        byte[] buff = userid.getBytes();
        int j = 0;
        while (j < buff.length) {
            send[j + 4] = buff[j];
            ++j;
        }
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "First Contact Request. code:" + code + " user:" + userid);
        return true;
    }

    private short node_Attestation(String userid, String project, Long lastupdate, boolean firstproject) {
        this.sleep();
        if (!this.conection_Attestation((short)51, userid, project, lastupdate, firstproject)) {
            return -1;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "051 sended client-connection request OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "151 waiting client-connection-request anser");
        short kind = this.kind_Recept((short)151);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "151 recieved client-connection-request anser OK");
        this.sleep();
        return kind;
    }

    public boolean conection_Attestation(short code, String userid, String project, Long lastupdate, boolean firstproject) {
        Struct_Connect_Digest data = new Struct_Connect_Digest();
        data.setSender(userid);
        data.setProject(project);
        data.setLastupdate(lastupdate);
        data.setFirstproject(firstproject);
        byte[] pcu_data = data.getByte();
        short i = (short)pcu_data.length;
        byte[] send = new byte[i + 4];
        send[0] = (byte)(code >>> 8 & 0xFF);
        send[1] = (byte)(code >>> 0 & 0xFF);
        send[2] = (byte)(i >>> 8 & 0xFF);
        send[3] = (byte)(i >>> 0 & 0xFF);
        int j = 0;
        while (j < pcu_data.length) {
            send[j + 4] = pcu_data[j];
            ++j;
        }
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "Attestation. code:" + code + " user:" + userid + " project:" + project + " lastupdate:" + lastupdate);
        return true;
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

