/*
 * Decompiled with CFR 0.152.
 */
package mailcost_main;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import structure.File_and_Directory_Address;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Cost_Analysis_Digest_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_Numeric_InputKey_check;
import tool.Tool_Numeric_check;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_PanelCostAnalysis
extends JInternalFrame
implements ActionListener,
FocusListener {
    JPanel contentPane;
    Tool_User_IO user_info;
    Struct_User su;
    JFormattedTextField write_time;
    JLabel lbl_write_maxcost;
    JFormattedTextField read_time;
    JLabel lbl_read_maxcost;
    JFormattedTextField real_time;
    JLabel lbl_real_maxcost;
    JFormattedTextField my_eval_time;
    JLabel lbl_my_eval_maxcost;
    JFormattedTextField other_eval_time;
    JLabel lbl_other_eval_maxcost;
    JFormattedTextField cont_time;
    JLabel lbl_cont_maxcost;
    JFormattedTextField total_time;
    JLabel lbl_total_maxcost;
    JButton btn_OK;
    JButton btn_Cancel;
    DecimalFormat fmtnumber = new DecimalFormat("###,###");
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());

    public Gui_PanelCostAnalysis() {
        super("\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", true, true);
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "LookAndFeel Error");
        }
        this.setFrameIcon(null);
        this.setLocation(50, 10);
        this.setSize(500, 390);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(null);
        this.user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        this.su = this.user_info.getStruct_User();
        Insets insets = new Insets(new JFormattedTextField().getMargin().top, new JFormattedTextField().getMargin().left, new JFormattedTextField().getMargin().bottom, 5);
        JLabel lbl1 = new JLabel();
        lbl1.setText("\u6700\u5927\u8868\u793a\u30b3\u30b9\u30c8");
        lbl1.setBounds(350, 10, 100, 28);
        this.contentPane.add(lbl1);
        JLabel lbl2 = new JLabel();
        lbl2.setText("\uff08\uff21\uff09\u66f8\u304d\u8fbc\u307f\u30b3\u30b9\u30c8");
        lbl2.setBounds(10, 40, 150, 28);
        this.contentPane.add(lbl2);
        this.write_time = new JFormattedTextField();
        this.write_time.setBounds(200, 40, 70, 28);
        DecimalFormat dfw = new DecimalFormat("#0.00");
        Tool_Numeric_InputKey_check nc = new Tool_Numeric_InputKey_check();
        this.write_time.setDocument(nc);
        this.write_time.setInputVerifier(new maxtimeVerifier());
        this.write_time.setText(dfw.format(this.su.getWrite_maxtime()));
        this.write_time.setHorizontalAlignment(4);
        this.write_time.setMargin(insets);
        this.write_time.addFocusListener(this);
        this.contentPane.add(this.write_time);
        JLabel lbl3 = new JLabel();
        lbl3.setText("\u6642\u9593");
        lbl3.setBounds(280, 40, 40, 28);
        this.contentPane.add(lbl3);
        this.lbl_write_maxcost = new JLabel();
        this.lbl_write_maxcost.setText(this.maxcost_Cal(this.write_time, 3600.0));
        this.lbl_write_maxcost.setBounds(330, 40, 80, 28);
        this.lbl_write_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_write_maxcost);
        JLabel lbl4 = new JLabel();
        lbl4.setText("\u5186");
        lbl4.setBounds(430, 40, 40, 28);
        this.contentPane.add(lbl4);
        JLabel lbl5 = new JLabel();
        lbl5.setText("\uff08\uff22\uff09\u8aad\u307f\u53d6\u308a\u30b3\u30b9\u30c8");
        lbl5.setBounds(10, 70, 150, 28);
        this.contentPane.add(lbl5);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.read_time = new JFormattedTextField();
        this.read_time.setBounds(200, 70, 70, 28);
        this.read_time.setDocument(nc);
        this.read_time.setInputVerifier(new maxtimeVerifier());
        this.read_time.setText(dfw.format(this.su.getRead_maxtime()));
        this.read_time.setHorizontalAlignment(4);
        this.read_time.setMargin(insets);
        this.read_time.addFocusListener(this);
        this.contentPane.add(this.read_time);
        JLabel lbl6 = new JLabel();
        lbl6.setText("\u6642\u9593");
        lbl6.setBounds(280, 70, 40, 28);
        this.contentPane.add(lbl6);
        this.lbl_read_maxcost = new JLabel();
        this.lbl_read_maxcost.setText(this.maxcost_Cal(this.read_time, 3600.0));
        this.lbl_read_maxcost.setBounds(330, 70, 80, 28);
        this.lbl_read_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_read_maxcost);
        JLabel lbl7 = new JLabel();
        lbl7.setText("\u5186");
        lbl7.setBounds(430, 70, 40, 28);
        this.contentPane.add(lbl7);
        JLabel lbl8 = new JLabel();
        lbl8.setText("\uff08\uff23\uff09\u7dcf\u30b3\u30b9\u30c8");
        lbl8.setBounds(10, 100, 150, 28);
        this.contentPane.add(lbl8);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.real_time = new JFormattedTextField();
        this.real_time.setBounds(200, 100, 70, 28);
        this.real_time.setDocument(nc);
        this.real_time.setInputVerifier(new maxtimeVerifier());
        this.real_time.setText(dfw.format(this.su.getReal_maxtime()));
        this.real_time.setHorizontalAlignment(4);
        this.real_time.setMargin(insets);
        this.real_time.addFocusListener(this);
        this.contentPane.add(this.real_time);
        JLabel lbl9 = new JLabel();
        lbl9.setText("\u6642\u9593");
        lbl9.setBounds(280, 100, 40, 28);
        this.contentPane.add(lbl9);
        this.lbl_real_maxcost = new JLabel();
        this.lbl_real_maxcost.setText(this.maxcost_Cal(this.real_time, 3600.0));
        this.lbl_real_maxcost.setBounds(330, 100, 80, 28);
        this.lbl_real_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_real_maxcost);
        JLabel lbl10 = new JLabel();
        lbl10.setText("\u5186");
        lbl10.setBounds(430, 100, 40, 28);
        this.contentPane.add(lbl10);
        JLabel lbl11 = new JLabel();
        lbl11.setText("\uff08\uff24\uff09\u81ea\u5206\u3092\u8a55\u4fa1\u3057\u305f\u30b3\u30b9\u30c8");
        lbl11.setBounds(10, 140, 180, 28);
        this.contentPane.add(lbl11);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.my_eval_time = new JFormattedTextField();
        this.my_eval_time.setBounds(200, 140, 70, 28);
        this.my_eval_time.setDocument(nc);
        this.my_eval_time.setInputVerifier(new maxtimeVerifier());
        this.my_eval_time.setText(dfw.format(this.su.getMy_eval_maxtime()));
        this.my_eval_time.setHorizontalAlignment(4);
        this.my_eval_time.setMargin(insets);
        this.my_eval_time.addFocusListener(this);
        this.contentPane.add(this.my_eval_time);
        JLabel lbl12 = new JLabel();
        lbl12.setText("\u6642\u9593");
        lbl12.setBounds(280, 140, 40, 28);
        this.contentPane.add(lbl12);
        this.lbl_my_eval_maxcost = new JLabel();
        this.lbl_my_eval_maxcost.setText(this.maxcost_Cal(this.my_eval_time, 3600.0));
        this.lbl_my_eval_maxcost.setBounds(330, 140, 80, 28);
        this.lbl_my_eval_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_my_eval_maxcost);
        JLabel lbl13 = new JLabel();
        lbl13.setText("\u5186");
        lbl13.setBounds(430, 140, 40, 28);
        this.contentPane.add(lbl13);
        JLabel lbl14 = new JLabel();
        lbl14.setText("\uff08\uff25\uff09\u76f8\u624b\u3092\u8a55\u4fa1\u3057\u305f\u30b3\u30b9\u30c8");
        lbl14.setBounds(10, 170, 180, 28);
        this.contentPane.add(lbl14);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.other_eval_time = new JFormattedTextField();
        this.other_eval_time.setBounds(200, 170, 70, 28);
        this.other_eval_time.setDocument(nc);
        this.other_eval_time.setInputVerifier(new maxtimeVerifier());
        this.other_eval_time.setText(dfw.format(this.su.getOther_eval_maxtime()));
        this.other_eval_time.setHorizontalAlignment(4);
        this.other_eval_time.setMargin(insets);
        this.other_eval_time.addFocusListener(this);
        this.contentPane.add(this.other_eval_time);
        JLabel lbl15 = new JLabel();
        lbl15.setText("\u6642\u9593");
        lbl15.setBounds(280, 170, 40, 28);
        this.contentPane.add(lbl15);
        this.lbl_other_eval_maxcost = new JLabel();
        this.lbl_other_eval_maxcost.setText(this.maxcost_Cal(this.other_eval_time, 3600.0));
        this.lbl_other_eval_maxcost.setBounds(330, 170, 80, 28);
        this.lbl_other_eval_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_other_eval_maxcost);
        JLabel lbl16 = new JLabel();
        lbl16.setText("\u5186");
        lbl16.setBounds(430, 170, 40, 28);
        this.contentPane.add(lbl16);
        JLabel lbl17 = new JLabel();
        lbl17.setText("\uff08\uff26\uff09\u8ca2\u732e\u30b3\u30b9\u30c8");
        lbl17.setBounds(10, 200, 150, 28);
        this.contentPane.add(lbl17);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.cont_time = new JFormattedTextField();
        this.cont_time.setBounds(200, 200, 70, 28);
        this.cont_time.setDocument(nc);
        this.cont_time.setInputVerifier(new maxtimeVerifier());
        this.cont_time.setText(dfw.format(this.su.getCont_maxtime()));
        this.cont_time.setHorizontalAlignment(4);
        this.cont_time.setMargin(insets);
        this.cont_time.addFocusListener(this);
        this.contentPane.add(this.cont_time);
        JLabel lbl18 = new JLabel();
        lbl18.setText("\u6642\u9593");
        lbl18.setBounds(280, 200, 40, 28);
        this.contentPane.add(lbl18);
        this.lbl_cont_maxcost = new JLabel();
        this.lbl_cont_maxcost.setText(this.maxcost_Cal(this.cont_time, 3600.0));
        this.lbl_cont_maxcost.setBounds(330, 200, 80, 28);
        this.lbl_cont_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_cont_maxcost);
        JLabel lbl19 = new JLabel();
        lbl19.setText("\u5186");
        lbl19.setBounds(430, 200, 40, 28);
        this.contentPane.add(lbl19);
        JLabel lbl20 = new JLabel();
        lbl20.setText("\uff08\uff27\uff09\u8ca2\u732e\u5f8c\u30b3\u30b9\u30c8");
        lbl20.setBounds(10, 240, 150, 28);
        this.contentPane.add(lbl20);
        dfw = new DecimalFormat("#0.00");
        nc = new Tool_Numeric_InputKey_check();
        this.total_time = new JFormattedTextField();
        this.total_time.setBounds(200, 240, 70, 28);
        this.total_time.setDocument(nc);
        this.total_time.setInputVerifier(new maxtimeVerifier());
        this.total_time.setText(dfw.format(this.su.getTotal_maxtime()));
        this.total_time.setHorizontalAlignment(4);
        this.total_time.setMargin(insets);
        this.total_time.addFocusListener(this);
        this.contentPane.add(this.total_time);
        JLabel lbl21 = new JLabel();
        lbl21.setText("\u6642\u9593");
        lbl21.setBounds(280, 240, 40, 28);
        this.contentPane.add(lbl21);
        this.lbl_total_maxcost = new JLabel();
        this.lbl_total_maxcost.setText(this.maxcost_Cal(this.total_time, 3600.0));
        this.lbl_total_maxcost.setBounds(330, 240, 80, 28);
        this.lbl_total_maxcost.setHorizontalAlignment(4);
        this.contentPane.add(this.lbl_total_maxcost);
        JLabel lbl22 = new JLabel();
        lbl22.setText("\u5186");
        lbl22.setBounds(430, 240, 40, 28);
        this.contentPane.add(lbl22);
        this.btn_OK = new JButton("\u78ba\u5b9a");
        this.btn_OK.setBounds(160, 290, 70, 50);
        this.contentPane.add(this.btn_OK);
        this.btn_OK.addActionListener(this);
        this.btn_Cancel = new JButton("\u53d6\u6d88");
        this.btn_Cancel.setBounds(260, 290, 70, 50);
        this.contentPane.add(this.btn_Cancel);
        this.btn_Cancel.addActionListener(this);
        this.setVisible(true);
    }

    private String maxcost_Cal(JFormattedTextField time, double adjust) {
        Double second;
        NumberFormat StringToDouble = NumberFormat.getInstance();
        try {
            second = StringToDouble.parse(time.getText()).doubleValue();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            second = 0.0;
        }
        Double cost = this.su.getUnit_cost() * second * adjust;
        BigDecimal bd = new BigDecimal(String.valueOf(cost));
        cost = bd.setScale(0, 4).doubleValue();
        DecimalFormat dfuc = new DecimalFormat("#,###,##0");
        return dfuc.format(cost);
    }

    private int maxcost_Cal_int(JFormattedTextField time, double adjust) {
        Double second;
        NumberFormat StringToDouble = NumberFormat.getInstance();
        try {
            second = StringToDouble.parse(time.getText()).doubleValue();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            second = 0.0;
        }
        Double cost = this.su.getUnit_cost() * second * adjust;
        return cost.intValue();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn_OK) {
            int ans = JOptionPane.showConfirmDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a\u3092\u5909\u66f4\u3057\u307e\u3059\u304b\uff1f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 2, 3);
            if (ans == 2) {
                return;
            }
            try {
                Number num = this.fmtnumber.parse(this.write_time.getText());
                this.su.setWrite_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.read_time.getText());
                this.su.setRead_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.real_time.getText());
                this.su.setReal_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.my_eval_time.getText());
                this.su.setMy_eval_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.other_eval_time.getText());
                this.su.setOther_eval_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.cont_time.getText());
                this.su.setCont_maxtime(num.doubleValue());
                num = this.fmtnumber.parse(this.total_time.getText());
                this.su.setTotal_maxtime(num.doubleValue());
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                return;
            }
            try {
                Number num_write_maxcost = this.fmtnumber.parse(this.lbl_write_maxcost.getText());
                Number num_read_maxcost = this.fmtnumber.parse(this.lbl_read_maxcost.getText());
                Number num_real_maxcost = this.fmtnumber.parse(this.lbl_real_maxcost.getText());
                Number num_my_eval_maxcost = this.fmtnumber.parse(this.lbl_my_eval_maxcost.getText());
                Number num_other_eval_maxcost = this.fmtnumber.parse(this.lbl_other_eval_maxcost.getText());
                Number num_cont_maxcost = this.fmtnumber.parse(this.lbl_cont_maxcost.getText());
                Number num_total_maxcost = this.fmtnumber.parse(this.lbl_total_maxcost.getText());
                this.su.setWrite_maxcost(num_write_maxcost.intValue());
                this.su.setRead_maxcost(num_read_maxcost.intValue());
                this.su.setReal_maxcost(num_real_maxcost.intValue());
                this.su.setMy_eval_maxcost(num_my_eval_maxcost.intValue());
                this.su.setOther_eval_maxcost(num_other_eval_maxcost.intValue());
                this.su.setCont_maxcost(num_cont_maxcost.intValue());
                this.su.setTotal_maxcost(num_total_maxcost.intValue());
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                return;
            }
            this.user_info.setStruct_User(this.su);
            this.user_info.saveXml();
            JOptionPane.showMessageDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a\u3092\u5909\u66f4\u3057\u307e\u3057\u305f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 1);
            int ans2 = JOptionPane.showConfirmDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u7d50\u679c(analysis)\u3092\u518d\u4f5c\u6210\u3057\u307e\u3059\u304b\uff1f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 2, 3);
            if (ans2 == 0) {
                this.make_analysis();
            }
            try {
                this.setClosed(true);
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                return;
            }
        }
        if (e.getSource() == this.btn_Cancel) {
            try {
                this.setClosed(true);
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                return;
            }
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        if (e.getSource() == this.write_time) {
            this.lbl_write_maxcost.setText(this.maxcost_Cal(this.write_time, 3600.0));
        } else if (e.getSource() == this.read_time) {
            this.lbl_read_maxcost.setText(this.maxcost_Cal(this.read_time, 3600.0));
        } else if (e.getSource() == this.real_time) {
            this.lbl_real_maxcost.setText(this.maxcost_Cal(this.real_time, 3600.0));
        } else if (e.getSource() == this.my_eval_time) {
            this.lbl_my_eval_maxcost.setText(this.maxcost_Cal(this.my_eval_time, 3600.0));
        } else if (e.getSource() == this.other_eval_time) {
            this.lbl_other_eval_maxcost.setText(this.maxcost_Cal(this.other_eval_time, 3600.0));
        } else if (e.getSource() == this.cont_time) {
            this.lbl_cont_maxcost.setText(this.maxcost_Cal(this.cont_time, 3600.0));
        } else if (e.getSource() == this.total_time) {
            this.lbl_total_maxcost.setText(this.maxcost_Cal(this.total_time, 3600.0));
        }
    }

    private void make_analysis() {
        Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
        tep.loadXml();
        String[] array_project = tep.get_project();
        int i = 0;
        while (i < array_project.length) {
            Tool_Cost_Analysis_Digest_IO t = new Tool_Cost_Analysis_Digest_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + array_project[i] + this.addr.getDir_costanalysis() + this.addr.getFile_cost_digest());
            t.loadXml();
            ArrayList array_Cost_Analysis_Digest = t.getdata();
            int j = 0;
            while (j < array_Cost_Analysis_Digest.size()) {
                ProcessBuilder builder = new ProcessBuilder("java", "-jar", String.valueOf(this.addr.getDir_current()) + this.addr.getPgm_make_analysis(), "--project", array_project[i], "--yyyymm", ((Struct_Cost_Analysis_Digest)array_Cost_Analysis_Digest.get(j)).getYyyymm());
                try {
                    Process process = builder.start();
                    process.waitFor();
                    process.destroy();
                    if (process.exitValue() != 0) {
                        JOptionPane.showMessageDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u304c\u5931\u6557\u3057\u307e\u3057\u305f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 1);
                        return;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                    this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                    JOptionPane.showMessageDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u304c\u5931\u6557\u3057\u307e\u3057\u305f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 1);
                    return;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
                    this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
                    JOptionPane.showMessageDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u304c\u5931\u6557\u3057\u307e\u3057\u305f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 1);
                    return;
                }
                ++j;
            }
            ++i;
        }
        JOptionPane.showMessageDialog(this, "\u30b3\u30b9\u30c8\u5206\u6790\u3092\u5b9f\u884c\u3057\u307e\u3057\u305f", "\u30b3\u30b9\u30c8\u5206\u6790\u8a2d\u5b9a", 1);
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }

    static class maxtimeVerifier
    extends InputVerifier {
        maxtimeVerifier() {
        }

        public boolean verify(JComponent input) {
            boolean flg = true;
            JFormattedTextField f = (JFormattedTextField)input;
            String s = f.getText();
            Tool_Numeric_check tnc = new Tool_Numeric_check(s);
            tnc.setInteger_digit((byte)3);
            tnc.setDecimal_digit((byte)2);
            tnc.setMinvalue(1.0f);
            tnc.setMaxvalue(999.0f);
            String msg = tnc.floatCheck();
            if (msg != null) {
                JOptionPane.showMessageDialog(null, msg, "\u8868\u793a\u30ec\u30d9\u30eb\u306e\u6700\u5927\u6642\u9593", 2);
                flg = false;
                f.setText("0.00");
                return flg;
            }
            DecimalFormat dfw = new DecimalFormat("#,##0.00");
            f.setText(dfw.format(Float.parseFloat(f.getText())));
            return flg;
        }
    }
}

