/*
 * Decompiled with CFR 0.152.
 */
package socket_common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Mail_Send {
    Socket sock;
    InputStream in;
    OutputStream out;
    Struct_SendList data;
    boolean direct;
    String dir;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];

    public Mail_Send(Socket sock, InputStream in, OutputStream out, Struct_SendList data, boolean direct, String dir) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.sock = sock;
        this.in = in;
        this.out = out;
        this.data = data;
        this.direct = direct;
        this.dir = dir;
    }

    public boolean submit() {
        int filesize;
        String filename = this.data.getFilename();
        Struct_Community_Digest digest = this.data.getScd();
        byte[] pcu_data = this.data.getByte();
        if (this.direct) {
            filesize = this.mailSendPermission_Request((short)10, pcu_data);
            if (filesize == 0) {
                return false;
            }
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "010 sended mail-send-permission-request OK");
        } else {
            filesize = this.mailSendPermission_Request((short)30, pcu_data);
            if (filesize == 0) {
                return false;
            }
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "030 sended mail-relay-permission-request OK");
        }
        if (!this.send_filesize((short)15, filesize)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "015 sended mail-(send or relay)-permission-request-complete OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "110 waiting mail-send-permission-request anser");
        if (!this.code_Recept((short)110)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "110 recieved mail-send-permission-request anser OK");
        this.sleep();
        filesize = this.send_file(String.valueOf(this.dir) + this.addr.getFs() + filename);
        if (filesize == 0) {
            return false;
        }
        if (!this.send_filesize((short)12, filesize)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "012 sended mail-send-complete OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "112 waiting mail-send-complete anser");
        if (!this.code_Recept((short)112)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "112 recieved mail-send-complete anser OK");
        return true;
    }

    public int mailSendPermission_Request(short code, byte[] indata) {
        int filesize = 0;
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "mail Send Permission Request start. code:" + code + " length:" + indata.length);
        int len = 0;
        int edaban = 0;
        boolean EOF = false;
        if (indata.length > this.sysconfig.getBuffsize() - 6) {
            len = this.sysconfig.getBuffsize() - 6;
        } else {
            len = indata.length;
            EOF = true;
        }
        while (true) {
            byte[] send = new byte[len + 6];
            send[0] = (byte)(code >>> 8 & 0xFF);
            send[1] = (byte)(code >>> 0 & 0xFF);
            send[2] = (byte)(len >>> 8 & 0xFF);
            send[3] = (byte)(len >>> 0 & 0xFF);
            edaban = (short)(edaban + 1);
            send[4] = (byte)(edaban >>> 8 & 0xFF);
            send[5] = (byte)(edaban >>> 0 & 0xFF);
            int i = 0;
            while (i < len) {
                send[i + 6] = indata[i + filesize];
                ++i;
            }
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "15:edaban=" + edaban + " filesize:" + (filesize += len));
            if (!this.send_Byte(send)) {
                this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "mail Send Permission Request send error");
                return 0;
            }
            if (EOF) break;
            if (indata.length - filesize > this.sysconfig.getBuffsize() - 6) {
                len = this.sysconfig.getBuffsize() - 6;
                continue;
            }
            len = indata.length - filesize;
            EOF = true;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "mail Send Permission Request end.");
        return filesize;
    }

    public boolean conection_Request(short code, String userid) {
        short i = (short)userid.length();
        byte[] send = new byte[i + 4];
        send[0] = (byte)(code >>> 8 & 0xFF);
        send[1] = (byte)(code >>> 0 & 0xFF);
        send[2] = (byte)(i >>> 8 & 0xFF);
        send[3] = (byte)(i >>> 0 & 0xFF);
        byte[] buff = userid.getBytes();
        int j = 0;
        while (j < buff.length) {
            send[j + 4] = buff[j];
            ++j;
        }
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "First Contact Request. code=" + code + " user=" + userid);
        return true;
    }

    public boolean code_Recept(short code) {
        int k;
        try {
            this.sock.setSoTimeout(this.sysconfig.getTimer_out());
            k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Code Recept:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Code Recept:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        if (k < 0) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Time Out Error ");
            return false;
        }
        if (k != 2) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Data Length is not 2. length:" + k);
            return false;
        }
        short cd = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != cd) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Code unmatch.  wait code=" + code + "  send code=" + cd);
            return false;
        }
        return true;
    }

    public int send_file(String filename) {
        int filesize = 0;
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_file start");
        FileInputStream fin = null;
        int code = 11;
        int len = 0;
        int edaban = 0;
        byte[] data = new byte[this.sysconfig.getBuffsize() - 6];
        try {
            fin = new FileInputStream(filename);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            return 0;
        }
        try {
            filesize = 0;
            while ((len = fin.read(data)) != -1) {
                byte[] send = new byte[len + 6];
                send[0] = (byte)(code >>> 8 & 0xFF);
                send[1] = (byte)(code >>> 0 & 0xFF);
                send[2] = (byte)(len >>> 8 & 0xFF);
                send[3] = (byte)(len >>> 0 & 0xFF);
                edaban = (short)(edaban + 1);
                send[4] = (byte)(edaban >>> 8 & 0xFF);
                send[5] = (byte)(edaban >>> 0 & 0xFF);
                int i = 0;
                while (i < len) {
                    send[i + 6] = data[i];
                    ++i;
                }
                this.send_Byte(send);
                filesize += len;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            return 0;
        }
        try {
            this.out.flush();
            fin.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_file end");
        return filesize;
    }

    public boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send start");
        int j = byte_send.length;
        try {
            this.out.write(byte_send, 0, j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send end");
        return true;
    }

    public boolean send_filesize(short code, int filesize) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF), (byte)(filesize >>> 24 & 0xFF), (byte)(filesize >>> 16 & 0xFF), (byte)(filesize >>> 8 & 0xFF), (byte)(filesize >>> 0 & 0xFF)};
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "sended filesize  code=" + code + " filesize=" + filesize);
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

