/*
 * Decompiled with CFR 0.152.
 */
package socket_server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_System_Config;
import tool.Tool_Community_Menber_IO;
import tool.Tool_JList_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Server_MasterSend {
    private Socket sock;
    private InputStream in;
    private OutputStream out;
    private String filepath;
    private long lastupdate;
    File masterfile;
    private File_and_Directory_Address addr = new File_and_Directory_Address();
    private Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    private Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    byte[] buf_send = new byte[this.sysconfig.getBuffsize()];
    byte[] buf_receive = new byte[this.sysconfig.getBuffsize()];

    public Server_MasterSend(Socket sock, InputStream in, OutputStream out, String filepath, long lastupdate) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.sock = sock;
        this.in = in;
        this.out = out;
        this.filepath = filepath;
        this.lastupdate = lastupdate;
    }

    public boolean sendcheck() {
        this.masterfile = new File(this.filepath);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), String.valueOf(this.masterfile.getName()) + " file llastupdate=" + this.masterfile.lastModified());
        if (this.masterfile.exists() && this.masterfile.lastModified() > this.lastupdate) {
            this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), String.valueOf(this.masterfile.getName()) + " file UPDATE");
            return true;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), String.valueOf(this.masterfile.getName()) + " file NO UPDATE");
        return false;
    }

    public boolean submit() {
        if (!this.masterfile_Request((short)60, this.masterfile.getName())) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "010 sended master-send-permission-request OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "110 waitingmaster-send-permission-request anser");
        if (!this.code_Recept((short)110)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "110 recieved master-send-permission-request anser OK");
        this.sleep();
        int filesize = this.send_file(this.filepath);
        if (filesize == 0) {
            return false;
        }
        if (!this.send_filesize((short)12, filesize)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "012 sended mail-send-complete OK");
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "112 waiting mail-send-complete anser");
        if (!this.code_Recept((short)112)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "112 recieved mail-send-complete anser OK");
        return true;
    }

    public boolean entryCommunityMake(String masterDir, String project, String userid) {
        Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO(String.valueOf(masterDir) + this.addr.getFile_com_menber());
        tcm.loadXml();
        ArrayList commenData = tcm.getCommunity(userid);
        DefaultListModel<String> listmodel = new DefaultListModel<String>();
        if (commenData != null && commenData.size() > 0) {
            int i = 0;
            while (i < commenData.size()) {
                listmodel.addElement(((Struct_Community_Menber)commenData.get(i)).getCommunity());
                ++i;
            }
        }
        JList list = new JList(listmodel);
        File file = new File(this.filepath);
        if (file.exists()) {
            file.delete();
        }
        Tool_JList_IO tls = new Tool_JList_IO(this.filepath);
        tls.putJList(list);
        tls.saveXml();
        this.masterfile = new File(this.filepath);
        return true;
    }

    private boolean masterfile_Request(short code, String filename) {
        short i = (short)filename.length();
        byte[] send = new byte[i + 4];
        send[0] = (byte)(code >>> 8 & 0xFF);
        send[1] = (byte)(code >>> 0 & 0xFF);
        send[2] = (byte)(i >>> 8 & 0xFF);
        send[3] = (byte)(i >>> 0 & 0xFF);
        byte[] buff = filename.getBytes();
        int j = 0;
        while (j < buff.length) {
            send[j + 4] = buff[j];
            ++j;
        }
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "First Contact Request. code=" + code + " masterfile=" + filename);
        return true;
    }

    private boolean code_Recept(short code) {
        int k;
        try {
            this.sock.setSoTimeout(this.sysconfig.getTimer_out());
            k = this.in.read(this.buf_receive);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Code Recept:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), "Code Recept:Server Recieve Error");
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        if (k < 0) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Time Out Error ");
            return false;
        }
        if (k != 2) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Data Length is not 2. length:" + k);
            return false;
        }
        short cd = (short)((this.buf_receive[0] << 8 & 0xFF00) + (this.buf_receive[1] & 0xFF));
        if (code != cd) {
            this.logout.out(this.sysconfig.getLogmode2(), this.getClass().getName(), "Code Recept:Code unmatch.  wait code=" + code + "  send code=" + cd);
            return false;
        }
        return true;
    }

    private int send_file(String filename) {
        int filesize = 0;
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_file start");
        FileInputStream fin = null;
        int code = 11;
        int len = 0;
        int edaban = 0;
        byte[] data = new byte[this.sysconfig.getBuffsize() - 6];
        try {
            fin = new FileInputStream(filename);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            return 0;
        }
        try {
            filesize = 0;
            while ((len = fin.read(data)) != -1) {
                byte[] send = new byte[len + 6];
                send[0] = (byte)(code >>> 8 & 0xFF);
                send[1] = (byte)(code >>> 0 & 0xFF);
                send[2] = (byte)(len >>> 8 & 0xFF);
                send[3] = (byte)(len >>> 0 & 0xFF);
                edaban = (short)(edaban + 1);
                send[4] = (byte)(edaban >>> 8 & 0xFF);
                send[5] = (byte)(edaban >>> 0 & 0xFF);
                int i = 0;
                while (i < len) {
                    send[i + 6] = data[i];
                    ++i;
                }
                this.send_Byte(send);
                filesize += len;
                this.sleep();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
            return 0;
        }
        try {
            this.out.flush();
            fin.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e1.getStackTrace());
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "send_file end");
        return filesize;
    }

    private boolean send_Byte(byte[] byte_send) {
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send start");
        int j = byte_send.length;
        try {
            this.out.write(byte_send, 0, j);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "byte_send end");
        return true;
    }

    private boolean send_filesize(short code, int filesize) {
        byte[] send = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code >>> 0 & 0xFF), (byte)(filesize >>> 24 & 0xFF), (byte)(filesize >>> 16 & 0xFF), (byte)(filesize >>> 8 & 0xFF), (byte)(filesize >>> 0 & 0xFF)};
        if (!this.send_Byte(send)) {
            return false;
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "sended filesize  code=" + code + " filesize=" + filesize);
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    private void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

