/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import structure.File_and_Directory_Address;
import structure.Struct_System_Config;
import tool.Tool_System_Config_IO;

public class Tool_LogOut
implements Serializable {
    private String filename;
    private byte logmode;
    private File_and_Directory_Address addr = new File_and_Directory_Address();
    private Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();

    public Tool_LogOut(String filename) {
        this.filename = filename;
        this.logmode = this.sysconfig.getLogmode();
    }

    public void out(byte mode, String classname, String msg) {
        if (this.logmode < mode) {
            return;
        }
        FileOutputStream fos = null;
        BufferedWriter fp = null;
        try {
            fos = new FileOutputStream(this.filename, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        fp = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            long nowtime = System.currentTimeMillis();
            SimpleDateFormat dfm = new SimpleDateFormat("yyyyMMdd HHmmss");
            fp.write(String.valueOf(DateFormat.getDateTimeInstance().format(nowtime)) + " [" + classname + "] " + msg);
            fp.newLine();
            fp.flush();
            fp.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void out(byte mode, String classname, StackTraceElement[] stack) {
        if (this.logmode < mode) {
            return;
        }
        FileOutputStream fos = null;
        BufferedWriter fp = null;
        try {
            fos = new FileOutputStream(this.filename, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        fp = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            int i = 0;
            while (i < stack.length) {
                fp.write("\t" + stack[i]);
                fp.newLine();
                ++i;
            }
            fp.flush();
            fp.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

