package socket_client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

import socket_common.Cost_Send;
import structure.File_and_Directory_Address;
import structure.Struct_Cost_SendList;
import structure.Struct_Entry_Project;
import structure.Struct_Relay_Node;
import structure.Struct_System_Config;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Client_Cost_Send {
	
	//ソケット
	Socket sock = null;
	//送受信用
	InputStream in = null;							//入力ストリーム
	OutputStream out = null;						//出力ストリーム
	
	int filesize;

	String mode;
	String dir;
	String suffix;
	
	boolean send_direct;					//直接送信
	boolean send_direct_option;			//直接送信オプション
	boolean send_direct_option_relay;		//直接送信オプション他ノード中継
	boolean send_direct_option_server;		//直接送信オプションサーバ中継
	ArrayList<Struct_Relay_Node> asrn ;

	boolean relay = false;					//中継送信の実施
	boolean server = false;				//サーバー送信の実施

	boolean blnswitch = true;						//ループスイッチ


	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
									addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ

	
	public Client_Cost_Send(	String mode,
								String dir,
								String suffix,
								boolean send_direct,
								boolean send_direct_option,
								boolean send_direct_option_relay,
								boolean send_direct_option_server,
								ArrayList<Struct_Relay_Node> asrn,
								boolean relay,
								boolean server){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.mode						=	mode;
		this.dir						=	dir;
		this.suffix						=	suffix;

		this.send_direct 				= 	send_direct;
		this.send_direct_option 		= 	send_direct_option;
		this.send_direct_option_relay 	= 	send_direct_option_relay;
		this.send_direct_option_server	=	send_direct_option_server;
		this.asrn						=	asrn;
		this.relay						=	relay;
		this.server						=	server;
		
	}
	
	
	
	
	public void costsend(File fl,String filepath,Tool_FileFilter ff,File[] files,int i){
		/*		
				Tool_Cost_SendList_IO cslm = new Tool_Cost_SendList_IO(filepath);
		    	cslm.loadXml();

				Struct_Cost_SendList data 	=	cslm.getdata();	

				String node 	=	data.getTarget_node();			//相手先ノードのＩＰアドレス
				String userid 	=	data.getTarget_user();			//相手先ノードのユーザー
				String filename =	data.getFilename(); 			//送信ファイル
				
				//回線接続
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket open");
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "target_node:"+node);
				if(open(node) == false){
					//オープン失敗
					return;
				}
				
				sleep();

				//(000)クライアント接続要求の送信
				if(conection_Request((short) 0,userid) == false){
					return;
				}
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "000 sended client-connection request OK");
				//(100)クライアント接続要求の受信
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 waiting client-connection-request anser");
				if(conection_Recept((short)100) == false){
					return;
				}
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 recieved client-connection-request anser OK");
				
				sleep();
		*/
				
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
				
		Tool_Cost_SendList_IO cslm = new Tool_Cost_SendList_IO(filepath);
    	cslm.loadXml();

		Struct_Cost_SendList data 	=	cslm.getdata();	


		String node		=	new String();			//相手先ノードのＩＰアドレス
		String userid	=	new String();			//相手先ノードのユーザー

		boolean node_connect_success = false;		//接続ノードが確立した場合、true
		boolean direct = true;						//直接送信が確定した場合、true

		//中継送信
		if(relay == true){
			//直接送信
			if(server == false){
				node 	=	data.getTarget_node();			//相手先ノードのＩＰアドレス
        		userid 	=	data.getTarget_user();			//相手先ノードのユーザー
        		//直接送信ノードへの接続
        		if(node_connect(node,userid) == true){
        			node_connect_success = true;
        			direct = true;
        		}
			}
			//サーバー送信
			else{
				Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + 
													addr.getFile_project_info());
				t.loadXml();
				ArrayList<Struct_Entry_Project> array_Entry_Project = t.getdata();
				for(int s=0 ; s<array_Entry_Project.size() ;s++){
					if(array_Entry_Project.get(s).getProject().equals(data.getTarget_project()))
		        		node 	=	array_Entry_Project.get(s).getIp_address();		//相手先ノードのＩＰアドレス
	        			userid 	=	array_Entry_Project.get(s).getUserid();			//相手先ノードのユーザー
		        		//中継サーバーへの接続
		        		if(node_connect(node,userid) == true){
		        			node_connect_success = true;
		        			direct = false;
		        			break;
		        		}
				}
				
			}
			
		}
		//直接送信
		else if(send_direct == true){
    		node 	=	data.getTarget_node();			//相手先ノードのＩＰアドレス
    		userid 	=	data.getTarget_user();			//相手先ノードのユーザー

    		//直接送信ノードへの接続
    		if(node_connect(node,userid) == true){
    			node_connect_success = true;
    			direct = true;
    		}
    		else{
    			//直接送信オプションあり
    			if(send_direct_option == true){
    				//他ノード中継
    				if(send_direct_option_relay == true){
    					for(int k=0 ;k<asrn.size() ;k++){
    						//ターゲットプロジェクトのノードであることが条件
    						if(asrn.get(k).getProject().equals(data.getTarget_project())  == true ){
        						node 	=	asrn.get(k).getNode();			//相手先ノードのＩＰアドレス
        		        		userid 	=	asrn.get(k).getUserid();		//相手先ノードのユーザー
        		        		//中継ノードへの接続
        		        		if(node_connect(node,userid) == true){
        		        			node_connect_success = true;
        		        			direct = false;
        		        			break;
        		        		}
    						}
    					}
    				}
        			//サーバ中継あり
    				if(node_connect_success == false &&
    						send_direct_option_server == true){
    					Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + 
    														addr.getFile_project_info());
    					t.loadXml();
    					ArrayList<Struct_Entry_Project> array_Entry_Project = t.getdata();
    					for(int s=0 ; s<array_Entry_Project.size() ;s++){
    						if(array_Entry_Project.get(s).getProject().equals(data.getTarget_project())){
        		        		node 	=	array_Entry_Project.get(s).getIp_address();		//相手先ノードのＩＰアドレス
    		        			userid 	=	array_Entry_Project.get(s).getUserid();			//相手先ノードのユーザー
        		        		//中継サーバーへの接続
        		        		if(node_connect(node,userid) == true){
        		        			node_connect_success = true;
        		        			direct = false;
        		        			break;
        		        		}
    							
    						}
    					}
    					
    				}
    				
    			}
    		}
		}
		//間接送信
		else if(send_direct == false){
			for(int k=0 ;k<asrn.size() ;k++){
				//ターゲットプロジェクトのノードであることが条件
				if(asrn.get(k).getProject().equals(data.getTarget_project())  == true ){
					node 	=	asrn.get(k).getNode();			//相手先ノードのＩＰアドレス
	        		userid 	=	asrn.get(k).getUserid();		//相手先ノードのユーザー
	        		//中継ノードへの接続
	        		if(node_connect(node,userid) == true){
	        			node_connect_success = true;
	        			direct = false;
	        			break;
	        		}
				}
			}
		
		}

		
		
		
		if(node_connect_success == false){
    			return;
   		}

		//***************************************************************************
		//* 送信手順開始
		//***************************************************************************

		Cost_Send cs = new Cost_Send(sock,in,out,data,direct,dir);
		if(cs.submit() == false) return;
	
		//***************************************************************************
		//* 送信手順終了
		//***************************************************************************
		

		//回線切り離しはサーバ書き込みが終了
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket close");
		if(close() == false){
			return;
		}
		
		//送信ファイルの削除
		File delfile = new File(dir + addr.getFs()+ data.getFilename());
   		if(delfile.delete() == false){
       		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+delfile.getAbsolutePath());
   		}
		
		//ダイジェストの削除
   		if(files[i].delete() == false){
       		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+files[i].getAbsolutePath());
   		}
		

		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
	
	}	

	
	
	//接続要求１
	public boolean conection_Request(short code,String userid) {
		
		short i =  (short) userid.length();
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		
		byte[] buff =  userid.getBytes();

		for(int j = 0;j<buff.length;j++){
			send[j+4] = buff[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact Request. code:"+code + " user:"+userid);
		return true;
		
	}
/*
	//メール送信許可要求
	public boolean mailSendPermission_Request(short code,byte[] data) {
		
		short i =  (short)data.length;
		
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF);
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		

		for(int j = 0;j<data.length;j++){
			send[j+4] = data[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "mail Send Permission Request. code:"+code );
		return true;

		
	}
*/	
	//接続要求受付
	public boolean conection_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Time Out Error ");
			return false;
		}

		//情報あり？
		if(k != 2){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Data Length is not 2. length:"+k);
			return false;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Code Error code:"+cd + " request code:"+code);
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact OK");
		return true;
	}		
	
	public boolean open(String ipadr) {

		//接続要求
		try {
			sock = new Socket(ipadr,sysconfig.getPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect Request Information++");
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
			in  = sock.getInputStream();
			out = sock.getOutputStream();
		} catch (UnknownHostException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		} catch (IOException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "接続要求ノードに接続しました");
		return true;
	}
	
	public boolean close()  {
		//ソケットクローズ
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect off Information++");
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
		blnswitch = false;
		try {
			sock.close();
		} catch (IOException e) {
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Socket Close Error");
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "切断しました");
		return true;
	}


	public boolean send_Byte(byte[] byte_send)  {
		int j;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send end");
		return true;
	}
	
	
/*	public void send_String(String str_send)  {
		//送信
		System.out.println("送信中...");
		//ストリームデータ送信
		String buf_string =  str_send ;
		buf_send = buf_string.getBytes() ;
		j = buf_string.getBytes().length;
		try {
			//ストリームデータ掃き出し
			out.write(buf_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

		System.out.println("送信成功");
	}
*/	
/*	
	public boolean send_file(String filename)  {
		filesize = 0;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file start");
		
		//ストリームデータ送信

		FileInputStream fin = null;

		short code = 11;
	    int len = 0;
	    short edaban = 0;

	    byte[] data = new byte[sysconfig.getBuffsize() -6];

		//ファイル設定
		try {
			fin = new FileInputStream(filename);
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return false;
		}
		
		try {
			//送信ループ
			filesize = 0;
			while ((len = fin.read(data)) != -1) {
				byte[] send = new byte[len+6];
			    //コード
				send[0] =  (byte)((code >>> 8) & 0xFF);
				send[1] =  (byte)((code >>> 0) & 0xFF) ;
			    //レングス
				send[2] =  (byte)((len >>> 8) & 0xFF);
				send[3] =  (byte)((len >>> 0) & 0xFF);
			    //枝番
				edaban++;
				send[4] =  (byte)((edaban >>> 8) & 0xFF);
				send[5] =  (byte)((edaban >>> 0) & 0xFF);

				//送信データ作成
				for(int i=0;i<len;i++){
					send[i+6]= data[i];
				}

//				out.write(send, 0, len+6);
				send_Byte(send);
				filesize = filesize + len;
//				System.out.println("send len:" + send.length);
//				System.out.println("len  len:" + len);
				
				
			}
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return false;
		}
		


		//おまじない
		try {
			//出力ファイルの掃き出し
			out.flush();
			//入力ファイルの開放
			fin.close();
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file end");
		return true;
	}
*/
	
	
/*
	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		System.out.println("接続要求回答："+code);
		
	}
*/	
	
/*	
	//メールファイル送信完了＆ファイルの大きさを送信
	public boolean send_filesize(short code) {
		
		byte send[]= new byte[6];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send[2] =  (byte)((filesize >>> 24)  & 0xFF) ;
		send[3] =  (byte)((filesize >>> 16)  & 0xFF) ;
		send[4] =  (byte)((filesize >>> 8)  & 0xFF) ;
		send[5] =  (byte)((filesize >>> 0)  & 0xFF) ;
		
		if(send_Byte(send) == false){
			return false;
		}
		
		System.out.println("接続要求回答："+ code);
		System.out.println("ファイルレングス："+filesize);
		return true;
		
	}
*/
	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	
	
	private boolean node_connect(String node,String userid){
		//回線接続
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket open");
		if(open(node) == false){
			//オープン失敗
			return false;
		}
	
		sleep();


		//(000)クライアント接続要求の送信
		if(conection_Request((short) 0,userid) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "000 sended client-connection request OK");
		//(100)クライアント接続要求の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 waiting client-connection-request anser");
		if(conection_Recept((short)100) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 recieved client-connection-request anser OK");
		
		sleep();

		return true;
		
		
		
	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}		
	
	
	
}
