package socket_client;

import java.util.ArrayList;
import java.io.*;

import structure.File_and_Directory_Address;
import structure.Struct_Relay_Node;
import structure.Struct_System_Config;
import structure.Struct_User;

import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_Task_Socket;
import tool.Tool_User_IO;

public class Client_Main {

	//ソケット
//	Socket sock = null;
	
	//送受信用
//	InputStream in = null;							//入力ストリーム
//	OutputStream out = null;						//出力ストリーム

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
									addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
//	byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
//	byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ

	//上位クラスへの引渡し
//	boolean blnswitch = true;						//ループスイッチ
//	String str;										//受信文字列
	
//	int filesize;
	
	String mode;

	//送信用パラメータ
	String suffix;
	boolean relay = false;					//中継送信の実施
	boolean server = false;				//サーバー送信の実施

	//サーバ接続用パラメータ
	String project;
	String userid ;
	String address;
	long  lastupdate;
	
	String dir;
	
	boolean send_direct;					//直接送信
	boolean send_direct_option;			//直接送信オプション
	boolean send_direct_option_relay;		//直接送信オプション他ノード中継
	boolean send_direct_option_server;		//直接送信オプションサーバ中継
	ArrayList<Struct_Relay_Node> asrn = new ArrayList<Struct_Relay_Node>();

	
	public static void main(String[] args){

		String mode = null;
		
		//送信用パラメータ
		String prefix = null;
		String suffix= null;
		boolean relay = false;
		boolean server = false;

		//サーバ接続用パラメータ
		String project = null;

		//パラメータ解析
		for (int i=0; i<args.length; ++i) {
			if ("--mode".equals(args[i])) {
                mode = args[++i];
            } 
            else if ("--prefix".equals(args[i])) {
            	prefix = args[++i];
            } 
            else if("--suffix".equals(args[i])) {
            	suffix = args[++i];
            } 
            else if("--relay".equals(args[i])) {
            	relay = true;
            }
            else if("--server".equals(args[i])) {
                	server = true;
            }
            else if("--project".equals(args[i])) {
            		project = args[++i];
            } else {
            	System.out.println("引数指定の誤り：未知の引数が指定されました");
       	    	System.exit(-1);
            }
        }
		
    	//個別送信
	    if(mode.equals("target")){
	    	Client_Main submit = new Client_Main(mode,prefix,suffix,relay,server);
//	    	submit.Client_Main();
	    	System.exit(0);

	    }
    	//一斉送信
	    else if(mode.equals("all")){
	    	Client_Main submit = new Client_Main(mode,null,suffix,relay,server);
//	    	submit.Client_Main();
	    	System.exit(0);
	    }
	    //サーバ接続
	    else if(mode.equals("server")){
	    	Client_Main submit = new Client_Main(project);
	    	System.exit(0);
	    }

	
	}

	
	//受信用
	Client_Main(String project){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.project	=	project;
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");

		Client_Recieve cr = new Client_Recieve(project);
		cr.recieve();
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
		
	}

	
	
	
	//送信用
	Client_Main(String mode,String prefix,String suffix,boolean relay,boolean server){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
		
		this.mode 		= mode;
		this.suffix 	= suffix;
		this.relay		= relay;
		this.server		= server;
		
		
		//***************************************************
		//送信ソケットは実行待ち処理
		//***************************************************
		Tool_Task_Socket tts = new Tool_Task_Socket();
		tts.sendTaskBorn();
		int timer = tts.getMax_timer();
		while(true){
			byte code = tts.submit_Judgment();
			if(code == 0){
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "Forced ending instruction");
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
				System.exit(0);
			}
			else if(code == 2){
				break;
			}
			if(timer < 0){
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "wait time over " +(tts.getInterval()*tts.getMax_timer()) +"minutes" );
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
				System.exit(0);
			}
			//スリープ
			try {
				Thread.sleep(tts.getInterval()*1000);
			} catch (InterruptedException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}
			timer--;
		}
		
		

		//ユーザー情報を取得
		user_get();		
		
		//送信ダイジェストを取得
		if(relay == false){
			dir = addr.getDir_current() + addr.getDir_buff_send();
		}
		else{
			dir = addr.getDir_current() + addr.getDir_buff_relay();
		}

		
		File fl = new File(dir);

    	Tool_FileFilter ff = new Tool_FileFilter();
    	
    	if(mode.equals("target")){
        	ff.setPrefix(prefix);
    	}
    	ff.setSuffix(suffix);	
    	
    	File[] files = fl.listFiles(ff);
		
    	//送信バッファのループ
		for(int i=0; i<files.length; i++) {
			byte sendkind = sendkind(files[i].getName());
			//メール送信
			if(sendkind == 1){
				Client_Mail_Send sms = new Client_Mail_Send(	mode,
																dir,
																suffix,
																send_direct,
																send_direct_option,
																send_direct_option_relay,
																send_direct_option_server,
																asrn,
																relay,
																server);
				
				sms.mailsend(fl,files[i].getPath(),ff,files,i);

			}
			//コスト送信
			else if( sendkind == 2){
				Client_Cost_Send scs = new Client_Cost_Send(	mode,
																dir,
																suffix,
																send_direct,
																send_direct_option,
																send_direct_option_relay,
																send_direct_option_server,
																asrn,
																relay,
																server);
				scs.costsend(fl,files[i].getPath(),ff,files,i);
			}
			else{
				continue;
			}
		
		}
    	//送信バッファのループの終端

		tts.sendTaskDead();
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
		
	}

/*	
	
	//接続要求１
	public boolean conection_Request(short code,String userid) {
		
		short i =  (short) userid.length();
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		
		byte[] buff =  userid.getBytes();

		for(int j = 0;j<buff.length;j++){
			send[j+4] = buff[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact Request. code:"+code + " user:"+userid);
		return true;
		
	}
*/
	
/*	
	//メール送信許可要求
	public boolean mailSendPermission_Request(short code,byte[] data) {
		
		short i =  (short)data.length;
		
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF);
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		

		for(int j = 0;j<data.length;j++){
			send[j+4] = data[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "mail Send Permission Request. code:"+code );
		return true;

		
	}
*/	

/*	
	//接続要求受付
	public boolean conection_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Time Out Error ");
			return false;
		}

		//情報あり？
		if(k != 2){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Data Length is not 2. length:"+k);
			return false;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			System.out.println("コードエラー:" + cd);
			return false;
		}
		System.out.println("要求受付ＯＫ："+cd);
		return true;
		
	}		
*/
	
/*	
	public boolean open(String ipadr) {

		//接続要求
		try {
			sock = new Socket(ipadr,sysconfig.getPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect Request Information++");
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
			in  = sock.getInputStream();
			out = sock.getOutputStream();
		} catch (UnknownHostException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		} catch (IOException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "接続要求ノードに接続しました");
		return true;
	}
*/
	
/*	
	public boolean close()  {
		//ソケットクローズ
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect off Information++");
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
		blnswitch = false;
		try {
			sock.close();
		} catch (IOException e) {
			System.out.println("クライアントソケット クローズエラー");
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "切断しました");
		return true;
	}
*/

/*
	public boolean send_Byte(byte[] byte_send)  {
		int j;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send end");
		return true;
	}
*/	
	
/*	public void send_String(String str_send)  {
		//送信
		System.out.println("送信中...");
		//ストリームデータ送信
		String buf_string =  str_send ;
		buf_send = buf_string.getBytes() ;
		j = buf_string.getBytes().length;
		try {
			//ストリームデータ掃き出し
			out.write(buf_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

		System.out.println("送信成功");
	}
*/	

	
/*	
	public boolean send_file(String filename)  {
		filesize = 0;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file start");
		
		//ストリームデータ送信

		FileInputStream fin = null;

		short code = 11;
	    int len = 0;
	    short edaban = 0;

	    byte[] data = new byte[sysconfig.getBuffsize() -6];

		//ファイル設定
		try {
			fin = new FileInputStream(filename);
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return false;
		}
		
		try {
			//送信ループ
			filesize = 0;
			while ((len = fin.read(data)) != -1) {
				byte[] send = new byte[len+6];
			    //コード
				send[0] =  (byte)((code >>> 8) & 0xFF);
				send[1] =  (byte)((code >>> 0) & 0xFF) ;
			    //レングス
				send[2] =  (byte)((len >>> 8) & 0xFF);
				send[3] =  (byte)((len >>> 0) & 0xFF);
			    //枝番
				edaban++;
				send[4] =  (byte)((edaban >>> 8) & 0xFF);
				send[5] =  (byte)((edaban >>> 0) & 0xFF);

				//送信データ作成
				for(int i=0;i<len;i++){
					send[i+6]= data[i];
				}

//				out.write(send, 0, len+6);
				send_Byte(send);
				filesize = filesize + len;
//				System.out.println("send len:" + send.length);
//				System.out.println("len  len:" + len);
				
				
			}
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return false;
		}
		


		//おまじない
		try {
			//出力ファイルの掃き出し
			out.flush();
			//入力ファイルの開放
			fin.close();
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file end");
		return true;
	}

*/	
	
/*
	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		System.out.println("接続要求回答："+code);
		
	}
*/
	
/*	
	//メールファイル送信完了＆ファイルの大きさを送信
	public boolean send_filesize(short code) {
		
		byte send[]= new byte[6];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send[2] =  (byte)((filesize >>> 24)  & 0xFF) ;
		send[3] =  (byte)((filesize >>> 16)  & 0xFF) ;
		send[4] =  (byte)((filesize >>> 8)  & 0xFF) ;
		send[5] =  (byte)((filesize >>> 0)  & 0xFF) ;
		
		if(send_Byte(send) == false){
			return false;
		}
		
		System.out.println("接続要求回答："+ code);
		System.out.println("ファイルレングス："+filesize);
		return true;
		
	}
*/	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	private byte sendkind(String filename){
		//コストの返信
		if(filename.substring(0, 1).equals("C") == true){
			return 2;
		}
		//メールの送信
		else{
			return 1;
		}
	}
	
	private void user_get(){
		//送信手順を取得
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		send_direct 				= su.isSend_direct();				//42.直接送信
		send_direct_option			= su.isSend_direct_option();		//43.直接送信オプション
		send_direct_option_relay	= su.isSend_direct_option_relay();	//44.直接送信オプション他ノード中継
		send_direct_option_server	= su.isSend_direct_option_server();	//45.直接送信オプションサーバ中継


		//他ノードの取得
		if(send_direct == false	||	
				(send_direct_option == true && 	send_direct_option_relay == true)){
			//優先順位１
			if(su.getRelay1_node() != null && su.getRelay1_node().length() > 0){
				Struct_Relay_Node srn = new Struct_Relay_Node();
				srn.setUserid(su.getRelay1_userid());
				srn.setNode(su.getRelay1_node());
				srn.setProject(su.getRelay1_project());
				srn.setCommunity(su.getRelay1_community());
				asrn.add(srn);
			}
			//優先順位２
			if(su.getRelay2_node() != null && su.getRelay2_node().length() > 0){
				Struct_Relay_Node srn = new Struct_Relay_Node();
				srn.setUserid(su.getRelay2_userid());
				srn.setNode(su.getRelay2_node());
				srn.setProject(su.getRelay2_project());
				srn.setCommunity(su.getRelay2_community());
				asrn.add(srn);
			}
			//優先順位３
			if(su.getRelay3_node() != null && su.getRelay3_node().length() > 0){
				Struct_Relay_Node srn = new Struct_Relay_Node();
				srn.setUserid(su.getRelay3_userid());
				srn.setNode(su.getRelay3_node());
				srn.setProject(su.getRelay3_project());
				srn.setCommunity(su.getRelay3_community());
				asrn.add(srn);
			}
			//優先順位４
			if(su.getRelay4_node() != null && su.getRelay4_node().length() > 0){
				Struct_Relay_Node srn = new Struct_Relay_Node();
				srn.setUserid(su.getRelay4_userid());
				srn.setNode(su.getRelay4_node());
				srn.setProject(su.getRelay4_project());
				srn.setCommunity(su.getRelay4_community());
				asrn.add(srn);
			}
			//優先順位５
			if(su.getRelay5_node() != null && su.getRelay5_node().length() > 0){
				Struct_Relay_Node srn = new Struct_Relay_Node();
				srn.setUserid(su.getRelay5_userid());
				srn.setNode(su.getRelay5_node());
				srn.setProject(su.getRelay5_project());
				srn.setCommunity(su.getRelay5_community());
				asrn.add(srn);
			}
		}
			
	}	

	
/*	
	
	private boolean node_connect(String node,String userid){
		//回線接続
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket open");
		if(open(node) == false){
			//オープン失敗
			return false;
		}
	
		sleep();


		//(000)クライアント接続要求の送信
		if(conection_Request((short) 0,userid) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "000 sended client-connection request OK");
		//(100)クライアント接続要求の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 waiting client-connection-request anser");
		if(conection_Recept((short)100) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "100 recieved client-connection-request anser OK");
		
		sleep();

		return true;
		
		
		
	}
*/	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	

}