package socket_client;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;


import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Client_MasterRecieve {

	//ソケット
	Socket sock = null;

	//送受信用
	InputStream in = null;							//入力ストリーム
	OutputStream out = null;						//出力ストリーム
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
										addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	String file_separator = System.getProperty("file.separator");
	String fs 			  = file_separator + file_separator;
	
	private byte[] buf_receive	= new byte[sysconfig.getBuffsize()];		//受信バッファ
	private byte[] buf_send	= new byte[sysconfig.getBuffsize()];		//送信バッファ
	private int j,k;														//送信、受信バイト数
	
	private String filename = null;
	private long  lastupdate;
	private String project = null;
	boolean masterfound;
	
	public Client_MasterRecieve(Socket sock,
			InputStream in,
			OutputStream out,
			String project){

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.sock 			= sock;
		this.in				= in;
		this.out			= out;
		this.project		= project;
		
	}
	
	
	public boolean submit(){

		//マスターファイル送信許可要求の受付
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "(060,061) waiting master-send-permission-request");

		Object answer = masterfile_Contact();
		if(answer instanceof Boolean){
			//********************************************
			//* エラー
			//********************************************
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "(060,061) connection Error");
			return false;
		}
		else if(answer instanceof Long){
			//********************************************
			//* プロジェクトファイルのタイムスタンプ更新
			//********************************************
			//マスファーファイルのタイムスタンプ更新
			String filepath;
			String newfilepath	= addr.getDir_current() + fs+"new_"+ addr.getFile_project_info().replaceAll(fs, "");
			
			//newファイルが存在する場合は優先する
			if(new File(newfilepath).exists()){
				filepath	= addr.getDir_current() + addr.getFile_project_info();
			}else{
				filepath	= newfilepath;
			}
			
			Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
			t.loadXml();
			ArrayList<Struct_Entry_Project>sep= t.getdata();
			for(int i=0;i<sep.size();i++){
				if(project.equals(sep.get(i).getProject())){
					sep.get(i).setLastupdate((Long) answer);
					break;
				}
			}
			t = new Tool_Entry_Project_IO(newfilepath);
			t.putdata(sep);
			t.saveXml();
			
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "061 Project TimeStamp Update complete");
			return true;
		}
		else if(answer instanceof String){
			//********************************************
			//* マスターファイルのコピー
			//********************************************
			filename = (String) answer;
			//マスターーファイル送信許可要求回答通知
			conection_Answer((short) 110);	
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 sended master-send-permission-request anser  OK");
			
			String filepath;
			if(filename.equals(addr.getFile_config().replaceAll(fs, ""))){
				//コンフィグファイル
				filepath =addr.getDir_current()+fs +"new_"+addr.getFile_config().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_eval_rank().replaceAll(fs, ""))){
				//評価基準ファイル
				filepath =addr.getDir_current()+fs +"new_"+addr.getFile_eval_rank().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_position().replaceAll(fs, ""))){
				//職種ファイル
				filepath =addr.getDir_current()+fs +"new_"+addr.getFile_position().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_pos_cost().replaceAll(fs, ""))){
				//職種別単価ファイル
				filepath =addr.getDir_current()+fs +"new_"+addr.getFile_pos_cost().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_business_year_days().replaceAll(fs, ""))){
				//年間営業日数ファイル
				filepath =addr.getDir_current()+fs +"new_"+addr.getFile_business_year_days().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_com_all().replaceAll(fs, ""))){
				//コミュニティファイル
				filepath =addr.getDir_current()+addr.getDir_project() + fs +project+ fs  +"new_"+addr.getFile_com_all().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_com_menber().replaceAll(fs, ""))){
				//コミュニティメンバーファイル
				filepath =addr.getDir_current()+addr.getDir_project() + fs +project+ fs  +"new_"+addr.getFile_com_menber().replaceAll(fs, "");
			}
			else if(filename.equals(addr.getFile_com_select().replaceAll(fs, ""))){
				//参加コミュニティリストファイル
				filepath =addr.getDir_current()+addr.getDir_project() + fs +project+ fs  +"new_"+addr.getFile_com_select().replaceAll(fs, "");
			}
			else{
				//ファイルが見当たらない
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "No Master File Error file="+filename);
				return false;
			}

			
			if(recieve_file(filepath) == false){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
				return false;
			}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "011 file recieve OK");
			
			sleep();
			//ファイル受信完了通知
			conection_Answer((short) 112);	
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "112 sended masterfile-send-complete OK");
			return true;
		}
		
		//死にロジック
		return false;
		
	}


	
	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Send Answer code:"+code);
		
	}
	
	public int getport() {
			return sock.getPort();
	}
	
	
	
	
	//マスターファイル送信許可要求の受付
	public Object masterfile_Contact(){
		try {
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Second Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		
		
		//データなし
		if(k<5){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Nothing Data Error");
			return false;
		}

		//コード取得
		short code ;
		code =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );
		

		//61:タイムスタンプ
		if(code == 61 ){
			byte timebyte[] = new byte[8];
			for(int i=0 ;i<8;i++){
				timebyte[i] = buf_receive[i+2];
			}
			
            ByteArrayInputStream bin = new ByteArrayInputStream( timebyte );
            DataInputStream din = new DataInputStream( ( InputStream )bin ) ;
            long timestamp = 0;
			try {
				timestamp = din.readLong();
			} catch (IOException e) {
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:timestamp Binary To long Error");
				return false;
			}
			
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:timestamp="+ timestamp);
			return timestamp;
		}

		//接続要求コードではない場合 60:マスターファイル
		if(code != 60 ){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Code is Not 060 Error. code="+ code);
			return false;
		}
		
		//レングス取得
		short len ;
		len =  (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
		
		//電文の長さ誤り
		if(k-4 != len){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Data Length Unmatch Error. "
					+ "info Length=" + len	+ " Real Length=" + (k-4));
			return false;
		}
		
		//マスターファイルの設定
		byte data[] = new byte[len];
		for(int j = 0;j<len;j++){
			data[j] = buf_receive[j+4];
		}
		String masterfile = new String(data);

		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:MasterFile="+masterfile);
		return masterfile;			
		
	}		

	public boolean recieve_file(String str_recieve)   {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file start");


			FileOutputStream fout = null;
			try {
				fout = new FileOutputStream(str_recieve);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "recieve_file:FileOutputStream error");
				return false;
			}

	/*		OutputStreamWriter osw = null;		
			BufferedWriter bw = null;
			try {
				osw = new OutputStreamWriter(fout , "UTF8");
				bw = new BufferedWriter(osw);
			} catch (UnsupportedEncodingException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			}
	*/

			
			
//				byte[] data = new byte[BUFSIZE];
		    int recvMsgSize = 0;
		    int totalByte = 0;

			try {
				short edaban_save = 1;
				recvMsgSize = in.read(buf_receive);
				while(true){
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Packet Total Size="+ recvMsgSize);
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Real   Data  Size="+ (recvMsgSize-6));
				     //Write to file
					short code		= (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

					//接続要求コードではない場合
					if(code == 11){
						short len		= (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
						short edaban	= (short) (   ((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Data Size Info.  ="+ len);
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:recieve mail parts edaban_save="+ edaban);

						//枝番誤り
						if(edaban != edaban_save){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() , 
									"recieve_file:edaban miss match Error. real edaban="+ edaban +" vs request edaban=" + edaban_save);
							fout.close();
							return false;
						}

						//電文の長さ誤り
						if(recvMsgSize-6 < len){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() ,
									"recieve_file:DADA too short Error.  real size="+(recvMsgSize-6) + "  vs  info size=" + len);
							fout.close();
							return false;
						}
						
						byte[] data = new byte[len];
						
						for(int i=0 ; i<len ; i++){
							data[i] = buf_receive[i+6] ;
						}

						
						
						totalByte = totalByte + len;
						fout.write(data,0,len);
						

	/*					String a = data.toString();
						logout.out("zzz", a);
						bw.write(a);
						bw.newLine();
	*/					
						//
						if((recvMsgSize-6) == len){
							recvMsgSize = 0;
							sleep();
							if((recvMsgSize = in.read(buf_receive)) == -1){
								return false;
							}
						}
						//連続してデータが届いた場合、
						else{
							byte[] buf = buf_receive;
							//フライングして到着した分をバッファに保存
							int Arrival = recvMsgSize - (len + 6);
							for(int i=0 ; i<Arrival ; i++){
								buf_receive[i] = buf[len + 6 + i] ;
							}
							//ファイルサイズっぽいデータがまるごと含まれていた場合
							if(Arrival == 6){
								recvMsgSize = Arrival;
								continue;
							}
							//未到着分を残りのバッファサイズに確保する
							recvMsgSize = 0;
							if((recvMsgSize = in.read(buf_receive,Arrival,sysconfig.getBuffsize() - Arrival)) == -1){
								return false;
							}
							logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
										"Arrival ahead bytes :Size="+ Arrival);
						}
						
					
						edaban_save++;
					
					}
					else if(code == 12){
						int size		= (int) (   ((buf_receive[2]<<24)&0xFF00) + ((buf_receive[3]<<16)&0xFF00) +
													((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:recieved mail. file size:"+ size);
						if(totalByte != size){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() , 
									"recieve_file:File Length Miss Match Error.  real size="+totalByte + "  vs  info size=" + size);
							return false;
						}
//						bw.close();
						fout.close();
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file end");
						return true;
					}
					else{
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "recieve_file:Code is not 012 Error. code="+code);
						fout.close();
						return false;
					}
					

				  }

				
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
				return false;

			}
		
		}	

	public boolean send_Byte(byte[] byte_send)  {
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte end");
		return true;
	}
	
	
	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
}
