package socket_client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;

import socket_common.Recieve;
import structure.File_and_Directory_Address;
import structure.Struct_Connect_Digest;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Client_Recieve {

	//ソケット
	Socket 			sock 	= null;

	//送受信用
	InputStream 	in 		= null;		//入力ストリーム
	OutputStream 	out 	= null;		//出力ストリーム

	//パラメータ
	String 			project = null;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
									addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ

	
	public Client_Recieve(String project){
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.project	=	project;
		
	}
	
	
	
	public void recieve(){

		//プロジェクトの取得
		Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
											addr.getFile_project_info());
		tep.loadXml();
		Struct_Entry_Project sep = tep.getdata(tep.getLine(project));			
		
		if(node_connect(sep.getIp_address(),sep.getUserid()) == false)
		{
			return;
		}

		
	    //ユーザー情報
    	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		
		//プロジェクトファイルの先頭プロジェクトはすべてのマスターファイルをダウンロードする
		//それ以外のプロジェクトは、コミュニティとコミュニティメンバーのみダウンロードする。
		boolean firstproject;
		if(tep.getLine(project) == 0){
			firstproject = true;
		}else{
			firstproject = false;
		}
		
		short sendkind = node_Attestation(su.getUserid(),project,sep.getLastupdate(),firstproject);

		
		//０より小さい場合はエラー
		if(sendkind < 0){
			return;
		}
		//２５５は送信データなしなのでスキップ
		else if(sendkind != 255){
			while(true){
				
				if(sendkind == 2){
					//***************************************************************************
		    		//* マスターファイル受信手順開始
		    		//***************************************************************************
					Client_MasterRecieve cmr = new Client_MasterRecieve(sock,in,out,sep.getProject());
					
					if(cmr.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					//***************************************************************************
		    		//* マスターファイル受信手順終了
		    		//***************************************************************************
				}

				//次のデータ有無を取得
				sendkind = kind_Recept((short)151);
				//０より小さい場合はエラー
				if(sendkind < 0){
	    			close();
	    			return;
				}
				//２５５は送信データなし
				else if(sendkind == 255){
					break;
				}
				
			}			
		}


		sendkind = kind_Recept((short)151);
		//０より小さい場合はエラー
		if(sendkind < 0){
			close();
			return;
		}
		//２５５は送信データなし
		//２５５は送信データなしなのでスキップ
		else if(sendkind != 255){
			while(true){
				
				if(sendkind == 1){
					//***************************************************************************
		    		//* メールおよびコスト受信手順開始
		    		//***************************************************************************

					Recieve rcv = new Recieve(sock,in,out);
					if(rcv.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Recieve Error");
						close();
						return;
					}
		    		
		    		//***************************************************************************
		    		//* メールおよびコスト受信手順終了
		    		//***************************************************************************				
				}

				//次のデータ有無を取得
				sendkind = kind_Recept((short)151);
				//０より小さい場合はエラー
				if(sendkind < 0){
	    			close();
	    			return;
				}
				//２５５は送信データなし
				else if(sendkind == 255){
					break;
				}
				
			}
			
		}
		
				
		//回線切り離しはサーバ書き込みが終了
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket close");
		close();
    	
	}	
	
	

	
	//接続要求受付
	public boolean conection_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
//			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Time Out Error ");
			return false;
		}

		//情報あり？
		if(k != 2){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Data Length is not 2. length:"+k);
			return false;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Code unmatch.  wait code="+code + "  send code="+cd);
			return false;
		}
		return true;
		
	}		

	//送信種類受付
	public short kind_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
//			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "send kind recept:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return -1;
		}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "send kind recept:Time Out Error ");
			return -1;
		}

		//情報あり？
		if(k != 4){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "send kind recept:Data Length is not 2. length:"+k);
			return -1;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			System.out.println("コードエラー:" + cd);
			return -1;
		}

		//コード取得
		short kind =  (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
		
		System.out.println("要求受付ＯＫ："+cd);
		return kind;
		
	}		
	
	public boolean open(String ipadr) {

		//接続要求
		try {
			sock = new Socket(ipadr,sysconfig.getPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect Request Information++");
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
			in  = sock.getInputStream();
			out = sock.getOutputStream();
		} catch (UnknownHostException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		} catch (IOException e) {
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "接続要求ノードに接続できません");
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "接続要求ノードに接続しました");
		return true;
	}
	
	public boolean close()  {
		//ソケットクローズ
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conect off Information++");
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());
//		blnswitch = false;
		try {
			sock.close();
		} catch (IOException e) {
			System.out.println("クライアントソケット クローズエラー");
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "切断しました");
		return true;
	}


	public boolean send_Byte(byte[] byte_send)  {
		int j;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send end");
		return true;
	}
	
	

	

	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		System.out.println("接続要求回答："+code);
		
	}
	
	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	private boolean node_connect(String node,String userid){
		//回線接続
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "client socket open");
		if(open(node) == false){
			//オープン失敗
			return false;
		}
	
		sleep();

		//(050)クライアント接続要求の送信
		if(conection_Request((short)50,userid) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "050 sended client-connection request OK");
		//(150)クライアント接続要求の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "150 waiting client-connection-request anser");
		if(conection_Recept((short)150) == false ){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "150 recieved client-connection-request anser OK");
		
		sleep();

		return true;
		
		
		
	}
	//接続要求１
	public boolean conection_Request(short code,String userid) {
		
		short i =  (short) userid.length();
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		
		byte[] buff =  userid.getBytes();

		for(int j = 0;j<buff.length;j++){
			send[j+4] = buff[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact Request. code:"+code + " user:"+userid);
		return true;
		
	}	

	
	private short node_Attestation(String userid,String project,Long lastupdate,boolean firstproject){
	
		sleep();

		//(050)クライアント接続要求の送信
		if(conection_Attestation((short)51,userid,project,lastupdate,firstproject) == false){
			return -1;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "051 sended client-connection request OK");
		//(151)クライアント接続要求の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "151 waiting client-connection-request anser");
		short kind = kind_Recept((short)151); 
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "151 recieved client-connection-request anser OK");
		
		sleep();

		return kind;
		
		
		
	}

	//接続要求１
	public boolean conection_Attestation(short code,String userid,String project,Long lastupdate,boolean firstproject) {
		
		Struct_Connect_Digest data = new Struct_Connect_Digest();
		data.setSender(userid);
		data.setProject(project);
		data.setLastupdate(lastupdate);
		data.setFirstproject(firstproject);
		
		byte[] pcu_data = data.getByte();	
		
		short i =  (short) pcu_data.length;
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);

		for(int j = 0;j<pcu_data.length;j++){
			send[j+4] = pcu_data[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Attestation. code:"+code + " user:"+userid + " project:"+ project +" lastupdate:"+lastupdate);
		return true;
		
	}	
	
	
	
	
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
	
}
