package structure;

import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;

public class File_and_Directory_Address implements Serializable{

	
	//ファイルセパレータ
	//Windows と Linux の共存対策
	private String file_separator = System.getProperty("file.separator");
	private String fs 			  = file_separator + file_separator;

	
	
	//ファイル
	String file_user_info 			= 	fs + "user.txt";
	String file_project_info 		= 	fs + "project.txt";
	String file_community_digest 	= 	fs + "community_digest.txt";
	String file_cost_digest 		= 	fs + "cost_digest.txt";
	String file_com_all				=	fs + "community_all.txt";
	String file_com_select			=	fs + "community_select.txt";
	String file_com_menber			=	fs + "community_menber.txt";
	String file_windowlist			=	fs + "windowlist.txt";
	String file_digest				=	"_digest.txt";
	String file_BCCdigest			=	"_BCC_digest.txt";
	String file_status				=	fs + "status.txt";
	String file_config				=	fs + "config.txt";
	String file_position			=	fs + "position.txt";
	String file_pos_cost			=	fs + "pos_cost.txt";
	String file_business_year_days	=	fs + "business_year_days.txt";
	String file_eval_rank			=	fs + "eval_rank.txt";
	String file_guistate			=	fs + "guistate.txt";
	String file_menber				=	fs + "menber.txt";	//mailcost_web用
	String file_master				=	fs + "master.txt";	//mailcost_web用
	String file_userconfirm			=	fs + "userconfirm.txt";	

	//ログファイル
	//　◇◇◇　要注意　出力先はゲッターを参照すること　◇◇◇
//	String dir_log					=	"\\log\\";
	String dir_log					=	fs +"log" + fs;
	String file_log					=	"_mailcost.log";
	String file_stdout				=	"_stdout.log";
	String file_stderr				=	"_stderr.log";
	
	//プログラム
	String dir_pgm					=	"pgm";
	String pgm_message				=	fs + "Client_Message.jar";
	String pgm_client				=	fs + "Client_Client.jar";
	String pgm_server				=	fs + "Client_Server.jar";
	String pgm_report_cost			=	fs + "Client_ReportCost.jar";
	String pgm_analysisreport_cost	=	fs + "Client_ReportAnalysisCost.jar";
	String pgm_make_analysis		=	fs + "Client_Analysis_Report.jar";
	String pgm_evaluate				=	fs + "Client_Evaluate.jar";
	
	//ノード
	String node_cost 				=	"Cost";
	String node_send 				=	"Send";
	String node_recive 				=	"Recieve";
	String node_analysis 			=	"Analysis";
	
	//ファイルサフィックス
	String File_cost_suffix			=	"C";

	//ファイルプレフィックス
	String prefix_send				=	"_send.txt";
	String prefix_recieve			=	"_recieve.txt";
	
	//ディレクトリ
//	String dir_current 				=	"D:\\mailcost_web\\server";
//	String dir_current 				=	"D:\\mailcost";
	String dir_current 				=	"D:\\zzzmailcost";
//	String dir_current 				=	new String();
	String dir_buff_send 			=	fs + "buff_send" 	+ fs;
	String dir_buff_recieve 		=	fs + "buff_recieve" + fs;
	String dir_buff_relay 			=	fs + "buff_relay" 	+ fs;
	String dir_project 				=	fs + "project" 		+ fs;
	String dir_send 				=	fs + "send" 		+ fs;
	String dir_draft 				=	fs + "draft" 		+ fs;
	String dir_cost 				=	fs +  node_cost.toLowerCase() + fs;
	String dir_costsend 			=	dir_cost + node_send.toLowerCase();
	String dir_costrecive 			=	dir_cost + node_recive.toLowerCase();
	String dir_costanalysis			=	dir_cost + node_analysis.toLowerCase();
	String dir_task 				=	fs + "task"			+ fs;
	String dir_task_socket			=	fs + "task_socket"	+ fs;
	String dir_icon 				=	fs + "icon" 		+ fs;
	
	//タスク
	String task_read				=	"read";
	String task_write				=	"write";

	//アイコン
	String icon_mailcost 			= 	"mailcost.gif";
	String icon_project 			= 	"project.gif";
	String icon_community 			= 	"community.gif";
	String icon_sendcost 			= 	"sendcost.gif";
	String icon_recievecost 		= 	"recievecost.gif";
	String icon_analysiscost 		= 	"analysiscost.gif";
	String icon_incompleteness 		= 	"incompleteness.gif";	//未送,未読
	String icon_noteval		 		= 	"noteval.gif";			//未評
	String icon_dead_suffix			=	"dead";
	
	
	public String getIcon_noteval() {
		return icon_noteval;
	}


	public String getIcon_incompleteness() {
		return icon_incompleteness;
	}


	public String getIcon_dead_suffix() {
		return icon_dead_suffix;
	}


	public String getDir_icon() {
		return dir_icon;
	}


	public String getIcon_mailcost() {
		return icon_mailcost;
	}


	public String getIcon_project() {
		return icon_project;
	}


	public String getTask_read() {
		return task_read;
	}


	public String getTask_write() {
		return task_write;
	}


	//実行年月を取得
	private String getyyyymm(){
    	DecimalFormat dfyyyy = new DecimalFormat("0000");
    	DecimalFormat dfmm = new DecimalFormat("00");

		Calendar cal = Calendar.getInstance();  
		int year = cal.get(Calendar.YEAR);        
	    int month = cal.get(Calendar.MONTH) + 1; 
	    
	    return dfyyyy.format(year) + dfmm.format(month);

	}
	
	
//	public String getDir_cost() {
//		return dir_cost;
//	}
//	public void setDir_cost(String dir_cost) {
//		this.dir_cost = dir_cost;
//	}
	//ゲッター
	public String getDir_buff_recieve() {
		return dir_buff_recieve;
	}
	public String getDir_buff_send() {
		return dir_buff_send;
	}
	public String getDir_buff_relay() {
		return dir_buff_relay;
	}

	
	
	public String getDir_current() {

		//未設定の場合、カレントディレクトリを取得する
		if(dir_current == null || dir_current.length() == 0){
			//実行中のプログラムの親ディレクトリを取得する
/*			String cdir = System.getProperty("user.dir");
			//実行プログラムの親ディレクトリがプログラムディレクトリにあるか？
			int index = cdir.lastIndexOf(dir_pgm);
			if(index > -1){
				File file = new File(cdir);
				dir_current = file.getParent();
			}
			else{
				dir_current = cdir;
			}
*/		
			String cdir = System.getProperty("java.class.path");
			File file 	= new File(cdir);
			file		= new File(file.getParent());
			dir_current	= file.getParent();

		}
		
		return dir_current;
	}
	public void setDir_current(String dir_current) {
		this.dir_current = dir_current;
	}
	public String getDir_project() {
		return dir_project;
	}
	public void setDir_project(String dir_project) {
		this.dir_project = dir_project;
	}
	
	
	public String getDir_Task() {
		return dir_task;
	}
	
	public String getFile_com_all() {
		return file_com_all;
	}
	public void setFile_com_all(String file_com_all) {
		this.file_com_all = file_com_all;
	}
	public String getFile_com_menber() {
		return file_com_menber;
	}
	public void setFile_com_menber(String file_com_menber) {
		this.file_com_menber = file_com_menber;
	}
	public String getFile_com_select() {
		return file_com_select;
	}
	public void setFile_com_select(String file_com_select) {
		this.file_com_select = file_com_select;
	}
	public String getFile_community_digest() {
		return file_community_digest;
	}
	public void setFile_community_digest(String file_community_digest) {
		this.file_community_digest = file_community_digest;
	}
	public String getFile_project_info() {
		return file_project_info;
	}
	public void setFile_project_info(String file_project_info) {
		this.file_project_info = file_project_info;
	}
	public String getFile_user_info() {
		return file_user_info;
	}
	public void setFile_user_info(String file_user_info) {
		this.file_user_info = file_user_info;
	}
	public String getFile_windowlist() {
		return file_windowlist;
	}
	public void setFile_windowlist(String file_windowlist) {
		this.file_windowlist = file_windowlist;
	}
	public String getFile_digest() {
		return file_digest;
	}
	public void setFile_digest(String file_digest) {
		this.file_digest = file_digest;
	}
	public String getDir_draft() {
		return dir_draft;
	}
	public String getDir_send() {
		return dir_send;
	}

	
	
	public String getPgm_message() {
		return fs + dir_pgm + pgm_message;
	}
	public String getFile_status() {
		return file_status;
	}
	public String getPgm_client() {
		return fs + dir_pgm + pgm_client;
	}
	public String getPgm_server() {
		return fs + dir_pgm + pgm_server;
	}
	public String getPgm_report_cost() {
		return fs + dir_pgm + pgm_report_cost;
	}
	public String getPgm_analysisreport_cost() {
		return fs + dir_pgm + pgm_analysisreport_cost;
	}
	public String getPgm_make_analysis() {
		return fs + dir_pgm + pgm_make_analysis;
	}
	
	public String getPgm_evaluate() {
		return  fs + dir_pgm + pgm_evaluate;
	}
	
	
	public String getFile_config() {
		return file_config;
	}
	public void setFile_config(String file_config) {
		this.file_config = file_config;
	}
	public String getFile_log() {
		return dir_log + getyyyymm() + file_log;
	}
	public void setFile_log(String file_log) {
		this.file_log = file_log;
	}
	public String getFile_stderr() {
		return dir_log + getyyyymm() + file_stderr;
	}
	public void setFile_stderr(String file_stderr) {
		this.file_stderr = file_stderr;
	}
	public String getFile_stdout() {
		return dir_log + getyyyymm() + file_stdout;
	}
	public void setFile_stdout(String file_stdout) {
		this.file_stdout = file_stdout;
	}
	public String getFile_pos_cost() {
		return file_pos_cost;
	}
	public void setFile_pos_cost(String file_pos_cost) {
		this.file_pos_cost = file_pos_cost;
	}
	public String getFile_position() {
		return file_position;
	}
	public void setFile_position(String file_position) {
		this.file_position = file_position;
	}
	public String getFile_cost_digest() {
		return file_cost_digest;
	}
	public void setFile_cost_digest(String file_cost_digest) {
		this.file_cost_digest = file_cost_digest;
	}
	public String getFile_business_year_days() {
		return file_business_year_days;
	}
	public void setFile_business_year_days(String file_business_year_days) {
		this.file_business_year_days = file_business_year_days;
	}
	public String getFile_BCCdigest() {
		return file_BCCdigest;
	}
	public void setFile_BCCdigest(String file_BCCdigest) {
		this.file_BCCdigest = file_BCCdigest;
	}
	public String getFile_eval_rank() {
		return file_eval_rank;
	}
	public void setFile_eval_rank(String file_eval_rank) {
		this.file_eval_rank = file_eval_rank;
	}
	public String getDir_costrecive() {
		return dir_costrecive;
	}
	public String getDir_costsend() {
		return dir_costsend;
	}
	public String getDir_costanalysis() {
		return dir_costanalysis;
	}


	public String getNode_cost() {
		return node_cost;
	}


	public String getNode_recive() {
		return node_recive;
	}
	public String getNode_send() {
		return node_send;
	}
	public String getNode_analysis() {
		return node_analysis;
	}


	public String getFile_cost_suffix() {
		return File_cost_suffix;
	}


	public String getPrefix_recieve() {
		return prefix_recieve;
	}


	public String getPrefix_send() {
		return prefix_send;
	}


	public String getDir_task_socket() {
		return dir_task_socket;
	}


	public String getFs() {
		return fs;
	}


	public String getFile_guistate() {
		return file_guistate;
	}


	public String getFile_menber() {
		return file_menber;
	}


	public String getFile_master() {
		return file_master;
	}


	public String getIcon_analysiscost() {
		return icon_analysiscost;
	}


	public String getIcon_recievecost() {
		return icon_recievecost;
	}


	public String getIcon_sendcost() {
		return icon_sendcost;
	}


	public String getIcon_community() {
		return icon_community;
	}


	public String getFile_userconfirm() {
		return file_userconfirm;
	}

	
}
