package mailcost_main;


import java.io.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

import structure.File_and_Directory_Address;
import structure.Struct_CostBar;
import structure.Struct_Cost_Digest;
import structure.Struct_System_Config;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Gui_CostView extends JInternalFrame {
	
	JTable table ;
	JScrollPane src;
	
	Struct_Cost_Digest scd = new Struct_Cost_Digest();
	

	Boolean				blnsubmit	=	true;
	int oldrow	=	-2;
	int nowrow	=	-1;
	
	Tool_Cost_Digest_IO t;
	
	String dir;
	String project;
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());


	Gui_CostView(){

		super("コスト",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
		//********************************************************************
		//* windowはプログレスバーの背景が表示できないので、
		//* コストだけメタルに統一して表示する
		//********************************************************************
		try {
			UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
		} catch (Exception e) {
			e.printStackTrace();
		}		

		setClosable(false);
		setVisible(true);
		setFrameIcon(null);

		
		setResizable(false);

//		table =new JTable(0,scd.getColData().length);
		table =new JTable(0,scd.getColData_short().length);
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
		
		//カラム表示設定
		table_Config(table);

/*		 
		TableColumn col;

	   	//ＮＯの右寄せ
	   	col = table.getColumnModel().getColumn(1);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);

		LineBorder border = new LineBorder(Color.PINK, 8, true);

		renderer.setBorder(border);
		renderer.setBackground(Color.BLUE);
		col.setCellRenderer(renderer);
	
		
	   	//プログレスバーのセル設定
		for(int i=4;i<9;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_CostBar());
			
		}
*/		
		src = new JScrollPane(table);
		getContentPane().add(src);

		//デフォルト枠線の排除
		setBorder(new EmptyBorder(0,0,0,0));


	}
	
	//jtableのロード	
	public void loadXml(String strproject,String costkind){
		this.project = strproject;
		dir = addr.getDir_current() +	
				addr.getDir_project() + 
				strproject +  addr.getFs()   + 
				costkind +  addr.getFs();
		
		t = new Tool_Cost_Digest_IO ( dir 	 +	addr.getFile_cost_digest());
		t.loadXml();
		DefaultTableModel tableModel;
	
		//０件データの場合
		if(t.getdata().size() == 0){
		   	tableModel = new DefaultTableModel(new Struct_Cost_Digest().getColData_short(),0);
		}
		//１件以上データがある
		else{
			Object[][] Objdata = t.getObj_short();
			tableModel = new DefaultTableModel(Objdata ,new Struct_Cost_Digest().getColData_short())				//編集不可処理
						{public boolean isCellEditable(int row, int column) 
						{	if(blnsubmit == true){
								Message_Submit(row);
							}
							return false;
						}
					};
		}
			
	   	table.setModel(tableModel);
	   	
		//カラム表示設定
		table_Config(table);

/*
		TableColumn col;

	   	//ＮＯの右寄せ
	   	col = table.getColumnModel().getColumn(1);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
		col.setCellRenderer(renderer);

	   	//プログレスバーのセル設定
		for(int i=4;i<9;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_CostBar());
			
		}
*/    	
    	
		//再表示
   		getContentPane().removeAll();
		src = new JScrollPane(table);
		getContentPane().add(src);
    	
	}

	//同じ行を２回選択した場合、メッセージを表示
	public void Message_Submit(int row){
		oldrow = nowrow;
		nowrow = row;
		if(oldrow == nowrow){
			
			//****************************
			//* 表示モードの選択
			//****************************
			String mode = null;
		    String selectvalues[] = {"明細を表示", "ユーザーをまとめて表示","表示中止"};
		    int select = JOptionPane.showOptionDialog(this,
		      "表示方法を選択してください", 
		      "コストレポート", 
		      JOptionPane.YES_NO_OPTION,
		      JOptionPane.QUESTION_MESSAGE,
		      null, 
		      selectvalues, 
		      selectvalues[2]
		    );

		    if(select == 0){
		    	mode = "normal";
		    }
		    else if(select == 1){
		    	mode = "user";
		    }
		    else if(select == 2){
		    	return;
		    }
			
			
			Struct_Cost_Digest scd = t.getdata(row);
			String file = scd.getFilename();
			
			//****************************
			//* コストレポートの表示
			//****************************
			ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
	    			addr.getDir_current()+addr.getPgm_report_cost(),
    				"--mode",mode,							// 1.モード
    				"--dir",dir,							// 2.ディレクトリ
    				"--file",file,							// 3.ファイル
    				"--project",project,					// 4.プロジェクト
    				"--sendnumber",scd.getSendnumber(),		// 5.送信番号
    				"--subject",scd.getSubject(),			// 6.件名
    				"--senddate",scd.getSend_date(),		// 7.送信日付
    				"--sender",scd.getSender()				// 8.送信者
		
			);
			
			try {
				Process process = builder.start();
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}
				
			
		}
		
	}	
	private void table_Config(JTable table){
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);

		TableColumn col;
	   	
	   	//******************************
	   	//* ＮＯの設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(1);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
	   	//右寄せ
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);
		
	   	//******************************
	   	//プログレスバーのセル設定
	   	//******************************
		for(int i=4;i<9;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_CostBar());
			
		}

	}

	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}

	//カラム幅を取得するする
	public int[] getColumnWidth(){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();

		int[] columnWidth = new int[columnModel.getColumnCount()];
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
			columnWidth[i] = column.getWidth();
		}
		return columnWidth;
		
	}

	//カラム幅を設定する
	public void setColumnWidth(int[] columnWidth){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
	    	column.setPreferredWidth(columnWidth[i]);
		}
		
	}
}
