package mailcost_main;


import java.io.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.table.*;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_AnalysisBar;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_System_Config;
import tool.Tool_Cost_Analysis_Digest_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Gui_Cost_AnalysisView extends JInternalFrame {
	
	JTable table ;
	JScrollPane src;
	
	Struct_Cost_Analysis_Digest scad = new Struct_Cost_Analysis_Digest();	

	Boolean				blnsubmit	=	true;
	int oldrow	=	-2;
	int nowrow	=	-1;
	
	Tool_Cost_Analysis_Digest_IO t;
	
	String dir;
	String project;
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(
											addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());


	Gui_Cost_AnalysisView(){

		super("コスト分析",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
		//********************************************************************
		//* windowはプログレスバーの背景が表示できないので、
		//* コストだけメタルに統一して表示する
		//********************************************************************
		try {
			UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
		} catch (Exception e) {
			e.printStackTrace();
		}		
		
		setClosable(false);
		setVisible(true);
		setResizable(false);

		table =new JTable(0,scad.getColData_short().length);
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
		
	   	//カラム表示設定
	   	table_Config(table);

	
		src = new JScrollPane(table);
		getContentPane().add(src);

		//デフォルト枠線の排除
		setBorder(new EmptyBorder(0,0,0,0));

	}
	
	//jtableのロード	
	public void loadXml(String strproject){
		this.project = strproject;
		dir = addr.getDir_current() +	
				addr.getDir_project() + 
				strproject +  addr.getFs()   + 
				addr.getDir_costanalysis() +  addr.getFs() ;
		t = new Tool_Cost_Analysis_Digest_IO ( dir 	 +
										addr.getFile_cost_digest());
		t.loadXml();
		DefaultTableModel tableModel;
	
		//０件データの場合
		if(t.getdata().size() == 0){
		   	tableModel = new DefaultTableModel(new Struct_Cost_Analysis_Digest().getColData_short(),0);
		}
		//１件以上データがある
		else{
			Object[][] Objdata = t.getObj_short();
			tableModel = new DefaultTableModel(Objdata ,new Struct_Cost_Analysis_Digest().getColData_short())				//編集不可処理
						{	public boolean isCellEditable(int row, int column) 
								{	if(blnsubmit == true){
										Message_Submit(row);
									}
									return false;
							}
							public void aaa(){
								
							}

						};
		}
			
	   	table.setModel(tableModel);

	   	
	   	//カラム表示設定
	   	table_Config(table);
	   	

 	
    	
		//再表示
   		getContentPane().removeAll();
		src = new JScrollPane(table);
		getContentPane().add(src);
    	
	}

	//同じ行を２回選択した場合、メッセージを表示
	public void Message_Submit(int row){
		oldrow = nowrow;
		nowrow = row;
		if(oldrow == nowrow){
			
			//****************************
			//* 表示モードの選択
			//****************************
			String mode = null;
			String file = null;
		    String selectvalues[] = {
		    		"送信メールを表示"	,	
		    		"受信メールを表示"	,	
		    		"表示中止"};
		    int select = JOptionPane.showOptionDialog(this,
		      "表示方法を選択してください", 
		      "コスト分析レポート", 
		      JOptionPane.YES_NO_OPTION,
		      JOptionPane.QUESTION_MESSAGE,
		      null, 
		      selectvalues, 
		      selectvalues[2]
		    );

		    Struct_Cost_Analysis_Digest scad = t.getdata(row);
		    //送信メールを表示
		    if(select == 0){
		    	mode = addr.getNode_send();
				file = scad.getFilename_send();

				//選択行の書き込みコストのセルに赤枠を付加する
				Struct_Cost_AnalysisBar w_cell = (Struct_Cost_AnalysisBar) table.getValueAt(row, 1);
				w_cell.setOutline((byte) 1);
			    table.setValueAt(w_cell, row, 1);
		    
				//選択行の自分を評価のセルに赤枠を付加する
				Struct_Cost_AnalysisBar e_cell = (Struct_Cost_AnalysisBar) table.getValueAt(row, 4);
				e_cell.setOutline((byte) 1);
			    table.setValueAt(e_cell, row, 4);

		    }
		    //受信メールを表示
		    else if(select == 1){
		    	mode = addr.getNode_recive();
				file = scad.getFilename_recieve();

				//選択行の読み取りコストのセルに青枠を付加する
				Struct_Cost_AnalysisBar w_cell = (Struct_Cost_AnalysisBar) table.getValueAt(row, 2);
				w_cell.setOutline((byte) 2);
			    table.setValueAt(w_cell, row, 2);
		    
				//選択行の相手を評価に青枠を付加する
				Struct_Cost_AnalysisBar e_cell = (Struct_Cost_AnalysisBar) table.getValueAt(row, 5);
				e_cell.setOutline((byte) 2);
			    table.setValueAt(e_cell, row, 5);

		    }
		    else {
		    	//表示中止
		    	return;
		    }
		    
			//****************************
			//* コストレポートの表示
			//****************************
		    ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
	    			addr.getDir_current()+addr.getPgm_analysisreport_cost(),
    				"--mode",mode,							// 1.モード
    				"--dir",dir,							// 2.ディレクトリ
    				"--file",file,							// 3.ファイル
    				"--project",project,					// 4.プロジェクト
    				"--yyyymm",scad.getYyyymm()				// 5.集約年月
		
			);
    		try {
				Process process = builder.start();
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}
				
			
		}
		
	}	

	private void table_Config(JTable table){
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);
		
		TableColumn col;

	   	//******************************
	   	//年月の中央せ
	   	//******************************
	   	col = table.getColumnModel().getColumn(0);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
	   	//中央せ
		renderer.setHorizontalAlignment(SwingConstants.CENTER);
		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(55);
		
	   	//******************************
	   	//プログレスバーのセル設定
	   	//******************************
		for(int i=1;i<8;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_Cost_AnalysisBar());
			
		}
	
	
	
	}  	
	   	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}

	//カラム幅を取得するする
	public int[] getColumnWidth(){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();

		int[] columnWidth = new int[columnModel.getColumnCount()];
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
			columnWidth[i] = column.getWidth();
		}
		return columnWidth;
		
	}

	//カラム幅を設定する
	public void setColumnWidth(int[] columnWidth){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
	    	column.setPreferredWidth(columnWidth[i]);
		}
		
	}	

}
