package evaluate;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.ArrayList;
import javax.swing.*;


import structure.File_and_Directory_Address;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Cost_Source;
import structure.Struct_System_Config;
import structure.Struct_Time_Count;
import structure.Struct_User;
import tool.Tool_Community_Diject_Status_Update;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_Eval_Rank_IO;
import tool.Tool_Gui_PanelEvaluate;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_Evaluate_Main extends JFrame implements ActionListener{
	
//	Struct_Eval_Rank ser;

	Tool_User_IO user_info;
	Struct_User su;
	
//	JPanel contentPane;
    
//	JRadioButton rbtn_level_5;
//	JRadioButton rbtn_level_4;
//	JRadioButton rbtn_level_3;
//	JRadioButton rbtn_level_2;
//	JRadioButton rbtn_level_1;
//	JRadioButton rbtn_level_0;

//	String level5	=	"5";
//	String level4	=	"4";
//	String level3	=	"3";
//	String level2	=	"2";
//	String level1	=	"1";
//	String level0	=	"0";
	
//	JButton btn_OK;
//	JButton btn_Cancel;

//	DecimalFormat df = new DecimalFormat("0.0");

	String nodeproject;							// 2.ノードプロジェクト
	String nodecommunity;						// 3.ノードコミュニティ
	String sendnumber;							// 4.送信番号
	String senduserid;							// 5.送信ユーザーＩＤ
	String sender;								// 8.送信者
	int recievecount;							// 9.送信人数
	String file;								//10.ファイル
	int sendcost;								//11.送信コスト
	String sendnode;							//12.（差出人）ノード	
	String sendproject;							//13.（差出人）プロジェクト
	String sendcommunity;						//14.（差出人）コミュニティ

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	//評価ランク
	Tool_Eval_Rank_IO eval_rank = new Tool_Eval_Rank_IO(addr.getDir_current() + addr.getFile_eval_rank());

	//評価入力パネル
	Tool_Gui_PanelEvaluate pnl_eval;
	
	Gui_Evaluate_Main(String mode,				// 1.モード
						String nodeproject,		// 2.ノードプロジェクト
						String nodecommunity,	// 3.ノードコミュニティ
						String sendnumber,		// 4.送信番号
						String senduserid,		// 5.（差出人）ユーザーＩＤ
						String subject,			// 6.件名
						String senddate,		// 7.送信日付
						String sender,			// 8.（差出人）送信者
						int recievecount,		// 9.送信人数
						String file,			//10.ファイル
						int sendcost,			//11.送信コスト
						String sendnode,		//12.（差出人）ノード
						String sendproject,		//13.（差出人）プロジェクト
						String sendcommunity){	//14.（差出人）コミュニティ
	

		this.nodeproject 	= nodeproject;		// 2.プロジェクト
		this.nodecommunity	= nodecommunity;	// 3.ノードコミュニティ
		this.sendnumber		= sendnumber;		// 4.送信番号
		this.senduserid		= senduserid;		// 5.送信ユーザーＩＤ
		this.sender			= sender;			// 5.送信ユーザーＩＤ
		this.recievecount	= recievecount;		// 9.送信人数
		this.file			= file;				//10.ファイル
		this.sendcost		= sendcost;			//11.送信コスト
		this.sendnode		= sendnode;			//12.（差出人）ノード
		this.sendproject	= sendproject;		//13.（差出人）プロジェクト
		this.sendcommunity	= sendcommunity;	//14.（差出人）コミュニティ
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.setTitle("評価");
		this.setSize(340, 450);
		this.setLocation(100, 100);

		
		user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		su = user_info.getStruct_User();

		//評価入力パネルを読み込む
		pnl_eval = new Tool_Gui_PanelEvaluate("mordores",
											sendnumber,		// 4.送信番号
											subject,		// 6.件名
											senddate,		// 7.送信日付
											sender);		// 8.（差出人）送信者);
		pnl_eval.btn_OK.addActionListener(this);
		pnl_eval.btn_Cancel.addActionListener(this);
		getContentPane().add(pnl_eval, BorderLayout.CENTER);

		//アイコン表示
		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon() + addr.getIcon_mailcost());
		this.setIconImage(icon.getImage());

		//画面表示
		this.setVisible(true); 
		
/*
		
		contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);

		//ラベル
		JLabel lbl1 = new JLabel();
		lbl1.setText("評価の入力");
		lbl1.setBounds(10, 10, 100, 28);
		contentPane.add(lbl1);
		

		//ラベル　送信番号
		JLabel lbl2 = new JLabel();
		lbl2.setText("送信番号：");
		lbl2.setBounds(30, 40, 100, 28);
		contentPane.add(lbl2);

		//ラベル　送信番号本体
		JLabel lbl3 = new JLabel();
		lbl3.setText(sendnumber);
		lbl3.setBounds(100, 40, 100, 28);
		contentPane.add(lbl3);


		//ラベル　件名
		JLabel lbl4 = new JLabel();
		lbl4.setText("件名　　：");
		lbl4.setBounds(30, 60, 100, 28);
		contentPane.add(lbl4);
		
		//ラベル　件名本体
		JLabel lbl5 = new JLabel();
		lbl5.setText(subject);
		lbl5.setBounds(100, 60, 400, 28);
		contentPane.add(lbl5);

		
		//ラベル　送信者
		JLabel lbl8 = new JLabel();
		lbl8.setText("送信者　：");
		lbl8.setBounds(30, 80, 100, 28);
		contentPane.add(lbl8);

		
		//ラベル　送信者本体
		JLabel lbl9 = new JLabel();
		lbl9.setText(sender);
		lbl9.setBounds(100, 80, 100, 28);
		contentPane.add(lbl9);


		//ラベル　送信日付
		JLabel lbl6 = new JLabel();
		lbl6.setText("送信日付：");
		lbl6.setBounds(30, 100, 100, 28);
		contentPane.add(lbl6);

		
		JLabel lbl7 = new JLabel();
		lbl7.setText(senddate);
		lbl7.setBounds(100, 100, 100, 28);
		contentPane.add(lbl7);


		//***********************************************
		//* 評価の選択
		//***********************************************
		
		//ラジオボタン　レベル５
		ser = eval_rank.getStruct_Eval_Rank(level5);
		rbtn_level_5 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_5.setBounds(30, 140, 450, 28);
		contentPane.add(rbtn_level_5);

		//ラジオボタン　レベル４
		ser = eval_rank.getStruct_Eval_Rank(level4);
		rbtn_level_4 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_4.setBounds(30, 170, 450, 28);
		contentPane.add(rbtn_level_4);

		//ラジオボタン　レベル３
		ser = eval_rank.getStruct_Eval_Rank(level3);
		rbtn_level_3 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_3.setBounds(30, 200, 450, 28);
		contentPane.add(rbtn_level_3);
		
		//ラジオボタン　レベル２
		ser = eval_rank.getStruct_Eval_Rank(level2);
		rbtn_level_2 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_2.setBounds(30, 230, 450, 28);
		contentPane.add(rbtn_level_2);

		//ラジオボタン　レベル１
		ser = eval_rank.getStruct_Eval_Rank(level1);
		rbtn_level_1 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_1.setBounds(30, 260, 450, 28);
		contentPane.add(rbtn_level_1);

		//ラジオボタン　レベル０
		ser = eval_rank.getStruct_Eval_Rank(level0);
		rbtn_level_0 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
		rbtn_level_0.setBounds(30, 290, 450, 28);
		contentPane.add(rbtn_level_0);

		//ラジオボタン　グループ
		ButtonGroup group_warning = new ButtonGroup();
		group_warning.add(rbtn_level_5); 
		group_warning.add(rbtn_level_4);
		group_warning.add(rbtn_level_3); 
		group_warning.add(rbtn_level_2); 	
		group_warning.add(rbtn_level_1); 	
		group_warning.add(rbtn_level_0); 	

		
		if(su.getEval_rank().equals(level5)){
			rbtn_level_5.setSelected( true);
		}
		else if(su.getEval_rank().equals(level4)){
			rbtn_level_4.setSelected( true);
		}
		else if(su.getEval_rank().equals(level3)){
			rbtn_level_3.setSelected( true);
		}
		else if(su.getEval_rank().equals(level2)){
			rbtn_level_2.setSelected( true);
		}
		else if(su.getEval_rank().equals(level1)){
			rbtn_level_1.setSelected( true);
		}
		else if(su.getEval_rank().equals(level0)){
			rbtn_level_0.setSelected( true);
		}

		//余白
		contentPane.add(Box.createRigidArea(new Dimension(10,10)));
		
        //確定ボタン
		btn_OK = new JButton("確定");
		btn_OK.setBounds(80, 340, 70, 50);
		contentPane.add(btn_OK);
		btn_OK.addActionListener(this);	

        //取消ボタン
		btn_Cancel = new JButton("取消");
		btn_Cancel.setBounds(180, 340, 70, 50);
		contentPane.add(btn_Cancel);
		btn_Cancel.addActionListener(this);		
		this.setVisible(true); 
*/		

	}

	//メイン
	public static void main(String[] args){
		String mode 			= null;						// 1.モード
		String nodeproject		= null;						// 2.ノードプロジェクト
		String nodecommunity	= null;						// 3.ノードコミュニティ
		String sendnumber		= null;						// 4.送信番号
		String senduserid		= null;						// 5.送信ユーザーＩＤ
		String subject			= null;						// 6.件名
		String senddate			= null;						// 7.送信日付
		String sender			= null;						// 8.送信者
		String recievecount		= null;						// 9.送信人数
		int	   recievecount_integer	= 0;					//   送信人数（型変換）
		String file				= null;						//10.ファイル
		String sendcost			= null;						//11.送信コスト
		int	   sendcost_integer	= 0;						//   送信コスト（型変換）
		String sendnode			= null;						//12.（差出人）ノード
		String sendproject		= null;						//13.（差出人）プロジェクト
		String sendcommunity	= null;						//14.（差出人）コミュニティ

		for (int i=0; i<args.length; ++i) {
			if ("--mode".equals(args[i])) {
				mode = args[++i];							// 1.モード
            } 
            else if ("--nodeproject".equals(args[i])) {
                nodeproject = args[++i];					// 2.ノードプロジェクト
            } 
            else if ("--nodecommunity".equals(args[i])) {
            	nodecommunity = args[++i];					// 3.ノードコミュニティ
            } 
            else if ("--sendnumber".equals(args[i])) {
                sendnumber = args[++i];						// 4.送信番号
            } 
            else if ("--senduserid".equals(args[i])) {
                senduserid = args[++i];						// 5.（差出人）ユーザーＩＤ
            } 
            else if ("--subject".equals(args[i])) {
                subject = args[++i];						// 6.件名
            } 
            else if ("--senddate".equals(args[i])) {
                senddate = args[++i];						// 7.送信日付
            } 
            else if ("--sender".equals(args[i])) {
                sender = args[++i];							// 8.（差出人）送信者
            } 
            else if ("--recievecount".equals(args[i])) {
            	recievecount = args[++i];					// 9.送信人数
            	recievecount_integer = Integer.valueOf(recievecount).intValue();
           } 
            else if ("--file".equals(args[i])) {
                file = args[++i];							//10.ファイル
            } 
            else if ("--sendcost".equals(args[i])) {
                sendcost = args[++i];						//11.送信コスト
                sendcost_integer = Integer.valueOf( sendcost).intValue();
            } 
            else if ("--sendnode".equals(args[i])) {
                sendnode = args[++i];						//12.（差出人）ノード
            } 
            else if ("--sendproject".equals(args[i])) {
                sendproject = args[++i];					//13.（差出人）プロジェクト
            } 
            else if ("--sendcommunity".equals(args[i])) {
                sendcommunity = args[++i];					//14.（差出人）コミュニティ
            } 
            else {
            	System.out.println("引数指定の誤り：未知の引数が指定されました");
            }
		}
    	JFrame frame = new Gui_Evaluate_Main(mode,							// 1.モード
												nodeproject,				// 2.ノードプロジェクト
												nodecommunity,				// 3.ノードコミュニティ
												sendnumber,					// 4.送信番号
												senduserid,					// 5.送信ユーザーＩＤ
												subject,					// 6.件名
												senddate,					// 7.送信日付
												sender,						// 8.送信者
    											recievecount_integer,		// 9.送信人数
    											file,						//10.ファイル
    											sendcost_integer,			//11.送信コスト
    											sendnode,					//12.（差出人）ノード
    											sendproject,				//13.（差出人）プロジェクト
    											sendcommunity);				//14.（差出人）コミュニティ
    				
    	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	public void actionPerformed(ActionEvent e) {
   		if(e.getSource() == pnl_eval.btn_OK ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"評価を確定しますか？",
    				"評価設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}
    		
//    		Double weight = 0.0;
/*
    		if(rbtn_level_5.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level5);
    			weight = ser.getEval_weight();
    		}
    		else if(rbtn_level_4.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level4);
    			weight = ser.getEval_weight();
    		}
    		else if(rbtn_level_3.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level3);
    			weight = ser.getEval_weight();
    		}
    		else if(rbtn_level_2.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level2);
    			weight = ser.getEval_weight();
    		}
    		else if(rbtn_level_1.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level1);
    			weight = ser.getEval_weight();
    		}
    		else if(rbtn_level_0.isSelected() == true){
    			ser = eval_rank.getStruct_Eval_Rank(level0);
    			weight = ser.getEval_weight();
    		}
*/
   	    	//********************************************************
   	    	//* コスト明細 レコード追加
   	    	//********************************************************
			//コスト明細ファイルの取得
			String filedir;
			filedir	=	addr.getDir_current() + addr.getDir_project()+ nodeproject + addr.getDir_costrecive();
			Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(filedir + addr.getFs() + addr.getFile_cost_suffix() +file);
			tcd.loadXml();
    		ArrayList array_cost_detail = tcd.getArray_cost_detail();
    		
    		//新レコードの初期化
    		Struct_Cost_Detail scu = new Struct_Cost_Detail();
    		
	    	//ゼロコスト
    		Struct_Cost_Source	zero_cost = new Struct_Cost_Source();
    		zero_cost.setUnitcost(0);
    		zero_cost.setSecond(0);
    		zero_cost.setCost(0);


    		scu.setSender(sender);										// 1.差出人
    		scu.setUserid(senduserid);									// 2.(差出人)USERID
    		
	    	//送信日付
	    	long nowtime = System.currentTimeMillis();
    		
	    	//最終システム送信番号１ＵＰ
			su.Last_system_send_number_CountUp();
			user_info.setStruct_User(su);
			user_info.saveXml();
    		scu.setSend_number(su.getLast_system_send_number());	// 3.ＮＯ <- システム送信ナンバー
    		
    		scu.setGeneration_date(nowtime);						// 4.発生日時
    		scu.setGeneration_node(su.getNode());					// 5.発生ノード
    		scu.setGeneration_userid(su.getUserid());				// 6.発生ユーザーＩＤ
    		scu.setGeneration_puroject(nodeproject);				// 7.発生プロジェクト
    		scu.setGeneration_community(nodecommunity);				// 8.発生コミュニティ	

    		Struct_Time_Count zero_count = new Struct_Time_Count();
    		scu.setTime_count(zero_count);							// 9.計測時間


    		//一人当たりの送信コストを計算
    		Double sendcost_per_one = (double)sendcost / recievecount;
    		//選択中の評価加重値を取得
    		Double weight = pnl_eval.getEvalWeight();
    		//評価額の計算 送信コスト　×　評価　÷　送信人数
    		int eval =(int) ((double)sendcost * weight / recievecount);

    		Struct_Cost_Source	send_cost = new Struct_Cost_Source();
    		send_cost.setUnitcost(0);
    		send_cost.setSecond(0);
    		send_cost.setCost(sendcost_per_one);
    		scu.setSend_cost(send_cost);							//10.送信コスト
    		
//    		scu.setSend_cost(zero_cost);							//10.送信コスト

    		scu.setRecieve_cost(zero_cost);							//11.受信コスト	
    		
    		scu.setTotal_cost(0);									//12.総コスト
    		
    		scu.setEval_value(eval);								//13.評価額
    		scu.setAtvalue_cost(-(eval));							//14.評価後コスト 
    		scu.setSend_number_original(sendnumber);				//15.（差出人）送信番号
    		//コスト明細の先頭に追加
    		array_cost_detail.add(0, scu);

    		//コスト明細の更新
    		tcd.setArray_cost_detail(array_cost_detail);
    		tcd.saveXml();

    		//********************************************************
   	    	//* コスト再計算
   	    	//********************************************************

    		Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(array_cost_detail);
    		tcdc.Caluculate();
    		
    		//********************************************************
   	    	//* コストダイジェスト 更新
   	    	//********************************************************
    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (filedir +  addr.getFs()  +
																addr.getFile_cost_digest());
    		tt.loadXml();

    		//更新データの取得
    		int index = tt.getLine(sendnumber);
    		Struct_Cost_Digest scd = tt.getdata(index);
    		
	    	//送信コストの再設定
    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
    		scd.setSend_cost(send_cost_bar);										// 4.送信コスト
    		
	    	//受信コストの再設定
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
    		scd.setRecieve_cost(recieve_cost_bar);									// 5.受信コスト	

    		
	    	//総コストの再設定
    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
    		scd.setTotal_cost(total_cost_bar);										// 6.総コスト
    		
	    	//評価額の再設定
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
    		scd.setEval_value(eval_value_cost_bar);									// 7.評価額	

	    	//評価後コストの再設定
    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
    		scd.setAteval_cost(ateval_cost_bar);									// 8.評価後コスト	
   		
    		
    		tt.replaceData(index, scd);
    		tt.saveXml();
    		
   			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end ");
				

   	    	//********************************************************
   	    	//* コスト明細 を送信バッファに作成
   	    	//********************************************************
    		//送信時は、送信コストはゼロ
   			scu.setSend_cost(zero_cost);							//10.送信コスト
    		
    		//コスト明細レコードの追加
    		array_cost_detail = new ArrayList();
    		array_cost_detail.add(scu);
    		
   	    	//送信日付のフォーマット変換
   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
   	    	//送信番号のフォーマット変換
   	    	DecimalFormat df = new DecimalFormat("00000");

   	    	
   	    	String dir 		= addr.getDir_current() + addr.getDir_buff_send();
   	    	String filename = addr.getFile_cost_suffix() + 
   	    						dfm.format(nowtime) + "_" 	+
   	    						df.format(su.getLast_system_send_number()) + "_" + 	
   	    						su.getUserid()		+ ".txt";
    		
    		tcd= new Tool_Cost_Detail_IO(dir + filename);
    		tcd.setArray_cost_detail(array_cost_detail);
    		tcd.saveXml();

   	    	//********************************************************
   	    	//* コスト送信指示リスト を送信バッファに作成
   	    	//********************************************************
    		Struct_Cost_SendList scs = new  Struct_Cost_SendList();
    		
    		scs.setSource_node(su.getNode());			// 1.送信元NODE
    		scs.setSource_user(su.getUserid());			// 2.送信元USERID
    		scs.setSource_project(nodeproject);			// 3.送信元プロジェクト
    		scs.setSource_community(nodecommunity);		// 4.送信元コミュニティ
    		scs.setTarget_node(sendnode);				// 5.送信先NODE
    		scs.setTarget_user(senduserid);				// 6.送信先USERID
    		scs.setTarget_project(sendproject);			// 7.送信先プロジェクト
    		scs.setTarget_community(sendcommunity);		// 8.送信先コミュニティ
    		scs.setSendnumber(sendnumber);				// 9.送信ナンバー
    		scs.setFilename(filename);					//10.送信ファイル名称
    		scs.setSource_filename(file);				//11.送信元メッセージのファイル名称
    		
    		
    		dir			=	addr.getDir_current() + addr.getDir_buff_send();
   	    	filename	=	addr.getFile_cost_suffix()	+
   	    					dfm.format(nowtime) + "_"	+
   	    					df.format(su.getLast_system_send_number()) + "_" + 	
   	    					su.getUserid()	+ 
   	    					addr.getFile_digest();

			
			Tool_Cost_SendList_IO slm = new Tool_Cost_SendList_IO(dir + filename,scs);
			slm.saveXml();


			//********************************************************
   	    	//* 未評　⇒　済評
   	    	//********************************************************
   	    	Tool_Community_Diject_Status_Update tcdsu = 
   	    		new Tool_Community_Diject_Status_Update(nodeproject,
   	    												nodecommunity,
   	    												senduserid,
   	    												sendnumber);

   	    	tcdsu.status_change(tcdsu.getStatus_evaluated());
			//********************************************************
   	    	//* 送信
   	    	//********************************************************
    		//テストモード時は呼び出し禁止
    		if(sysconfig.isTestmode() == false){
	    		ProcessBuilder builder = new ProcessBuilder("java", "-jar",
	    								addr.getDir_current() + addr.getPgm_client(),
	    								"--mode","target","--prefix",filename );

				try {
					Process process = builder.start();	//プロセス実行
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					if(process.exitValue() == 0){
					}
					else{
			    		JOptionPane.showMessageDialog(this, "送信処理が失敗しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
				} catch (IOException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				} catch (InterruptedException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				}
    			
    		}    		
    		
   			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end ");
   	    	
   	    	System.exit(0);

    		
   		}	
   		else if(e.getSource() == pnl_eval.btn_Cancel){
   			System.out.println("Cancel");
   	   		//ウィンドウを閉じる
   			System.exit(0);
   		}
		
	}
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}
	
}
