package mailcost_main;



import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicInternalFrameUI;

import java.beans.PropertyVetoException;
import java.io.*;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Entry_Project;
import structure.Struct_GuiState;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileCopy;
import tool.Tool_FileFilter;
import tool.Tool_GuiState_IO;
import tool.Tool_JList_IO;
import tool.Tool_LogOut;
import tool.Tool_Status_IO;
import tool.Tool_System_Config_IO;
import tool.Tool_Task;
import tool.Tool_Task_Socket;
import tool.Tool_User_IO;


//import message.Gui_Message_Main;
import message.Tool_SendList_IO;

public class Gui_Main_window extends JFrame 
	implements ActionListener,TreeSelectionListener, InternalFrameListener, MouseListener, WindowListener {

	
	Timer t;
	Gui_WindowList 			windowlist;			//（左枠）ノードの表示
	Gui_WindowView 			windowview;			//（右枠）メールダイジェストの表示
	Gui_CostView 			costview;			//（右枠）コストダイジェスト表示
	Gui_Cost_AnalysisView	cost_analysis_view;	//（右枠）コスト分析表示
	Gui_PanelUser  			pu;					//ユーザー情報設定
	Gui_PanelProject  		pp;					//プロジェクト設定
	Gui_PanelCommunity  	pc;					//コミュニティ設定
	Gui_PanelEval  			pe;					//デフォルト評価設定
	Gui_PanelCostAnalysis	pt;					//コスト分析設定
	Gui_PanelBatchConfig	pb;					//コスト分析設定
	Gui_PanelSendConfig		ps;					//送信手順設定
	Gui_PanelFont  			pf;					//フォント設定

	int current_node;

	Gui_ToolBar toolbar;	
	Gui_MenuBar menubar;
	
	JSplitPane spp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,true);

	JDesktopPane desktop = new JDesktopPane();
	JInternalFrame frame_center;

	int next_relay_time;						//次回中継送信の残りタイマーカウント
	int next_relay_keep_time;					//最大中継保持時間切れの残りタイマーカウント

	
	boolean config_state = false;				//設定画面立ち上げ中
	Tool_Task tool_task;						//メッセージの割り込み
	Tool_Task_Socket tts;						//送信処理の割り込み

	Tool_GuiState_IO 	tGuiState;				//GUI状態　Ｉ／Ｏ
	Struct_GuiState		sGuiState;				//GUI状態

	boolean windowview_firstopen;				//初めて開く時は、カラム幅を
	boolean costview_firstopen;				//復元するためのフラグ
	boolean cost_analysis_view_firstopen;		//
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	//constract
	public  Gui_Main_window(String name) {
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Start");

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
//			UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
//			UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
//			UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
//			UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
		}		
		
		
		
		
		//******************************************************
		//* ２重起動回避
		//******************************************************
		Tool_Status_IO st = new Tool_Status_IO(addr.getDir_current() + addr.getFile_status());
		if(st.getEnd() != true){
			String yes = (String) UIManager.get("OptionPane.yesButtonText", getLocale());
		    String no  = (String) UIManager.get("OptionPane.noButtonText", getLocale());
			int ans = JOptionPane.showConfirmDialog(this, 
	    			"既に起動中ですか？\n" +
	    			"「" + yes + "」を選択した場合、アプリケーションを終了します.\n" +
	    			"「" + no  + "」を選択した場合、正常終了状態に更新後、アプリケーションを終了します.",
    				"メール＆コスト",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.YES_OPTION){
    			System.exit(0);
    		}
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Stasus is abnormal End : "+st.getStatus()) ;
			st.setEnd();
			st.saveXml();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Stasus is Reset. Please your Machine logoff or shutdown. next Try start ") ;
    		JOptionPane.showMessageDialog(this, "前回の操作で正常終了しないため、実行状態を正常終了に強制変更しました.\n" +
										"このアプリケーションの常駐プログラムが終了していない可能性があります.\n"+
										"コンピュータをシャットダウンまたはログオフしてから、起動をトライしてください", 
    				"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 

			
			System.exit(0);
		}
		//******************************************************
		//* カレントディレクトリ　半角スペースチェック
		//******************************************************
		if(addr.getDir_current().indexOf(" ") > 0){
    		JOptionPane.showMessageDialog(this, "カレントディレクトリに半角スペースが含まれていると正しく稼動しません.\n" +
					"別の場所に置いてください.\n"+
					"カレントディレクトリ＝"+addr.getDir_current(),
					"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
    		System.exit(0);
		}

		//******************************************************
		//* カレントディレクトリ　文字列チェック
		//******************************************************
		if(addr.getDir_current().indexOf("new_") > 0){
    		JOptionPane.showMessageDialog(this, "カレントディレクトリに特殊な文字列が含まれていると正しく稼動しません.\n" +
					"ディレクトリを変更してください.\n"+
					"カレントディレクトリ＝"+addr.getDir_current() +"\n"+
					"特殊な文字列:[new_][old,]"					
					,
					"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
    		System.exit(0);
		}

		
		//******************************************************
		//* analysisコストの自動実行
		//******************************************************
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
	
		//システム日付の取得
		long nowtime = System.currentTimeMillis();
	
	   	//送信日付のフォーマット変換
	   	DateFormat dfdd = new SimpleDateFormat("dd");//月における日
	   	DateFormat dfhh = new SimpleDateFormat("HH");//0-23
    	DateFormat dfyyyyMM = new SimpleDateFormat("yyyyMM");
	
	   	//***********************************************
	   	//* 毎月１日１４時以降？
	   	//***********************************************
	   	if(Integer.valueOf(dfdd.format(nowtime)).intValue() >1 ||
	   			Integer.valueOf(dfhh.format(nowtime)).intValue() >=14){
		   	//*********************************************************************
	   		//* 以下のどちから一方の条件を満たす場合はanalysisコストを作成する
	   		//* 前回実行タイムスタンプは前月の場合
	   		//* 当月かつ１日１４時前
		   	//*********************************************************************

	   		if(Integer.valueOf(dfyyyyMM.format(su.getLastbatchtimestamp())).intValue() !=
	   				Integer.valueOf(dfyyyyMM.format(nowtime)).intValue()					||
	   				(Integer.valueOf(dfdd.format(su.getLastbatchtimestamp())).intValue() ==1 &&
		   			Integer.valueOf(dfhh.format(su.getLastbatchtimestamp())).intValue() <14)){
	   		

	    		//西暦年のフォーマット変換
	   	    	DateFormat dfyyyy = new SimpleDateFormat("yyyy");
	   		   	DateFormat dfMM = new SimpleDateFormat("MM");
	   	    	DecimalFormat cvtyyyy = new DecimalFormat("0000");
	   	    	DecimalFormat cvtmm = new DecimalFormat("00");

	   	    	String yyyy = dfyyyy.format(nowtime);
	   	    	String mm = dfMM.format(nowtime);
	   	    	int int_yyyy = Integer.valueOf(yyyy).intValue();
	   	    	int int_mm 	= Integer.valueOf(mm).intValue();

	   	    	if(int_mm ==1 ){
	   	    		int_yyyy = int_yyyy -1;
	   	    		int_mm = 12;
	   	    	}else{
	   	    		int_mm = int_mm - 1;
	   	    	}
	   	    	
	   	    	String yyyymm = cvtyyyy.format(int_yyyy)+cvtmm.format(int_mm);
	   	    	
	    		JOptionPane.showMessageDialog(this, yyyy+"年"+mm+"月のコスト分析を作成します.\n"+
	    				"数分かかる場合もあります", 
	    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 

	   	    	
	   	    	//最新年月の場合はユーザー情報の前回実行タイムスタンプを更新する
	   	    	ProcessBuilder builder = new ProcessBuilder("java", "-jar",
   								addr.getDir_current() + addr.getPgm_make_analysis(),
   								"--yyyymm",yyyymm,"--timestamp" );
    			

				try {
					Process process = builder.start();	//プロセス実行
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					if(process.exitValue() == 0){
			    		JOptionPane.showMessageDialog(this, "コスト分析を実施しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
					else{
			    		JOptionPane.showMessageDialog(this, "コスト分析が失敗しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
				} catch (IOException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				} catch (InterruptedException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				}
	   		}
	   	
	   	}
	
		//******************************************************
		//* 送信タスク回避
		//******************************************************
		Tool_Task_Socket tts = new Tool_Task_Socket();
		if(tts.forceDead() == false){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "socket is Reset. Please your Machine logoff or shutdown. next Try start ") ;
			System.exit(0);
		}
		
		
		
		//センターフレーム
		getContentPane().add(desktop,BorderLayout.CENTER);
		frame_center = new JInternalFrame();
		frame_center.setResizable(false);
		frame_center.setVisible(true);
		//デフォルト枠線の排除
		frame_center.setBorder(new EmptyBorder(0,0,0,0));
		//タイトル行の削除
		BasicInternalFrameUI mui = (BasicInternalFrameUI)frame_center.getUI();
		mui.setNorthPane(null);

		desktop.add(frame_center);
		
		this.setTitle(name);

		//メニューバー
		menubar = new Gui_MenuBar();
		setJMenuBar(menubar);
		menubar.miuser.addActionListener(this);
		menubar.miproject.addActionListener(this);
		menubar.micommunity.addActionListener(this);
		menubar.mieval.addActionListener(this);
		menubar.micost.addActionListener(this);
		menubar.mibatch.addActionListener(this);
		menubar.misend.addActionListener(this);
//		menubar.font.addActionListener(this);
		
		//ツールバー
		toolbar = new Gui_ToolBar();
		getContentPane().add(toolbar, BorderLayout.NORTH);
//		toolbar.btnload.addActionListener(this);
//		toolbar.btnsave.addActionListener(this);
		toolbar.btnmake.addActionListener(this);
		toolbar.btnsend.addActionListener(this);
		toolbar.btnserver.addActionListener(this);
		
		//ステータスバーもどき
		if(sysconfig.isTestmode() == true){
			JLabel statusBar = new JLabel("テストモード");
			getContentPane().add(statusBar, BorderLayout.SOUTH);
		}
		else{
			JLabel statusBar = new JLabel("本番モード");
			getContentPane().add(statusBar, BorderLayout.SOUTH);
		}

		
		//フォルダー
		windowlist = new Gui_WindowList();
		windowlist.tree.addTreeSelectionListener(this);
		 
		//受信トレイ
		windowview = new Gui_WindowView();

		//コスト表示
		costview = new Gui_CostView();
		
		//コスト分析表示
		cost_analysis_view = new Gui_Cost_AnalysisView();
		
		windowview.table.addMouseListener(this);
		
		
		//分割フレーム
		spp.setLeftComponent(windowlist);
		spp.setRightComponent(windowview);		

		spp.setVisible(true);
		
		//デフォルト枠線の排除
		spp.setBorder(new EmptyBorder(0,0,0,0));

//		getContentPane().add(spp);

		
		frame_center.add(spp);
//		desktop.add(spp);

		//ウィンドウリストのフレームの固定
		BasicInternalFrameUI ui = (BasicInternalFrameUI)windowlist.getUI();
		Component north = ui.getNorthPane();
		MouseMotionListener[] actions = (MouseMotionListener[])north.getListeners(MouseMotionListener.class);
		for(int i=0;i<actions.length;i++) {
			north.removeMouseMotionListener( actions[i] );
		}		

		//ウィンドウビューのフレームの固定
		ui = (BasicInternalFrameUI)windowview.getUI();
		north = ui.getNorthPane();
		actions = (MouseMotionListener[])north.getListeners(MouseMotionListener.class);
		for(int i=0;i<actions.length;i++) {
			north.removeMouseMotionListener( actions[i] );
		}		

		//タイマースタート
		t = new Timer(sysconfig.getTimer_main(),this);
//		t.addActionListener(this);
		t.start();
    	logout.out(sysconfig.getLogmode4(),this.getClass().getName(),"timer start" + sysconfig.getTimer_main());

		
		//センターフレーム最大化

		try {
			frame_center.setMaximum(true);
		} catch (PropertyVetoException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}

		//ステータスを稼働中にする
		st = new Tool_Status_IO(addr.getDir_current() + addr.getFile_status());
		st.setExecute();
		//テストモード時は呼び出し禁止
		if(sysconfig.isTestmode() == false){
			//受信サーバを起動
			ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
	    			addr.getDir_current() + addr.getPgm_server());

	    	try {
	    		Process process = builder.start();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
	    		JOptionPane.showMessageDialog(this, "自動受信の起動に失敗しました", 
	    				"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
			}
			
		}
		
		
    	//テストモード時は呼び出し禁止
		if(sysconfig.isTestmode() == false && sysconfig.isStart_relay() == true){
			//中継バッファに存在するファイルを送信する
    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
    									addr.getDir_current() + addr.getPgm_client(),
			"--mode","all","--suffix",addr.getFile_digest(),"--relay");
			try {
				Process process = builder.start();
			} catch (IOException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			}
			
		}
		
		//次回最大中継保持時間切れ送信の残りタイマーカウントの初回設定
		setNext_Relay_Keep_Time();
		//次回中継送信日時の初回設定
		setNext_Relay_Time();
		


		
		//********************************************************
		//* ＧＵＩの復元
		//********************************************************
		//フレーム
		tGuiState = new Tool_GuiState_IO(addr.getDir_current() + addr.getFile_guistate());
		tGuiState.loadXml();
		sGuiState = tGuiState.getSGuiState();
		if(sGuiState != null){
			this.setBounds(sGuiState.getMainWindow_x(),
							sGuiState.getMainWindow_y(),
							sGuiState.getMainWindow_width(),
							sGuiState.getMainWindow_height());
		}else{
			sGuiState = new Struct_GuiState();
			this.setBounds(0,0,800,600);
		}
		//画面分割
		if(sGuiState.getSplitlocation() > 0 ){
			spp.setDividerLocation(sGuiState.getSplitlocation());
		}
		
		//表示を復元する
		nodechange();
		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon() + addr.getIcon_mailcost());
		this.setIconImage(icon.getImage());
		this.addWindowListener(this);	//20070911

		//*画面を開いた時はフォルダ一覧をアクティブにする
		//setVisible後にウィンドウリストフレームを選択状態にする
		this.setVisible(true);
		try {
			windowlist.setSelected(true);
		} catch (PropertyVetoException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		
	}
	
	private ArrayList buff_recieve(){

    	String dir  = addr.getDir_current() + addr.getDir_buff_recieve();
    	//送信指示コマンドリストを検索
    	File fl = new File(dir);
    	File[] files = fl.listFiles(new FileFilter(){
			public boolean accept(File pathname) {
//				if(pathname.getName().endsWith("_digest.txt") == true){
				if(pathname.getName().endsWith(addr.getFile_digest()) == true){
					return true;
				}
				else{
					return false;
				}
			}
    	});
    	
    	//受信データはない
    	if(files.length == 0){
    		return null;
    	}
    	ArrayList community_list = new ArrayList();
    	//送信指示コマンドリストのループ
		for(int i=0; i<files.length; i++) {
//			System.out.println(files[i].getPath());
			//***************************************************
			//*メールを受信バッファから取得する
			//***************************************************
//			if(files[i].getName().substring(0, 1).equals("C") == false){
			if(files[i].getName().substring(0, 1).equals(addr.getFile_cost_suffix()) == false){
				Tool_SendList_IO slm = new Tool_SendList_IO(files[i].getPath());
				
				//データが正しく読めるかチェック
				boolean datachk = false;
				for(int j=0 ;j<3 ; j++){
		   	    	slm.loadXml();
		   	    	if(slm.dataCheck() == true){
		   	    		datachk = true;
		   	    		break;
		   	    	}
		   	    	sleep();
				}
				if(datachk == false){
					continue;
				}

				
				Struct_SendList data 	=	slm.getdata(0);		
	
	    		String infile = new String(addr.getDir_current() + 
							addr.getDir_buff_recieve() + 
								data.getFilename());
//	    		System.out.println("infile  : "+infile);
	    		String outfile = new String(addr.getDir_current() + 
								addr.getDir_project() + 
								data.getTarget_project() +  addr.getFs()  +
								data.getTarget_community() +  addr.getFs()  +
								data.getScd().getFilename());
//20070907				data.getFilename());
//	    		System.out.println("outfile  : "+outfile);
	    		//メールファイルをコミュニティディレクトリにコピー
	    		boolean answer = new Tool_FileCopy().Tool_FileCopy(infile,outfile);
	    		if(answer ==false){
	   	    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "filecopy error in:"+infile+" out:"+outfile);
	    			continue;
	    		}
	   	    		
	    		//ダイジェストの更新
	   			String[] columnames = data.getScd().getColData();
	   	    	String filename = addr.getDir_current() + 
	   	    						addr.getDir_project() +
	   	    							data.getTarget_project() +  addr.getFs()  +
	   	    								data.getTarget_community() + 
	   	    									addr.getFile_community_digest();
	   	    	Tool_JTable_IO t = new Tool_JTable_IO (filename);
	   	    	t.putColum(columnames);
	   	    	t.loadXml();
	//	    	t.putData(data.getScd().getArryData());
		    	t.insertData(data.getScd().getArryData());
	   	    	t.saveXml2();

	   	    	
				//コストダイジェスト更新
				insert_cost_digest(data);

	    		//ダイジェストを削除
	    		if(new File(files[i].getPath()).delete() ==false){
	    			continue;
	    		}
	
	    		//メールファイルを削除
	
	    		if(new File(infile).delete() ==false){
	    			continue;
	    		}
	    		community_list.add(data.getTarget_community());				
			}
			//***************************************************
			//* コストを受信バッファから取得する
			//***************************************************
			else{
				Tool_Cost_SendList_IO cslm = new Tool_Cost_SendList_IO(files[i].getPath());
	   	    	cslm.loadXml();
	   			Struct_Cost_SendList scu 	=	cslm.getdata();	
	   			//受信したコスト明細の取得
				Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(addr.getDir_current() + 
						addr.getDir_buff_recieve() + 
						scu.getFilename());
				tcd.loadXml();
	    		ArrayList array_cost_detail = tcd.getArray_cost_detail();
	    		Struct_Cost_Detail  new_data = (Struct_Cost_Detail ) array_cost_detail.get(0);
	    		
	   			
	   			//既存のコスト明細の取得
				tcd= new Tool_Cost_Detail_IO(addr.getDir_current() + 
											addr.getDir_project() + 
											scu.getTarget_project() + 
											addr.getDir_costsend() +  addr.getFs()  +
											addr.getFile_cost_suffix() + 
											scu.getSource_filename());
				
				tcd.loadXml();
	    		array_cost_detail = tcd.getArray_cost_detail();
	    		
	    		
	    		//コスト明細の先頭に追加
	    		array_cost_detail.add(0, new_data);

	    		//コスト明細の更新
	    		tcd.setArray_cost_detail(array_cost_detail);
	    		tcd.saveXml();

	    		//********************************************************
	   	    	//* コスト再計算
	   	    	//********************************************************
	    		Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(array_cost_detail);
	    		tcdc.Caluculate();	   			

	    		//********************************************************
	   	    	//* コストダイジェスト 更新
	   	    	//********************************************************
	    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (addr.getDir_current() + 
																	addr.getDir_project() + 
																	scu.getTarget_project() +
																	addr.getDir_costsend() +
																	addr.getFile_cost_digest());
	    		tt.loadXml();

	    		//更新データの取得
	    		int index = tt.getLine(scu.getSendnumber());
	    		Struct_Cost_Digest scd = tt.getdata(index);
	    		
				Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
				Struct_User su = user_info.getStruct_User();

	    		
		    	//送信コストの再設定
	    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
	    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
	    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
	    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
	    		scd.setSend_cost(send_cost_bar);										// 4.送信コスト
	    		
		    	//受信コストの再設定
	    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
	    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
	    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
	    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
	    		scd.setRecieve_cost(recieve_cost_bar);									// 5.受信コスト	

	    		
		    	//総コストの再設定
	    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
	    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
	    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
	    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
	    		scd.setTotal_cost(total_cost_bar);										// 6.総コスト
	    		
		    	//評価額の再設定
	    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
	    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
	    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
	    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
	    		scd.setEval_value(eval_value_cost_bar);									// 7.評価額	

		    	//評価後コストの再設定
	    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
	    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
	    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
	    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
	    		scd.setAteval_cost(ateval_cost_bar);										// 8.評価後コスト	

	    		tt.replaceData(index, scd);
	    		tt.saveXml();
	    		
	    		//ダイジェストを削除
	    		if(new File(files[i].getPath()).delete() ==false){
	    			continue;
	    		}
	
	    		//コストファイルを削除
	    		if(new File(addr.getDir_current() + 
	    					addr.getDir_buff_recieve() + 
	    					scu.getFilename()).delete() ==false){
	    			continue;
	    		}

	    		
			}

		}
    	//送信指示コマンドリストのループの終端		
		return community_list;
	}
	
	private void insert_cost_digest(Struct_SendList sendlist) {
		//********************************************************
	    //* コストダイジェスト コスト表示枠作成のための更新
	    //********************************************************
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		
		Struct_Cost_Digest scd = new Struct_Cost_Digest();

		scd.setSender(sendlist.getScd().getSender());					// 1.差出人
		scd.setSendnumber(sendlist.getScd().getSendnumber());			// 2.送信ナンバー
		scd.setSubject(sendlist.getScd().getSubject());					// 3.件名
		scd.setSend_date(sendlist.getScd().getSend_date());				// 4.送信日時
		
		//初期コスト
		Struct_CostBar 	init_cost_bar = new Struct_CostBar();
		init_cost_bar.setMaxvalue(su.getMaxValue(0));
		init_cost_bar.setRealvalue(0);
		init_cost_bar.setMode(su.getMode(0));

		scd.setSend_cost(init_cost_bar);										// 5.送信コスト
		scd.setRecieve_cost(init_cost_bar);										// 6.受信コスト	
		scd.setTotal_cost(init_cost_bar);										// 7.総コスト
		scd.setEval_value(init_cost_bar);										// 8.評価額	
		scd.setAteval_cost(init_cost_bar);										// 9.評価後コスト	
		scd.setUserid(sendlist.getSource_user());								//10.（差出人）ユーザーＩＤ
//20070908		scd.setFilename(addr.getFile_cost_suffix() + sendlist.getFilename());						//11.ファイル名
		scd.setFilename(addr.getFile_cost_suffix() + sendlist.getScd().getFilename());	//11.ファイル名
		
		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (addr.getDir_current() + 
				addr.getDir_project() + 
				sendlist.getTarget_project() +  addr.getFs()  +
				addr.getDir_costrecive() +  addr.getFs()  +
				addr.getFile_cost_digest());
		tt.loadXml();
		tt.insertData(scd);
		tt.saveXml();
		
	}	
	
	
	private boolean wait_on(){
		//**************************************
		//* メッセージの割り込み
		//**************************************
		tool_task = new Tool_Task();
		//メッセージが終了するまでループする
		if(tool_task.taskAllExec() == true){

			JOptionPane.showMessageDialog(this, 
    				"メッセージ起動中は設定変更できません",
					"ツール", JOptionPane.INFORMATION_MESSAGE); 
		
    		return false;
		}
		tool_task.taskWaitBorn();
		
		
		
		//**************************************
		//* 送信処理の割り込み
		//**************************************
		tts = new Tool_Task_Socket();
		tts.sendTaskBorn();
		//送信処理が終了するまでループする
		while(true){
			byte code = tts.submit_Judgment();
			if(code == 0){
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "Forced ending instruction");
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
				return false;
			}
			else if(code == 2){
				break;
			}
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"送信中は設定変更できません.\n"+
    				"終了するまで待ちますか？",
    				"ツール",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.NO_OPTION){
    			return false;
    		}

    		//スリープ
			try {
				Thread.sleep(tts.getInterval()*10000);
			} catch (InterruptedException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}
		
		}
		
		return true;
		
		
	}
	private void wait_off(){
		//**************************************
		//* メッセージの割り込み
		//**************************************
		tool_task.taskWaitDead();
		//**************************************
		//* 送信処理の割り込み 解除
		//**************************************
		tts.sendTaskDead();
	}
	
	//*****************************************************************************
	//*****************************************************************************
	//***                      メ イ ン ル ー チ ン                             ***
	//*****************************************************************************
	//*****************************************************************************
	public  static void main(String[] args){
		
		//新しいパラメータを検索
		InitialNewParameter ip = new InitialNewParameter();
		if(ip.newParam() == false){
			InitialNewProject inp = new InitialNewProject();
			inp.newProject();
		}
		
		JFrame frame = new Gui_Main_window("mailcost frame in development");
		frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

//		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//		frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

//		frame.addWindowListener(new Gui_WindowEventHandler());
//		frame.addWindowListener(new WindowAdapter(){
//		});

		frame.setVisible(true);

	
	
	}

	//次回中継送信の残りタイマーカウントの設定
	private void setNext_Relay_Time(){
		//計算式
		//（現在時刻＋中継送信タイマー）／メインタイマー
		if(sysconfig.getTimer_relay() > 0){
			next_relay_time	=	( sysconfig.getTimer_relay()*60*1000)	/sysconfig.getTimer_main();						
		}
		else{
			next_relay_time = -999;
		}
	}
	
	//次回最大中継保持時間切れ送信の残りタイマーカウントの設定
	private void setNext_Relay_Keep_Time(){
		//計算式
		//（現在時刻＋最大中継保持タイマー）／メインタイマー
//		if(next_relay_keep_time > 0){
		if(sysconfig.getMax_relay_keeptime() > 0){
			next_relay_keep_time	=	(sysconfig.getMax_relay_keeptime()*60*60*1000)	/sysconfig.getTimer_main();						
		}
		else{
			next_relay_keep_time	=	-999;						
		}
	}
	
	

	public void actionPerformed(ActionEvent ae) {
	    Object source = ae.getSource();
	    //タイマー呼び出し
	    if(source == t && config_state == false){
	    	//送信チェック
	    	String activecommunity = windowlist.activeCommunity();
	    	if(activecommunity != null){
	    		File comdijest = new File(addr.getDir_current() + 
	    									addr.getDir_project() +
	    									windowlist.activeProject() +  addr.getFs() +
	    									activecommunity + 
	    									addr.getFile_community_digest());
	    		//コミュニティダイジェストが存在する場合
	    		if(comdijest.exists() == true){
	    			long lastdate = comdijest.lastModified();
		    		long nowtime = System.currentTimeMillis();
		    		if(lastdate + sysconfig.getTimer_main() >  nowtime){
		    			 nodechange();
		    		}
	    		}
	    	}
	    	
	    	//受信バッファ処理
	    	 ArrayList community = buff_recieve();
	    	 if(community != null){
	    		 if(community.indexOf(windowlist.activeCommunity()) != -1)
	    			 nodechange();
	    	 
	    	 }
	    	 //次回最大中継保持時間切れ送信の残りタイマーカウントの減算
	    	 if(next_relay_keep_time > 0){
		    	 next_relay_keep_time--;
	    	 }
	    	 //カウントゼロ
	    	 if(next_relay_keep_time == 0){
	     		if(sysconfig.isTestmode() == false){
	     			//中継送信の実行
	        		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
							addr.getDir_current() + addr.getPgm_client(),
							"--mode","all","--suffix",addr.getFile_digest(),"--relay","--server");
					try {
						Process process = builder.start();
					} catch (IOException e1) {
						// TODO 自動生成された catch ブロック
						e1.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
					}
	    			
	    		}
	     		//次回最大中継保持時間切れ送信の残りタイマーカウントの再設定
	     		setNext_Relay_Keep_Time();
	     		//次回中継送信の残りタイマーカウントの再設定
	     		//※中継バッファにファイルは存在しないため、中継送信は次回に繰り上げる
	     		setNext_Relay_Time();
	    	 }
	    	 //次回中継送信の残りタイマーカウントの減算
	    	 if(next_relay_time > 0){
		    	 next_relay_time--;
	    	 }
	    	 //カウントゼロ
	    	 if(next_relay_time == 0){
	     		if(sysconfig.isTestmode() == false){
	     			//中継送信の実行
	        		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
							addr.getDir_current() + addr.getPgm_client(),
							"--mode","all","--suffix",addr.getFile_digest(),"--relay");
					try {
						Process process = builder.start();
					} catch (IOException e1) {
						// TODO 自動生成された catch ブロック
						e1.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
					}
	    			
	    		}
	     		//次回中継送信の残りタイマーカウントの再設定
	     		setNext_Relay_Time();
	    	 }

	    }
	    //操作がない場合は戻る
	    String answer = ae.getActionCommand();	
	    if(answer == null){	
	    	return;
	    }
	    //ユーザー情報
	    if(ae.getSource() == menubar.miuser){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pu = new Gui_PanelUser(); 
	    	desktop.add(pu,new Integer(3))	;
	    	pu.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pu.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //プロジェクト
	    else if(ae.getSource() == menubar.miproject){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pp = new Gui_PanelProject(); 
	    	desktop.add(pp,new Integer(3))	;
	    	pp.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pp.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //コミュニティ
	    else if(ae.getSource() == menubar.micommunity){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pc = new Gui_PanelCommunity(); 
	    	desktop.add(pc,new Integer(3))	;
	    	pc.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pc.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //デフォルト評価	    
	    else if(ae.getSource() == menubar.mieval){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pe = new Gui_PanelEval(); 
	    	desktop.add(pe,new Integer(3))	;
	    	pe.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pe.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //コスト分析	    
	    else if(ae.getSource() == menubar.micost){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pt = new Gui_PanelCostAnalysis(); 
	    	desktop.add(pt,new Integer(3))	;
	    	pt.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pt.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //コスト分析実行	    
	    else if(ae.getSource() == menubar.mibatch){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pb = new Gui_PanelBatchConfig(); 
	    	desktop.add(pb,new Integer(3))	;
	    	pb.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				pb.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //送信手順	    
	    else if(ae.getSource() == menubar.misend){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	ps = new Gui_PanelSendConfig(); 
	    	desktop.add(ps,new Integer(3))	;
	    	ps.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
			try {
				ps.setSelected(true);
			} catch (PropertyVetoException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
	    }
	    //フォント	    
/*
	    else if(ae.getSource() == menubar.font){
	    	if( wait_on() == false) return;
	    	config_state = true;
	    	pf = new Gui_PanelFont(); 
	    	desktop.add(pf,new Integer(3))	;
	    	pf.addInternalFrameListener(this);
			menubar.all_NotEnable();					//メニューバーを使用不可にする
	    }
*/
	    //送信ボタン
	    else if(ae.getSource() == toolbar.btnsend){
	    	
	    	//テストモード時は呼び出し禁止
    		if(sysconfig.isTestmode() == true){
    			return;
    		}	
    			
			//送信ダイジェストを取得
			File fl = new File(addr.getDir_current() + addr.getDir_buff_send());
	    	Tool_FileFilter ff = new Tool_FileFilter();
	    	ff.setSuffix(addr.getFile_digest());	
	    	File[] files = fl.listFiles(ff);

	    	if(files == null || files.length == 0){
				JOptionPane.showMessageDialog(this, 
	    				"未送信メールはありません",
						"送信", JOptionPane.INFORMATION_MESSAGE); 
				return;
	    	}

	    	int ans = JOptionPane.showConfirmDialog(this, 
    				"未送信メールまたは未送信コストは　"+
    				files.length +
    				"件です.\n"+
    				"送信しますか？",
    				"送信",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.NO_OPTION){
    			return;
    		}

			
    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
    									addr.getDir_current() + addr.getPgm_client(),
			"--mode","all","--suffix",addr.getFile_digest());
			try {
				Process process = builder.start();
			} catch (IOException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			}
    		JOptionPane.showMessageDialog(this, "送信処理が実行しました", 
    				"送信", JOptionPane.INFORMATION_MESSAGE); 
    			
	    	
	    }
	    //ロードボタン
//	    else if(answer.equals("load")){
	    	
	    	
//	    	card =  new ToolControlCard_IO("D:\\controlcard.txt");
//	    	card.loadXml();	    	
	    	
//	    	windowview.loadXml();

	    	//再表示
//	    	spp.remove(windowview);
//			spp.setRightComponent(windowview);		

//	    	System.out.println("tree(0,0):" + windowview.getdata(0,0));
//	    }
	    //セーブボタン
//	    else if(answer.equals("save")){
//	    	card.saveXml();

//	   		windowview.saveXml();
	    	
//	    	Tool_System_Config_IO a = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config());
//	    	a.saveXml();

//	    	Tool_User_IO  a = new Tool_User_IO (addr.getDir_current()+addr.getFile_user_info());
//	    	Struct_User su = a.getStruct_User();
//	    	a.saveXml();

//			Tool_Cost_Digest_IO t = new Tool_Cost_Digest_IO (addr.getDir_current()+addr.getFile_cost_digest());
//			Struct_Cost_Digest scd = new Struct_Cost_Digest();
//			scd.init();
//			t.setStruct_Cost_Digest(scd);
//			t.saveXml();
	    	
/*	    	Tool_Business_Year_days_IO  a = new Tool_Business_Year_days_IO (addr.getDir_current()+addr.getFile_business_year_days());
	    	Struct_Business_Year_days[] s = new Struct_Business_Year_days [2];
	    	s[0] = new Struct_Business_Year_days();
	    	s[0].init();
	    	s[1] = new Struct_Business_Year_days();
	    	s[1].init();
	    	a.setStruct_Business_Year_days(s);
	    	a.saveXml();*/
	    	
//	    	Tool_Eval_Rank_IO eval_rank = new Tool_Eval_Rank_IO(addr.getDir_current() + addr.getFile_eval_rank());
//	    	eval_rank.loadXml();
//	    	eval_rank.saveXml();
	    	
//	    }
	    //新規作成ボタン
//	    else if(answer.equals("新規作成")){
	    else if(ae.getSource() == toolbar.btnmake){

	    	String project = windowlist.activeProject();
	    	String community = windowlist.activeCommunity();

	    	try {
	    		//本番
	    		if(sysconfig.isTestmode() == false){
	    			//参加プロジェクトの取得
	    			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
	    												addr.getFile_project_info());
	    			tep.loadXml();
	    			if(tep.getLiveProject() == null){
	    	    		JOptionPane.showMessageDialog(this, "参加プロジェクトがありません", 
	    	    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
	    				return;
	    			}
	    			
	    			if(tep.liveProject(project) == false){
		    			//離脱したプロジェクトの場合
			    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
				    			addr.getDir_current() + addr.getPgm_message(),
			    				"--mode","write");
				    	Process process = builder.start();
	    			}
	    			
	    			
		    		//ウィンドウリストの選択状態により、メッセージ作成パネルの引数を変える
		    		if((community != null)  && (community.length() > 0)){

		    			//参加コミュニティかを確認
		    			Tool_JList_IO tls;
		    	   		String com_sel_file 	=	addr.getDir_current() + 
		    										addr.getDir_project() +
		    										project  +
		    										addr.getFile_com_select();
		    			tls = new Tool_JList_IO(com_sel_file);	
		    			String[] comary =  tls.loadXml2();
		    			boolean found = false;
		    			for(int i=0;i<comary.length;i++){
		    				if(community.equals(comary[i])){
		    					found = true;
		    					break;
		    				}
		    			}
		    			
		    			//コミュニティを選択した場合
		    			if(found == true){
			    			//参加コミュニティの場合
				    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
					    			addr.getDir_current() + addr.getPgm_message(),
					    			"--mode","write","--nodeproject",project,"--nodecommunity",community);
					    	Process process = builder.start();
		    			}else{
			    			//離脱したコミュニティの場合
				    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
					    			addr.getDir_current() + addr.getPgm_message(),
					    			"--mode","write","--nodeproject",project);
					    	Process process = builder.start();
		    			}
		    		}
		    		else if((project != null)  &&  (project.length() > 0) ){
		    			//プロジェクト以下の階層を選択、コミュニティは選択していない場合
			    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
				    			addr.getDir_current() + addr.getPgm_message(),
				    			"--mode","write","--nodeproject",project);
				    	Process process = builder.start();
		    		}
		    		else{
		    			//ルートノードの場合
			    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
				    			addr.getDir_current() + addr.getPgm_message(),
			    				"--mode","write");
				    	Process process = builder.start();
		    		}
	    	
	    		}
	    	} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			}
	    	catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

		}
	    
	    }
	    //サーバー接続ボタン
	    else if(ae.getSource() == toolbar.btnserver){
	    	//テストモード時は呼び出し禁止
    		if(sysconfig.isTestmode() == true){
    			return;
    		}
	    	int ans = JOptionPane.showConfirmDialog(this, 
    				"サーバー接続を実施しますか？\n" +
    				"(安全のため自動受信を停止します．)",
    				"サーバー接続",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.NO_OPTION){
    			return;
    		}
    		
			//ステータスを終了待ちにする
    		Tool_Status_IO st = new Tool_Status_IO(addr.getDir_current() + addr.getFile_status());
			st.setPauseWait();
			for(int i=0; i< 20;i++){
				// 受信サーバの終了を確認した場合
				if(st.getPAUSE() == true){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Server_main Ended(Pause) Confirmation");
					logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "End");
			    	break;
				}
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    		JOptionPane.showMessageDialog(this,
		    				"自動受信の停止に失敗しました.\n" +
		    				"サーバー接続を終了します.", 
		    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
		    		return;
				} 
			}
    		
	    	//参加プロジェクトの取得
			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
			tep.loadXml();
			ArrayList<Struct_Entry_Project> array_project = tep.getdata();
			
			//プロジェクトのループ
			for(int i=0 ; i<array_project.size() ; i++){
				//離脱したプロジェクトには接続しない
				if(array_project.get(i).isKill() == true){
					continue;
				}
	    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
						addr.getDir_current() + addr.getPgm_client(),
						"--mode","server",
						"--project",array_project.get(i).getProject()
	    		);
				try {
					Process process = builder.start();
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					if(process.exitValue() == 0){
					}
					else{
			    		JOptionPane.showMessageDialog(this, array_project.get(i).getProject() + 
			    				"\nサーバー接続に失敗しました.", 
			    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
					}
				} catch (IOException e1) {
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    		JOptionPane.showMessageDialog(this, array_project.get(i).getProject() + 
		    				"\nサーバー接続に失敗しました.", 
		    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
				} catch (InterruptedException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    		JOptionPane.showMessageDialog(this, array_project.get(i).getProject() + 
		    				"\nサーバー接続に失敗しました.", 
		    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
				}
			
			
			}
			
			//受信サーバを起動
			ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
	    			addr.getDir_current() + addr.getPgm_server());

	    	try {
	    		Process process = builder.start();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
	    		JOptionPane.showMessageDialog(this,
	    				"自動受信の再起動に失敗しました.\n" +
	    				"サーバー接続を終了します.", 
	    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
			}
			st.setExecute();
    		JOptionPane.showMessageDialog(this, "サーバー接続を終了しました", 
    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
	    	
    		//***************************************
    		//* 新設定ファイルの表示
    		//***************************************
    		String file_separator = System.getProperty("file.separator");
    		String fs 			  = file_separator + file_separator;

			File fl = new File(addr.getDir_current());
	    	Tool_FileFilter ff = new Tool_FileFilter();
	    	ff.setPrefix("new_");
	    	ff.setSuffix(".txt");
	    	File[] files = fl.listFiles(ff);

	    	boolean found = false;
    		String newfilename = new String();
	    	if(files != null && files.length > 0 ){
        		for(int i=0;i<files.length;i++){
        			if(files[i].getName().indexOf(addr.getFile_project_info().replaceAll(fs, "")) > -1){
        				//プロジェクトファイルは表示対象外
        				continue;
        			}
        			newfilename += files[i].getName().replaceAll("new_", "") + "\n";
        			found = true;
        		}	
        	}

	    	//プロジェクトディレクトリから検索
			Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
			t.loadXml();
			ArrayList<Struct_Entry_Project> al = t.getdata();
			
			for(int i=0;i<al.size();i++){
				//コミュニティファイルの存在チェック
				if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"new_"+addr.getFile_com_all().replaceAll(fs, "")).exists()){
					newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_all().replaceAll(fs, "") + "\n";
        			found = true;
				}
				//コミュニティメンバーファイルの存在チェック
				if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"new_"+addr.getFile_com_menber().replaceAll(fs, "")).exists()){
					newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_menber().replaceAll(fs, "") + "\n";
        			found = true;
				}
				//参加コミュニティリストファイルの存在チェック
				if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"new_"+addr.getFile_com_select().replaceAll(fs, "")).exists()){
					newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_select().replaceAll(fs, "") + "\n";
        			found = true;
				}
			}

	    	
	    	if(found == true){
	    		JOptionPane.showMessageDialog(this,
	    				"サーバーから新設定ファイルを受信しました.\n" +
	    				"新設定ファイルを反映するためには本アプリケーションの再起動が必要です.\n"+
	    				"以下、新設定ファイル\n"+
	    				newfilename, 
	    				"サーバー接続", JOptionPane.INFORMATION_MESSAGE); 
	    	}
        		
        		
	    }

		
	}

//	********************************************************
//	* ツリーノードのイベント
//	********************************************************
	
	//ノードの選択変更
	public void valueChanged(TreeSelectionEvent te) {
		nodechange();
	}
   		
	private void nodechange() {
   		
		//アクテイブなプロジェクトとコミュニティを取得する。
		String strproject 	= windowlist.activeProject();
  		String strcommunity = windowlist.activeCommunity();
  		String strcost 		= windowlist.activeCost();

  		
  		//コミュニティを選択
  		if(strproject != null && strcommunity != null){
  			if(windowview_firstopen == true || sGuiState.getMailcolumnwidth() == null){
  	  			sGuiState.setMailcolumnwidth(windowview.getColumnWidth());
  			}
  			windowview.loadXml(strproject,strcommunity);
  	   		windowview.setColumnWidth(sGuiState.getMailcolumnwidth());
  	   		windowview_firstopen = true;
	    	//再表示
	    	if( spp.getRightComponent() == windowview){
		    	spp.remove(windowview);
	    	}
	    	else if( spp.getRightComponent() == costview){
		    	spp.remove(costview);
	    	}
	    	else {
		    	spp.remove(cost_analysis_view);
	    	}
			spp.setRightComponent(windowview);		
			
  		}
  		//コストを選択
  		else if(strcost != null && 
  				(strcost.equals(addr.getDir_costrecive()) || strcost.equals(addr.getDir_costsend()))){
	    	//再表示
	    	if( spp.getRightComponent() == windowview){
		    	spp.remove(windowview);
	    	}
	    	else if( spp.getRightComponent() == costview){
		    	spp.remove(costview);
	    	}
	    	else {
		    	spp.remove(cost_analysis_view);
	    	}
  			if(costview_firstopen == true || sGuiState.getCostcolumnwidth() == null){
  	  			sGuiState.setCostcolumnwidth(costview.getColumnWidth());
  			}
	    	costview.loadXml(strproject,windowlist.activeCost());
  	   		costview.setColumnWidth(sGuiState.getCostcolumnwidth());
			spp.setRightComponent(costview);		
			costview_firstopen = true;
		}
  		//コスト分析を選択
  		else if(strcost != null && 
  			strcost.equals(addr.getDir_costanalysis())){
	    	//再表示
	    	if( spp.getRightComponent() == windowview){
		    	spp.remove(windowview);
	    	}
	    	else if( spp.getRightComponent() == costview){
		    	spp.remove(costview);
	    	}
	    	else {
		    	spp.remove(cost_analysis_view);
	    	}
  			if(cost_analysis_view_firstopen == true || sGuiState.getCost_analysis_columnwidth() == null){
  	  			sGuiState.setCost_analysis_columnwidth(cost_analysis_view.getColumnWidth());
  			}
	    	cost_analysis_view.loadXml(strproject);
	    	cost_analysis_view.setColumnWidth(sGuiState.getCost_analysis_columnwidth());
			spp.setRightComponent(cost_analysis_view);
			cost_analysis_view_firstopen = true;
  		}
  		
  			
	}

//	********************************************************
//	* インターナルルレームのイベント
//	********************************************************
	
	public void internalFrameActivated(InternalFrameEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	//フレームを閉じる前
	public void internalFrameClosed(InternalFrameEvent e) {
//		boolean blnnodata = false;
		JInternalFrame f = e.getInternalFrame();
		String s1 = f.getClass().toString();
		String s2 = ".Gui_PanelProject";
		String s3 = ".Gui_PanelCommunity";
		//プロジェクトパネル
		//変更後のプロジェクトをリストに追加する
		if(s1.endsWith(s2)==true){
			
			ArrayList pn= pp.getProject();
			windowlist.ProjectNodeReMake(pn);	
	   		windowlist.saveXml();

		}
		//コミュニティパネル
		//変更後のコミュニティをリストに追加する
		else if(s1.endsWith(s3)==true){
			//Gui_PanelCommunityクラスのdoDefaultCloseActionメソッド終了後に呼び出す

//			pp = new Gui_PanelProject("nopanel"); 
	   		ArrayList pn= pc.getDeleteproject();
	   		ArrayList cn= pc.getDeletecommunity();
	   		
	   		if(pn.size()>0){
		   		//参加プロジェクトのループ
				windowlist.CommunityNodeReMake(pn,cn);	
		   		windowlist.saveXml();
	   		}
			
		}

		//メニューバーを閉じた場合
		if(s1.indexOf("Gui_Panel") != -1){
			//メニューバーを使用可にする
			menubar.all_Enable();
			wait_off();
	    	config_state = false;
		}

	
	}

	public void internalFrameClosing(InternalFrameEvent e) {
	}
	public void internalFrameDeactivated(InternalFrameEvent e) {
	}
	public void internalFrameDeiconified(InternalFrameEvent e) {
	}
	public void internalFrameIconified(InternalFrameEvent e) {
	}
	public void internalFrameOpened(InternalFrameEvent e) {
	}

	
//	********************************************************
//	* マウスのイベント
//	********************************************************
	public void mouseClicked(MouseEvent e) {
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}
	public void mousePressed(MouseEvent e) {
	}
	public void mouseReleased(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
	}

	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}	

	
	
	//********************************************************
	//* ウィンドウズイベント
	//********************************************************
	public void windowActivated(WindowEvent e) {
	}
	public void windowClosed(WindowEvent e) {
	}

	public void windowClosing(WindowEvent e) {

		
		//閉じますメッセージ
//		Gui_ClosingMessage pz = new Gui_ClosingMessage(); 
//    	desktop.add(pz,new Integer(3))	;
    	

		//ノード状態をセーブする
		windowlist.saveXml();
		
		//ファイル＆ディレクトリ取得
		File_and_Directory_Address addr = new File_and_Directory_Address();
		//モード取得
		Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
		//ログ出力
		Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

		Tool_Status_IO st = new Tool_Status_IO(addr.getDir_current() + addr.getFile_status());

		//本番モード
		if(sysconfig.isTestmode() == false){

			if(sysconfig.isEnd_server() == true){
				//**********************************************
				//* 中継バッファをサーバに送信する
				//**********************************************
				ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
						addr.getDir_current() + addr.getPgm_client(),
						"--mode","all","--suffix",addr.getFile_digest(),"--relay","--server");
				try {
					Process process = builder.start();
				} catch (IOException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				}
			}

			//**********************************************
			//* 受信サーバを終了する
			//**********************************************
			//ステータスを終了待ちにする
			st.setEndWait();
			
//			for(int i=0; i<sysconfig.getTimer_server() * 20;i++){
			boolean endstatus = false;
			for(int i=0; i<20;i++){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "End Waitting Recieve Server " +(20 - i) +" sec.");
				// 受信サーバの終了を確認した場合
				if(st.getEnd() == true){
//20070923					sysconfig.getTimer_server();
//20070923					sysconfig.getTimer_server();
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Server_main Ended Confirmation");
					logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "End");
					endstatus = true;
					break;
				}
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			    	System.exit(0);
				} 
			}
			if(endstatus == false){
				// 受信サーバの終了を確認できなかった場合
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Server_main Ended Unconfirmed");
				logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "End");
				
			}
			
			
		}
		//テストモード
		else{
			st.setEnd();
			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "End");
			
		}

   		
		
		//*****************************************************************
		//* ＧＵＩセーブ
		//*****************************************************************
   		//メインウィンドウ
		sGuiState.setMainWindow_x((int) this.getLocation().getY());
		sGuiState.setMainWindow_y((int) this.getLocation().getY());
		sGuiState.setMainWindow_width(this.getWidth());
		sGuiState.setMainWindow_height(this.getHeight());
		sGuiState.setSplitlocation(spp.getDividerLocation());
		
   		//メインウィンドウの分割位置
		tGuiState.setSGuiState(sGuiState);
		
   		//メールのカラム幅状態を保存する
		sGuiState.setMailcolumnwidth(windowview.getColumnWidth());
		if(costview != null){
	   		//コストのカラム幅状態を保存する
	   		sGuiState.setCostcolumnwidth(costview.getColumnWidth());
		}
		if(cost_analysis_view != null){
			//分析コストのカラム幅状態を保存する
	   		sGuiState.setCost_analysis_columnwidth(cost_analysis_view.getColumnWidth());
		}
		
   		tGuiState.saveXml();

		System.exit(0);

		//閉じますメッセージ
//		pz.close();
		
	}

	public void windowDeactivated(WindowEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void windowDeiconified(WindowEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void windowIconified(WindowEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void windowOpened(WindowEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}	
	
	
	
	
	
}
	
	