package message;


import java.awt.*;
import java.awt.event.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.*;
import java.util.*;

import javax.swing.*;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

import mailcost_main.Tool_JTable_IO;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_Community_Menber;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Cost_Source;
import structure.Struct_DayTime;
import structure.Struct_System_Config;
import structure.Struct_Time_Count;
import structure.Struct_User;
import tool.RemoveFileExtension;
import tool.Tool_Community_Diject_Status_Update;
import tool.Tool_Community_Menber_IO;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_Gui_PanelEvaluate;
import tool.Tool_JList_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_Task;
import tool.Tool_User_IO;



public class Gui_Message_Main extends JFrame implements ActionListener, MouseListener,WindowListener{
	
	Timer t;						//タイマー
	Gui_Message_ToolBar toolbar;
	
	Gui_part_button btnProject;		//プロジェクトボタン
	Gui_part_button btnReceiver;	//宛先ボタン
	Gui_part_button btnCC;			//ＣＣボタン
	Gui_part_button btnBCC;			//ＢＣＣボタン
	Gui_part_button btnSender;		//差出人ボタン
	
	JTextField txtProject;			// プロジェクト表示領域
	JTextField txtReceiver;			//宛先表示領域
	JTextField txtCC;				//ＣＣ表示領域
	JTextField txtBCC;				//ＢＣＣ表示領域
	JTextField txtSender;			//差出人表示領域
	JTextField txtSubject;			//件名編集領域
	JTextArea txtarea;				//メッセージ編集領域
	
	//送信相手をメンバーリストのライン数で覚えておく
//	ArrayList arry_Receiver;
//	ArrayList arry_CC;
//	ArrayList arry_BCC;
	ArrayList arry_Sender;
	
	//ＢＣＣの送信相手を覚えておく
//20070908	ArrayList arry_BCCtxt;

	
	//送信相手の属性（ノード、ユーザーＩＤ等）を覚えておく
	ArrayList<Struct_Community_Menber> arry_Receiver_menber = new ArrayList();
	ArrayList<Struct_Community_Menber> arry_CC_menber = new ArrayList();
	ArrayList<Struct_Community_Menber> arry_BCC_menber = new ArrayList();
	
	
	String strproject 		= null;
	String strcommunity 	= null;
	
	//メインパラメータ
	String mode;									// 1.モード		
	String read_file		= null;					// 3.ファイル
	String node_project 	= null;					// 5.ノードコミュニティ
	String node_community 	= null;					// 6.ノードプロジェクト

	String send_number		= null;					// 7.送信番号
	String send_fullname	= null;					// 8.差出人
	String send_userid		= null;					// 9.（差出人）ユーザーＩＤ
	String send_node		= null;					//10.（差出人）ノード
	String send_community	= null;					//11.（差出人）コミュニティ
	String send_project		= null;					//12.（差出人）プロジェクト
	int	   recievecount		= 0;					//13.送信人数
	String send_date		= null;					//14.送信日付
	String send_cost		= null;					//15.送信コスト
	
	Struct_Time_Count timecount	= new Struct_Time_Count();
	int save_execnumber		= 1;	//前回タスク走数	
	int execnumber;					//今回タスク走数
	//評価
	boolean eval_switch = false;
	double eval_weight;
	
	Tool_Task tool_task;

	
	
	boolean isIcon = false;
	boolean isIconActive = false;
	boolean isActive = false;
	boolean isClosing = false;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
												addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	Gui_Message_Main(String mode,					// 1.モード
						String read_dir,			// 2.ディレクトリ
						String read_file,			// 3.ファイル
						String status,				// 4.状態
						String nodecommunity,		// 5.ノードコミュニティ
						String nodeproject,			// 6.ノードプロジェクト			
						String send_number,			// 7.送信番号
						String send_fullname,		// 8.差出人
						String senduserid,			// 9.（差出人）ユーザーＩＤ
						String sendnode,			//10.（差出人）ノード
						String sendcommunity,		//11.（差出人）コミュニティ
						String sendproject,			//12.（差出人）プロジェクト
						int recievecount,			//13.送信人数
						String send_date,			//14.送信日付	
						String send_cost			//15.送信コスト	
						){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}		
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setTitle("メッセージ");
		this.setSize(500, 500);
		this.setLocation(100, 100);
		
		this.mode			=	mode;				// 1.モード
		this.read_file		=	read_file;			// 3.ファイル
		this.node_community 	= 	nodecommunity;	// 5.ノードコミュニティ
		this.node_project 	= 	nodeproject;		// 6.ノードプロジェクト	
		this.send_number	=	send_number;		// 7.送信番号
		this.send_fullname	=	send_fullname;		// 8.差出人
		this.send_userid	=	senduserid;			// 9.（差出人）ユーザーＩＤ
		this.send_node		=	sendnode;			//10.（差出人）ノード
		this.send_community=	sendcommunity;		//11.（差出人）コミュニティ
		this.send_project	=	sendproject;		//12.（差出人）プロジェクト
		this.recievecount	=	recievecount;		//13.送信人数
		this.send_date		=	send_date;			//14.送信日付
		this.send_cost		=	send_cost;			//15.送信コスト

		
		//ツールバー
		toolbar = new Gui_Message_ToolBar(mode);
		getContentPane().add(toolbar, BorderLayout.NORTH);
		toolbar.setPreferredSize(new Dimension(240,25));
		
		
		//プロジェクトボタン
		btnProject = new Gui_part_button("Project");

		
		//プロジェクト表示領域
		strproject = nodeproject;
		txtProject = new JTextField(strproject);
		txtProject.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
		txtProject.setEditable(false);

		
		//プロジェクト文字列とプロジェクト表示領域を横連結
		JPanel pnlProject = new JPanel();
		pnlProject.setLayout(new BoxLayout(pnlProject, BoxLayout.LINE_AXIS));
		pnlProject.add(btnProject);
		pnlProject.add(txtProject);
		
		//宛先ボタン
		btnReceiver = new Gui_part_button("宛先");
		
		//宛先表示領域
		txtReceiver = new JTextField();
		txtReceiver.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
		txtReceiver.setEditable(false);


		
		//宛先文字列と宛先表示領域を横連結
		JPanel pnlReceiver = new JPanel();
		pnlReceiver.setLayout(new BoxLayout(pnlReceiver, BoxLayout.LINE_AXIS));
		pnlReceiver.add(btnReceiver);
		pnlReceiver.add(txtReceiver);


		//ＣＣボタン
		btnCC = new Gui_part_button("ＣＣ");


		//ＣＣ表示領域
		txtCC = new JTextField();
		txtCC.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
		txtCC.setEditable(false);

		//ＣＣ文字列とＣ表示領域を横連結
		JPanel pnlCC = new JPanel();
		pnlCC.setLayout(new BoxLayout(pnlCC, BoxLayout.LINE_AXIS));
		pnlCC.add(btnCC);
		pnlCC.add(txtCC);
		

		//ＢＣＣ文字列
		btnBCC = new Gui_part_button("ＢＣＣ");


		//ＢＣＣ表示領域
		txtBCC = new JTextField();
		txtBCC.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
		txtBCC.setEditable(false);

		//ＢＣＣ文字列とＢＣＣ表示領域を横連結
		JPanel pnlBCC = new JPanel();
		pnlBCC.setLayout(new BoxLayout(pnlBCC, BoxLayout.LINE_AXIS));
		pnlBCC.add(btnBCC);
		pnlBCC.add(txtBCC);

		
		//差出人文字列
		btnSender = new Gui_part_button("差出人");

		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		//差出人表示領域
		if(nodecommunity == null){
			txtSender = new JTextField();
		}
		else{
			strcommunity = nodecommunity;
			txtSender = new JTextField("["+strcommunity+"]"+su.getUser_fullname());
		}
		
		txtSender.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
		txtSender.setEditable(false);

		//差出人文字列と差出人表示領域を横連結
		JPanel pnlSender = new JPanel();
		pnlSender.setLayout(new BoxLayout(pnlSender, BoxLayout.LINE_AXIS));
		pnlSender.add(btnSender);
		pnlSender.add(txtSender);
		
		
		//件名文字列
		JTextField txtlabelSubject = new JTextField ("件名");
		txtlabelSubject.setPreferredSize(new Dimension(60,28));
		txtlabelSubject.setMaximumSize(new Dimension(60, 28));
		txtlabelSubject.setBorder(new EmptyBorder( 0, 8, 0, 0));
		txtlabelSubject.setEditable(false);
		txtlabelSubject.setFont(new Font(txtlabelSubject.getFont().getFontName().toString(),
				Font.BOLD,txtlabelSubject.getFont().getSize()));

		//件名書き込み領域
		txtSubject = new JTextField();
		//表示制限の設定
		txtSubject.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));

		//件名文字列と件名表示領域を横連結
		JPanel pnlSubject = new JPanel();
		pnlSubject.setLayout(new BoxLayout(pnlSubject, BoxLayout.LINE_AXIS));
		pnlSubject.add(txtlabelSubject);
		pnlSubject.add(txtSubject);

		
		//メッセージ書き込み領域
		txtarea = new JTextArea();
		txtarea.setMargin(new Insets(10, 10, 10, 10));
		JScrollPane scroll_txtarea = new JScrollPane(txtarea);
		
//		area.setBounds(300, 100, 100, 100);
//		getContentPane().add(area);
		
		JPanel p = new JPanel();
//        p.setPreferredSize(new Dimension(350,150));
        p.setLayout(new BoxLayout(p, BoxLayout.PAGE_AXIS));

        p.add(pnlProject);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
        p.add(pnlReceiver);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
        p.add(pnlCC);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
        p.add(pnlBCC);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
        p.add(pnlSender);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
		p.add(pnlSubject);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
		p.add(scroll_txtarea);
		
		getContentPane().add(p, BorderLayout.CENTER);

		
/* 20070925
 * 		linuxで落ちる
 * 		FocusTraversalPolicyで対応できるらしい
 * 
		//タブキー
		btnProject.setNextFocusableComponent(btnReceiver);
		btnReceiver.setNextFocusableComponent(btnCC);
		btnCC.setNextFocusableComponent(btnBCC);
		btnBCC.setNextFocusableComponent(btnSender);
		btnSender.setNextFocusableComponent(txtSubject);
		txtSubject.setNextFocusableComponent(txtarea);
*/
		
		//読み込み
//		if(mode.equals("read")){
		if(mode.equals(addr.getTask_read())){
			tool_task = new Tool_Task(new RemoveFileExtension()	.removeFileExtension(read_file));
			//２重起動チェック
			if(tool_task.dualCheck() == true){
				System.exit(0);
			}
			if(tool_task.taskWaitCheck() == true){
   	    		JOptionPane.showMessageDialog(this, "設定変更中は読み込みメッセージの起動はできません", 
   	    				"メッセージ", JOptionPane.WARNING_MESSAGE); 
   	    		System.exit(0);
			}
			//タスク登録
			if(tool_task.taskBorn() == false){
				System.exit(0);
			}
			
			//状態が完評以外の場合
			if(senduserid.equals(su.getUserid()) == false &&
					status.equals(new Tool_Community_Diject_Status_Update().getStatus_evaluated()) == false){
				//評価可能
				toolbar.btnEval.addActionListener(this);								//評価ボタン
			}

			//ファイル読み込み
   	    	Tool_Message_IO f = new Tool_Message_IO (read_dir+ addr.getFs() +read_file);
   	    	f.loadXml();
   	    	txtProject.setText(((JTextField)f.getData("project")).getText());		//プロジェクト
   	    	if( f.getData("Receiver") != null ){
   	 	    	txtReceiver.setText(((JTextField)f.getData("Receiver")).getText());	//宛先
   	    	}
   	    	if( f.getData("CC") != null ){
   	 	    	txtCC.setText(((JTextField)f.getData("CC")).getText());				//ＣＣ
   	    	}
   	    	if( f.getData("BCC") != null ){
  	   	    	txtBCC.setText(((JTextField)f.getData("BCC")).getText());			//ＢＣＣ
   	    	}
   	    	txtSender.setText(((JTextField)f.getData("Sender")).getText());			//差出人
   	    	txtSubject.setText(((JTextField)f.getData("Subject")).getText());		//件名
   	    	txtarea.setText(((JTextArea)f.getData("Message")).getText());			//メッセージ
   	    	
   	    	txtSubject.setEditable(false);											//件名編集不可
   	    	txtarea.setEditable(false);												//メッセージ編集不可
   	    	
   	    	//書き込みタスクがない場合
   	    	if(tool_task.writeTaskExec() == false){
				timecount.Start();
				save_execnumber = 1;
			}
   	    	//書き込みタスクがある場合
			else{
				timecount.StartAndPause();
				save_execnumber = 0;
			}
			
		}
		//新規作成
//		else if(mode.equals("write")){
		else if(mode.equals(addr.getTask_write())){
			tool_task = new Tool_Task();
			if(tool_task.New_dualCheck() == true){
   	    		JOptionPane.showMessageDialog(this, "新規メッセージの２重起動はできません", 
   	    				"メッセージ", JOptionPane.WARNING_MESSAGE); 
   	    		System.exit(0);
			}
			if(tool_task.taskWaitCheck() == true){
   	    		JOptionPane.showMessageDialog(this, "設定変更中は新規メッセージの起動はできません", 
   	    				"メッセージ", JOptionPane.WARNING_MESSAGE); 
   	    		System.exit(0);
			}
			//新規書き込み専用タスク登録
			tool_task.taskNewBorn();
			
			toolbar.btnSend.addActionListener(this);	//送信ボタン
			btnProject.addActionListener(this);			//project 押下イベント
			btnProject.addMouseListener(this);			//project マウスイベント
			btnReceiver.addActionListener(this);		//宛先　　押下イベント
			btnReceiver.addMouseListener(this);			//宛先　　マウスイベント
			btnCC.addActionListener(this);				//ＣＣ　　押下イベント
			btnCC.addMouseListener(this);				//ＣＣ　　マウスイベント
			btnBCC.addActionListener(this);				//ＢＣＣ　押下イベント
			btnBCC.addMouseListener(this);				//ＢＣＣ　マウスイベント
			btnSender.addActionListener(this);			//差出人　押下イベント
			btnSender.addMouseListener(this);			//差出人　マウスイベント
			
			timecount.Start();
		}

		//アイコン表示
		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon() + addr.getIcon_mailcost());
		this.setIconImage(icon.getImage());
		
		this.addWindowListener(this);
		this.setVisible(true); 

		//タイマースタート
		t = new Timer(sysconfig.getCost_timer(),this);
//		t.addActionListener(this);
		t.start();
	}


	
	//メイン
	public static void main(String[] args){

		String mode 			= null;						// 1.モード
		String dir 				= null;						// 2.ディレクトリ
		String file 			= null;						// 3.ファイル
		String status 			= null;						// 4.状態
		String nodecommunity 	= null;						// 5.ノードコミュニティ
		String nodeproject 		= null;						// 6.ノードプロジェクト
		String sendnumber 		= null;						// 7.送信番号
		String sender 			= null;						// 8.差出人
		String senduserid 		= null;						// 9.（差出人）ユーザーＩＤ
		String sendnode			= null;						//10.（差出人）ノード
		String sendcommunity 	= null;						//11.（差出人）コミュニティ
		String sendproject 		= null;						//12.（差出人）プロジェクト
		String recievecount		= null;						//13.送信人数
		int	   recievecount_integer	= 0;					//   送信人数（型変換）
		String senddate			= null;						//14.送信日付
		String sendcost			= null;						//15.送信コスト

		
		//パラメータ解析
		for (int i=0; i<args.length; ++i) {
			if ("--mode".equals(args[i])) {
				mode = args[++i];							// 1.モード
            } 
	        else if ("--dir".equals(args[i])) {
	            dir = args[++i];							// 2.ディレクトリ
	        } 
            else if ("--file".equals(args[i])) {
                file = args[++i];							// 3.ファイル
            }
            else if ("--status".equals(args[i])) {
                    status = args[++i];						// 4.状態
            }
            else if("--nodecommunity".equals(args[i])) {
                nodecommunity = args[++i];					// 5.ノードコミュニティ
            } 
            else if ("--nodeproject".equals(args[i])) {
                nodeproject = args[++i];					// 6.ノードプロジェクト
            } 
            else if ("--sendnumber".equals(args[i])) {
            	 sendnumber = args[++i];					// 7.送信番号
            }
            else if ("--sender".equals(args[i])) {
            	 sender = args[++i];						// 8.差出人
            }	 
            else if ("--senduserid".equals(args[i])) {
                    senduserid = args[++i];					// 9.（差出人）ユーザーＩＤ
            }
            else if ("--sendnode".equals(args[i])) {
                sendnode = args[++i];						//10.（差出人）ノード
            }
            else if("--sendcommunity".equals(args[i])) {
                 sendcommunity = args[++i];					//11.（差出人）コミュニティ
            } 
            else if ("--sendproject".equals(args[i])) {
                 sendproject = args[++i];					//12.（差出人）プロジェクト
            } 
            else if ("--recievecount".equals(args[i])) {
            	recievecount = args[++i];					//13.送信人数
            	recievecount_integer = Integer.valueOf(recievecount).intValue();
           } 
           else if ("--senddate".equals(args[i])) {
                senddate = args[++i];						//14.送信日付
           }
           else if ("--sendcost".equals(args[i])) {
               sendcost = args[++i];						//15.送信コスト
          }
           else {
            	System.out.println("引数指定の誤り：未知の引数が指定されました");
            }
        }

		
	    if(mode.equals("write")){
	    	//メッセージの新規作成
	    	JFrame frame = new Gui_Message_Main(mode,	// 1.モード
	    			null,								// 2.ディレクトリ
	    			null,								// 3.ファイル
	    			null,								// 4.状態
	    			nodecommunity,						// 5.ノードコミュニティ
	    			nodeproject,						// 6.ノードプロジェクト
	    			null,								// 7.送信番号
	    			null,								// 8.差出人
	    			null,								// 9.（差出人）ユーザーＩＤ
	    			null,								//10.（差出人）ノード
	    			null,								//11.（差出人）コミュニティ
	    			null,								//12.（差出人）プロジェクト
	    			0,									//13.送信人数
	    			null,								//14.送信日付
	    			null								//15.送信コスト
	    			);
	    }
	    else if(mode.equals("read")){
	    	//メッセージの表示
	    	JFrame frame = new Gui_Message_Main(mode,	// 1.モード
	    			dir,								// 2.ディレクトリ
	    			file,								// 3.ファイル
	    			status,								// 4.状態
	    			nodecommunity,						// 5.ノードコミュニティ
	    			nodeproject,						// 6.ノードプロジェクト
	    			sendnumber,							// 7.送信番号
	    			sender,								// 8.差出人
	    			senduserid,							// 9.（差出人）ユーザーＩＤ
	    			sendnode,							//10.（差出人）ノード
	    			sendcommunity,						//11.（差出人）コミュニティ
	    			sendproject,						//12.（差出人）プロジェクト
	    			recievecount_integer,				//13.送信人数
	    			senddate,							//14.送信日付
	    			sendcost							//15.送信コスト
	    			);
	    }
	}

	
	
	public void actionPerformed(ActionEvent e) {
	    Object source = e.getSource();
	    //タイマー呼び出し
	    if(source == t){
			DateFormat dfa = new SimpleDateFormat("yyyyMMdd_HHmmss");
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "timer:"+dfa.format(System.currentTimeMillis()));
//	    	if(mode.equals("read")){
	    	if(mode.equals(addr.getTask_read())){
	    		if(isIcon == false){
	    			//タスク状態の取得
	    			execnumber = tool_task.taskExecNumbers();
	    			//前回のタスク状態と今回のタクス状態が同じ場合
	    			if(save_execnumber == execnumber){
	    			}
	    			//前回のタスク状態はコストオフで今回のタクス状態はコストオンの場合
	    			else if(save_execnumber == 0 && execnumber > 0){
		    			timecount.ReStart();
	    			}
	    			//前回のタスク状態はコストオンで今回のタクス状態はコストオフの場合
	    			else if(save_execnumber > 0 && execnumber == 0){
	    				timecount.Pause(save_execnumber);
	    			}
	    			//前回のタスク状態と今回のタクス状態はコストオンだが走数が異なる場合
	    			else{
		    			timecount.ChangeExecNumber(save_execnumber)	;
	    			}
		    		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "timer *** exec save_timer =" + save_execnumber);
	    			//タスク状態のセーブ
	    			save_execnumber = execnumber;
//					*** debug ***					
		    		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "timer *** exec timer      =" + execnumber);
		    		debugTimeCountPrint();
	    		}
	    	}
	    	
	    }
	    String answer = e.getActionCommand();	
	    if(answer == null){	
	    	return;
	    }
    	//********************************************************
    	//* （ツールバー）送信ボタンを押した処理
    	//********************************************************
   		if(e.getSource() ==toolbar.btnSend){
   			timecount.Pause(1);	//一時中断
   			
   			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Send check");

   	    	//********************************************************
   	    	//* チェック
   	    	//********************************************************
   			//送信チェック
   			if(strproject == null){
   	    		JOptionPane.showMessageDialog(this, "Projectを入力してください", 
   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
   	   			timecount.ReStart();	//リスタート
   	    		return;
   			}
   			if(txtReceiver == null || txtReceiver.getText().length() == 0){
   	   			if(txtBCC == null || txtBCC.getText().length() == 0){
	   	    		JOptionPane.showMessageDialog(this, "宛先またはＢＣＣを入力してください", 
	   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
	   	   			timecount.ReStart();	//リスタート
	   	    		return;
   				}
    		}    		
   			if(txtSender == null || txtSender.getText().length() == 0){
   	    		JOptionPane.showMessageDialog(this, "差出人を入力してください", 
   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
   	   			timecount.ReStart();	//リスタート
   	    		return;
   			}
   			if(txtSubject == null || txtSubject.getText().length() == 0){
   	    		JOptionPane.showMessageDialog(this, "件名を入力してください", 
   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
   	   			timecount.ReStart();	//リスタート
   	    		return;
   			}
   			if(txtarea == null || txtarea.getText().length() == 0){
   	    		JOptionPane.showMessageDialog(this, "メッセージを入力してください", 
   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
   	   			timecount.ReStart();	//リスタート
   	    		return;
   			}
   			
   			//***********************************************************
   			//* 宛先の重複チェック
   			//***********************************************************
   			//宛先、ＣＣ、ＢＣＣの重複調整
   			ArrayList<Struct_Community_Menber> rsv_arry_Receiver_menber		=	arry_Receiver_menber;
   			ArrayList<Struct_Community_Menber> rsv_arry_CC_menber			=	arry_CC_menber;
   			ArrayList<Struct_Community_Menber> rsv_arry_BCC_menber			=	arry_BCC_menber;

   			if(duplicate_Check("宛先",rsv_arry_Receiver_menber,"ＣＣ",rsv_arry_CC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}
   			if(duplicate_Check("宛先",rsv_arry_Receiver_menber,"ＢＣＣ",rsv_arry_BCC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}
   			if(duplicate_Check("ＣＣ",rsv_arry_CC_menber,"ＢＣＣ",rsv_arry_BCC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}

  			
   			//すべてのメンバーの展開
   			expand(rsv_arry_Receiver_menber);
   			expand(rsv_arry_CC_menber);
   			expand(rsv_arry_BCC_menber);
   			
   			//展開後に送信種類内部に重複データがないかをチェック   			
   			duplicate_delete("宛先",rsv_arry_Receiver_menber);
   			duplicate_delete("ＣＣ",rsv_arry_CC_menber);
   			duplicate_delete("ＢＣＣ",rsv_arry_BCC_menber);
   			
   			//展展開後に送信種類と他の送信種類との関係で重複データがないかをチェック  
   			if(duplicate_Check("宛先",rsv_arry_Receiver_menber,"ＣＣ",rsv_arry_CC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}
   			if(duplicate_Check("宛先",rsv_arry_Receiver_menber,"ＢＣＣ",rsv_arry_BCC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}
   			if(duplicate_Check("ＣＣ",rsv_arry_CC_menber,"ＢＣＣ",rsv_arry_BCC_menber) == false){
   	   			timecount.ReStart();	//リスタート
   				return;
   			}
   			
   			
   			//* ｜宛先　｜ＣＣ　｜ＢＣＣ｜送信パターン
   			//* ｜　○　｜　○　｜　○　｜ＯＫ
   			//* ｜　○　｜　○　｜　×　｜ＯＫ
   			//* ｜　○　｜　×　｜　○　｜ＯＫ
   			//* ｜　×　｜　○　｜　○　｜　　　ＮＧ　ここでチェック　
   			//* ｜　○　｜　×　｜　×　｜ＯＫ　
   			//* ｜　×　｜　○　｜　×　｜　　　ＮＧ　ここでチェック
   			//* ｜　×　｜　×　｜　○　｜ＯＫ
   			//* ｜　×　｜　×　｜　×　｜　　　ＮＧ　もっと前でチェック済
   			
   			//調整後に宛先またはＢＣＣのいづれかに送信先はあるか？
   			if(rsv_arry_Receiver_menber == null || rsv_arry_Receiver_menber.size() == 0){
   	   			if(rsv_arry_BCC_menber == null || rsv_arry_BCC_menber.size() == 0){
	   	    		JOptionPane.showMessageDialog(this, "宛先またはＢＣＣが未入力です\n見直しをしてください", 
	   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
	   	   			timecount.ReStart();	//リスタート
	   	    		return;
   				}
    		}    		
   			
   			//調整後に宛先またはＢＣＣのいづれかに送信先はあるか？
   			if(rsv_arry_Receiver_menber == null || rsv_arry_Receiver_menber.size() == 0){
   	   			if(rsv_arry_CC_menber != null && rsv_arry_CC_menber.size() > 0){
	   	    		JOptionPane.showMessageDialog(this, "ＣＣを入力する時は宛先の入力が必要です\n見直しをしてください", 
	   	    				"送信", JOptionPane.INFORMATION_MESSAGE); 
	   	   			timecount.ReStart();	//リスタート
	   	    		return;
   				}
    		}    		
   			
   			//重複調整後の宛先、ＣＣ、ＢＣＣの画面表示データの取得
   			String rsv_txtReceiver	= toTextData(rsv_arry_Receiver_menber);
   			String rsv_txtCC		= toTextData(rsv_arry_CC_menber);
   			String rsv_txtBCC		= toTextData(rsv_arry_BCC_menber);
   			
   			
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"メッセージを送信しますか？",
    				"メッセージ",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.NO_OPTION){
       			timecount.ReStart();	//再開
    			return;
    		}
   			
    		//重複調整した宛先、ＣＣ、ＢＣＣを画面に再表示
    		txtReceiver.setText(rsv_txtReceiver);
   			txtCC.setText(rsv_txtCC);
   			txtBCC.setText(rsv_txtBCC);
   			
    		//重複調整＆すべてのメンバー展開したした宛先、ＣＣ、ＢＣＣを設定
   			arry_Receiver_menber	= rsv_arry_Receiver_menber;
   			arry_CC_menber 			= rsv_arry_CC_menber;
   			arry_BCC_menber			= rsv_arry_BCC_menber;
   			
   			
   			timecount.End(1);			//時間計測終了


   			//********************************************************
   	    	//* コミュニティダイジェスト更新
   	    	//********************************************************
   			//ダイジェスト更新
	    	Struct_Community_Digest com_dig_data = new Struct_Community_Digest();			
   			String[] columnames = com_dig_data.getColData();
			String 	filedir			=addr.getDir_current() + addr.getDir_project();
   	    	String filename = filedir + strproject +  addr.getFs()  + 
   	    						strcommunity + addr.getFile_community_digest();
   	    	Tool_JTable_IO t = new Tool_JTable_IO (filename);
   	    	t.putColum(columnames);
   	    	t.loadXml();

   	    	//ユーザー情報
	    	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + 
	    												addr.getFile_user_info());
			Struct_User su = user_info.getStruct_User();

	    	//最終送信番号１ＵＰ
			su.Last_send_number_CountUp();
			user_info.setStruct_User(su);
			user_info.saveXml();
	    

	    	//送信日付
	    	long nowtime = System.currentTimeMillis();
	    	//送信ユーザー
	    	String userid = su.getUserid();
	    	
   	    	//送信日付のフォーマット変換
   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
   	    	//送信番号のフォーマット変換
   	    	DecimalFormat df = new DecimalFormat("00000");


   	    	//送信ファイル
   	    	filedir		=addr.getDir_current() + addr.getDir_project()+ 
   	    					strproject +  addr.getFs()  + 
   	    					strcommunity +  addr.getFs()  ;
   	    	filename 	= dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) 
   	    					+ "_" +userid + ".txt";

   	    	//コミュニティダイジェスト
   	    	com_dig_data.setStatus(new Tool_Community_Diject_Status_Update().getStatus_notsend());	// 1.状態
	    	com_dig_data.setSender(su.getUser_fullname());											// 2.差出人
	    	com_dig_data.setSendnumber(Integer.toString(su.getLast_send_number()));					// 3.送信ナンバー
	    	com_dig_data.setSubject(txtSubject.getText());											// 4.件名
	    	com_dig_data.setSend_date(DateFormat.getDateTimeInstance().format(nowtime));			// 5.送信日時		
	    	com_dig_data.setText_size(Integer.toString(txtarea.getText().length()));				// 6.本文サイズ
	    	com_dig_data.setUserid(userid);															// 7.送信ユーザーＩＤ
	    	com_dig_data.setNode(su.getNode());														// 8.送信ノード	
	    	com_dig_data.setCommunity(strcommunity);												// 9.送信コミュニティ名称
	    	com_dig_data.setProject(strproject);													//10.送信プロジェクト名称
	    	com_dig_data.setFilename(filename);														//11.送信ファイル名称

	    	//送信コストの計算
	    	Struct_Cost_Source	send_cost = new Struct_Cost_Source();
    		send_cost.setUnitcost(su.getUnit_cost());
    		send_cost.setSecond(timecount.getInterval_date()/1000);
    		send_cost.Calculate();


    		
	    	com_dig_data.setSendcost_integer((int)send_cost.getCost());								//12.送信コスト
	    	
	    	int recieve_count = 0;
	    	if(arry_Receiver_menber != null && arry_Receiver_menber.size() > 0){
	    		recieve_count	=	arry_Receiver_menber.size();
	    	}
	    	if(arry_CC_menber != null && arry_CC_menber.size() > 0){
	    		recieve_count	=	recieve_count	+	arry_CC_menber.size();
	    	}
	    	if(arry_BCC_menber != null && arry_BCC_menber.size() > 0){
	    		recieve_count	=	recieve_count	+	arry_BCC_menber.size();
	    	}

//	    	for(int i=0;i<arry_Receiver_menber.size();i++){
//	    		System.out.println("bbb"+((Struct_Community_Menber)arry_Receiver_menber.get(i)).getNode());
//	    	}
	    	
	    	com_dig_data.setReciever_count_integer(recieve_count);									//13.受信者数
	    	
//	    	t.putData(com_dig_data.getArryData());
	    	t.insertData(com_dig_data.getArryData());
   	    	t.saveXml2();

   	    	
   	    	//********************************************************
   	    	//* コミュニティディレクトリにメールファイルを作成
   	    	//********************************************************
   	    	Tool_Message_IO sf = new Tool_Message_IO (filedir + filename);
   	    	sf.loadXml();							//枠作成
   	    	sf.putData("project", txtProject);
   	    	sf.putData("Receiver", txtReceiver);
   	    	sf.putData("CC", txtCC);
   	    	sf.putData("BCC", txtBCC);
   	    	sf.putData("Sender", txtSender);
   	    	sf.putData("Subject", txtSubject);
   	    	sf.putData("Message", txtarea);
   	    	//コミュニティディレクトリにセーブ
   	    	sf.saveXml();

   	    	
   	    	//********************************************************
   	    	//* 送信バッファに送信ファイルを作成　宛先、ＣＣ用
   	    	//********************************************************
			String sendlistname = new String();
   	    	//宛先、ＣＣがある場合
   	    	if(rsv_arry_Receiver_menber != null && rsv_arry_Receiver_menber.size() > 0){
   	   	    	sf.replace_filename(addr.getDir_current() + addr.getDir_buff_send() + filename);
   	   	    	sf.putData("BCC", null);
   	   	    	sf.saveXml();
   	   	    	//********************************************************
   	   	    	//* 送信バッファに送送付指示リストを作成　宛先、ＣＣ用
   	   	    	//********************************************************
   	   	    	sendlistname = addr.getDir_current() + addr.getDir_buff_send() + 
   	   	    							dfm.format(nowtime) + "_" 
   	   	    							+df.format(su.getLast_send_number()) + "_" + userid  
   	   	    							+ addr.getFile_digest();
//   	   	    							+"digest.txt";
   	   	    	
   	   	    	//送信用のコミュニティダイジェストは状態を未読にする
   	   	    	com_dig_data.setStatus(new Tool_Community_Diject_Status_Update().getStatus_notread());	
   	   	    	
   	   	    	Tool_SendList_IO slm = new Tool_SendList_IO( strproject,sendlistname, 
   																filename, 
//   																arry_Receiver, 
   																arry_Receiver_menber,
   																com_dig_data);
//   	   	    	if(arry_CC != null){
   	   	    	if(arry_CC_menber != null){
//   	   	   	    	slm = new Tool_SendList_IO( strproject,sendlistname,filename,arry_CC,com_dig_data);
//   	   	   	    	slm.add_SendList(arry_CC);
   	   	   	    	slm.add_SendList(arry_CC_menber);
   	   	    	}
   	   	    	slm.saveXml();
   			}
   	    	//宛先、ＣＣがない場合
   			else{
   	   	    	//送信用のコミュニティダイジェストは状態を未読にする
   	   	    	com_dig_data.setStatus(new Tool_Community_Diject_Status_Update().getStatus_notread());	
   			}

   	    	
   	    	//********************************************************
   	    	//* 送信バッファ処理　ＢＣＣ用
   	    	//********************************************************
   	    	sf.putData("CC", null);
   	    	sf.putData("BCC", null);

   	    	//枝番をランダム作成する準備
   	    	Random rnd = new Random();
//   	    	DecimalFormat df2 = new DecimalFormat("000");

//   	    	if( arry_BCC != null){
   	    	if( arry_BCC_menber != null){
   	    		ArrayList arry_BCCtxt = toArrayData(rsv_arry_BCC_menber);
   	    		
//	   	    	for(int i = 0 ; i < arry_BCC.size();i++){
	   	    	for(int i = 0 ; i < arry_BCC_menber.size();i++){
	   	    		//枝番をランダム作成
//	   	    		int rdnumber = rnd.nextInt(1000);
			    	//最終システム送信番号１ＵＰ
					su.Last_system_send_number_CountUp();
					user_info.setStruct_User(su);
					user_info.saveXml();
					int rdnumber =su.getLast_system_send_number();	

	   	    		
	   	    		//ファイル名作成
	   	    		filename 	= dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) 
	   	    					+ "_" +userid + "_" +df.format(rdnumber) +".txt";
	   	   	    	sendlistname = addr.getDir_current() + addr.getDir_buff_send()
	   	   	    					+ dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) +
	   	   	    					"_" + userid + "_" +df.format(rdnumber) 
//	   	   	    					+"digest.txt";
	   	   	    					+ addr.getFile_BCCdigest();
	   	   	    	sf.replace_filename(addr.getDir_current() + addr.getDir_buff_send() + filename);
	
	   	   	    	//ＢＣＣを宛先に設定
//	   	   	    	sf.putData("Receiver", arry_BCCtxt.get(i).toString());
//20070908	   	   	    	JTextField ghost = new JTextField(arry_BCCtxt.get(i).toString());
	   	   	    	JTextField ghost = new JTextField(arry_BCCtxt.get(i).toString());
	   	   	    	sf.putData("Receiver", ghost);
//					System.out.println("@@@:"+arry_BCCtxt.get(i).toString());
//					System.out.println("@@@:"+sf.getData("Receiver"));
					
	   	   	    	//送信ファイルをバッファに置く
	   	   	    	sf.saveXml();
	   	   	    	//ダイジェストの送信ファイル名を書き換え
//	   	   	    	data[9] = filename;
//20070907	   	   	    	com_dig_data.setFilename(filename);
	   	   	    	//送付指示リストの作成
//	   	   	    	slm = new Tool_SendList_IO( strproject,sendlistname,filename,arry_BCC.get(i).toString(),com_dig_data.getArryData());
	   	   	    	Tool_SendList_IO slm = new Tool_SendList_IO( strproject,sendlistname,filename,arry_BCC_menber.get(i),com_dig_data);
	   	   	    	slm.saveXml();
	   	    	}   	    		
   	    	}

   			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "call Client_Main ");
   	    	
   	    	//********************************************************
   	    	//* 送信
   	    	//********************************************************
   	    	//モード取得
	   	 	Struct_System_Config sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
   	    	
    		//テストモード時は呼び出し禁止
    		if(sysconfig.isTestmode() == false){
	    		ProcessBuilder builder = new ProcessBuilder("java", "-jar",
	    								addr.getDir_current() + addr.getPgm_client(),
	    								"--mode","target","--prefix",dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) ,"--suffix",addr.getFile_digest());
//20070923 								"--mode","target","--prefix",dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) ,"--suffix","digest.txt");


				try {
					Process process = builder.start();	//プロセス実行
		    		JOptionPane.showMessageDialog(this, "送信を実施しました,\n"+
		    											"注意：送信処理中は書き込みメッセージを開くことができません.", 
		    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
		    		//画面消去
		    		this.setVisible(false);
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					//送信失敗
					if(process.exitValue() != 0){
			    		JOptionPane.showMessageDialog(this, "送信処理が失敗しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
				
				} catch (IOException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());

				} catch (InterruptedException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				}
    			
    		}

    		
   	    	//********************************************************
   	    	//* コミュニティダイジェストのステータス更新
   	    	//********************************************************
    		new Tool_Community_Diject_Status_Update(strproject,
    												strcommunity,
    												nowtime,
    												su.getLast_send_number()).sendCheck();

   	    	//********************************************************
   	    	//* コスト明細 クリエイト
   	    	//********************************************************
    		Struct_Cost_Detail scu = new Struct_Cost_Detail();

    		scu.setSender(su.getUser_fullname());					// 1.差出人
    		scu.setSend_number(su.getLast_send_number());			// 2.送信ナンバー
    		scu.setGeneration_date(nowtime);						// 3.発生日時
    		scu.setGeneration_node(su.getNode());					// 4.発生ノード
    		scu.setGeneration_userid(su.getUserid());				// 5.発生ユーザーＩＤ
    		scu.setGeneration_puroject(strproject);					// 6.発生プロジェクト
    		scu.setGeneration_community(strcommunity);				// 7.発生コミュニティ	
    		scu.setTime_count(timecount);							// 8.計測時間

/*    		Struct_Cost_Source	send_cost = new Struct_Cost_Source();
    		send_cost.setUnitcost(su.getUnit_cost());
    		send_cost.setSecond(timecount.getInterval_date()/1000);
    		send_cost.Calculate();
*/    		
    		//送信コストはダイジェスト作成時に計算済み
    		scu.setSend_cost(send_cost);							// 9.送信コスト
    		
    		
    		Struct_Cost_Source	recieve_cost = new Struct_Cost_Source();
    		recieve_cost.setUnitcost(0);
    		recieve_cost.setSecond(0);
    		recieve_cost.setCost(0);

    		scu.setRecieve_cost(recieve_cost);						//10.受信コスト	
    		
    		scu.setTotal_cost(send_cost.getCost());					//11.総コスト
    		scu.setEval_value(0);									//12.評価額
    		scu.setAtvalue_cost(send_cost.getCost());				//13.評価後コスト 
    		scu.setUserid(su.getUserid());							//14.（差出人）ユーザーＩＤ
    		//20071022
    		scu.setSend_number_original(String.valueOf(su.getLast_send_number()));	//15.（差出人）送信ナンバー
   		
    		ArrayList array_cost_detail = new ArrayList();
    		
    		array_cost_detail.add(scu);

  	    	filedir		=addr.getDir_current() + addr.getDir_project()+ 
  	    					strproject + 
  	    					addr.getDir_costsend() +  addr.getFs() ;
   	    	filename 	= addr.getFile_cost_suffix() + dfm.format(nowtime) + "_" +df.format(su.getLast_send_number()) 
   	    					+ "_" +userid + ".txt";    		
    		
    		Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(filedir + filename );
    		tcd.setArray_cost_detail(array_cost_detail);
    		tcd.saveXml();

   	    	//********************************************************
   	    	//* コストダイジェスト 更新
   	    	//********************************************************
    		Struct_Cost_Digest scd = new Struct_Cost_Digest();

    		scd.setSender(su.getUser_fullname());									// 1.差出人
    		scd.setUserid(su.getUserid());											// 2.（差出人）ユーザーＩＤ
    		scd.setSendnumber(Integer.toString(su.getLast_send_number()));			// 3.送信ナンバー
    		scd.setSubject(txtSubject.getText());									// 4.件名
    		scd.setSend_date(DateFormat.getDateTimeInstance().format(nowtime));		// 5.送信日時

    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue((int) send_cost.getCost()));
    		send_cost_bar.setRealvalue((int) send_cost.getCost());
    		send_cost_bar.setMode(su.getMode((int) send_cost.getCost()));
    		scd.setSend_cost(send_cost_bar);										// 6.送信コスト
    		
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue(0));
    		recieve_cost_bar.setRealvalue(0);
    		recieve_cost_bar.setMode(su.getMode(0));
    		scd.setRecieve_cost(recieve_cost_bar);									// 7.受信コスト	
    		scd.setTotal_cost(send_cost_bar);										// 8.総コスト
    		
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(0));
    		eval_value_cost_bar.setRealvalue(0);
    		eval_value_cost_bar.setMode(su.getMode(0));
    		scd.setEval_value(eval_value_cost_bar);									// 9.評価額	
    		scd.setAteval_cost(send_cost_bar);										//10.評価後コスト	
    		scd.setFilename(filename);												//11.ファイル
    		
    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (addr.getDir_current() + 
					addr.getDir_project() + 
					strproject + 
					addr.getDir_costsend() +  addr.getFs()  +
					addr.getFile_cost_digest());
    		tt.loadXml();
    		tt.insertData(scd);
    		tt.saveXml();
    		
   			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end ");
   	    	
			tool_task.taskNewDead();
   	    	System.exit(0);
   	    	
   		}
    	//********************************************************
    	//* プロジェクトボタンを押した処理
    	//********************************************************
   		else if(e.getSource() ==btnProject){
   			Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
   			t.loadXml();
//   			String[] communitydata= t.get_project();
   			String[] communitydata= t.getLiveProject();
   			
   			Object ans = null;
   			ans = JOptionPane.showInputDialog(
   					this, 
   					"プロジェクトを選択してください", 
   					"プロジェクトの選択", 
   					JOptionPane.QUESTION_MESSAGE, 
   					null, 
   					communitydata,strcommunity) ;
   			if(ans != null){
   				strproject = (String) ans;
   				txtProject.setText(strproject);
   			}
   			return;
   		}
   		
	    //プロジェクトチェック
   		if(e.getSource() ==btnReceiver	||
   			e.getSource() ==btnCC		||
   			e.getSource() ==btnBCC		||
   			e.getSource() ==btnSender	){
   			if(strproject == null){
   	    		JOptionPane.showMessageDialog(this, "Projectを入力してください。", 
   	    				"送付先/差出人の選択", JOptionPane.ERROR_MESSAGE); 
   	    		return;
   			}
   		}
   		
    	//********************************************************
    	//* 宛先ボタンを押した処理
    	//********************************************************
   		if(e.getSource() ==btnReceiver){
   			Gui_Panel_sendlist option = new Gui_Panel_sendlist("宛先",strproject,txtReceiver.getText(),arry_Receiver_menber);
   			int ans = JOptionPane.showConfirmDialog(this, 
   					option,
   					"宛先の選択",
   					JOptionPane.OK_CANCEL_OPTION,
   					JOptionPane.PLAIN_MESSAGE);
   			//yesのみ反映
   			if(ans == 0){
   				txtReceiver.setText(option.getData());
   				
//   				arry_Receiver = option.getselect_line();
   				arry_Receiver_menber = option.getSelect_Menber();
   				
   			}
   		}
    	//********************************************************
    	//* ＣＣボタンを押した処理
    	//********************************************************
   		else if(e.getSource() ==btnCC){
   			Gui_Panel_sendlist option = new Gui_Panel_sendlist("ＣＣ",strproject,txtCC.getText(),arry_CC_menber);
   			int ans = JOptionPane.showConfirmDialog(this, 
   					option,
   					"ＣＣの選択",
   					JOptionPane.OK_CANCEL_OPTION,
   					JOptionPane.PLAIN_MESSAGE);
   			//yesのみ反映
   			if(ans == 0){
   				txtCC.setText(option.getData());
//   				arry_CC = option.getselect_line();
   				arry_CC_menber = option.getSelect_Menber();
   			}
   		}
    	//********************************************************
    	//* ＢＣＣボタンを押した処理
    	//********************************************************
   		else if(e.getSource() ==btnBCC){
   			Gui_Panel_sendlist option = new Gui_Panel_sendlist("ＢＣＣ",strproject,txtBCC.getText(),arry_BCC_menber);
   			int ans = JOptionPane.showConfirmDialog(this, 
   					option,
   					"ＢＣＣの選択",
   					JOptionPane.OK_CANCEL_OPTION,
   					JOptionPane.PLAIN_MESSAGE);
   			//yesのみ反映
   			if(ans == 0){
   				txtBCC.setText(option.getData());
//   				arry_BCC = option.getselect_line();
//20070908   				arry_BCCtxt = option.getselect_text();
   				arry_BCC_menber = option.getSelect_Menber();
   			}
   		}
    	//********************************************************
    	//* 差出人ボタンを押した処理
    	//********************************************************
   		else if(e.getSource() ==btnSender){
   			
   			String  filename = addr.getDir_current() + addr.getDir_project()  + strproject + addr.getFile_com_select();
	   		Tool_JList_IO tls = new Tool_JList_IO(filename);	
   			String[] projectdata= tls.loadXml2();
   			Object ans = null;
   			ans = JOptionPane.showInputDialog(
   					this, 
   					"コミュニティを選択してください", 
   					"差出人の選択", 
   					JOptionPane.QUESTION_MESSAGE, 
   					null, 
   					projectdata,strproject) ;
   			//コミュニティに値がある場合
   			if(ans != null){
   				//値を取得
   				strcommunity = (String) ans;
   	   	    	//ユーザー情報から名前をロード
   	   	    	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
   				Struct_User su = user_info.getStruct_User();
   	   	    	
   	   	    	//画面に表示
   				txtSender.setText("["+strcommunity+"]["+   su.getUser_fullname() +"]");
   			
   			}
   		}
   		//評価ボタンを押した場合
   		else if(e.getSource() == toolbar.btnEval){
   			Tool_Gui_PanelEvaluate option = new Tool_Gui_PanelEvaluate("modal",
								   					send_number,			// 送信番号
								   					txtSubject.getText(),	// 件名
													send_date,				// 送信日付
													send_fullname);			// （差出人）送信者

   			int ans = JOptionPane.showConfirmDialog(this, 
   					option,
   					"評価の入力",
   					JOptionPane.OK_CANCEL_OPTION,
   					JOptionPane.PLAIN_MESSAGE);

   			
   			//yesのみ反映
   			if(ans == 0){
   				eval_switch = true;
   				eval_weight = option.getEvalWeight();
   			}
   			else{
   				eval_switch = false;
   			}

		}
	}
	
	public void mouseClicked(MouseEvent e) {
	}
	//マウスは敷地に入った
	public void mouseEntered(MouseEvent e) {
   		if(e.getSource() ==btnProject){
   	   	   	btnProject.setBorderPainted(true);
   		}
   		else if(e.getSource() ==btnReceiver){
   			btnReceiver.setBorderPainted(true);
   		}
   		else if(e.getSource() ==btnCC){
   			btnCC.setBorderPainted(true);
   		}
   		else if(e.getSource() ==btnBCC){
   	   	   	btnBCC.setBorderPainted(true);
   		}
   		else if(e.getSource() ==btnSender){
   	   	   	btnSender.setBorderPainted(true);
   		}
	}
	//マウスは敷地からでた
	public void mouseExited(MouseEvent e) {
   		if(e.getSource() == btnProject){
   	   	   	btnProject.setBorderPainted(false);
   		}
   		if(e.getSource() == btnReceiver){
   	   	   	btnReceiver.setBorderPainted(false);
   		}
   		else if(e.getSource() == btnCC){
   	   	   	btnCC.setBorderPainted(false);
   		}
   		else if(e.getSource() == btnBCC){
   	   	   	btnBCC.setBorderPainted(false);
   		}
   		else if(e.getSource() == btnSender){
   	   	   	btnSender.setBorderPainted(false);
   		}
	}
	public void mousePressed(MouseEvent e) {
	}
	public void mouseReleased(MouseEvent e) {
	}

	//********************************************************
	//* ウィンドウイベント
	//********************************************************

	//アクティブ化
	public void windowActivated(WindowEvent e) {
		isActive 	=	true;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "active on");
		if(mode.equals(addr.getTask_read())){
			//アイコン化からの復元の場合
			if(isIconActive == true){
				isIconActive 	=	false;
			}
			else{
				//タスク状態の取得
    			execnumber = tool_task.taskExecNumbers();
    			if(save_execnumber == 0 && execnumber == 0){
    				//* 何もしない
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "act nothing zero");
    			}
    			//前回のタスク状態と今回のタクス状態が同じ場合
    			else if(save_execnumber == execnumber){
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "act nothing");
    			}
    			//前回のタスク状態はコストオフで今回のタクス状態はコストオンの場合
    			else if(save_execnumber == 0 && execnumber > 0){
	    			timecount.ReStart();
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "act active");
	    			save_execnumber = 1;
    			}
    			//前回のタスク状態はコストオンで今回のタクス状態はコストオフの場合
    			else if(save_execnumber > 0 && execnumber == 0){
	    			timecount.Pause(save_execnumber);
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "act pause");
	    			save_execnumber = 0;
    			}
    			//前回のタスク状態と今回のタクス状態はコストオンだが走数が異なる場合
    			else{
	    			timecount.ChangeExecNumber(save_execnumber)	;
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "act change");
	    			save_execnumber = execnumber;
    			}
			}
		}
//		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "windowActivated");
		debugTimeCountPrint();
	}
	
	//非アクティブ化
	public void windowDeactivated(WindowEvent e) {
		isActive 	=	false;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "active off");
		
		if(mode.equals(addr.getTask_read())){
			if(isIcon == false && isClosing == false && save_execnumber != 0){
				timecount.Pause(save_execnumber);
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "dec pause");
				save_execnumber = 0;
			}
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "windowDeactivated");
		debugTimeCountPrint();
	}
	//アイコン化から復元
	public void windowDeiconified(WindowEvent e) {
		isIcon = false;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Icon off");
		if(mode.equals(addr.getTask_write())){
			timecount.ReStart();
			//新規書き込み専用タスク登録
			tool_task.taskNewBorn();
		}
		else{
			tool_task.taskBorn();
			//書き込みタスクがなければ、コストフル
			if(tool_task. writeTaskExec() == false){
				timecount.ReStart();
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "dic restart");
				save_execnumber = 1;
			}
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "windowDeiconified");
		debugTimeCountPrint();
	}
	//アイコン化
	public void windowIconified(WindowEvent e) {
		isIcon 			=	true;
		isIconActive 	=	true;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Icon");
		if(mode.equals(addr.getTask_write())){
			timecount.Pause(1);
			//新規書き込み専用タスク解除
			tool_task.taskNewWait();
		}
		else{
			//アクティブオンから変化した場合
			if(save_execnumber != 0){
				timecount.Pause(save_execnumber);
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "ico pause");
				save_execnumber = 0;
			}
			tool_task.taskWait();
		}
//		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "windowIconified");
		debugTimeCountPrint();
	}
	
	
	public void windowOpened(WindowEvent e) {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "open");
//		debugTimeCountPrint();
	}		
	
	
	public void windowClosed(WindowEvent e) {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "closed");
		if(mode.equals(addr.getTask_write())){
			tool_task.taskNewDead();
		}
		else{
			tool_task.taskDead();
		}
	}
	
	public void windowClosing(WindowEvent e) {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "closing");
		isClosing = true;
		if(mode.equals(addr.getTask_read()) == true){
			t.stop();								//タイマーストップ
   			timecount.End(save_execnumber);			//時間計測終了
   			
			Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
			Struct_User su = user_info.getStruct_User();
   	    	//********************************************************
   	    	//* コスト明細 レコード追加
   	    	//********************************************************
			//コスト明細ファイルの取得
			String filedir;
			//本人が作成したメッセージを読んだ場合
			if(send_userid.equals(su.getUserid())){		
				filedir	=	addr.getDir_current() + 
								addr.getDir_project()+ 
								strproject + 
								addr.getDir_costsend();
			}
			//他人が作成したメッセージを読んだ場合
			else{
				filedir	=	addr.getDir_current() + 
								addr.getDir_project()+ 
								strproject + 
								addr.getDir_costrecive();
			}
			Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(filedir +  addr.getFs() + 
																addr.getFile_cost_suffix() + read_file);
			tcd.loadXml();
    		ArrayList array_cost_detail = tcd.getArray_cost_detail();
    		
    		//新レコードの初期化
    		Struct_Cost_Detail scu = new Struct_Cost_Detail();

    		//ゼロコスト
    		Struct_Cost_Source	zero_cost = new Struct_Cost_Source();
    		zero_cost.setUnitcost(0);
    		zero_cost.setSecond(0);
    		zero_cost.setCost(0);
    		

    		//受信コストの計算
	    	Struct_Cost_Source	recieve_cost = new Struct_Cost_Source();
	    	recieve_cost.setUnitcost(su.getUnit_cost());
    		recieve_cost.setSecond(timecount.getInterval_date()/1000);
    		recieve_cost.Calculate();

    		scu.setSender(send_fullname);								// 1.差出人
    		scu.setUserid(send_userid);									// 2.(差出人)USERID
    		
	    	//送信日付
	    	long nowtime = System.currentTimeMillis();
    		
			//本人が作成したメッセージを読んだ場合
			if(send_userid.equals(su.getUserid())){
		    	scu.setSend_number(0);									// 3.ＮＯ <- ゼロ
			}
			//他人が作成したメッセージを読んだ場合
			else{
		    	//最終システム送信番号１ＵＰ
				su.Last_system_send_number_CountUp();
				user_info.setStruct_User(su);
				user_info.saveXml();
	    		scu.setSend_number(su.getLast_system_send_number());	// 3.ＮＯ <- システム送信ナンバー
			}
    		
    		scu.setGeneration_date(nowtime);						// 4.発生日時
    		scu.setGeneration_node(su.getNode());					// 5.発生ノード
    		scu.setGeneration_userid(su.getUserid());				// 6.発生ユーザーＩＤ
    		scu.setGeneration_puroject(strproject);					// 7.発生プロジェクト
    		scu.setGeneration_community(strcommunity);				// 8.発生コミュニティ	
    		scu.setTime_count(timecount);							// 9.計測時間
    		

    		//評価あり
    		if(eval_switch == true){
        		//一人当たりの送信コストを計算
        		Double sendcost_per_one = (double)Integer.valueOf(this.send_cost).intValue() / recievecount;
        		//評価額の計算 送信コスト　×　評価　÷　送信人数
        		int eval =(int) ((double)Integer.valueOf(this.send_cost).intValue() * eval_weight / recievecount);

    	    	//送信コストの計算
        		Struct_Cost_Source	send_cost = new Struct_Cost_Source();
        		send_cost.setUnitcost(0);
        		send_cost.setSecond(0);
        		send_cost.setCost(sendcost_per_one);

        		scu.setSend_cost(send_cost);										//10.送信コスト
        		scu.setRecieve_cost(recieve_cost);									//11.受信コスト	
        		scu.setTotal_cost(send_cost.getCost() + recieve_cost.getCost());	//12.総コスト

        		scu.setEval_value(eval);										//13.評価額
    		}
    		//評価なし
    		else{
        		scu.setSend_cost(zero_cost);									//10.送信コスト
        		scu.setRecieve_cost(recieve_cost);								//11.受信コスト	
        		scu.setTotal_cost(recieve_cost.getCost());						//12.総コスト
        		scu.setEval_value(0);											//13.評価額
    		}
    		scu.setAtvalue_cost(scu.getTotal_cost() - scu.getEval_value());		//14.評価後コスト 
    		scu.setSend_number_original(send_number);							//15.（差出人）送信ナンバー
    		
    		//コスト明細の先頭に追加
    		array_cost_detail.add(0, scu);

    		//コスト明細の更新
    		tcd.setArray_cost_detail(array_cost_detail);
    		tcd.saveXml();

    		//********************************************************
   	    	//* コスト再計算
   	    	//********************************************************

    		Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(array_cost_detail);
    		tcdc.Caluculate();
    		
    		
    		//********************************************************
   	    	//* コストダイジェスト 更新
   	    	//********************************************************
    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (filedir +  addr.getFs()  +
																addr.getFile_cost_digest());
    		tt.loadXml();

    		//更新データの取得
    		int index = tt.getLine(send_number);
    		Struct_Cost_Digest scd = tt.getdata(index);
    		
	    	//送信コストの再設定
    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
    		scd.setSend_cost(send_cost_bar);										// 4.送信コスト
    		
	    	//受信コストの再設定
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
    		scd.setRecieve_cost(recieve_cost_bar);									// 5.受信コスト	

    		
	    	//総コストの再設定
    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
    		scd.setTotal_cost(total_cost_bar);										// 6.総コスト
    		
	    	//評価額の再設定
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
    		scd.setEval_value(eval_value_cost_bar);									// 7.評価額	

	    	//評価後コストの再設定
    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
    		scd.setAteval_cost(ateval_cost_bar);									// 8.評価後コスト	
    		
    		tt.replaceData(index, scd);
    		tt.saveXml();
    		
   			logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end ");
				
			//他人が作成したメッセージを読んだ場合は
			//１．送信バッファに送る
			//２．レシーブコストに更新する
			if(send_userid.equals(su.getUserid()) == false){

	   	    	//********************************************************
	   	    	//* コスト明細 を送信バッファに作成
	   	    	//********************************************************
	    		//送信時は、送信コストはゼロ
	   			scu.setSend_cost(zero_cost);									//10.送信コスト
        		scu.setTotal_cost(recieve_cost.getCost());						//12.総コスト
        		scu.setAtvalue_cost(scu.getTotal_cost() - scu.getEval_value());	//14.評価後コスト 
	    		
	    		//コスト明細レコードの追加
	    		array_cost_detail = new ArrayList();
	    		array_cost_detail.add(scu);
	    		
	   	    	//送信日付のフォーマット変換
	   	    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
	   	    	//送信番号のフォーマット変換
	   	    	DecimalFormat df = new DecimalFormat("00000");

	   	    	
	   	    	String dir 		= addr.getDir_current() + addr.getDir_buff_send();
	   	    	String filename = addr.getFile_cost_suffix() + 
	   	    						dfm.format(nowtime) + "_" 	+
	   	    						df.format(su.getLast_system_send_number()) + "_" + 	
	   	    						su.getUserid()		+ ".txt";
	    		
	    		tcd= new Tool_Cost_Detail_IO(dir + filename);
	    		tcd.setArray_cost_detail(array_cost_detail);
	    		tcd.saveXml();

	   	    	//********************************************************
	   	    	//* コスト送信指示リスト を送信バッファに作成
	   	    	//********************************************************
	    		Struct_Cost_SendList scs = new  Struct_Cost_SendList();
	    		
	    		scs.setSource_node(su.getNode());			// 1.送信元NODE
	    		scs.setSource_user(su.getUserid());			// 2.送信元USERID
	    		scs.setSource_project(node_project);		// 3.送信元プロジェクト
	    		scs.setSource_community(node_community);	// 4.送信元コミュニティ
	    		scs.setTarget_node(send_node);				// 5.送信先NODE
	    		scs.setTarget_user(send_userid);			// 6.送信先USERID
	    		scs.setTarget_project(send_project);		// 7.送信先プロジェクト
	    		scs.setTarget_community(send_community);	// 8.送信先コミュニティ
	    		scs.setSendnumber(send_number);				// 9.送信ナンバー
	    		scs.setFilename(filename);					//10.送信ファイル名称
	    		scs.setSource_filename(read_file);			//11.送信元メッセージのファイル名称
	    		
	    		
	    		dir			=	addr.getDir_current() + addr.getDir_buff_send();
	   	    	filename	=	addr.getFile_cost_suffix()	+
	   	    					dfm.format(nowtime) + "_"	+
	   	    					df.format(su.getLast_system_send_number()) + "_" + 	
	   	    					su.getUserid()	+ 
	   	    					addr.getFile_digest();
				
				Tool_Cost_SendList_IO slm = new Tool_Cost_SendList_IO(dir + filename,scs);
				slm.saveXml();
				
    			//********************************************************
       	    	//* 未評　⇒　済評
       	    	//********************************************************
	    		if(eval_switch == true){
	       	    	Tool_Community_Diject_Status_Update tcdsu = 
	       	    		new Tool_Community_Diject_Status_Update(node_project,
	       	    												node_community,
	       	    												send_userid,
	       	    												send_number);
	       	    	tcdsu.status_change(tcdsu.getStatus_evaluated());
	    		}
	   	    	//********************************************************
	   	    	//* 送信
	   	    	//********************************************************
	    		//テストモード時は呼び出し禁止
	    		if(sysconfig.isTestmode() == false){
		    		ProcessBuilder builder = new ProcessBuilder("java", "-jar",
		    								addr.getDir_current() + addr.getPgm_client(),
		    								"--mode","target","--prefix",filename );

					try {
						Process process = builder.start();	//プロセス実行
			    		//画面消去
			    		this.setVisible(false);
						process.waitFor();					//終了待機
						process.destroy();					//プロセス終了
						if(process.exitValue() != 0){
				    		JOptionPane.showMessageDialog(this, "送信処理が失敗しました", 
				    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
						}
					} catch (IOException e1) {
						// TODO 自動生成された catch ブロック
						e1.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
					} catch (InterruptedException e1) {
						// TODO 自動生成された catch ブロック
						e1.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
					}
	    			
	    		}
	    	}
		
		
		}

		//* タイムカウント情報の出力(デバッグ用)
		debugTimeCountPrint();
				
	
	}

	
	
	

	//宛先、ＣＣ、ＢＣＣの送信先重複の調整
	//すべてのメンバーの展開後に使用
	private boolean	duplicate_delete(String word,ArrayList<Struct_Community_Menber> arrylist){

		if(arrylist == null || arrylist.size() == 0)		{
			return true;
		}
		for(int i=0 ; i<arrylist.size()-1;i++){
			Struct_Community_Menber scm1 = (Struct_Community_Menber)arrylist.get(i);
			for(int j=i+1 ; j<arrylist.size();j++){
				Struct_Community_Menber scm2 = (Struct_Community_Menber)arrylist.get(j);
				//ユーザーＩＤが等しい
				if(scm1.getUserid().equals(scm2.getUserid()) == true){
					//コミュニティが異なる場合
					if(scm1.getCommunity().equals(scm2.getCommunity()) == false){
						String[] selectvalues = {scm1.getCommunity(),scm2.getCommunity(),"送信方法を見直す"};
						int select = JOptionPane.showOptionDialog(this,
							      scm1.getUser_fullname()+"さんへの送信コミュニティが重複しています\n"+
							      scm1.getCommunity() +"　または　"+scm2.getCommunity()+"　のどちらかを選択してください", 
							      word +"の重複", 
							      JOptionPane.YES_NO_OPTION,
							      JOptionPane.QUESTION_MESSAGE,
							      null, 
							      selectvalues, 
							      selectvalues[2]
							    );
						//×ボタンまたは"送信方法を見直す"を選択した場合
						if (select == JOptionPane.CLOSED_OPTION ||
								select == 2){
							return false;
						}else{
							//前者を選択した場合
							if(select == 0){
								logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "delete"+((Struct_Community_Menber)arrylist.get(j)).getUser_fullname());
								arrylist.remove(j);			//前者を削除
								j--;						//カウンターを調整して繰り上がったデータをチェック				
								continue;
							}
							//後者を選択した場合(selectは1)
							else{
								logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "delete"+((Struct_Community_Menber)arrylist.get(i)).getUser_fullname());
								arrylist.remove(i);			//後者を削除
								i--;						//カウンターを調整して再チェック				
								break;
							}
						}
					}
					//コミュニティが同じ場合
					else{
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "delete"+((Struct_Community_Menber)arrylist.get(j)).getUser_fullname());
						arrylist.remove(j);			//前者を削除
						j--;						//カウンターを調整して繰り上がったデータをチェック				
						continue;
					}
				}
			}
			
			
		}
		
		
		return true;
	}

	//宛先、ＣＣ、ＢＣＣの送信先重複の調整
	private boolean	duplicate_Check(String word1,ArrayList<Struct_Community_Menber> arrylist1,
										String word2,ArrayList<Struct_Community_Menber> arrylist2){

		String[] selectvalues = {word1,word2,"送信方法を見直す"};
		if(arrylist1 == null || arrylist1.size() == 0)		{
			return true;
		}
		if(arrylist2 == null || arrylist2.size() == 0)		{
			return true;
		}
		for(int i=0 ; i<arrylist1.size();i++){
			Struct_Community_Menber scm1 = (Struct_Community_Menber)arrylist1.get(i);
			int found = arrylist2.indexOf(scm1);
			if(found != -1){
				int select = JOptionPane.showOptionDialog(this,
					      scm1.getUser_fullname()+"さんへの送信種類が重複しています\n"+
					      	word1 +"　または　"+word2+"　のどちらかを選択してください", 
					      "送信先の重複", 
					      JOptionPane.YES_NO_OPTION,
					      JOptionPane.QUESTION_MESSAGE,
					      null, 
					      selectvalues, 
					      selectvalues[2]
					    );
				//×ボタンまたは"送信方法を見直す"を選択した場合
				if (select == JOptionPane.CLOSED_OPTION ||
						select == 2	){
					return false;
				}else{
					//前者を選択した場合
					if(select == 0){
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "delete"+((Struct_Community_Menber)arrylist2.get(found)).getUser_fullname());
						arrylist2.remove(found);	//後者を削除
						i--;						//カウンターを調整して再チェック				
						continue;
					}
					//後者を選択した場合(selectは1)
					else{
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "delete"+((Struct_Community_Menber)arrylist1.get(i)).getUser_fullname());
						arrylist1.remove(i);		//前者を削除
						i--;						//カウンターを調整して繰り上がったデータをチェック				
						continue;
					}
				}
			}
			
		}
		
		
		return true;
	}

	private String toTextData(ArrayList<Struct_Community_Menber> arraydata){
		//０件時はナル値を返す
		if(arraydata == null || arraydata.size() == 0){
			return null;
		}
		String rtndata = new String();
		for(int i=0;i<arraydata.size();i++){
			Struct_Community_Menber scm = arraydata.get(i);
			if(i != 0){
				rtndata= rtndata +",";
			}
			rtndata= rtndata + "[" + scm.getCommunity()+"]["+scm.getUser_fullname()+"]";
			
		}
		return rtndata;
		
	}
	
	private ArrayList toArrayData(ArrayList<Struct_Community_Menber> arraydata){
		//０件時はナル値を返す
		if(arraydata == null || arraydata.size() == 0){
			return null;
		}
		ArrayList rtndata = new ArrayList();
		for(int i=0;i<arraydata.size();i++){
			Struct_Community_Menber scm = arraydata.get(i);
			rtndata.add("[" + scm.getCommunity()+"]["+scm.getUser_fullname()+"]");
			
		}
		return rtndata;
		
	}

	
	//すべてのメンバーを展開
	private void expand(ArrayList <Struct_Community_Menber> arraydata){
		//０件時はナル値を返す
		if(arraydata == null || arraydata.size() == 0){
			return;
		}
		String 	filedir			=	addr.getDir_current() + addr.getDir_project();	
		String filename = filedir +  strproject + addr.getFile_com_menber();
		Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO(filename);
		ArrayList<Struct_Community_Menber> array_Community_Menber = tcm.getdata();

    	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		
		for(int i = 0;i<arraydata.size();i++){
			
			Struct_Community_Menber scm = arraydata.get(i);
			//すべてのメンバーを見つけた場合
			if(scm.getUserid().equals("allmenber")){
				//すべてのメンバーを削除、カウンター補正
				arraydata.remove(i);
				i--;
				//展開
				for(int j = 0;j<array_Community_Menber.size();j++){
					Struct_Community_Menber scm2 = array_Community_Menber.get(j);
					if(scm2.getCommunity().equals(scm.getCommunity()) == true && 
						scm2.getUserid().equals("allmenber") == false &&
						scm2.getUserid().equals(su.getUserid()) == false){
						arraydata.add(scm2);
					}
				}
			}
		}
	}
	
	private void debugTimeCountPrint(){
		//*****************************************
		//* タイムカウント情報の出力
		//*****************************************
		DateFormat dfa = new SimpleDateFormat("yyyyMMdd_HHmmss");
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "start:"+dfa.format(timecount.getStart_date()));

		if(timecount.getEnd_date() != 0){
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "end  :"+dfa.format(timecount.getEnd_date()));
		}

		Struct_DayTime dt = new Struct_DayTime(timecount.getInterval_date()); 
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "itval    :"+ timecount.getInterval_date());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "itval day:"+ dt.getDay());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "itval hh :"+ dt.getHour());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "itval mm :"+ dt.getMinutes());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "itval ss :"+ dt.getSecond());

		dt = new Struct_DayTime(timecount.getAll_Interval_date()); 
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Aitvl    :"+ timecount.getAll_Interval_date());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Aitvl day:"+ dt.getDay());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Aitvl hh :"+ dt.getHour());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Aitvl mm :"+ dt.getMinutes());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Aitvl ss :"+ dt.getSecond());

		dt = new Struct_DayTime(timecount.getWait_date()); 
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "wait     :"+ timecount.getWait_date());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "wait  day:"+ dt.getDay());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "wait  hh :"+ dt.getHour());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "wait  mm :"+ dt.getMinutes());
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "wait  ss :"+ dt.getSecond());
		
		
	}
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}
	
}
