package mailcost_main;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import javax.swing.*;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_PanelBatchConfig extends JInternalFrame implements ItemListener, ActionListener {

	JPanel contentPane;
	
	JComboBox comboyyyymm;			//基準年月 
	Checkbox chkauto;				//自動実行使用可否

	//ユーザー情報
	Tool_User_IO user_info;
	Struct_User su;
	
	//マニュアル実行ボタン
	JButton btn_submit;
	
	
	//確定・取消ボタン
	JButton btn_OK;
	JButton btn_Cancel;

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	public Gui_PanelBatchConfig() {

			super("コスト分析の実行",true,true);
		   
			if(sysconfig.isStandardmode() == true){
				setStandard();
			}

			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				SwingUtilities.updateComponentTreeUI(this);
			} catch (Exception e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
			}		
			
			setFrameIcon(null);

			//ユーザー情報の取得
	        user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
			su = user_info.getStruct_User();

			setLocation(50, 50);
			setSize(450,300);
			
	        contentPane = (JPanel) this.getContentPane();
	        contentPane.setLayout(null);
	        
	        
	        //ラベル
	        JLabel lbl1 = new JLabel();
			lbl1.setText("自動実行");
			lbl1.setBounds(10, 10, 100, 28);
			contentPane.add(lbl1);
			
			
			chkauto = new Checkbox("　毎月１日１４時以降、起動直後に自動実行します。");
			chkauto.setBounds(20, 40, 300, 28);
			contentPane.add(chkauto);

			//ユーザー情報より取得
			if(su.isAutobatch() == true){
				chkauto.setState(true);
			}
			else{
				chkauto.setState(false);
			}

			chkauto.addItemListener(this);
			

			//ラベル
	        JLabel lbl2 = new JLabel();
			lbl2.setText("マニュアル実行");
			lbl2.setBounds(10, 80, 100, 28);
			contentPane.add(lbl2);

			//ラベル
	        JLabel lbl3 = new JLabel();
			lbl3.setText("基準年月");
			lbl3.setBounds(30, 110, 100, 28);
			contentPane.add(lbl3);

			
	    	//システム日付の取得
	    	long nowtime = System.currentTimeMillis();
	    	
   	    	//送信日付のフォーマット変換
   	    	DateFormat dfyyyy = new SimpleDateFormat("yyyy");
   	    	DateFormat dfMM = new SimpleDateFormat("MM");

   	    	String yyyy = dfyyyy.format(nowtime);
   	    	String mm = dfMM.format(nowtime);

			comboyyyymm = new JComboBox();
   	    	comboyyyymm.addItem(yyyy+mm);

   	    	//西暦年のフォーマット変換
   	    	DecimalFormat cvtyyyy = new DecimalFormat("0000");
   	    	DecimalFormat cvtmm = new DecimalFormat("00");
   	    	
   	    	
   	    	int int_yyyy = Integer.valueOf(yyyy).intValue();
   	    	int int_mm 	= Integer.valueOf(mm).intValue();
   	    	
   	    	//基準年月を過去１年分表示する
			for(int i = 0;i<12;i++){
				if(int_mm == 1){
					int_yyyy--;
					int_mm = 12;
				}
				else{
					int_mm--;
				}
				comboyyyymm.addItem(cvtyyyy.format(int_yyyy)+cvtmm.format(int_mm));
			}

			comboyyyymm.setBounds(100, 110, 70, 28);
			comboyyyymm.setSelectedItem(yyyy+mm);
			contentPane.add(comboyyyymm);
			comboyyyymm.addItemListener(this);

			//ラベル
	        JLabel lbl4 = new JLabel();
			lbl4.setText("★yyyymm");
			Font font = lbl4.getFont();
			lbl4.setFont(new Font(font.getFontName(), Font.ITALIC, font.getSize()));
			lbl4.setForeground(Color.MAGENTA);
			lbl4.setBounds(95, 140, 100, 28);
			contentPane.add(lbl4);
			
			
			//ラベル
	        JLabel lbl5 = new JLabel();
			lbl5.setText("を今すぐ");
			lbl5.setBounds(185, 110, 100, 28);
			contentPane.add(lbl5);

			//マニュアル実行ボタン
			btn_submit = new JButton("実行します");
			btn_submit.setBounds(250, 100, 100, 50);
			contentPane.add(btn_submit);
			btn_submit.addActionListener(this);	

			//確定ボタン
			btn_OK = new JButton("確定");
			btn_OK.setBounds(130, 200, 70, 50);
			contentPane.add(btn_OK);
			btn_OK.addActionListener(this);	

	        //取消ボタン
			btn_Cancel = new JButton("取消");
			btn_Cancel.setBounds(230, 200, 70, 50);
			contentPane.add(btn_Cancel);
			btn_Cancel.addActionListener(this);

			
			//画面表示
			this.setVisible(true);
		   
		   }

	public void itemStateChanged(ItemEvent e) {
		// TODO 自動生成されたメソッド・スタブ
			
		
		
	}

	public void actionPerformed(ActionEvent e) {
   		if(e.getSource() == btn_submit ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"コスト分析を実行しますか",
    				"コスト分析",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}

    		if(sysconfig.isTestmode() == false){
	    		ProcessBuilder builder;
    			if(comboyyyymm.getSelectedIndex() == 0){
    				//最新年月の場合はユーザー情報の前回実行タイムスタンプを更新する
    	    		builder = new ProcessBuilder("java", "-jar",
   	    								addr.getDir_current() + addr.getPgm_make_analysis(),
   	    								"--yyyymm",comboyyyymm.getSelectedItem().toString(),"--timestamp" );
    			}else{
        			
    	    		builder = new ProcessBuilder("java", "-jar",
   	    								addr.getDir_current() + addr.getPgm_make_analysis(),
   	    								"--yyyymm",comboyyyymm.getSelectedItem().toString());
    			}
    			

				try {
					Process process = builder.start();	//プロセス実行
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					if(process.exitValue() == 0){
			    		JOptionPane.showMessageDialog(this, "コスト分析を実施しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
					else{
			    		JOptionPane.showMessageDialog(this, "コスト分析が失敗しました", 
			    				"メッセージ", JOptionPane.INFORMATION_MESSAGE); 
					}
				} catch (IOException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				} catch (InterruptedException e1) {
					// TODO 自動生成された catch ブロック
					e1.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				}
    			
    		}
    		
    		
   		}
   		else if(e.getSource() == btn_OK ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"自動実行設定を変更しますか？",
    				"自動実行設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}

    		if(chkauto.getState() == true){
    			su.setAutobatch(true);
    		}
    		else{
    			su.setAutobatch(false);
    		}
    		user_info.setStruct_User(su);
    		user_info.saveXml();
    		JOptionPane.showMessageDialog(this, "ユーザー設定を変更しました", 
    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}

   		}
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}
		
	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}



}
