package mailcost_main;


import java.awt.event.*;
import java.beans.PropertyVetoException;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;

import structure.File_and_Directory_Address;
import structure.Struct_JCheckBox;
import structure.Struct_System_Config;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_JList_IO;
import tool.Tool_JTree_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;



public class Gui_PanelCommunity extends JInternalFrame implements ActionListener{

	private JPanel contentPane;
	private JScrollPane src;

	private JTable table = new JTable();	//参加プロジェクトの表示
	
    private Tool_JList_IO tls;
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	private ArrayList arrayproject = new ArrayList();
	private ArrayList arraycommunity = new ArrayList();
	private ArrayList deleteproject = new ArrayList();
	private ArrayList deletecommunity = new ArrayList();
	

	private JButton btn_OK;
	private JButton btn_Cancel;
	

	//画面表示なし
	public Gui_PanelCommunity(String parm){
		//プロジェクトの選択
		String 	projectfilename	= addr.getDir_current() + addr.getFile_project_info();
//		Tool_JTable_IO t = new Tool_JTable_IO(projectfilename);
//		String[] projectdata= t.loadXml2();

		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(projectfilename);
		t.loadXml();
		
		String[] projectdata= t.getProjectData();
		
		
	}
	
	
	//画面表示あり
	public Gui_PanelCommunity(){
		super("コミュニティの削除",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
		}		
		
		setFrameIcon(null);
		
		setLocation(50, 50);
		setSize(470,280);
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);
        
        //ラベル
        JLabel lbl1 = new JLabel();
		lbl1.setText("削除候補のコミュニティ");
		lbl1.setBounds(10, 10, 300, 28);
		contentPane.add(lbl1);   

		
		
		//ルートノードの作成
		Tool_JTree_IO t = new Tool_JTree_IO(addr.getDir_current() + addr.getFile_windowlist());
		t.loadXml();
        DefaultTreeModel model;
		model = t.getDefaultTreeModel();
		
		JTree tree = new JTree(model);
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();

		DefaultMutableTreeNode node = root;
		node = node.getNextNode();
		while(true){
			if(node == null){
				break;
			}
			String project = (String) node.getUserObject();
			DefaultMutableTreeNode dummy = (DefaultMutableTreeNode) node.getFirstChild();
			if(dummy.getUserObject().equals("Community")){
				//万が一、コミュニティノードにコミュニティが存在しない場合
				//次のプロジェクトにスキップする
				if(dummy.getChildCount() == 0){
					continue;
				}
				//*参加コミュニティの取得
				tls = new Tool_JList_IO(addr.getDir_current() + addr.getDir_project()+project + addr.getFile_com_select());	
				String[] comary =  tls.loadXml2();
				Enumeration e = dummy.children();
				while(e.hasMoreElements()){
					DefaultMutableTreeNode comnode = (DefaultMutableTreeNode) e.nextElement();
	    			boolean found = false;
	    			//コミュニティ参加中かを検索
	    			for(int i=0;i<comary.length;i++){
	    				if(comnode.getUserObject().toString().equals(comary[i])){
	    					found = true;
	    					break;
	    				}
	    			}
	    			//非参加の場合
	    			if(found == false){
	    				arrayproject.add(project);
	    				arraycommunity.add(comnode.getUserObject());
	    			}
				}
			}
			node = node.getNextSibling();
		}
		

		
        //確定ボタン
		btn_OK = new JButton("確定");
		btn_OK.setBounds(130, 170, 70, 50);
		contentPane.add(btn_OK);
		btn_OK.addActionListener(this);	

        //取消ボタン
		btn_Cancel = new JButton("取消");
		btn_Cancel.setBounds(260, 170, 70, 50);
		contentPane.add(btn_Cancel);
		btn_Cancel.addActionListener(this);	
		
		
		
		if(arrayproject.size() == 0){
            JLabel lbl2 = new JLabel();
    		lbl2.setText("削除可能なコミュニティはありません");
    		lbl2.setBounds(30, 40, 400,100);
    		contentPane.add(lbl2);   
    		btn_OK.setEnabled(false);
		}else{
			Object[][] Objdata = getTableObj(arrayproject,arraycommunity);
			
			String[] data = new String[3];
			data[0]	=	"<html><Center>" + "削除" + "</Center></html>";	
			data[1]	=	"プロジェクト";			
			data[2]	=	"コミュイニティ";			

			DefaultTableModel tableModel = new DefaultTableModel(Objdata ,data);				
			
			table.setModel(tableModel);		
			table.setRowSelectionAllowed(true);
			table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 

			//カラム表示設定
			table_Config(table);
		   	
			//プロジェクトを表示
			src = new JScrollPane(table);
			src.setBounds(30, 40, 400, 100);
			contentPane.add(src);			
		}
		

		
		this.setVisible(true);


	}
	
	public void actionPerformed(ActionEvent e) {
		// TODO 自動生成されたメソッド・スタブ
	    String answer = e.getActionCommand();
   		//確定ボタン
   		if(e.getSource() == btn_OK ){
   			boolean delete = false;
   			for(int i=0;i<table.getRowCount();i++){
   				Object obj = table.getValueAt(i, 0);
   				if(obj instanceof Boolean &&
   						(Boolean)obj == true){
   					delete = true;
   					break;
   				}
   			}
   			if(delete == false){
   	    		JOptionPane.showMessageDialog(this, "削除チェックがありません", 
   	    				"コミュニティの削除", JOptionPane.INFORMATION_MESSAGE); 
   	    		return;
   			}
   			
   			for(int i=0;i<table.getRowCount();i++){
   				Object obj = table.getValueAt(i, 0);
   				if(obj instanceof Boolean &&
   						(Boolean)obj == true){
					String[] selectvalues = {"削除","キャンセル"};
					int select = JOptionPane.showOptionDialog(this,
							"["+table.getValueAt(i, 1)+"]["+table.getValueAt(i, 2)+"]コミュニティを削除してよろしいですか？\n"+
						      "（削除後は蓄積したメールとコストを復元できません）", 
						      "コミュニティの削除", 
						      JOptionPane.YES_NO_OPTION,
						      JOptionPane.QUESTION_MESSAGE,
						      null, 
						      selectvalues, 
						      selectvalues[1]
						    );
					//削除を選択した場合
					if (select == 0){
	   					//コミュニティディレクトリ作成
	   	   		    	String strdir = addr.getDir_current() + addr.getDir_project() +
	   	   		    					table.getValueAt(i, 1) + addr.getFs() + table.getValueAt(i, 2);
	   	   		    	//念のため、過去のディレクトリを消す
	   	   		    	Tool_DirDel dirdel = new Tool_DirDel(strdir);
	   	   		    	if(dirdel.delete() == false){
	   	   		    		JOptionPane.showInternalMessageDialog(this, "過去のコミュニティディレクトリが削除できません。", 
	   	   		    				"コミュニティの削除", JOptionPane.ERROR_MESSAGE); 
	   	   		    		return;
	   	   		    	}
	   	   		    	deleteproject.add(table.getValueAt(i, 1).toString());
	   	   		    	deletecommunity.add(table.getValueAt(i, 2).toString());
					}
   				}
   			}
	    	
	    
    		JOptionPane.showMessageDialog(this, "コミュニティを確定しました", 
    				"コミュニティの削除", JOptionPane.INFORMATION_MESSAGE); 
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}

	    }

	    //取消ボタン
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}

	    	
	    	
	    	
	    }
		
	}

	
	//フォームのクローズ時
	public void doDefaultCloseAction() {
		super.doDefaultCloseAction();

	}

	//最新のコミュニティを返す
	public ArrayList getCommunity(String project){
		ArrayList arrycommunity = new ArrayList();		

		tls = new Tool_JList_IO(addr.getDir_current() + addr.getDir_project()+project + addr.getFile_com_select());	
   		tls.loadXml();
		String[] comary =  tls.loadXml2();
		
		for(int i=0;i<comary.length	;i++){
			arrycommunity.add(comary[i]);
		}
		return arrycommunity;
	}

	
	
	public Object[][] getTableObj(ArrayList project,ArrayList community){
		
		Object[][] rtnobj = new Object[project.size()][3];

		for(int i = 0;i<project.size();i++){
			
			rtnobj[i][0] = new Struct_JCheckBox(false);
			rtnobj[i][1] = project.get(i);
			rtnobj[i][2] = community.get(i);
		}
			
		return rtnobj ;
	}	

	private void table_Config(JTable table){
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);

		TableColumn col;
	   	
	   	//******************************
	   	//* チェックボックスの設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(0);
	   	Struct_JCheckBox sjcb = new Struct_JCheckBox();
		col.setCellRenderer(sjcb);
		col.setCellEditor(new DefaultCellEditor(sjcb));
		col.setPreferredWidth(50);
		col.setMaxWidth(100);
	}
		
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}


	public ArrayList getDeletecommunity() {
		return deletecommunity;
	}


	public ArrayList getDeleteproject() {
		return deleteproject;
	}	

	
}
