package mailcost_main;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.*;
import java.util.ArrayList;

import javax.swing.*;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Cost_Analysis_Digest_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_Numeric_InputKey_check;
import tool.Tool_Numeric_check;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_PanelCostAnalysis  extends JInternalFrame implements ActionListener, FocusListener{

	JPanel contentPane;

	//ユーザー情報
	Tool_User_IO user_info;
	Struct_User su;

	//書き込み
	JFormattedTextField write_time;		//時間
	JLabel lbl_write_maxcost;			//コスト

	//読み取り
	JFormattedTextField read_time;		//時間
	JLabel lbl_read_maxcost;			//コスト

	//実コスト
	JFormattedTextField real_time;		//時間
	JLabel lbl_real_maxcost;			//コスト

	//評価されたコスト
	JFormattedTextField my_eval_time;	//時間
	JLabel lbl_my_eval_maxcost;			//コスト

	//評価したコスト
	JFormattedTextField other_eval_time;	//時間
	JLabel lbl_other_eval_maxcost;			//コスト
	
	//貢献コスト
	JFormattedTextField cont_time;		//時間
	JLabel lbl_cont_maxcost;			//コスト

	//総合コスト
	JFormattedTextField total_time;		//時間
	JLabel lbl_total_maxcost;			//コスト
	
	//確定・取消ボタン
	JButton btn_OK;
	JButton btn_Cancel;

	DecimalFormat fmtnumber = new DecimalFormat("###,###");

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Gui_PanelCostAnalysis() {

		super("コスト分析設定",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
		}		
		
		setFrameIcon(null);
		
		setLocation(50, 10);
		setSize(500,390);
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);

		user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		su = user_info.getStruct_User();
        


		//*****************************
		//* 表示の補助
		//*****************************
		//右側の余白を大きくする
		Insets insets = new Insets(new JFormattedTextField().getMargin().top,
						new JFormattedTextField().getMargin().left,
						new JFormattedTextField().getMargin().bottom,
						5);
		
		
		
		//*****************************
		//* 題目
		//*****************************

		//ラベル
        JLabel lbl1 = new JLabel();
		lbl1.setText("最大表示コスト");
		lbl1.setBounds(350, 10, 100, 28);
		contentPane.add(lbl1);
		
		//*****************************
		//* 書き込みコスト
		//*****************************
		
		//ラベル
        JLabel lbl2 = new JLabel();
		lbl2.setText("（Ａ）書き込みコスト");
		lbl2.setBounds(10, 40, 150, 28);
		contentPane.add(lbl2);

		//時間の設定
		write_time = new JFormattedTextField ();
		write_time.setBounds(200, 40, 70, 28);
		
		//入力チェック
		DecimalFormat dfw = new DecimalFormat("#0.00");
		Tool_Numeric_InputKey_check nc = new Tool_Numeric_InputKey_check();

		write_time.setDocument(nc);								//入力キー制限
		write_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		write_time.setText(dfw.format(su.getWrite_maxtime()));	//既に設定した値
		write_time.setHorizontalAlignment(JLabel.RIGHT);		//右寄せ
		write_time.setMargin(insets);							//右余白
		write_time.addFocusListener(this);
		contentPane.add(write_time);

		
		
		
		//ラベル
        JLabel lbl3 = new JLabel();
		lbl3.setText("時間");
		lbl3.setBounds(280, 40, 40, 28);
		contentPane.add(lbl3);
		
		//コスト
        lbl_write_maxcost = new JLabel();
		lbl_write_maxcost.setText(maxcost_Cal(write_time,60*60));
		lbl_write_maxcost.setBounds(330, 40, 80, 28);
		lbl_write_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_write_maxcost);
		
		//ラベル
        JLabel lbl4 = new JLabel();
		lbl4.setText("円");
		lbl4.setBounds(430, 40, 40, 28);
		contentPane.add(lbl4);
		

		
		//*****************************
		//* 読み取りコスト
		//*****************************
		
		//ラベル
        JLabel lbl5 = new JLabel();
		lbl5.setText("（Ｂ）読み取りコスト");
		lbl5.setBounds(10, 70, 150, 28);
		contentPane.add(lbl5);

		//入力チェック ※排除禁止
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();

		//時間の設定
		read_time = new JFormattedTextField ();
		read_time.setBounds(200, 70, 70, 28);
		
		read_time.setDocument(nc);								//入力キー制限
		read_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		read_time.setText(dfw.format(su.getRead_maxtime()));	//既に設定した値
		read_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		read_time.setMargin(insets);							//右余白
		read_time.addFocusListener(this);
		contentPane.add(read_time);
        
		//ラベル
        JLabel lbl6 = new JLabel();
		lbl6.setText("時間");
		lbl6.setBounds(280, 70, 40, 28);
		contentPane.add(lbl6);

		//コスト
        lbl_read_maxcost = new JLabel();
		lbl_read_maxcost.setText(maxcost_Cal(read_time,60*60));
		lbl_read_maxcost.setBounds(330, 70, 80, 28);
		lbl_read_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_read_maxcost);
		
		//ラベル
        JLabel lbl7 = new JLabel();
		lbl7.setText("円");
		lbl7.setBounds(430, 70, 40, 28);
		contentPane.add(lbl7);
		

		
		//*****************************
		//* 実コスト
		//*****************************
		
		//ラベル
        JLabel lbl8 = new JLabel();
		lbl8.setText("（Ｃ）総コスト");
		lbl8.setBounds(10, 100, 150, 28);
		contentPane.add(lbl8);

		//入力チェック
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();

		//時間の設定
		real_time = new JFormattedTextField ();
		real_time.setBounds(200, 100, 70, 28);
		
		real_time.setDocument(nc);								//入力キー制限
		real_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		real_time.setText(dfw.format(su.getReal_maxtime()));	//既に設定した値
		real_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		real_time.setMargin(insets);								//右余白
		real_time.addFocusListener(this);
		contentPane.add(real_time);
        
		//ラベル
        JLabel lbl9 = new JLabel();
		lbl9.setText("時間");
		lbl9.setBounds(280, 100, 40, 28);
		contentPane.add(lbl9);

		//コスト
        lbl_real_maxcost = new JLabel();
		lbl_real_maxcost.setText(maxcost_Cal(real_time,60*60));
		lbl_real_maxcost.setBounds(330, 100, 80, 28);
		lbl_real_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_real_maxcost);
		
		//ラベル
        JLabel lbl10 = new JLabel();
		lbl10.setText("円");
		lbl10.setBounds(430, 100, 40, 28);
		contentPane.add(lbl10);
		

		//*****************************
		//* 評価されたコスト
		//*****************************
		
		//ラベル
        JLabel lbl11 = new JLabel();
		lbl11.setText("（Ｄ）自分を評価したコスト");
		lbl11.setBounds(10, 140, 180, 28);
		contentPane.add(lbl11);

		//入力チェック
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		
		//時間の設定
		my_eval_time = new JFormattedTextField ();
		my_eval_time.setBounds(200, 140, 70, 28);
		
		my_eval_time.setDocument(nc);								//入力キー制限
		my_eval_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		my_eval_time.setText(dfw.format(su.getMy_eval_maxtime()));	//既に設定した値
		my_eval_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		my_eval_time.setMargin(insets);								//右余白
		my_eval_time.addFocusListener(this);
		contentPane.add(my_eval_time);
        
		//ラベル
        JLabel lbl12 = new JLabel();
		lbl12.setText("時間");
		lbl12.setBounds(280, 140, 40, 28);
		contentPane.add(lbl12);

		//コスト
        lbl_my_eval_maxcost = new JLabel();
		lbl_my_eval_maxcost.setText(maxcost_Cal(my_eval_time,60*60));
		lbl_my_eval_maxcost.setBounds(330, 140, 80, 28);
		lbl_my_eval_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_my_eval_maxcost);
		
		//ラベル
        JLabel lbl13 = new JLabel();
		lbl13.setText("円");
		lbl13.setBounds(430, 140, 40, 28);
		contentPane.add(lbl13);
		
	
		//*****************************
		//* 評価したコスト
		//*****************************
		
		//ラベル
        JLabel lbl14 = new JLabel();
		lbl14.setText("（Ｅ）相手を評価したコスト");
		lbl14.setBounds(10, 170, 180, 28);
		contentPane.add(lbl14);

		//入力チェック
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();

		//時間の設定
		other_eval_time = new JFormattedTextField ();
		other_eval_time.setBounds(200, 170, 70, 28);
		
		other_eval_time.setDocument(nc);								//入力キー制限
		other_eval_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		other_eval_time.setText(dfw.format(su.getOther_eval_maxtime()));	//既に設定した値
		other_eval_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		other_eval_time.setMargin(insets);								//右余白
		other_eval_time.addFocusListener(this);
		contentPane.add(other_eval_time);
        
		//ラベル
        JLabel lbl15 = new JLabel();
		lbl15.setText("時間");
		lbl15.setBounds(280, 170, 40, 28);
		contentPane.add(lbl15);

		//コスト
        lbl_other_eval_maxcost = new JLabel();
		lbl_other_eval_maxcost.setText(maxcost_Cal(other_eval_time,60*60));
		lbl_other_eval_maxcost.setBounds(330, 170, 80, 28);
		lbl_other_eval_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_other_eval_maxcost);
		
		//ラベル
        JLabel lbl16 = new JLabel();
		lbl16.setText("円");
		lbl16.setBounds(430, 170, 40, 28);
		contentPane.add(lbl16);		


		//*****************************
		//* 貢献コスト
		//*****************************
		
		//ラベル
        JLabel lbl17 = new JLabel();
		lbl17.setText("（Ｆ）貢献コスト");
		lbl17.setBounds(10, 200, 150, 28);
		contentPane.add(lbl17);

		//入力チェック
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();

		//時間の設定
		cont_time = new JFormattedTextField ();
		cont_time.setBounds(200, 200, 70, 28);
		
		cont_time.setDocument(nc);								//入力キー制限
		cont_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		cont_time.setText(dfw.format(su.getCont_maxtime()));	//既に設定した値
		cont_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		cont_time.setMargin(insets);							//右余白
		cont_time.addFocusListener(this);
		contentPane.add(cont_time);
        
		//ラベル
        JLabel lbl18 = new JLabel();
		lbl18.setText("時間");
		lbl18.setBounds(280, 200, 40, 28);
		contentPane.add(lbl18);

		//コスト
        lbl_cont_maxcost = new JLabel();
		lbl_cont_maxcost.setText(maxcost_Cal(cont_time,60*60));
		lbl_cont_maxcost.setBounds(330, 200, 80, 28);
		lbl_cont_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_cont_maxcost);
		
		//ラベル
        JLabel lbl19 = new JLabel();
		lbl19.setText("円");
		lbl19.setBounds(430, 200, 40, 28);
		contentPane.add(lbl19);	

		
		//*****************************
		//* 総合コスト
		//*****************************
		
		//ラベル
        JLabel lbl20 = new JLabel();
		lbl20.setText("（Ｇ）貢献後コスト");
		lbl20.setBounds(10, 240, 150, 28);
		contentPane.add(lbl20);

		//入力チェック
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();

		//時間の設定
		total_time = new JFormattedTextField ();
		total_time.setBounds(200, 240, 70, 28);
		
		total_time.setDocument(nc);								//入力キー制限
		total_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		total_time.setText(dfw.format(su.getTotal_maxtime()));	//既に設定した値
		total_time.setHorizontalAlignment(JLabel.RIGHT);		//右寄せ
		total_time.setMargin(insets);							//右余白
		total_time.addFocusListener(this);
		contentPane.add(total_time);
        
		//ラベル
        JLabel lbl21 = new JLabel();
		lbl21.setText("時間");
		lbl21.setBounds(280, 240, 40, 28);
		contentPane.add(lbl21);

		//コスト
        lbl_total_maxcost = new JLabel();
		lbl_total_maxcost.setText(maxcost_Cal(total_time,60*60));
		lbl_total_maxcost.setBounds(330, 240, 80, 28);
		lbl_total_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_total_maxcost);
		
		//ラベル
        JLabel lbl22 = new JLabel();
		lbl22.setText("円");
		lbl22.setBounds(430, 240, 40, 28);
		contentPane.add(lbl22);			

		
		
		//*****************************
		//* ボタン
		//*****************************

		//確定ボタン
		btn_OK = new JButton("確定");
		btn_OK.setBounds(160, 290, 70, 50);
		contentPane.add(btn_OK);
		btn_OK.addActionListener(this);	

        //取消ボタン
		btn_Cancel = new JButton("取消");
		btn_Cancel.setBounds(260, 290, 70, 50);
		contentPane.add(btn_Cancel);
		btn_Cancel.addActionListener(this);
		

		//画面表示
		this.setVisible(true);
	}
	
	private String maxcost_Cal(JFormattedTextField time,double adjust){
		//テキスト抽出
		NumberFormat StringToDouble = NumberFormat.getInstance();
		Double second;
		try {
			second = StringToDouble.parse(time.getText()).doubleValue();
		} catch (ParseException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
	    	second = 0.0;
		}
			
		//コスト算出　
		Double cost = su.getUnit_cost() * second * adjust;
		
		BigDecimal bd = new BigDecimal(String.valueOf(cost));
		cost = bd.setScale(0, BigDecimal.ROUND_HALF_UP) .doubleValue();
		DecimalFormat dfuc = new DecimalFormat("#,###,##0");
		return dfuc.format(cost);
	}
	
	private int maxcost_Cal_int(JFormattedTextField time,double adjust){
		//テキスト抽出
		NumberFormat StringToDouble = NumberFormat.getInstance();
		Double second;
		try {
			second = StringToDouble.parse(time.getText()).doubleValue();
		} catch (ParseException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
	    	second = 0.0;
		}
			
		//コスト算出　
		Double cost = su.getUnit_cost() * second * adjust;
		
		return cost.intValue();
	}

	
	static class maxtimeVerifier extends InputVerifier{
		public boolean verify(JComponent input){
			boolean flg = true;
			JFormattedTextField f = (JFormattedTextField)input;
			String s = f.getText();
	
			//入力フィールドのニューメリックチェック
			Tool_Numeric_check tnc = new Tool_Numeric_check(s);
			tnc.setInteger_digit((byte) 3);		//整数３桁
			tnc.setDecimal_digit((byte) 2);		//少数２桁
			tnc.setMinvalue(1);					//最小値1
			tnc.setMaxvalue(999);				//最大値999
			
			String msg = tnc.floatCheck();
			if(msg  != null){
		    		JOptionPane.showMessageDialog(null, msg, 
		    				"表示レベルの最大時間", JOptionPane.WARNING_MESSAGE); 
				flg = false;
				f.setText("0.00");
				return flg;
			}
			//表示正規化
			DecimalFormat dfw = new DecimalFormat("#,##0.00");
			f.setText(dfw.format(Float.parseFloat(f.getText())));
			return flg;
		}
	}	
	
	public void actionPerformed(ActionEvent e) {
   		if(e.getSource() == btn_OK ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"コスト分析設定を変更しますか？",
    				"コスト分析設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}
			
    		
			//最大時間の設定
    		try {
    			Number num = fmtnumber.parse(write_time.getText());
    			su.setWrite_maxtime(num.doubleValue());
    			num = fmtnumber.parse(read_time.getText());
    			su.setRead_maxtime(num.doubleValue());
    			num = fmtnumber.parse(real_time.getText());
    			su.setReal_maxtime(num.doubleValue());
    			num = fmtnumber.parse(my_eval_time.getText());
    			su.setMy_eval_maxtime(num.doubleValue());
    			num = fmtnumber.parse(other_eval_time.getText());
    			su.setOther_eval_maxtime(num.doubleValue());
    			num = fmtnumber.parse(cont_time.getText());
    			su.setCont_maxtime(num.doubleValue());
    			num = fmtnumber.parse(total_time.getText());
    			su.setTotal_maxtime(num.doubleValue());
    		} catch (ParseException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
			}



    		
    		//コストの設定
    		try {
        		Number num_write_maxcost		= fmtnumber.parse(lbl_write_maxcost.getText());
    			Number num_read_maxcost			= fmtnumber.parse(lbl_read_maxcost.getText());
    			Number num_real_maxcost 		= fmtnumber.parse(lbl_real_maxcost.getText());
    			Number num_my_eval_maxcost		= fmtnumber.parse(lbl_my_eval_maxcost.getText());
    			Number num_other_eval_maxcost	= fmtnumber.parse(lbl_other_eval_maxcost.getText());
    			Number num_cont_maxcost			= fmtnumber.parse(lbl_cont_maxcost.getText());
    			Number num_total_maxcost		= fmtnumber.parse(lbl_total_maxcost.getText());
/*    			
    			if((num_write_maxcost.intValue() + num_read_maxcost.intValue())
    								> num_real_maxcost.intValue()){
       	    		JOptionPane.showMessageDialog(this, "[実コスト]は[書き込みコスト]と[読み取りコスト]の合計より大きくしてください", 
       	    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    				return;
    			}
    			if(num_real_maxcost.intValue()	> num_total_maxcost.intValue()){
			   		JOptionPane.showMessageDialog(this, "[総コスト]は[実コスト]より大きくしてください", 
			   				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
					return;
				}
*/
    			su.setWrite_maxcost(num_write_maxcost.intValue());
    			su.setRead_maxcost(num_read_maxcost.intValue());
    			su.setReal_maxcost(num_real_maxcost.intValue());
    			su.setMy_eval_maxcost(num_my_eval_maxcost.intValue());
    			su.setOther_eval_maxcost(num_other_eval_maxcost.intValue());
    			su.setCont_maxcost(num_cont_maxcost.intValue());
    			su.setTotal_maxcost(num_total_maxcost.intValue());
    			
			} catch (ParseException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
			}

    		
    		user_info.setStruct_User(su);
    		user_info.saveXml();
    		JOptionPane.showMessageDialog(this, "コスト分析設定を変更しました", 
    				"コスト分析設定", JOptionPane.INFORMATION_MESSAGE); 

   			
    		int ans2 = JOptionPane.showConfirmDialog(this, 
    				"コスト分析結果(analysis)を再作成しますか？",
    				"コスト分析設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans2 == JOptionPane.OK_OPTION){
        		make_analysis();
    		}
    		
    		
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
    		
    		
    		
   		}
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}		
	}

	//フォーカスイベント
	public void focusGained(FocusEvent arg0) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void focusLost(FocusEvent e) {
		//オプションメッセージ表示中はロストフォーカス処理しない
		if ( e.isTemporary() == true){ 
			return; 
		} 

		if( e.getSource() == write_time){
			lbl_write_maxcost.setText(maxcost_Cal(write_time,60*60));	
		}
		else if( e.getSource() == read_time){
			lbl_read_maxcost.setText(maxcost_Cal(read_time,60*60));	
		}
		else if( e.getSource() == real_time){
			lbl_real_maxcost.setText(maxcost_Cal(real_time,60*60));	
		}
		else if( e.getSource() == my_eval_time){
			lbl_my_eval_maxcost.setText(maxcost_Cal(my_eval_time,60*60));	
		}
		else if( e.getSource() == other_eval_time){
			lbl_other_eval_maxcost.setText(maxcost_Cal(other_eval_time,60*60));	
		}
		else if( e.getSource() == cont_time){
			lbl_cont_maxcost.setText(maxcost_Cal(cont_time,60*60));	
		}
		else if( e.getSource() == total_time){
			lbl_total_maxcost.setText(maxcost_Cal(total_time,60*60));	
		}
		
	}

	
	
	
	private void make_analysis(){
		
		//参加プロジェクトの取得
		Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
																addr.getFile_project_info());
		tep.loadXml();
		String[] array_project = tep.get_project();

		
		//プロジェクトのループ
		for(int i=0 ; i<array_project.length ; i++){
			//コスト分析ダイジェストを取得
			Tool_Cost_Analysis_Digest_IO t = new Tool_Cost_Analysis_Digest_IO (
											addr.getDir_current() + 
											addr.getDir_project() + 
											array_project[i] + 
											addr.getDir_costanalysis() 	 +
											addr.getFile_cost_digest());
			t.loadXml();
			ArrayList<Struct_Cost_Analysis_Digest> array_Cost_Analysis_Digest = t.getdata();
			
			for(int j=0 ; j<array_Cost_Analysis_Digest.size() ; j++){

	    		ProcessBuilder builder = new ProcessBuilder("java", "-jar",
						addr.getDir_current() + addr.getPgm_make_analysis(),
						"--project",array_project[i],
						"--yyyymm",array_Cost_Analysis_Digest.get(j).getYyyymm() );
	    		
				try {
					Process process = builder.start();	//プロセス実行
					process.waitFor();					//終了待機
					process.destroy();					//プロセス終了
					if(process.exitValue() == 0){
					}
					else{
						JOptionPane.showMessageDialog(this, "コスト分析が失敗しました", 
								"コスト分析設定", JOptionPane.INFORMATION_MESSAGE); 
						return;
					}
				} catch (IOException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				JOptionPane.showMessageDialog(this, "コスト分析が失敗しました", 
						"コスト分析設定", JOptionPane.INFORMATION_MESSAGE); 
				return;
				} catch (InterruptedException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
				JOptionPane.showMessageDialog(this, "コスト分析が失敗しました", 
						"コスト分析設定", JOptionPane.INFORMATION_MESSAGE); 
				return;
				}
				
				
			}
			
		}
		JOptionPane.showMessageDialog(this, "コスト分析を実行しました", 
				"コスト分析設定", JOptionPane.INFORMATION_MESSAGE); 
		
	}

	
	
	
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}

	
	
}
