package mailcost_main;

import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;

import javax.swing.*;

import structure.File_and_Directory_Address;
import structure.Struct_Eval_Rank;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Eval_Rank_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_PanelEval extends JInternalFrame implements ActionListener {

	JPanel contentPane;
	
	Tool_Eval_Rank_IO eval_rank;
	Struct_Eval_Rank ser;

	
	Tool_User_IO user_info;
	Struct_User su;
	
	JRadioButton rbtn_level_5;
	JRadioButton rbtn_level_4;
	JRadioButton rbtn_level_3;
	JRadioButton rbtn_level_2;
	JRadioButton rbtn_level_1;
	JRadioButton rbtn_level_0;

	String level5	=	"5";
	String level4	=	"4";
	String level3	=	"3";
	String level2	=	"2";
	String level1	=	"1";
	String level0	=	"0";
	
	
	JButton btn_OK;
	JButton btn_Cancel;
	
	DecimalFormat df = new DecimalFormat("0.0");

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
												addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Gui_PanelEval() {

			super("デフォルト評価設定",true,true);

			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				SwingUtilities.updateComponentTreeUI(this);
			} catch (Exception e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
			}		
			
			setFrameIcon(null);
			
			setLocation(50, 50);
			setSize(500,350);
		   
			eval_rank = new Tool_Eval_Rank_IO(addr.getDir_current() + addr.getFile_eval_rank());
			
			user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
			su = user_info.getStruct_User();
			
			
			
	        contentPane = (JPanel) this.getContentPane();
	        contentPane.setLayout(null);
	        
	        
	        //ラベル
	        JLabel lbl1 = new JLabel();
			lbl1.setText("デフォルト評価");
			lbl1.setBounds(10, 10, 100, 28);
			contentPane.add(lbl1);
			
			//ラジオボタン　レベル５
			ser = eval_rank.getStruct_Eval_Rank(level5);
			rbtn_level_5 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_5.setBounds(10, 50, 450, 28);
			contentPane.add(rbtn_level_5);

			//ラジオボタン　レベル４
			ser = eval_rank.getStruct_Eval_Rank(level4);
			rbtn_level_4 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_4.setBounds(10, 80, 450, 28);
			contentPane.add(rbtn_level_4);

			//ラジオボタン　レベル３
			ser = eval_rank.getStruct_Eval_Rank(level3);
			rbtn_level_3 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_3.setBounds(10, 110, 450, 28);
			contentPane.add(rbtn_level_3);
			
			//ラジオボタン　レベル２
			ser = eval_rank.getStruct_Eval_Rank(level2);
			rbtn_level_2 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_2.setBounds(10, 140, 450, 28);
			contentPane.add(rbtn_level_2);

			//ラジオボタン　レベル１
			ser = eval_rank.getStruct_Eval_Rank(level1);
			rbtn_level_1 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_1.setBounds(10, 170, 450, 28);
			contentPane.add(rbtn_level_1);

			//ラジオボタン　レベル０
			ser = eval_rank.getStruct_Eval_Rank(level0);
			rbtn_level_0 	= new JRadioButton("×"+ df.format( ser.getEval_weight()) + " "+  ser.getEval_sentence(), true);
			rbtn_level_0.setBounds(10, 200, 450, 28);
			contentPane.add(rbtn_level_0);

			//ラジオボタン　グループ
			ButtonGroup group_warning = new ButtonGroup();
			group_warning.add(rbtn_level_5); 
			group_warning.add(rbtn_level_4);
			group_warning.add(rbtn_level_3); 
			group_warning.add(rbtn_level_2); 	
			group_warning.add(rbtn_level_1); 	
			group_warning.add(rbtn_level_0); 	

			
			if(su.getEval_rank().equals(level5)){
				rbtn_level_5.setSelected( true);
			}
			else if(su.getEval_rank().equals(level4)){
				rbtn_level_4.setSelected( true);
			}
			else if(su.getEval_rank().equals(level3)){
				rbtn_level_3.setSelected( true);
			}
			else if(su.getEval_rank().equals(level2)){
				rbtn_level_2.setSelected( true);
			}
			else if(su.getEval_rank().equals(level1)){
				rbtn_level_1.setSelected( true);
			}
			else if(su.getEval_rank().equals(level0)){
				rbtn_level_0.setSelected( true);
			}
			
	        //確定ボタン
			btn_OK = new JButton("確定");
			btn_OK.setBounds(150, 250, 70, 50);
			contentPane.add(btn_OK);
			btn_OK.addActionListener(this);	

	        //取消ボタン
			btn_Cancel = new JButton("取消");
			btn_Cancel.setBounds(250, 250, 70, 50);
			contentPane.add(btn_Cancel);
			btn_Cancel.addActionListener(this);

			
			//画面表示
			this.setVisible(true);
		   
		   }

	public void actionPerformed(ActionEvent e) {
   		if(e.getSource() == btn_OK ){
   			System.out.println("OK");
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"デフォルト評価を変更しますか？",
    				"デフォルト評価設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}
    		
    		if(rbtn_level_5.isSelected() == true){
       			su.setEval_rank(level5);
    		}
    		else if(rbtn_level_4.isSelected() == true){
       			su.setEval_rank(level4);
    		}
    		else if(rbtn_level_3.isSelected() == true){
       			su.setEval_rank(level3);
    		}
    		else if(rbtn_level_2.isSelected() == true){
       			su.setEval_rank(level2);
    		}
    		else if(rbtn_level_1.isSelected() == true){
       			su.setEval_rank(level1);
    		}
    		else if(rbtn_level_0.isSelected() == true){
       			su.setEval_rank(level0);
    		}

    		user_info.saveXml();
    		JOptionPane.showMessageDialog(this, "デフォルト評価を変更しました", 
    				"デフォルト評価設定", JOptionPane.INFORMATION_MESSAGE); 
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
		
   		}	
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}

		
	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}





}
