package mailcost_main;


import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_JCheckBox;
import structure.Struct_System_Config;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_JTree_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Gui_PanelProject extends JInternalFrame implements ActionListener{
	
	private JPanel contentPane;
    private JScrollPane src;
	private JTextField tf;					//プロジェクトの入力領域
	private JTable table = new JTable();	//参加プロジェクトの表示

	
	//ファイル＆ディレクトリ取得
    private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	private String 	projectfilepath	= addr.getDir_current() + addr.getFile_project_info();
	
	//確定・取消ボタン
	private JButton btn_OK;
	private JButton btn_Cancel;
	
	//画面表示なし
	public Gui_PanelProject(String parm){
/*
		t = new Tool_JTable_IO(filename);
		t.putColum(new Struct_Entry_Project().getColData_short());
		t.loadXml();
        DefaultTableModel model;
		model = t.getDefaultTableModele();
		table = new JTable(model);
*/
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		
		
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(projectfilepath);
		t.loadXml();
		Object[][] Objdata = t.getObj();
		DefaultTableModel tableModel ; 
		if(Objdata.length == 0){
			tableModel = new DefaultTableModel(new Struct_Entry_Project().getColData(),0);
		}
		else{
			tableModel = new DefaultTableModel(Objdata ,new Struct_Entry_Project().getColData());				
		}

	   	table.setModel(tableModel);
	
	
	}

	//画面表示あり
	public Gui_PanelProject(){
		
		super("プロジェクトの送信停止・削除",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
		}		
		
		setFrameIcon(null);
		
		setLocation(50, 50);
		setSize(470,280);
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);

        //ラベル
        JLabel lbl1 = new JLabel();
		lbl1.setText("プロジェクト");
		lbl1.setBounds(10, 10, 300, 28);
		contentPane.add(lbl1);

        //確定ボタン
		btn_OK = new JButton("確定");
		btn_OK.setBounds(130, 170, 70, 50);
		contentPane.add(btn_OK);
		btn_OK.addActionListener(this);	

        //取消ボタン
		btn_Cancel = new JButton("取消");
		btn_Cancel.setBounds(260, 170, 70, 50);
		contentPane.add(btn_Cancel);
		btn_Cancel.addActionListener(this);	

		
		//プロジェクトのセーブデータをロード
/*
		t = new Tool_JTable_IO(filename);
		t.putColum(new Struct_Entry_Project().getColData_short());
		t.loadXml();
        DefaultTableModel model;
		model = t.getDefaultTableModele();
		table = new JTable(model);
*/		

		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(projectfilepath);
		t.loadXml();
		Object[][] Objdata = getTableObj(t.getdata());
		
		
		DefaultTableModel tableModel ; 
		
		if(Objdata.length == 0){
			tableModel = new DefaultTableModel(new Struct_Entry_Project().getColData_short2(),0);
		}
		else{
			tableModel = new DefaultTableModel(Objdata ,new Struct_Entry_Project().getColData_short2());				
		}

		table.setModel(tableModel);		
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 

		//カラム表示設定
		table_Config(table);
	   	
		//プロジェクトを表示
		src = new JScrollPane(table);
		src.setBounds(30, 40, 400, 100);
		contentPane.add(src);
		
		this.setVisible(true);
		
		
	}
	//クローズ前処理
	public void doDefaultCloseAction() {
		super.doDefaultCloseAction();
    }

	public void actionPerformed(ActionEvent e) {
	    String answer = e.getActionCommand();
   		if(e.getSource() == btn_OK ){
   			//*****************************************
   			//* プロジェクトを全部削除できないチェック
   			//*****************************************
   			boolean liveproject = false;
   			for(int i=0;i<table.getRowCount();i++){
   				Object obj = table.getValueAt(i, 1);
   				if(obj instanceof Struct_JCheckBox){
   					liveproject = true;
   					break;
   				}
   			}
   			if(liveproject == false){
   	    		JOptionPane.showMessageDialog(this, "プロジェクトをすべて消すことはできません", 
   	    				"プロジェクトの送信停止・削除", JOptionPane.INFORMATION_MESSAGE); 
   	    		return;
   			}
   			
   			//*****************************************
   			//* プロジェクトファイルの取得
   			//* windowlistファイルの取得
   			//*****************************************
   			
   			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(projectfilepath);
   			tep.loadXml();
   			ArrayList<Struct_Entry_Project> arrayproject = tep.getdata();
   			
			Tool_JTree_IO tjt = new Tool_JTree_IO(addr.getDir_current() + addr.getFile_windowlist());
			tjt.loadXml();
	        DefaultTreeModel model;
			model = tjt.getDefaultTreeModel();
			JTree tree = new JTree(model);
			DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
  			
   			
   			
			String project;
   			for(int i=0;i<table.getRowCount();i++){
   				//送信停止カラムを取得
   				Object obj = table.getValueAt(i, 0);
   				System.out.println(obj.getClass());
				project = (String) table.getValueAt(i, 2);
				//************************************************************
				//* 送信停止チェックボックスの判定
				//* チェックボックスを操作した場合、Booleanクラスとなる
				//* 操作しない場合はStruct_JCheckBoxクラスとなり処理は不要
				//************************************************************
   				//送信停止オンの場合
   				if(obj instanceof Boolean &&
   						(Boolean)obj == true){
					//windowlist更新
			    	for(int j=0;j<arrayproject.size();j++){
			    		if(arrayproject.get(j).getProject().equals(project)){
			    			arrayproject.get(j).setKill(true);
			    			break;
			    		}
			    	}
   				}
   				//送信停止オフの場合
   				else if(obj instanceof Boolean &&
   						(Boolean)obj == false){
					//windowlist更新
			    	for(int j=0;j<arrayproject.size();j++){
			    		if(arrayproject.get(j).getProject().equals(project)){
			    			arrayproject.get(j).setKill(false);
			    			break;
			    		}
			    	}
   				}

   				//削除カラムを取得
   				obj = table.getValueAt(i, 1);
   				if(obj instanceof Boolean &&
   						(Boolean)obj == true){
					String[] selectvalues = {"削除","キャンセル"};
					int select = JOptionPane.showOptionDialog(this,
							"["+table.getValueAt(i, 2)+"]プロジェクトを削除してよろしいですか？\n"+
						      "（削除後は蓄積したメールとコストを復元できません）", 
						      "プロジェクトの送信停止・削除", 
						      JOptionPane.YES_NO_OPTION,
						      JOptionPane.QUESTION_MESSAGE,
						      null, 
						      selectvalues, 
						      selectvalues[1]
						    );
					//削除を選択した場合
					if (select == 0){
					//×ボタンまたは"キャンセル"を選択した場合
//						project = (String) table.getValueAt(i, 2);
						//プロジェクトディレクトリの削除
				    	Tool_DirDel dirdel = new Tool_DirDel(addr.getDir_current() + addr.getDir_project()+project);
				    	if(dirdel.delete() == false){
				    		JOptionPane.showInternalMessageDialog(this, "過去のプロジェクトディレクトリが削除できません。", 
				    				"プロジェクトの送信停止・削除", JOptionPane.ERROR_MESSAGE); 
				    		return;
				    	}
						//プロジェクトファイルから削除
				    	for(int j=0;j<arrayproject.size();j++){
				    		if(arrayproject.get(j).getProject().equals(project)){
				    			arrayproject.remove(j);
				    			break;
				    		}
				    	}
				    	
				    	//windowlistより削除
						DefaultMutableTreeNode node = root;
						node = node.getNextNode();
						while(true){
							if(node == null){
								break;
							}
							if(project.equals(node.getUserObject())){
								root.remove(node);
							}
							node = node.getNextSibling();
						}
				    	
					}else{
						//* 処理なし
					}
   				}
   				
   			}

			//プロジェクトファイルのセーブ
   			tep.putdata(arrayproject);
   			tep.saveXml();
   			
			//windowlistファイルのセーブ
   			tjt.putJTree(tree);
   			tjt.saveXml();
	    	
    		JOptionPane.showMessageDialog(this, "プロジェクトを確定しました", 
    				"プロジェクトの送信停止・削除", JOptionPane.INFORMATION_MESSAGE); 
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
	    }
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}
	}

	//最新のプロジェクトを返す
	public ArrayList getProject(){
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(projectfilepath);
		t.loadXml();
		ArrayList arryproject = t.getArrayProject();		
		return arryproject;
	}
	

	private void table_Config(JTable table){
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);

		TableColumn col;
	   	
	   	//******************************
	   	//* チェックボックスの設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(0);
	   	Struct_JCheckBox sjcb = new Struct_JCheckBox();
		col.setCellRenderer(sjcb);
		col.setCellEditor(new DefaultCellEditor(sjcb));
		col.setPreferredWidth(50);
		col.setMaxWidth(100);

		col = table.getColumnModel().getColumn(1);
	   	sjcb = new Struct_JCheckBox();
		col.setCellRenderer(sjcb);
		col.setCellEditor(new DefaultCellEditor(sjcb));
		col.setPreferredWidth(50);
		col.setMaxWidth(100);
/*		
	   	col = table.getColumnModel().getColumn(0);
	   	Struct_JCheckBox sjcb = new Struct_JCheckBox();
		col.setCellRenderer(sjcb);
		col.setCellEditor(sjcb);
		col.setPreferredWidth(50);
		col.setMaxWidth(100);
	   	col = table.getColumnModel().getColumn(1);
	   	sjcb = new Struct_JCheckBox();
		col.setCellEditor(new DefaultCellEditor(sjcb));
		col.setCellRenderer(sjcb);
		col.setPreferredWidth(50);
		col.setMaxWidth(100);
*/
	}
	
	
	public Object[][] getTableObj(ArrayList<Struct_Entry_Project> data){
		Struct_Entry_Project struct_entry_project = new Struct_Entry_Project();
		
		Object[][] rtnobj = new Object[data.size()][3];

		for(int i = 0;i<data.size();i++){
			
			rtnobj[i][0] = new Struct_JCheckBox(data.get(i).isKill());
			rtnobj[i][1] = new Struct_JCheckBox(false);
//			rtnobj[i][0] = new JCheckBox("",data.get(i).isKill());
//			rtnobj[i][1] = new JCheckBox("",true);
			rtnobj[i][2] = data.get(i).getProject();
		}
			
		return rtnobj ;
	}	
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}


}
