package mailcost_main;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;

import javax.swing.*;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_Entry_Project;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Community_Menber_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_PanelSendConfig extends JInternalFrame implements ItemListener, ActionListener {

	JPanel contentPane;
	
	JRadioButton rbtn_direct;		//直接送信可否
	JRadioButton rbtn_indirect;		//間接送信可否

	JRadioButton rbtn_wait;			//直接送信オプション　使用不可
	JRadioButton rbtn_relay;		//直接送信オプション　使用可能
	
	JCheckBox chkrelay;				//直接送信オプション　間接送信可否
	JCheckBox chkserver;			//直接送信オプション　サーバ中継可否

	JComboBox cmb_project1;			//間接送信　優先順位１　プロジェクト 
	JComboBox cmb_relay1;			//間接送信　優先順位１　中継基地 
	
	JComboBox cmb_project2;			//間接送信　優先順位２　プロジェクト 
	JComboBox cmb_relay2;			//間接送信　優先順位２　中継基地 

	JComboBox cmb_project3;			//間接送信　優先順位３　プロジェクト 
	JComboBox cmb_relay3;			//間接送信　優先順位３　中継基地 
	
	JComboBox cmb_project4;			//間接送信　優先順位４　プロジェクト 
	JComboBox cmb_relay4;			//間接送信　優先順位４　中継基地 

	JComboBox cmb_project5;			//間接送信　優先順位５　プロジェクト 
	JComboBox cmb_relay5;			//間接送信　優先順位５　中継基地 
	
	//ユーザー情報
	Tool_User_IO user_info;
	Struct_User su;
	
	
	//確定・取消ボタン
	JButton btn_OK;
	JButton btn_Cancel;

	ArrayList project_IPaddress = new ArrayList();
	ArrayList project_userid 	= new ArrayList();
	
	ArrayList userid1 			= new ArrayList();
	ArrayList IPaddress1 		= new ArrayList();
	
	ArrayList userid2 			= new ArrayList();
	ArrayList IPaddress2 		= new ArrayList();

	ArrayList userid3			= new ArrayList();
	ArrayList IPaddress3 		= new ArrayList();
	
	ArrayList userid4			= new ArrayList();
	ArrayList IPaddress4 		= new ArrayList();

	ArrayList userid5			= new ArrayList();
	ArrayList IPaddress5 		= new ArrayList();
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	public Gui_PanelSendConfig() {

			super("送信手順",true,true);
		   
			if(sysconfig.isStandardmode() == true){
				setStandard();
			}

			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				SwingUtilities.updateComponentTreeUI(this);
			} catch (Exception e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
			}		
			
			setFrameIcon(null);

			//ユーザー情報の取得
	        user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
			su = user_info.getStruct_User();

			setLocation(50, 30);
			setSize(650,450);
			
	        contentPane = (JPanel) this.getContentPane();
	        contentPane.setLayout(null);
	        
			//*************************************************
			//* ダイレクト送信　または　中継　の　選択
			//*************************************************
			
	        rbtn_direct = new JRadioButton("　送信先にダイレクトに送信します");
	        rbtn_direct.setBounds(10, 20, 450, 28);
			contentPane.add(rbtn_direct);
			
			rbtn_indirect = new JRadioButton("　他ノードを中継して送信先に送信します（以下、優先順位）");
			rbtn_indirect.setBounds(10, 140, 450, 28);
			contentPane.add(rbtn_indirect);

			//直接送信と間接送信はグループ選択
			ButtonGroup group_sendkind = new ButtonGroup();
			group_sendkind.add(rbtn_direct); 
			group_sendkind.add(rbtn_indirect);

			
	        //ラベル
	        JLabel lbl1 = new JLabel();
			lbl1.setText("送信できない場合");
			lbl1.setFont(new Font(lbl1.getFont().getFontName(), Font.PLAIN, lbl1.getFont().getSize()));
			lbl1.setBounds(80, 40, 150, 28);
			contentPane.add(lbl1);

			
			//*************************************************
			//* ダイレクト送信　オプション使用可否　の　選択
			//*************************************************
			
			rbtn_wait = new JRadioButton(" 待機します");
			rbtn_wait.setFont(new Font(rbtn_wait.getFont().getFontName(), Font.PLAIN, rbtn_wait.getFont().getSize()));
			rbtn_wait.setBounds(180, 40, 300, 28);
			contentPane.add(rbtn_wait);
			
			rbtn_relay = new JRadioButton();
			rbtn_relay.setBounds(180, 65, 20, 28);
			contentPane.add(rbtn_relay);
			
			//直接送信と間接送信はグループ選択
			ButtonGroup group_sendkind2 = new ButtonGroup();
			group_sendkind2.add(rbtn_wait); 
			group_sendkind2.add(rbtn_relay);
			
			//*************************************************
			//* ダイレクト送信　オプション　の　選択
			//*************************************************
			
			
			chkrelay = new JCheckBox("　他ノードを中継して送信先に送信します");
			chkrelay.setBounds(210, 65, 300, 28);
			contentPane.add(chkrelay);

			
			chkserver = new JCheckBox("　サーバーを中継して送信します");
			chkserver.setBounds(210, 90, 300, 28);
			contentPane.add(chkserver);

			//******************************************************
			//* 間接送信　優先順位１
			//******************************************************
			
	        //ラベル
	        JLabel lbl2 = new JLabel();
			lbl2.setText("１．");
			lbl2.setFont(new Font(lbl1.getFont().getFontName(), Font.PLAIN, lbl1.getFont().getSize()));
			lbl2.setBounds(80, 170, 150, 28);
			contentPane.add(lbl2);
			
			Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + 
																	addr.getFile_project_info());
			t.loadXml();
			ArrayList array_Entry_Project = t.getdata();

			cmb_project1 = new JComboBox();
			cmb_project1.addItem("***未設定***");
   	    	
 			for(int i = 0;i<array_Entry_Project.size();i++){
				Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);
				cmb_project1.addItem(sep.getProject());
				//ＩＰアドレスのセーブ
				project_IPaddress.add(sep.getIp_address());
				//ユーザーＩＤのセーブ
				project_userid.add(sep.getUserid());

 			}

			cmb_project1.setBounds(120, 170, 150, 28);
			cmb_project1.setSelectedItem("***未設定***");
			contentPane.add(cmb_project1);

			cmb_relay1 = new JComboBox();
			cmb_relay1.setBounds(300, 170, 300, 28);
			contentPane.add(cmb_relay1);

			
			//******************************************************
			//* 間接送信　優先順位２
			//******************************************************
			
	        //ラベル
	        JLabel lbl3 = new JLabel();
			lbl3.setText("２．");
			lbl3.setFont(new Font(lbl3.getFont().getFontName(), Font.PLAIN, lbl3.getFont().getSize()));
			lbl3.setBounds(80, 200, 150, 28);
			contentPane.add(lbl3);

			cmb_project2 = new JComboBox();
			cmb_project2.addItem("***未設定***");
   	    	
 			for(int i = 0;i<array_Entry_Project.size();i++){
				Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);
				cmb_project2.addItem(sep.getProject());
 			}

			cmb_project2.setBounds(120, 200, 150, 28);
			cmb_project2.setSelectedItem("***未設定***");
			contentPane.add(cmb_project2);

			cmb_relay2 = new JComboBox();
			cmb_relay2.setBounds(300, 200, 300, 28);
			contentPane.add(cmb_relay2);
			

			//******************************************************
			//* 間接送信　優先順位３
			//******************************************************
			
	        //ラベル
	        JLabel lbl4 = new JLabel();
			lbl4.setText("３．");
			lbl4.setFont(new Font(lbl4.getFont().getFontName(), Font.PLAIN, lbl4.getFont().getSize()));
			lbl4.setBounds(80, 230, 150, 28);
			contentPane.add(lbl4);
			
			cmb_project3 = new JComboBox();
			cmb_project3.addItem("***未設定***");
   	    	
 			for(int i = 0;i<array_Entry_Project.size();i++){
				Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);
				cmb_project3.addItem(sep.getProject());
 			}

			cmb_project3.setBounds(120, 230, 150, 28);
			cmb_project3.setSelectedItem("***未設定***");
			contentPane.add(cmb_project3);

			cmb_relay3 = new JComboBox();
			cmb_relay3.setBounds(300, 230, 300, 28);
			contentPane.add(cmb_relay3);
			

			//******************************************************
			//* 間接送信　優先順位４
			//******************************************************
			
	        //ラベル
	        JLabel lbl5 = new JLabel();
			lbl5.setText("４．");
			lbl5.setFont(new Font(lbl5.getFont().getFontName(), Font.PLAIN, lbl5.getFont().getSize()));
			lbl5.setBounds(80, 260, 150, 28);
			contentPane.add(lbl5);
			
			cmb_project4 = new JComboBox();
			cmb_project4.addItem("***未設定***");
   	    	
 			for(int i = 0;i<array_Entry_Project.size();i++){
				Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);
				cmb_project4.addItem(sep.getProject());
 			}

			cmb_project4.setBounds(120, 260, 150, 28);
			cmb_project4.setSelectedItem("***未設定***");
			contentPane.add(cmb_project4);

			cmb_relay4 = new JComboBox();
			cmb_relay4.setBounds(300, 260, 300, 28);
			contentPane.add(cmb_relay4);

			
			//******************************************************
			//* 間接送信　優先順位５
			//******************************************************
			
	        //ラベル
	        JLabel lbl6 = new JLabel();
			lbl6.setText("５．");
			lbl6.setFont(new Font(lbl6.getFont().getFontName(), Font.PLAIN, lbl6.getFont().getSize()));
			lbl6.setBounds(80, 290, 150, 28);
			contentPane.add(lbl6);
			
			cmb_project5 = new JComboBox();
			cmb_project5.addItem("***未設定***");
   	    	
 			for(int i = 0;i<array_Entry_Project.size();i++){
				Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);
				cmb_project5.addItem(sep.getProject());
 			}

			cmb_project5.setBounds(120, 290, 150, 28);
			cmb_project5.setSelectedItem("***未設定***");
			contentPane.add(cmb_project5);

			cmb_relay5 = new JComboBox();
			cmb_relay5.setBounds(300, 290, 300, 28);
			contentPane.add(cmb_relay5);
			
			
			//確定ボタン
			btn_OK = new JButton("確定");
			btn_OK.setBounds(230, 350, 70, 50);
			contentPane.add(btn_OK);
			btn_OK.addActionListener(this);	

	        //取消ボタン
			btn_Cancel = new JButton("取消");
			btn_Cancel.setBounds(330, 350, 70, 50);
			contentPane.add(btn_Cancel);
			btn_Cancel.addActionListener(this);


			//*******************************************
			//* ユーザー情報の復元
			//*******************************************

			//直接送信オプション　他ノード中継
			if(su.isSend_direct_option_relay() == true){
				chkrelay.setSelected(true);
			}
			
			//直接送信オプション　サーバー中継
			if(su.isSend_direct_option_server() == true){
				chkserver.setSelected(true);
			}

			//直接送信オプション
			if(su.isSend_direct_option() == true	){
				rbtn_relay.setSelected(true);
			}
			else{
				rbtn_wait.setSelected(true);
				//直接送信オプションの使用不可
				chkrelay.setEnabled(false);
				chkserver.setEnabled(false);
			}
			
			//直接送信　または　間接送信
			if(su.isSend_direct() == true){
				rbtn_direct.setSelected(true);		
			}
			else{
				rbtn_indirect.setSelected(true);				
				//直接送信使用不可
				rbtn_wait.setEnabled(false);
				rbtn_relay.setEnabled(false);
				chkrelay.setEnabled(false);
				chkserver.setEnabled(false);
			}
			
			//*******************************************
			//* 優先順位１の復元
			//*******************************************

			//優先順位１　プロジェクト　未設定の場合
			if(su.getRelay1_project() == null || su.getRelay1_project().length() == 0){
				cmb_project1.setSelectedIndex(0);
			}
			//優先順位１　プロジェクト　設定ありの場合
			else{
				boolean found = false;
				int i;
				for(i=0;i<array_Entry_Project.size();i++){
					Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);

					if(sep.getProject().equals(su.getRelay1_project())){
						found = true;
						break;
					}
				}

				//設定値を表示
				if(found == true){
					cmb_project1.setSelectedIndex(i+1);		//未設定が最上項目にあるので、＋１する
				}
				else {
			    		JOptionPane.showMessageDialog(this, "前回設定した優先１位のプロジェクトはテーブルに存在しません\n正しく設定してください", 
		   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
			    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay1_project Error  nothing table  last Relay1_project = "+su.getRelay1_project());
			    		cmb_project1.setSelectedIndex(0);
				}

			}

			//コミュニティ＆メンバーを設定する
			projectChange(cmb_project1,cmb_relay1,userid1,IPaddress1);
			
			//未設定ではない場合
			if(cmb_project1.getSelectedIndex() != 0){
				//サーバー設定
				if(su.getRelay1_community() == null || su.getRelay1_community().length() == 0){
					cmb_relay1.setSelectedIndex(0);
				}
				else{
					boolean found = false;
					int i;
					for(i=0;i<userid1.size();i++){

						if(su.getRelay1_community().equals(cmb_relay1.getItemAt(i)) &&
							su.getRelay1_userid().equals(userid1.get(i))){
							found = true;
							break;
						}
					}

					//設定値を表示
					if(found == true){
						cmb_relay1.setSelectedIndex(i);
					}
					else {
				    		JOptionPane.showMessageDialog(this, "前回設定した優先１位のノードはテーブルに存在しません\n正しく設定してください", 
			   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
				    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay1_project Error  nothing table  last Relay1_project = "+su.getRelay1_project());
				    		cmb_relay1.setSelectedIndex(0);
					}
					
				}

				
			}
			
			//*******************************************
			//* 優先順位２の復元
			//*******************************************

			//優先順位２　プロジェクト　未設定の場合
			if(su.getRelay2_project() == null || su.getRelay2_project().length() == 0){
				cmb_project2.setSelectedIndex(0);
			}
			//優先順位２　プロジェクト　設定ありの場合
			else{
				boolean found = false;
				int i;
				for(i=0;i<array_Entry_Project.size();i++){
					Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);

					if(sep.getProject().equals(su.getRelay2_project())){
						found = true;
						break;
					}
				}

				//設定値を表示
				if(found == true){
					cmb_project2.setSelectedIndex(i+1);		//未設定が最上項目にあるので、＋１する
				}
				else {
			    		JOptionPane.showMessageDialog(this, "前回設定した優先２位のプロジェクトはテーブルに存在しません\n正しく設定してください", 
		   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
			    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay2_project Error  nothing table  last Relay2_project = "+su.getRelay2_project());
			    		cmb_project2.setSelectedIndex(0);
				}

			}

			//コミュニティ＆メンバーを設定する
			projectChange(cmb_project2,cmb_relay2,userid2,IPaddress2);
			
			//未設定ではない場合
			if(cmb_project2.getSelectedIndex() != 0){
				//サーバー設定
				if(su.getRelay2_community() == null || su.getRelay2_community().length() == 0){
					cmb_relay2.setSelectedIndex(0);
				}
				else{
					boolean found = false;
					int i;
					for(i=0;i<userid2.size();i++){

						if(su.getRelay2_community().equals(cmb_relay2.getItemAt(i)) &&
							su.getRelay2_userid().equals(userid2.get(i))){
							found = true;
							break;
						}
					}

					//設定値を表示
					if(found == true){
						cmb_relay2.setSelectedIndex(i);
					}
					else {
				    		JOptionPane.showMessageDialog(this, "前回設定した優先２位のノードはテーブルに存在しません\n正しく設定してください", 
			   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
				    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay2_project Error  nothing table  last Relay2_project = "+su.getRelay2_project());
				    		cmb_relay2.setSelectedIndex(0);
					}
				}
			}			

			
			//*******************************************
			//* 優先順位３の復元
			//*******************************************

			//優先順位３　プロジェクト　未設定の場合
			if(su.getRelay3_project() == null || su.getRelay3_project().length() == 0){
				cmb_project3.setSelectedIndex(0);
			}
			//優先順位３　プロジェクト　設定ありの場合
			else{
				boolean found = false;
				int i;
				for(i=0;i<array_Entry_Project.size();i++){
					Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);

					if(sep.getProject().equals(su.getRelay3_project())){
						found = true;
						break;
					}
				}

				//設定値を表示
				if(found == true){
					cmb_project3.setSelectedIndex(i+1);		//未設定が最上項目にあるので、＋１する
				}
				else {
			    		JOptionPane.showMessageDialog(this, "前回設定した優先３位のプロジェクトはテーブルに存在しません\n正しく設定してください", 
		   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
			    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay3_project Error  nothing table  last Relay3_project = "+su.getRelay3_project());
			    		cmb_project3.setSelectedIndex(0);
				}

			}
			
			//コミュニティ＆メンバーを設定する
			projectChange(cmb_project3,cmb_relay3,userid3,IPaddress3);
			
			//未設定ではない場合
			if(cmb_project3.getSelectedIndex() != 0){
				//サーバー設定
				if(su.getRelay3_community() == null || su.getRelay3_community().length() == 0){
					cmb_relay3.setSelectedIndex(0);
				}
				else{
					boolean found = false;
					int i;
					for(i=0;i<userid3.size();i++){

						if(su.getRelay3_community().equals(cmb_relay3.getItemAt(i)) &&
							su.getRelay3_userid().equals(userid3.get(i))){
							found = true;
							break;
						}
					}

					//設定値を表示
					if(found == true){
						cmb_relay3.setSelectedIndex(i);
					}
					else {
				    		JOptionPane.showMessageDialog(this, "前回設定した優先３位のノードはテーブルに存在しません\n正しく設定してください", 
			   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
				    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay3_project Error  nothing table  last Relay3_project = "+su.getRelay3_project());
				    		cmb_relay3.setSelectedIndex(0);
					}
				}
			}					

			
			//*******************************************
			//* 優先順位４の復元
			//*******************************************

			//優先順位４　プロジェクト　未設定の場合
			if(su.getRelay4_project() == null || su.getRelay4_project().length() == 0){
				cmb_project4.setSelectedIndex(0);
			}
			//優先順位４　プロジェクト　設定ありの場合
			else{
				boolean found = false;
				int i;
				for(i=0;i<array_Entry_Project.size();i++){
					Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);

					if(sep.getProject().equals(su.getRelay4_project())){
						found = true;
						break;
					}
				}

				//設定値を表示
				if(found == true){
					cmb_project4.setSelectedIndex(i+1);		//未設定が最上項目にあるので、＋１する
				}
				else {
			    		JOptionPane.showMessageDialog(this, "前回設定した優先４位のプロジェクトはテーブルに存在しません\n正しく設定してください", 
		   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
			    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay4_project Error  nothing table  last Relay4_project = "+su.getRelay4_project());
			    		cmb_project4.setSelectedIndex(0);
				}

			}
			
			//コミュニティ＆メンバーを設定する
			projectChange(cmb_project4,cmb_relay4,userid4,IPaddress4);
			
			//未設定ではない場合
			if(cmb_project4.getSelectedIndex() != 0){
				//サーバー設定
				if(su.getRelay4_community() == null || su.getRelay4_community().length() == 0){
					cmb_relay4.setSelectedIndex(0);
				}
				else{
					boolean found = false;
					int i;
					for(i=0;i<userid4.size();i++){

						if(su.getRelay4_community().equals(cmb_relay4.getItemAt(i)) &&
							su.getRelay4_userid().equals(userid4.get(i))){
							found = true;
							break;
						}
					}

					//設定値を表示
					if(found == true){
						cmb_relay4.setSelectedIndex(i);
					}
					else {
				    		JOptionPane.showMessageDialog(this, "前回設定した優先４位のノードはテーブルに存在しません\n正しく設定してください", 
			   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
				    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay4_project Error  nothing table  last Relay4_project = "+su.getRelay4_project());
				    		cmb_relay4.setSelectedIndex(0);
					}
				}
			}				
			
			
			//*******************************************
			//* 優先順位５の復元
			//*******************************************

			//優先順位５　プロジェクト　未設定の場合
			if(su.getRelay5_project() == null || su.getRelay5_project().length() == 0){
				cmb_project5.setSelectedIndex(0);
			}
			//優先順位５　プロジェクト　設定ありの場合
			else{
				boolean found = false;
				int i;
				for(i=0;i<array_Entry_Project.size();i++){
					Struct_Entry_Project sep = (Struct_Entry_Project)array_Entry_Project.get(i);

					if(sep.getProject().equals(su.getRelay5_project())){
						found = true;
						break;
					}
				}

				//設定値を表示
				if(found == true){
					cmb_project5.setSelectedIndex(i+1);		//未設定が最上項目にあるので、＋１する
				}
				else {
			    		JOptionPane.showMessageDialog(this, "前回設定した優先５位のプロジェクトはテーブルに存在しません\n正しく設定してください", 
		   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
			    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay5_project Error  nothing table  last Relay5_project = "+su.getRelay5_project());
			    		cmb_project5.setSelectedIndex(0);
				}

			}
			
			//コミュニティ＆メンバーを設定する
			projectChange(cmb_project5,cmb_relay5,userid5,IPaddress5);
			
			//未設定ではない場合
			if(cmb_project5.getSelectedIndex() != 0){
				//サーバー設定
				if(su.getRelay5_community() == null || su.getRelay5_community().length() == 0){
					cmb_relay5.setSelectedIndex(0);
				}
				else{
					boolean found = false;
					int i;
					for(i=0;i<userid5.size();i++){

						if(su.getRelay5_community().equals(cmb_relay5.getItemAt(i)) &&
							su.getRelay5_userid().equals(userid5.get(i))){
							found = true;
							break;
						}
					}

					//設定値を表示
					if(found == true){
						cmb_relay5.setSelectedIndex(i);
					}
					else {
				    		JOptionPane.showMessageDialog(this, "前回設定した優先５位のノードはテーブルに存在しません\n正しく設定してください", 
			   	    				"送信手順設定", JOptionPane.ERROR_MESSAGE); 
				    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Relay5_project Error  nothing table  last Relay5_project = "+su.getRelay5_project());
				    		cmb_relay5.setSelectedIndex(0);
					}
				}
			}		
			
			
			//*******************************************
			//*ラジオボタンのリスナー登録
			//*******************************************
			
			rbtn_direct.addItemListener(this);
			rbtn_indirect.addItemListener(this);
			rbtn_wait.addItemListener(this);
			rbtn_relay.addItemListener(this);
			
			//*******************************************
			//*コンボボックスのリスナー登録
			//*******************************************
			
			cmb_project1.addItemListener(this);
			cmb_project2.addItemListener(this);
			cmb_project3.addItemListener(this);
			cmb_project4.addItemListener(this);
			cmb_project5.addItemListener(this);

			
			
			
			//画面表示
			this.setVisible(true);
			
   }


	public void actionPerformed(ActionEvent e) {

   		if(e.getSource() == btn_OK ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"送信手順を変更しますか？",
    				"送信手順設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}

    		
    		//重複チェック
 			if(dupCheck(cmb_project1,cmb_relay1,userid1,cmb_project2,cmb_relay2,userid2,"優先１位","優先２位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project1,cmb_relay1,userid1,cmb_project3,cmb_relay3,userid3,"優先１位","優先３位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project1,cmb_relay1,userid1,cmb_project4,cmb_relay4,userid4,"優先１位","優先４位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project1,cmb_relay1,userid1,cmb_project5,cmb_relay5,userid5,"優先１位","優先５位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project2,cmb_relay2,userid2,cmb_project3,cmb_relay3,userid3,"優先２位","優先３位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project2,cmb_relay2,userid2,cmb_project4,cmb_relay4,userid4,"優先２位","優先４位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project2,cmb_relay2,userid2,cmb_project5,cmb_relay5,userid5,"優先２位","優先５位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project3,cmb_relay3,userid3,cmb_project4,cmb_relay4,userid4,"優先３位","優先４位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project3,cmb_relay3,userid3,cmb_project5,cmb_relay5,userid5,"優先３位","優先５位") ==true){
 				return;
 			}
 			if(dupCheck(cmb_project4,cmb_relay4,userid4,cmb_project5,cmb_relay5,userid5,"優先４位","優先５位") ==true){
 				return;
 			}
 			
 			
    		//42.直接送信　の　設定
    		if(rbtn_direct.isSelected() == true){
    			su.setSend_direct(true);
    		}
    		else{
    			su.setSend_direct(false);
    		}
    		
    		//43.直接送信オプション の　設定
    		if(rbtn_relay.isSelected() == true){
    			su.setSend_direct_option(true);
    		}
    		else{
       			su.setSend_direct_option(false);
    		}

    		//44.直接送信オプション他ノード中継 の　設定
			if(chkrelay.isSelected() == true){
    			su.setSend_direct_option_relay(true);
			}
			else{
    			su.setSend_direct_option_relay(false);
			}

			//45.直接送信オプションサーバ中継	の　設定
			if(chkserver.isSelected() == true){
    			su.setSend_direct_option_server(true);
			}
			else{
    			su.setSend_direct_option_server(false);
			}
    			
    		
    		//***************************************************
    		//* 優先順位１
    		//***************************************************

    		//未設定の場合
    		if(cmb_project1.getSelectedIndex() == 0){
    			su.setRelay1_project(new String());			//46.中継プロジェクト１　
    			su.setRelay1_community(new String());		//47.中継コミュニティ１
    			su.setRelay1_userid(new String());			//48.中継ユーザーＩＤ１
    			su.setRelay1_node(new String());			//49.中継ノード１
    			}
    		//プロジェクトを選択した場合
    		else{
    			su.setRelay1_project(cmb_project1.getSelectedItem().toString());	//46.中継プロジェクト１
    			//サーバを選択した場合
    			if(cmb_relay1.getSelectedIndex() == 0){
        			su.setRelay1_community(new String());							//47.中継コミュニティ１
    			}
    			else{
        			su.setRelay1_community(cmb_relay1.getSelectedItem().toString());//47.中継コミュニティ１
    			}

    			su.setRelay1_userid((String) userid1.get(cmb_relay1.getSelectedIndex()));	//48.中継ユーザーＩＤ１
    			su.setRelay1_node((String) IPaddress1.get(cmb_relay1.getSelectedIndex()));	//49.中継ノード１
    			
    		}
    		
    		
    		//***************************************************
    		//* 優先順位２
    		//***************************************************

    		//未設定の場合
    		if(cmb_project2.getSelectedIndex() == 0){
    			su.setRelay2_project(new String());			//50.中継プロジェクト２　
    			su.setRelay2_community(new String());		//51.中継コミュニティ２
    			su.setRelay2_userid(new String());			//52.中継ユーザーＩＤ２
    			su.setRelay2_node(new String());			//53.中継ノード２
    			}
    		//プロジェクトを選択した場合
    		else{
    			su.setRelay2_project(cmb_project2.getSelectedItem().toString());	//50.中継プロジェクト２
    			//サーバを選択した場合
    			if(cmb_relay2.getSelectedIndex() == 0){
        			su.setRelay2_community(new String());							//51.中継コミュニティ２
    			}
    			else{
        			su.setRelay2_community(cmb_relay2.getSelectedItem().toString());//51.中継コミュニティ２
    			}

    			su.setRelay2_userid((String) userid2.get(cmb_relay2.getSelectedIndex()));	//52.中継ユーザーＩＤ２
    			su.setRelay2_node((String) IPaddress2.get(cmb_relay2.getSelectedIndex()));	//53.中継ノード２
    		}    		
    		

    		//***************************************************
    		//* 優先順位３
    		//***************************************************

    		//未設定の場合
    		if(cmb_project3.getSelectedIndex() == 0){
    			su.setRelay3_project(new String());			//54.中継プロジェクト３　
    			su.setRelay3_community(new String());		//55.中継コミュニティ３
    			su.setRelay3_userid(new String());			//56.中継ユーザーＩＤ３
    			su.setRelay3_node(new String());			//57.中継ノード３
    			}
    		//プロジェクトを選択した場合
    		else{
    			su.setRelay3_project(cmb_project3.getSelectedItem().toString());	//54.中継プロジェクト３
    			//サーバを選択した場合
    			if(cmb_relay3.getSelectedIndex() == 0){
        			su.setRelay3_community(new String());							//55.中継コミュニティ３
    			}
    			else{
        			su.setRelay3_community(cmb_relay3.getSelectedItem().toString());//55.中継コミュニティ３
    			}

    			su.setRelay3_userid((String) userid3.get(cmb_relay3.getSelectedIndex()));	//56.中継ユーザーＩＤ３
    			su.setRelay3_node((String) IPaddress3.get(cmb_relay3.getSelectedIndex()));	//57.中継ノード３
    		}    		

    		
    		//***************************************************
    		//* 優先順位４
    		//***************************************************

    		//未設定の場合
    		if(cmb_project4.getSelectedIndex() == 0){
    			su.setRelay4_project(new String());			//58.中継プロジェクト４　
    			su.setRelay4_community(new String());		//59.中継コミュニティ４
    			su.setRelay4_userid(new String());			//60.中継ユーザーＩＤ４
    			su.setRelay4_node(new String());			//61.中継ノード４
    			}
    		//プロジェクトを選択した場合
    		else{
    			su.setRelay4_project(cmb_project4.getSelectedItem().toString());	//58.中継プロジェクト４
    			//サーバを選択した場合
    			if(cmb_relay4.getSelectedIndex() == 0){
        			su.setRelay4_community(new String());							//59.中継コミュニティ４
    			}
    			else{
        			su.setRelay4_community(cmb_relay4.getSelectedItem().toString());//59.中継コミュニティ４
    			}

    			su.setRelay4_userid((String) userid4.get(cmb_relay4.getSelectedIndex()));	//60.中継ユーザーＩＤ４
    			su.setRelay4_node((String) IPaddress4.get(cmb_relay4.getSelectedIndex()));	//61.中継ノード４
    		}    		

    		
    		//***************************************************
    		//* 優先順位５
    		//***************************************************

    		//未設定の場合
    		if(cmb_project5.getSelectedIndex() == 0){
    			su.setRelay5_project(new String());			//62.中継プロジェクト５　
    			su.setRelay5_community(new String());		//63.中継コミュニティ５
    			su.setRelay5_userid(new String());			//64.中継ユーザーＩＤ５
    			su.setRelay5_node(new String());			//65.中継ノード５
    			}
    		//プロジェクトを選択した場合
    		else{
    			su.setRelay5_project(cmb_project5.getSelectedItem().toString());	//62.中継プロジェクト５
    			//サーバを選択した場合
    			if(cmb_relay5.getSelectedIndex() == 0){
        			su.setRelay5_community(new String());							//63.中継コミュニティ５
    			}
    			else{
        			su.setRelay5_community(cmb_relay5.getSelectedItem().toString());//63.中継コミュニティ５
    			}

    			su.setRelay5_userid((String) userid5.get(cmb_relay5.getSelectedIndex()));	//64.中継ユーザーＩＤ５
    			su.setRelay5_node((String) IPaddress5.get(cmb_relay5.getSelectedIndex()));	//65.中継ノード５
    		}    		

    		
    		user_info.setStruct_User(su);
    		user_info.saveXml();
    		JOptionPane.showMessageDialog(this, "送信手順を変更しました", 
    				"送信手順設定", JOptionPane.INFORMATION_MESSAGE); 
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}

   		}
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}
		
	}

	
	//コンボボックスのプロジェクトを変更したイベント
	public void itemStateChanged(ItemEvent e) {
		if(e.getStateChange() == ItemEvent.SELECTED){
			//直接送信　
			if(e.getSource() == rbtn_direct){
				rbtn_wait.setEnabled(true);
				rbtn_relay.setEnabled(true);
				if(rbtn_relay.isSelected() == true){
					chkrelay.setEnabled(true);
					chkserver.setEnabled(true);
				}
				
			}
			//間接送信　
			else if(e.getSource() == rbtn_indirect){
				rbtn_wait.setEnabled(false);
				rbtn_relay.setEnabled(false);
				chkrelay.setEnabled(false);
				chkserver.setEnabled(false);
			}
			//直接送信　オプション私用不可を選択
			else if(e.getSource() == rbtn_wait){
				chkrelay.setEnabled(false);
				chkserver.setEnabled(false);
			}
			else if(e.getSource() == rbtn_relay){
				chkrelay.setEnabled(true);
				chkserver.setEnabled(true);
					
			}
			//優先順位１　プロジェクトの変更
			else if(e.getSource() == cmb_project1 ){
				projectChange(cmb_project1,cmb_relay1,userid1,IPaddress1);
			}
			//優先順位２　プロジェクトの変更
			else if(e.getSource() == cmb_project2 ){
				projectChange(cmb_project2,cmb_relay2,userid2,IPaddress2);
			}
			//優先順位３　プロジェクトの変更
			else if(e.getSource() == cmb_project3){
				projectChange(cmb_project3,cmb_relay3,userid3,IPaddress3);
			}
			//優先順位４　プロジェクトの変更
			else if(e.getSource() == cmb_project4){
				projectChange(cmb_project4,cmb_relay4,userid4,IPaddress4);
			}
			//優先順位５　プロジェクトの変更
			else if(e.getSource() == cmb_project5){
				projectChange(cmb_project5,cmb_relay5,userid5,IPaddress5);
			}
			
		}
	}
	

	private void projectChange(JComboBox cmb_project,JComboBox cmb_relay,ArrayList userid,ArrayList IPaddress){
		//未設定を選択した場合
		if(cmb_project.getSelectedIndex() == 0){
			cmb_relay.removeAllItems();
			cmb_relay.setEnabled(false);
			return;
		}
		
		//コミュニティメンバーの取得
		Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO (addr.getDir_current() + 
												addr.getDir_project() + 
												cmb_project.getSelectedItem() + 
												addr.getFile_com_menber());
		ArrayList<Struct_Community_Menber>all_commnity_menber = tcm.getdata();
		
		//画面表示用コンボボックスの初期化
		cmb_relay.removeAllItems();
		cmb_relay.setEnabled(true);
		//ＩＰアドレスの初期化
		IPaddress.clear();			//new ArrayList()を実行すると参照渡しされないので注意
		//ユーザーＩＤの初期化
		userid.clear();				//new ArrayList()を実行すると参照渡しされないので注意

		//一番上にサーバー値を設定する
		cmb_relay.addItem("サーバー");
		

		IPaddress.add(project_IPaddress.get(cmb_project.getSelectedIndex()-1));
		userid.add(project_userid.get(cmb_project.getSelectedIndex()-1));
		
		for(int i=0 ; i<all_commnity_menber.size() ; i++ ){
			if(all_commnity_menber.get(i).getUserid().equals("allmenber") == false &&
				all_commnity_menber.get(i).getUserid().equals(su.getUserid()) == false 	){
				String data = "[" + 
				all_commnity_menber.get(i).getCommunity() +  "][" + 
				all_commnity_menber.get(i).getUser_fullname() + "]";
				cmb_relay.addItem(data);
				userid.add(all_commnity_menber.get(i).getUserid());
				IPaddress.add(all_commnity_menber.get(i).getNode());
			}
		}
	
	}
	
	
	private boolean dupCheck(JComboBox cmb_projectA,JComboBox cmb_relayA,ArrayList useridA,
			JComboBox cmb_projectB,JComboBox cmb_relayB,ArrayList useridB,String A,String B){
		//未設定の場合はチェック対象外
		if(cmb_projectA.getSelectedIndex() == 0){
			return false;
		}
		if(cmb_projectB.getSelectedIndex() == 0){
			return false;
		}
		//プロジェクトが異なる場合はチェック対象外
		if(cmb_projectA.getSelectedIndex() != cmb_projectB.getSelectedIndex()){
			return false;
		}
		if(useridA.get(cmb_relayA.getSelectedIndex()).equals(useridB.get(cmb_relayB.getSelectedIndex())) == true){
	    		JOptionPane.showMessageDialog(this, "["+A+"]と["+B+"]のノードは同一です\nどちらかを変更してください", 
   	    				"送信手順設定", JOptionPane.INFORMATION_MESSAGE); 
			return true;
			
		}
		
		return false;
		
	}
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}



}
