package mailcost_main;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;

import javax.swing.*;

import structure.File_and_Directory_Address;
import structure.Struct_Business_Year_days;
import structure.Struct_Cost_Digest;
import structure.Struct_System_Config;
import structure.Struct_UnitCost;
import structure.Struct_User;
import tool.Tool_Business_Year_days_IO;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_LogOut;
import tool.Tool_Numeric_InputKey_check;
import tool.Tool_Numeric_check;
import tool.Tool_System_Config_IO;
import tool.Tool_UnitCost_IO;
import tool.Tool_User_IO;

public class Gui_PanelUser extends JInternalFrame implements ItemListener, ActionListener, FocusListener{

	JPanel contentPane;
	
	JComboBox combposition;
	JComboBox combpos_cost;
	
	Struct_UnitCost[] position_data;
	Struct_UnitCost[] pos_cost_data;
	
	//ユーザー情報
	Tool_User_IO user_info;
	Struct_User su;
	
	
	
	//画面のパーツ
	JTextField userid;					//ユーザーＩＤ
	JTextField username;				//ユーザー名
	JTextField node;					//アドレス（ノード）

	JFormattedTextField working_time;	//１日の労働時間
	JLabel lblunitcost;					//単価／秒

	//表示レベル１	
	JFormattedTextField normal_time;	//正常最大時間　単位は固定ではない
	JLabel lbl_normal_maxcost;			//コスト
	JRadioButton rbtn_normal_second;
	JRadioButton rbtn_normal_minute;
	JRadioButton rbtn_normal_hour;
	JRadioButton rbtn_normal_day;

	//表示レベル２	
	JFormattedTextField semi_warning_time;	//警告最大時間　単位は固定ではない
	JLabel lbl_semi_warning_maxcost;			//コスト
	JRadioButton rbtn_semi_warning_second;
	JRadioButton rbtn_semi_warning_minute;
	JRadioButton rbtn_semi_warning_hour;
	JRadioButton rbtn_semi_warning_day;
	
	//表示レベル３	
	JFormattedTextField warning_time;	//警告最大時間　単位は固定ではない
	JLabel lbl_warning_maxcost;			//コスト
	JRadioButton rbtn_warning_second;
	JRadioButton rbtn_warning_minute;
	JRadioButton rbtn_warning_hour;
	JRadioButton rbtn_warning_day;
	
	//表示レベル４	
	JFormattedTextField semi_abnormal_time;	//異常最大時間　単位は固定ではない
	JLabel lbl_semi_abnormal_maxcost;		//コスト
	JRadioButton rbtn_semi_abnormal_second;
	JRadioButton rbtn_semi_abnormal_minute;
	JRadioButton rbtn_semi_abnormal_hour;
	JRadioButton rbtn_semi_abnormal_day;
	
	//表示レベル５	
	JFormattedTextField abnormal_time;		//異常最大時間　単位は固定ではない
	JLabel lbl_abnormal_maxcost;			//コスト
	JRadioButton rbtn_abnormal_second;
	JRadioButton rbtn_abnormal_minute;
	JRadioButton rbtn_abnormal_hour;
	JRadioButton rbtn_abnormal_day;

	//確定・取消ボタン
	JButton btn_OK;
	JButton btn_Cancel;

	//標準単価のチェック
	JCheckBox chkbox_std;
	
	DecimalFormat fmtnumber = new DecimalFormat("###,###");
	
	double unitcost;			//１秒あたりのコスト
	
	
	boolean focus_check = true;			//オプションメッセージ表示中はロストフォーカスを経由しない

	int focus_id;

	Struct_Business_Year_days  sbyd;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
													addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Gui_PanelUser() {

		super("ユーザー設定",true,true);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "LookAndFeel Error");
		}		
		
		setFrameIcon(null);

		setLocation(50, 10);
		setSize(700,470);
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(null);
        
        //ユーザー情報の取得
        user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		su = user_info.getStruct_User();
		su.setLastbatchtimestamp(System.currentTimeMillis());

		//ラベル
        JLabel lbl1 = new JLabel();
		lbl1.setText("ユーザーＩＤ");
		lbl1.setBounds(10, 10, 100, 28);
		contentPane.add(lbl1);
		
		
        //ラベル
        JLabel lbl2 = new JLabel();
		lbl2.setText("ユーザー名称");
		lbl2.setBounds(10, 40, 100, 28);
		contentPane.add(lbl2);


        //ラベル
        JLabel lbl3 = new JLabel();
		lbl3.setText("アドレス");
		lbl3.setBounds(10, 70, 100, 28);
		contentPane.add(lbl3);
		
		
		//ラベル
        JLabel lbl4 = new JLabel();
		lbl4.setText("職種");
		lbl4.setBounds(10, 100, 100, 28);
		contentPane.add(lbl4);

		//ラベル
        JLabel lbl5 = new JLabel();
		lbl5.setText("単価");
		lbl5.setBounds(10, 130, 100, 28);
		contentPane.add(lbl5);

		//ラベル
        JLabel lbl6 = new JLabel();
		lbl6.setText("円／月");
		lbl6.setBounds(325, 130, 100, 28);
		contentPane.add(lbl6);

		//ユーザーＩＤの設定
		userid = new JTextField ();
		userid.setBounds(110, 10, 300, 28);
		userid.setText(su.getUserid());
		contentPane.add(userid);

		//ユーザー名称の設定
		username = new JTextField ();
		username.setBounds(110, 40, 300, 28);
		username.setText(su.getUser_fullname());
		contentPane.add(username);

		//アドレスの設定
		node = new JTextField ();
		node.setBounds(110, 70, 300, 28);
		node.setText(su.getNode());
		contentPane.add(node);
		
		/****************************************/
		/* 役割の設定                           */
		/****************************************/
//		position_data = (String[][]) new Tool_ArrayData_IO(addr.getDir_current() + addr.getFile_position()).getdata();
		
		position_data = new Tool_UnitCost_IO(addr.getDir_current() + 
												addr.getFile_position()).getStruct_UnitcCost();
		
		String data[] = new String[position_data.length];
		 
		boolean found = false;
		
		for(int i=0;i<position_data.length;i++){
//			data[i] = position_data[i][0];
			data[i] = position_data[i].getPosition();
//			if(data[i].equals(su.getPosition())){
			if(data[i].equals(su.getStruct_unitccost().getPosition())){
				found = true;
			}
		}
		combposition = new JComboBox(data);

		//設定値を表示
		if(found == true){
			combposition.setSelectedItem(su.getStruct_unitccost().getPosition());
		}
		else if((su.getStruct_unitccost().getPosition() != null) || (su.getStruct_unitccost().getPosition().length() > 0)){
	    		JOptionPane.showMessageDialog(this, "前回設定した役割はテーブルに存在しません\n正しい役割を設定してください\n単価は再計算した結果を表示します", 
   	    				"ユーザー設定", JOptionPane.ERROR_MESSAGE); 
	    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Position Error  nothing table  last Position = "+su.getStruct_unitccost().getPosition());
				combposition.setSelectedIndex(0);
		}
		
		combposition.setBounds(110, 100, 200, 28);
		contentPane.add(combposition);
		combposition.addItemListener(this);
		


		//標準単価のみ表示
		chkbox_std	=	new JCheckBox("標準単価を選択") ;
		chkbox_std.setBounds(320, 100, 200, 28);
		contentPane.add(chkbox_std);
		chkbox_std.addItemListener(this);
		
		
		/****************************************/
		/* 単価の設定                           */
		/****************************************/
		
		pos_cost_data = new Tool_UnitCost_IO(addr.getDir_current() + 
												addr.getFile_pos_cost()).getStruct_UnitcCost();

		 
		 
		int count = 0;
		for(int i=0;i<pos_cost_data.length;i++){
//			if(pos_cost_data[i][0].equals(combposition.getSelectedItem())){
			if(pos_cost_data[i].getPosition().equals(combposition.getSelectedItem())){
				count++;
			}
		}
		int datax[] = new int[count];
		int j = 0;
		
		for(int i=0;i<pos_cost_data.length;i++){
			if(pos_cost_data[i].getPosition().equals(combposition.getSelectedItem())){
				datax[j] = pos_cost_data[i].getUnitcost();
				j++;
			}
		}
		
		
//		combpos_cost = new JComboBox(datax);
		combpos_cost = new JComboBox();

		change_cost(combposition.getSelectedItem().toString());
		
//		combpos_cost.setSelectedItem(data);
		combpos_cost.setBounds(110, 130, 200, 28);
		contentPane.add(combpos_cost);
		combpos_cost.addItemListener(this);

		NumberFormat StringToDouble = NumberFormat.getInstance();
		double monthlycost = 0;
		try {
			monthlycost = StringToDouble.parse(combpos_cost.getSelectedItem().toString()).doubleValue();
		} catch (ParseException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}

		if(monthlycost != su.getStruct_unitccost().getUnitcost()){
    		JOptionPane.showMessageDialog(this, "前回設定した単価はテーブルに存在しません\n正しい単価を設定してください\n単価は再計算した結果を表示します", 
	    				"ユーザー設定", JOptionPane.ERROR_MESSAGE); 
    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Cost Error  nothing table  last Cost = "+su.getStruct_unitccost().getUnitcost());
		}
		
		sbyd = new Tool_Business_Year_days_IO(addr.getDir_current() + 
												addr.getFile_business_year_days()).getStruct_Business_Year_days();
		
		//ラベル
        JLabel lbl7 = new JLabel();
		lbl7.setText("年間営業日数");
		lbl7.setBounds(10, 170, 100, 28);
		contentPane.add(lbl7);
		
		//年間営業日数
		JLabel  lbldays = new JLabel();
		lbldays.setText(Integer.toString(sbyd.getDays()));
		lbldays.setBounds(110, 170, 80, 28);
		lbldays.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(lbldays);
		
		if(su.getBusiness_year_days() != sbyd.getDays()){
    		JOptionPane.showMessageDialog(this, "前回設定した年間営業日数は変更されました\n単価は再計算した結果を表示します", 
	    				"ユーザー設定", JOptionPane.ERROR_MESSAGE); 
    		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "User_info Business_year_days change information  last Business_year_days = "+su.getBusiness_year_days());
		}
		

		//ラベル
        JLabel lbl8 = new JLabel();
		lbl8.setText("日");
		lbl8.setBounds(200, 170, 100, 28);
		contentPane.add(lbl8);

		//ラベル
        JLabel lbl9 = new JLabel();
		lbl9.setText("１日の労働時間");
		lbl9.setBounds(10, 200, 100, 28);
		contentPane.add(lbl9);
		
		//労働時間の設定
		working_time = new JFormattedTextField ();
		working_time.setBounds(110, 200, 70, 28);

		DecimalFormat dfw = new DecimalFormat("#0.00");
		Tool_Numeric_InputKey_check nc = new Tool_Numeric_InputKey_check();
		working_time.setDocument(nc);							//入力キー制限
		working_time.setInputVerifier(new MyVerifier());		//入力値チェック
		working_time.setText(dfw.format(su.getWorking_time()));	

		working_time.addFocusListener(this);
		contentPane.add(working_time);
		
		//ラベル
        JLabel lbl10 = new JLabel();
		lbl10.setText("時間");
		lbl10.setBounds(200, 200, 100, 28);
		contentPane.add(lbl10);
		
		//ラベル
        JLabel lbl11 = new JLabel();
		lbl11.setText("単価");
		lbl11.setBounds(10, 230, 100, 28);
		contentPane.add(lbl11);

		//単価
		lblunitcost = new JLabel();
		
		lblunitcost.setText(unitcost_Cal());
		lblunitcost.setBounds(110, 230, 80, 28);
		lblunitcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lblunitcost);
		
		//ラベル
        JLabel lbl12 = new JLabel();
		lbl12.setText("円／秒");
		lbl12.setBounds(200, 230, 100, 28);
		contentPane.add(lbl12);
		
		//*****************************
		//* 表示レベル１
		//*****************************
		
		//ラベル
        JLabel lbl13 = new JLabel();
		lbl13.setText("表示レベル１");
		lbl13.setBounds(10, 270, 80, 28);
		lbl13.setOpaque(true);
		lbl13.setBackground(Color.CYAN);
		contentPane.add(lbl13);
		
		//コスト
        lbl_normal_maxcost = new JLabel();
		lbl_normal_maxcost.setText(Integer.toString(su.getNormal_maxcost()));
		lbl_normal_maxcost.setBounds(110, 270, 80, 28);
		lbl_normal_maxcost.setHorizontalAlignment(JLabel.RIGHT);

		contentPane.add(lbl_normal_maxcost);
		
		//ラベル
        JLabel lbl14 = new JLabel();
		lbl14.setText("円");
		lbl14.setBounds(200, 270, 40, 28);
		contentPane.add(lbl14);
		
		//時間の設定
		normal_time = new JFormattedTextField ();
		normal_time.setBounds(250, 270, 70, 28);

		
		//右側の余白を大きくする
		Insets insets = new Insets(new JFormattedTextField().getMargin().top,
						new JFormattedTextField().getMargin().left,
						new JFormattedTextField().getMargin().bottom,
						5);
		
		
		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		normal_time.setDocument(nc);								//入力キー制限
		normal_time.setInputVerifier(new maxtimeVerifier());		//入力値チェック
		normal_time.setText(dfw.format(su.getNormal_maxtime()));	//既に設定した値
		normal_time.setHorizontalAlignment(JLabel.RIGHT);			//右寄せ
		normal_time.setMargin(insets);								//右余白
		
		normal_time.addFocusListener(this);
		contentPane.add(normal_time);

		//ラジオボタン　秒
		rbtn_normal_second 	= new JRadioButton("秒", true);
		rbtn_normal_second.setBounds(330, 270, 40, 28);
		rbtn_normal_second.addItemListener(this);  
		contentPane.add(rbtn_normal_second);

		//ラジオボタン　分
		rbtn_normal_minute 	= new JRadioButton("分", false);
		rbtn_normal_minute.setBounds(370, 270, 40, 28);
		rbtn_normal_minute.addItemListener(this);  
		contentPane.add(rbtn_normal_minute);

		//ラジオボタン　時
		rbtn_normal_hour	 	= new JRadioButton("時", false);
		rbtn_normal_hour.setBounds(410, 270, 40, 28);
		rbtn_normal_hour.addItemListener(this);  
		contentPane.add(rbtn_normal_hour);
		
		//ラジオボタン　日
		rbtn_normal_day	 	= new JRadioButton("日", false);
		rbtn_normal_day.setBounds(450, 270, 40, 28);
		rbtn_normal_day.addItemListener(this);  
		contentPane.add(rbtn_normal_day);

		//ラジオボタン　グループ
		ButtonGroup group_normal = new ButtonGroup();
		group_normal.add(rbtn_normal_second); 
		group_normal.add(rbtn_normal_minute);
		group_normal.add(rbtn_normal_hour); 
		group_normal.add(rbtn_normal_day); 

		//ラジオボタン位置の回復
		initSelectJRadioButton(su.getNormal_kind(),
				rbtn_normal_second,
				rbtn_normal_minute,
				rbtn_normal_hour,
				rbtn_normal_day);
		
		
		//*****************************
		//* 表示レベル２
		//*****************************
		
		//ラベル
        JLabel lbl15 = new JLabel();
		lbl15.setText("表示レベル２");
		lbl15.setBounds(10, 300, 80, 28);
		lbl15.setOpaque(true);
		lbl15.setBackground(Color.GREEN);
		contentPane.add(lbl15);

		//コスト
        lbl_semi_warning_maxcost = new JLabel();
		lbl_semi_warning_maxcost.setText(Integer.toString(su.getSemi_warning_maxcost()));
		lbl_semi_warning_maxcost.setBounds(110, 300, 80, 28);
		lbl_semi_warning_maxcost.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(lbl_semi_warning_maxcost);
		
		//ラベル
        JLabel lbl16 = new JLabel();
		lbl16.setText("円");
		lbl16.setBounds(200, 300, 40, 28);
		contentPane.add(lbl16);
		
		//時間の設定
		semi_warning_time = new JFormattedTextField ();
		semi_warning_time.setBounds(250, 300, 70, 28);

		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		semi_warning_time.setDocument(nc);										//入力キー制限
		semi_warning_time.setInputVerifier(new maxtimeVerifier());				//入力値チェック
		semi_warning_time.setText(dfw.format(su.getSemi_warning_maxtime()));	//既に設定した値
		semi_warning_time.setHorizontalAlignment(JLabel.RIGHT);					//右寄せ
		semi_warning_time.setMargin(insets);									//右余白

		semi_warning_time.addFocusListener(this);
		contentPane.add(semi_warning_time);

		//ラジオボタン　秒
		rbtn_semi_warning_second 	= new JRadioButton("秒", true);
		rbtn_semi_warning_second.setBounds(330, 300, 40, 28);
		rbtn_semi_warning_second.addItemListener(this);  
		contentPane.add(rbtn_semi_warning_second);

		//ラジオボタン　分
		rbtn_semi_warning_minute 	= new JRadioButton("分", false);
		rbtn_semi_warning_minute.setBounds(370, 300, 40, 28);
		rbtn_semi_warning_minute.addItemListener(this);  
		contentPane.add(rbtn_semi_warning_minute);

		//ラジオボタン　時
		rbtn_semi_warning_hour	 	= new JRadioButton("時", false);
		rbtn_semi_warning_hour.setBounds(410, 300, 40, 28);
		rbtn_semi_warning_hour.addItemListener(this);  
		contentPane.add(rbtn_semi_warning_hour);
		
		//ラジオボタン　日
		rbtn_semi_warning_day	 	= new JRadioButton("日", false);
		rbtn_semi_warning_day.setBounds(450, 300, 40, 28);
		rbtn_semi_warning_day.addItemListener(this);  
		contentPane.add(rbtn_semi_warning_day);

		//ラジオボタン　グループ
		ButtonGroup group_semi_warning = new ButtonGroup();
		group_semi_warning.add(rbtn_semi_warning_second); 
		group_semi_warning.add(rbtn_semi_warning_minute);
		group_semi_warning.add(rbtn_semi_warning_hour); 
		group_semi_warning.add(rbtn_semi_warning_day); 		

		//ラジオボタン位置の回復
		initSelectJRadioButton(su.getSemi_warning_kind(),
				rbtn_semi_warning_second,
				rbtn_semi_warning_minute,
				rbtn_semi_warning_hour,
				rbtn_semi_warning_day);
		
		//*****************************
		//* 表示レベル３
		//*****************************
		
		//ラベル
        JLabel lbl17 = new JLabel();
		lbl17.setText("表示レベル３");
		lbl17.setBounds(10, 330, 80, 28);
		lbl17.setOpaque(true);
		lbl17.setBackground(Color.YELLOW);
		contentPane.add(lbl17);

		//コスト
        lbl_warning_maxcost = new JLabel();
		lbl_warning_maxcost.setText(Integer.toString(su.getWarning_maxcost()));
		lbl_warning_maxcost.setBounds(110, 330, 80, 28);
		lbl_warning_maxcost.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(lbl_warning_maxcost);
		
		//ラベル
        JLabel lbl18 = new JLabel();
		lbl18.setText("円");
		lbl18.setBounds(200, 330, 40, 28);
		contentPane.add(lbl18);
		
		//時間の設定
		warning_time = new JFormattedTextField ();
		warning_time.setBounds(250, 330, 70, 28);

		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		warning_time.setDocument(nc);									//入力キー制限
		warning_time.setInputVerifier(new maxtimeVerifier());			//入力値チェック
		warning_time.setText(dfw.format(su.getWarning_maxtime()));		//既に設定した値
		warning_time.setHorizontalAlignment(JLabel.RIGHT);				//右寄せ
		warning_time.setMargin(insets);									//右余白

		warning_time.addFocusListener(this);
		contentPane.add(warning_time);

		//ラジオボタン　秒
		rbtn_warning_second 	= new JRadioButton("秒", true);
		rbtn_warning_second.setBounds(330, 330, 40, 28);
		rbtn_warning_second.addItemListener(this);  
		contentPane.add(rbtn_warning_second);

		//ラジオボタン　分
		rbtn_warning_minute 	= new JRadioButton("分", false);
		rbtn_warning_minute.setBounds(370, 330, 40, 28);
		rbtn_warning_minute.addItemListener(this);  
		contentPane.add(rbtn_warning_minute);

		//ラジオボタン　時
		rbtn_warning_hour	 	= new JRadioButton("時", false);
		rbtn_warning_hour.setBounds(410, 330, 40, 28);
		rbtn_warning_hour.addItemListener(this);  
		contentPane.add(rbtn_warning_hour);
		
		//ラジオボタン　日
		rbtn_warning_day	 	= new JRadioButton("日", false);
		rbtn_warning_day.setBounds(450, 330, 40, 28);
		rbtn_warning_day.addItemListener(this);  
		contentPane.add(rbtn_warning_day);

		//ラジオボタン　グループ
		ButtonGroup group_warning = new ButtonGroup();
		group_warning.add(rbtn_warning_second); 
		group_warning.add(rbtn_warning_minute);
		group_warning.add(rbtn_warning_hour); 
		group_warning.add(rbtn_warning_day); 		

		//ラジオボタン位置の回復
		initSelectJRadioButton(su.getWarning_kind(),
				rbtn_warning_second,
				rbtn_warning_minute,
				rbtn_warning_hour,
				rbtn_warning_day);

		
		//*****************************
		//* 表示レベル４
		//*****************************
		
		//ラベル
        JLabel lbl19 = new JLabel();
		lbl19.setText("表示レベル４");
		lbl19.setBounds(10, 360, 80, 28);
		lbl19.setOpaque(true);
		lbl19.setBackground(Color.PINK);
		contentPane.add(lbl19);

		//コスト
        lbl_semi_abnormal_maxcost = new JLabel();
		lbl_semi_abnormal_maxcost.setText(Integer.toString(su.getSemi_abnormal_maxcost()));
		lbl_semi_abnormal_maxcost.setBounds(110, 360, 80, 28);
		lbl_semi_abnormal_maxcost.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(lbl_semi_abnormal_maxcost);
		
		//ラベル
        JLabel lbl20 = new JLabel();
		lbl20.setText("円");
		lbl20.setBounds(200, 360, 40, 28);
		contentPane.add(lbl20);
		
		//時間の設定
		semi_abnormal_time = new JFormattedTextField ();
		semi_abnormal_time.setBounds(250, 360, 70, 28);

		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		semi_abnormal_time.setDocument(nc);										//入力キー制限
		semi_abnormal_time.setInputVerifier(new maxtimeVerifier());				//入力値チェック
		semi_abnormal_time.setText(dfw.format(su.getSemi_abnormal_maxtime()));	//既に設定した値
		semi_abnormal_time.setHorizontalAlignment(JLabel.RIGHT);				//右寄せ
		semi_abnormal_time.setMargin(insets);									//右余白

		semi_abnormal_time.addFocusListener(this);
		contentPane.add(semi_abnormal_time);

		//ラジオボタン　秒
		rbtn_semi_abnormal_second 	= new JRadioButton("秒", true);
		rbtn_semi_abnormal_second.setBounds(330, 360, 40, 28);
		rbtn_semi_abnormal_second.addItemListener(this);  
		contentPane.add(rbtn_semi_abnormal_second);

		//ラジオボタン　分
		rbtn_semi_abnormal_minute 	= new JRadioButton("分", false);
		rbtn_semi_abnormal_minute.setBounds(370, 360, 40, 28);
		rbtn_semi_abnormal_minute.addItemListener(this);  
		contentPane.add(rbtn_semi_abnormal_minute);

		//ラジオボタン　時
		rbtn_semi_abnormal_hour	 	= new JRadioButton("時", false);
		rbtn_semi_abnormal_hour.setBounds(410, 360, 40, 28);
		rbtn_semi_abnormal_hour.addItemListener(this);  
		contentPane.add(rbtn_semi_abnormal_hour);
		
		//ラジオボタン　日
		rbtn_semi_abnormal_day	 	= new JRadioButton("日", false);
		rbtn_semi_abnormal_day.setBounds(450, 360, 40, 28);
		rbtn_semi_abnormal_day.addItemListener(this);  
		contentPane.add(rbtn_semi_abnormal_day);

		//ラジオボタン　グループ
		ButtonGroup group_semi_abnormal = new ButtonGroup();
		group_semi_abnormal.add(rbtn_semi_abnormal_second); 
		group_semi_abnormal.add(rbtn_semi_abnormal_minute);
		group_semi_abnormal.add(rbtn_semi_abnormal_hour); 
		group_semi_abnormal.add(rbtn_semi_abnormal_day); 		

		//ラジオボタン位置の回復
		initSelectJRadioButton(su.getSemi_abnormal_kind(),
				rbtn_semi_abnormal_second,
				rbtn_semi_abnormal_minute,
				rbtn_semi_abnormal_hour,
				rbtn_semi_abnormal_day);		

		
		//*****************************
		//* 表示レベル５
		//*****************************
		
		//ラベル
        JLabel lbl21 = new JLabel();
		lbl21.setText("表示レベル５");
		lbl21.setBounds(10, 390, 80, 28);
		lbl21.setOpaque(true);
		lbl21.setBackground(Color.MAGENTA);
		contentPane.add(lbl21);

		//コスト
        lbl_abnormal_maxcost = new JLabel();
		lbl_abnormal_maxcost.setText(Integer.toString(su.getAbnormal_maxcost()));
		lbl_abnormal_maxcost.setBounds(110, 390, 80, 28);
		lbl_abnormal_maxcost.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(lbl_abnormal_maxcost);
		
		//ラベル
        JLabel lbl22 = new JLabel();
		lbl22.setText("円");
		lbl22.setBounds(200, 390, 40, 28);
		contentPane.add(lbl22);
		
		//時間の設定
		abnormal_time = new JFormattedTextField ();
		abnormal_time.setBounds(250, 390, 70, 28);

		dfw = new DecimalFormat("#0.00");
		nc = new Tool_Numeric_InputKey_check();
		abnormal_time.setDocument(nc);									//入力キー制限
		abnormal_time.setInputVerifier(new maxtimeVerifier());			//入力値チェック
		abnormal_time.setText(dfw.format(su.getAbnormal_maxtime()));	//既に設定した値
		abnormal_time.setHorizontalAlignment(JLabel.RIGHT);				//右寄せ
		abnormal_time.setMargin(insets);								//右余白

		abnormal_time.addFocusListener(this);
		contentPane.add(abnormal_time);

		//ラジオボタン　秒
		rbtn_abnormal_second 	= new JRadioButton("秒", true);
		rbtn_abnormal_second.setBounds(330, 390, 40, 28);
		rbtn_abnormal_second.addItemListener(this);  
		contentPane.add(rbtn_abnormal_second);

		//ラジオボタン　分
		rbtn_abnormal_minute 	= new JRadioButton("分", false);
		rbtn_abnormal_minute.setBounds(370, 390, 40, 28);
		rbtn_abnormal_minute.addItemListener(this);  
		contentPane.add(rbtn_abnormal_minute);

		//ラジオボタン　時
		rbtn_abnormal_hour	 	= new JRadioButton("時", false);
		rbtn_abnormal_hour.setBounds(410, 390, 40, 28);
		rbtn_abnormal_hour.addItemListener(this);  
		contentPane.add(rbtn_abnormal_hour);
		
		//ラジオボタン　日
		rbtn_abnormal_day	 	= new JRadioButton("日", false);
		rbtn_abnormal_day.setBounds(450, 390, 40, 28);
		rbtn_abnormal_day.addItemListener(this);  
		contentPane.add(rbtn_abnormal_day);

		//ラジオボタン　グループ
		ButtonGroup group_abnormal = new ButtonGroup();
		group_abnormal.add(rbtn_abnormal_second); 
		group_abnormal.add(rbtn_abnormal_minute);
		group_abnormal.add(rbtn_abnormal_hour); 
		group_abnormal.add(rbtn_abnormal_day); 		

		//ラジオボタン位置の回復
		initSelectJRadioButton(su.getAbnormal_kind(),
				rbtn_abnormal_second,
				rbtn_abnormal_minute,
				rbtn_abnormal_hour,
				rbtn_abnormal_day);				
		
        //確定ボタン
		btn_OK = new JButton("確定");
		btn_OK.setBounds(510, 360, 70, 50);
		contentPane.add(btn_OK);
		btn_OK.addActionListener(this);	

        //取消ボタン
		btn_Cancel = new JButton("取消");
		btn_Cancel.setBounds(610, 360, 70, 50);
		contentPane.add(btn_Cancel);
		btn_Cancel.addActionListener(this);
		

		//画面表示
		this.setVisible(true);
	   
	   }

	public void itemStateChanged(ItemEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
		//役割変更
		if(	e.getSource() == combposition && e.getStateChange() == ItemEvent.SELECTED){
			
			change_cost(e.getItem().toString());

			//単価変更
			lblunitcost.setText(unitcost_Cal());
			//表示レベル１変更
			changeRadioButton(rbtn_normal_second,
					rbtn_normal_minute,
					rbtn_normal_hour,
					rbtn_normal_day,
					normal_time,
					lbl_normal_maxcost);
			//表示レベル２変更
			changeRadioButton(rbtn_semi_warning_second,
					rbtn_semi_warning_minute,
					rbtn_semi_warning_hour,
					rbtn_semi_warning_day,
					semi_warning_time,
					lbl_semi_warning_maxcost);
			//表示レベル３変更
			changeRadioButton(rbtn_warning_second,
					rbtn_warning_minute,
					rbtn_warning_hour,
					rbtn_warning_day,
					warning_time,
					lbl_warning_maxcost);
			//表示レベル４変更
			changeRadioButton(rbtn_semi_abnormal_second,
					rbtn_semi_abnormal_minute,
					rbtn_semi_abnormal_hour,
					rbtn_semi_abnormal_day,
					semi_abnormal_time,
					lbl_semi_abnormal_maxcost);
			//表示レベル５変更
			changeRadioButton(rbtn_abnormal_second,
					rbtn_abnormal_minute,
					rbtn_abnormal_hour,
					rbtn_abnormal_day,
					abnormal_time,
					lbl_abnormal_maxcost);
		
		
		}
		//単価変更
		if(	e.getSource() == this.combpos_cost && e.getStateChange() == ItemEvent.SELECTED){
			//単価変更
			lblunitcost.setText(unitcost_Cal());
			//表示レベル１変更
			//表示レベル１変更
			changeRadioButton(rbtn_normal_second,
					rbtn_normal_minute,
					rbtn_normal_hour,
					rbtn_normal_day,
					normal_time,
					lbl_normal_maxcost);
			//表示レベル２変更
			changeRadioButton(rbtn_semi_warning_second,
					rbtn_semi_warning_minute,
					rbtn_semi_warning_hour,
					rbtn_semi_warning_day,
					semi_warning_time,
					lbl_semi_warning_maxcost);
			//表示レベル３変更
			changeRadioButton(rbtn_warning_second,
					rbtn_warning_minute,
					rbtn_warning_hour,
					rbtn_warning_day,
					warning_time,
					lbl_warning_maxcost);
			//表示レベル４変更
			changeRadioButton(rbtn_semi_abnormal_second,
					rbtn_semi_abnormal_minute,
					rbtn_semi_abnormal_hour,
					rbtn_semi_abnormal_day,
					semi_abnormal_time,
					lbl_semi_abnormal_maxcost);
			//表示レベル５変更
			changeRadioButton(rbtn_abnormal_second,
					rbtn_abnormal_minute,
					rbtn_abnormal_hour,
					rbtn_abnormal_day,
					abnormal_time,
					lbl_abnormal_maxcost);		
		}
		//標準単価表示
		else if(	e.getSource() == chkbox_std ){
			//オン
			if(chkbox_std.isSelected() == true){
				combpos_cost.setEnabled(false);
				change_cost(combposition.getSelectedItem().toString());				
			}
			//オフ
			else{
				combpos_cost.setEnabled(true);
			}
			
		}
		//表示レベル１のラジオボタンを変更
		else if(	e.getSource() == rbtn_normal_second ||
					e.getSource() == rbtn_normal_minute ||
					e.getSource() == rbtn_normal_hour   ||
					e.getSource() == rbtn_normal_day){
			//表示レベル１変更
			changeRadioButton(rbtn_normal_second,
					rbtn_normal_minute,
					rbtn_normal_hour,
					rbtn_normal_day,
					normal_time,
					lbl_normal_maxcost);
			
		}
		//表示レベル２のラジオボタンを変更
		else if(	e.getSource() == rbtn_semi_warning_second ||
				e.getSource() == rbtn_semi_warning_minute ||
				e.getSource() == rbtn_semi_warning_hour   ||
				e.getSource() == rbtn_semi_warning_day){
		//表示レベル２変更
			changeRadioButton(rbtn_semi_warning_second,
					rbtn_semi_warning_minute,
					rbtn_semi_warning_hour,
					rbtn_semi_warning_day,
					semi_warning_time,
					lbl_semi_warning_maxcost);
		}
		//表示レベル３のラジオボタンを変更
		else if(	e.getSource() == rbtn_warning_second ||
				e.getSource() == rbtn_warning_minute ||
				e.getSource() == rbtn_warning_hour   ||
				e.getSource() == rbtn_warning_day){
		//表示レベル３変更
			changeRadioButton(rbtn_warning_second,
					rbtn_warning_minute,
					rbtn_warning_hour,
					rbtn_warning_day,
					warning_time,
					lbl_warning_maxcost);
		}
		//表示レベル４のラジオボタンを変更
		else if(	e.getSource() == rbtn_semi_abnormal_second ||
				e.getSource() == rbtn_semi_abnormal_minute ||
				e.getSource() == rbtn_semi_abnormal_hour   ||
				e.getSource() == rbtn_semi_abnormal_day){
			//表示レベル４変更
			changeRadioButton(rbtn_semi_abnormal_second,
					rbtn_semi_abnormal_minute,
					rbtn_semi_abnormal_hour,
					rbtn_semi_abnormal_day,
					semi_abnormal_time,
					lbl_semi_abnormal_maxcost);
		
		}
		//表示レベル５のラジオボタンを変更
		else if(	e.getSource() == rbtn_abnormal_second ||
				e.getSource() == rbtn_abnormal_minute ||
				e.getSource() == rbtn_abnormal_hour   ||
				e.getSource() == rbtn_abnormal_day){
			//表示レベル５変更
			changeRadioButton(rbtn_abnormal_second,
					rbtn_abnormal_minute,
					rbtn_abnormal_hour,
					rbtn_abnormal_day,
					abnormal_time,
					lbl_abnormal_maxcost);
		
		}
		
	}


	private void change_cost(String posision){
		int count = 0;
		for(int i=0;i<pos_cost_data.length;i++){
			
			
			if(pos_cost_data[i].getPosition().equals(posision)){
				count++;
			}
		}
		combpos_cost.removeAllItems();
		
		for(int i=0;i<pos_cost_data.length;i++){
			if(pos_cost_data[i].getPosition().equals(posision)){
//				combpos_cost.addItem(pos_cost_data[i].getUnitcost());
				
				combpos_cost.addItem(fmtnumber.format(pos_cost_data[i].getUnitcost()) );

			}
		}
		combpos_cost.setSelectedItem(fmtnumber.format(position_data[combposition.getSelectedIndex()].getUnitcost()));
	}

	public void actionPerformed(ActionEvent e) {
   		if(e.getSource() == btn_OK ){
    		int ans = JOptionPane.showConfirmDialog(this, 
    				"ユーザー設定を変更しますか？",
    				"ユーザー設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans == JOptionPane.CANCEL_OPTION){
    			return;
    		}
    		Struct_UnitCost new_value = new Struct_UnitCost();
    		new_value.setPosition(combposition.getSelectedItem().toString());

    		try {
				Number num = fmtnumber.parse(combpos_cost.getSelectedItem().toString());
	    		new_value.setUnitcost(num.intValue());
			} catch (ParseException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
			}

			su.setStruct_unitccost(new_value);			//役割と（月）単価

			su.setUserid(userid.getText());				//ユーザーＩＤ
			su.setUser_fullname(username.getText());	//ユーザー名称
			su.setNode(node.getText());					//アドレス（ノード）
			su.setBusiness_year_days(sbyd.getDays());	//年間営業日数
			
			//１日の労働時間
			try {
				NumberFormat StringToDouble = NumberFormat.getInstance();
				su.setWorking_time(StringToDouble.parse(working_time.getText()).doubleValue());
			} catch (ParseException e2) {
				// TODO 自動生成された catch ブロック
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
		    	return;
			}
			
			su.setUnit_cost(unitcost);					//（秒）単価
    		
			//レベル１、２，３、４，５の最大時間
    		try {
    			Number num = fmtnumber.parse(normal_time.getText());
    			su.setNormal_maxtime(num.doubleValue());
    			num = fmtnumber.parse(semi_warning_time.getText());
    			su.setSemi_warning_maxtime(num.doubleValue());
    			num = fmtnumber.parse(warning_time.getText());
    			su.setWarning_maxtime(num.doubleValue());
    			num = fmtnumber.parse(semi_abnormal_time.getText());
    			su.setSemi_abnormal_maxtime(num.doubleValue());
    			num = fmtnumber.parse(abnormal_time.getText());
    			su.setAbnormal_maxtime(num.doubleValue());
			} catch (ParseException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
			}

    		//レベル１の表示種類
    		su.setNormal_kind(getKind(rbtn_normal_second,
					rbtn_normal_minute,
					rbtn_normal_hour,
					rbtn_normal_day));
    		
    		//レベル２の表示種類
    		su.setSemi_warning_kind(getKind(rbtn_semi_warning_second,
					rbtn_semi_warning_minute,
					rbtn_semi_warning_hour,
					rbtn_semi_warning_day));

    		//レベル３の表示種類
    		su.setWarning_kind(getKind(rbtn_warning_second,
					rbtn_warning_minute,
					rbtn_warning_hour,
					rbtn_warning_day));

    		//レベル４の表示種類
    		su.setSemi_abnormal_kind(getKind(rbtn_semi_abnormal_second,
					rbtn_semi_abnormal_minute,
					rbtn_semi_abnormal_hour,
					rbtn_semi_abnormal_day));
    		
    		//レベル５の表示種類
    		su.setAbnormal_kind(getKind(rbtn_abnormal_second,
					rbtn_abnormal_minute,
					rbtn_abnormal_hour,
					rbtn_abnormal_day));

    		
    		//表示レベル１，２，３のコスト
    		try {
        		Number num_normal 			= fmtnumber.parse(lbl_normal_maxcost.getText());
    			Number num_semi_warning		= fmtnumber.parse(lbl_semi_warning_maxcost.getText());
    			Number num_warning 			= fmtnumber.parse(lbl_warning_maxcost.getText());
    			Number num_semi_abnormal 	= fmtnumber.parse(lbl_semi_abnormal_maxcost.getText());
    			Number num_abnormal 		= fmtnumber.parse(lbl_abnormal_maxcost.getText());

    			if(num_normal.intValue() >= num_semi_warning.intValue()){
       	    		JOptionPane.showMessageDialog(this, "[表示レベル１]コストより[表示レベル２]コストを大きくしてください", 
       	    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    				return;
    			}
    			if(num_semi_warning.intValue() >= num_warning.intValue()){
       	    		JOptionPane.showMessageDialog(this, "[表示レベル２]コストより[表示レベル３]コストを大きくしてください", 
       	    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    				return;
    			}
    			if(num_warning.intValue() >= num_semi_abnormal.intValue()){
       	    		JOptionPane.showMessageDialog(this, "[表示レベル３]コストより[表示レベル４]コストを大きくしてください", 
       	    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    				return;
    			}
    			if(num_semi_abnormal.intValue() >= num_abnormal.intValue()){
       	    		JOptionPane.showMessageDialog(this, "[表示レベル４]コストより[表示レベル５]コストを大きくしてください", 
       	    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    				return;
    			}
    			
    			su.setNormal_maxcost(num_normal.intValue());
    			su.setSemi_warning_maxcost(num_semi_warning.intValue());
    			su.setWarning_maxcost(num_warning.intValue());
    			su.setSemi_abnormal_maxcost(num_semi_abnormal.intValue());
    			su.setAbnormal_maxcost(num_abnormal.intValue());
			} catch (ParseException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
			}


    		//標準単価の強制表示切替
    		if(chkbox_std.isSelected() ==true){
        		su.setStd_chk(true);
    		}
    		else{
        		su.setStd_chk(false);
    		}
    		
    		user_info.setStruct_User(su);
    		user_info.saveXml();
    		JOptionPane.showMessageDialog(this, "ユーザー設定を変更しました", 
    				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 

    		
    		int ans2 = JOptionPane.showConfirmDialog(this, 
    				"コスト表示レベルを変更した場合、表示データを書き換える必要があります.\n"+
    				"コスト表示データを書き換えますか？",
    				"ユーザー設定",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
    		if(ans2 == JOptionPane.OK_OPTION){
        		rewrite_cost();
        		JOptionPane.showMessageDialog(this, "コスト表示データを書き換えました", 
        				"ユーザー設定", JOptionPane.INFORMATION_MESSAGE); 
    		}
    		
    		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		
   		
   		
   		}
   		else if(e.getSource() == btn_Cancel){
   	   		//ウィンドウを閉じる
   	   		try {
   				this.setClosed(true);
   			} catch (PropertyVetoException e1) {
   				// TODO 自動生成された catch ブロック
   				e1.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		    	return;
   			}
   		}
		
	}


	//フォーカス
	public void focusGained(FocusEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void focusLost(FocusEvent e) {
		//オプションメッセージ表示中はロストフォーカス処理しない
		if ( e.isTemporary() == true){ 
			return; 
		} 

		//労働時間の変更
		if( e.getSource() == working_time){
			//単価変更
			lblunitcost.setText(unitcost_Cal());
			//表示レベル１変更
			changeRadioButton(rbtn_normal_second,
					rbtn_normal_minute,
					rbtn_normal_hour,
					rbtn_normal_day,
					normal_time,
					lbl_normal_maxcost);
			//表示レベル２変更
			changeRadioButton(rbtn_semi_warning_second,
					rbtn_semi_warning_minute,
					rbtn_semi_warning_hour,
					rbtn_semi_warning_day,
					semi_warning_time,
					lbl_semi_warning_maxcost);
			//表示レベル３変更
			changeRadioButton(rbtn_warning_second,
					rbtn_warning_minute,
					rbtn_warning_hour,
					rbtn_warning_day,
					warning_time,
					lbl_warning_maxcost);
			//表示レベル４変更
			changeRadioButton(rbtn_semi_abnormal_second,
					rbtn_semi_abnormal_minute,
					rbtn_semi_abnormal_hour,
					rbtn_semi_abnormal_day,
					semi_abnormal_time,
					lbl_semi_abnormal_maxcost);
			//表示レベル５変更
			changeRadioButton(rbtn_abnormal_second,
					rbtn_abnormal_minute,
					rbtn_abnormal_hour,
					rbtn_abnormal_day,
					abnormal_time,
					lbl_abnormal_maxcost);
			
		}
		//表示レベル１の時間変更
		else if( e.getSource() == normal_time){
			changeRadioButton(rbtn_normal_second,
								rbtn_normal_minute,
								rbtn_normal_hour,
								rbtn_normal_day,
								normal_time,
								lbl_normal_maxcost);
			
		}
		//表示レベル２の時間変更
		else if( e.getSource() == semi_warning_time){
			changeRadioButton(rbtn_semi_warning_second,
								rbtn_semi_warning_minute,
								rbtn_semi_warning_hour,
								rbtn_semi_warning_day,
								semi_warning_time,
								lbl_semi_warning_maxcost);
			
		}
		//表示レベル３の時間変更
		else if( e.getSource() == warning_time){
			changeRadioButton(rbtn_warning_second,
								rbtn_warning_minute,
								rbtn_warning_hour,
								rbtn_warning_day,
								warning_time,
								lbl_warning_maxcost);
			
		}
		//表示レベル４の時間変更
		else if( e.getSource() == semi_abnormal_time){
			changeRadioButton(rbtn_semi_abnormal_second,
								rbtn_semi_abnormal_minute,
								rbtn_semi_abnormal_hour,
								rbtn_semi_abnormal_day,
								semi_abnormal_time,
								lbl_semi_abnormal_maxcost);
			
		}
		//表示レベル５の時間変更
		else if( e.getSource() == abnormal_time){
			changeRadioButton(rbtn_abnormal_second,
								rbtn_abnormal_minute,
								rbtn_abnormal_hour,
								rbtn_abnormal_day,
								abnormal_time,
								lbl_abnormal_maxcost);
			
		}
		
	}	



	static class MyVerifier extends InputVerifier{
		public boolean verify(JComponent input){
			boolean flg = true;
			JFormattedTextField f = (JFormattedTextField)input;
			String s = f.getText();
	
			//入力フィールドのニューメリックチェック
			Tool_Numeric_check tnc = new Tool_Numeric_check(s);
			tnc.setInteger_digit((byte) 2);		//整数２桁
			tnc.setDecimal_digit((byte) 2);		//少数２桁
			tnc.setMinvalue(1);					//最小値1.00
			tnc.setMaxvalue(24);				//最大値24.00
			
			String msg = tnc.floatCheck();
			if(msg  != null){
		    		JOptionPane.showMessageDialog(null, msg, 
		    				"１日の労働時間", JOptionPane.WARNING_MESSAGE); 
				flg = false;
				f.setText("00.00");
				return flg;
			}
			//表示正規化
			DecimalFormat dfw = new DecimalFormat("#0.00");
			f.setText(dfw.format(Float.parseFloat(f.getText())));
			return flg;
		}
	}
	
	static class maxtimeVerifier extends InputVerifier{
		public boolean verify(JComponent input){
			boolean flg = true;
			JFormattedTextField f = (JFormattedTextField)input;
			String s = f.getText();
	
			//入力フィールドのニューメリックチェック
			Tool_Numeric_check tnc = new Tool_Numeric_check(s);
			tnc.setInteger_digit((byte) 3);		//整数３桁
			tnc.setDecimal_digit((byte) 2);		//少数２桁
			tnc.setMinvalue(1);					//最小値1
			tnc.setMaxvalue(999);				//最大値999
			
			String msg = tnc.floatCheck();
			if(msg  != null){
		    		JOptionPane.showMessageDialog(null, msg, 
		    				"表示レベルの最大時間", JOptionPane.WARNING_MESSAGE); 
				flg = false;
				f.setText("0.00");
				return flg;
			}
			//表示正規化
			DecimalFormat dfw = new DecimalFormat("#,##0.00");
			f.setText(dfw.format(Float.parseFloat(f.getText())));
			return flg;
		}
	}

	
	private String unitcost_Cal(){
		//単価算出：月単価　÷　（年間日数　×　１日の労働時間　×　６０分　６０秒　÷　１２ヶ月）
		NumberFormat StringToDouble = NumberFormat.getInstance();
		double monthlycost = 0;
		try {
			monthlycost = StringToDouble.parse(combpos_cost.getSelectedItem().toString()).doubleValue();
		} catch (ParseException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return("0");
		}

		//労働時間の変換
		double workingtime = 0;
		try {
			workingtime = StringToDouble.parse(working_time.getText()).doubleValue();
		} catch (ParseException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return("0");
		}
		
		
		unitcost = monthlycost /	(sbyd.getDays() * workingtime*60*60/12);

		//少数桁第４位で四捨五入
		BigDecimal bd = new BigDecimal(String.valueOf(unitcost));
		unitcost = bd.setScale(7, BigDecimal.ROUND_HALF_UP) .doubleValue();
		DecimalFormat dfuc = new DecimalFormat("#0.0000000");
		return(dfuc.format(unitcost));
	}

	private String maxcost_Cal(JFormattedTextField time,double adjust){
		//テキスト抽出
		NumberFormat StringToDouble = NumberFormat.getInstance();
		Double second;
		try {
			second = StringToDouble.parse(time.getText()).doubleValue();
		} catch (ParseException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
	    	second = 0.0;
		}
			
		//コスト算出　
		Double cost = unitcost * second * adjust;

		BigDecimal bd = new BigDecimal(String.valueOf(cost));
		cost = bd.setScale(0, BigDecimal.ROUND_HALF_UP) .doubleValue();
		DecimalFormat dfuc = new DecimalFormat("#,##0");
		return dfuc.format(cost);
	}

	//表示レベルのコスト計算＆表示
	private void changeRadioButton(JRadioButton rbtn_second,	
									JRadioButton rbtn_minute,
									JRadioButton rbtn_hour,
									JRadioButton rbtn_day,
									JFormattedTextField time,
										JLabel label_cost){
	
		//
		if(rbtn_second.isSelected() == true){
			label_cost.setText(maxcost_Cal(time,1));	
		}
		else if(rbtn_minute.isSelected() == true){
			label_cost.setText(maxcost_Cal(time,60));	
			
		}
		else if(rbtn_hour.isSelected() == true){
			label_cost.setText(maxcost_Cal(time,60*60));	
			
		}
		else if(rbtn_day.isSelected() == true){
//			label_cost.setText(maxcost_Cal(time,60*60*24));	
			NumberFormat StringToDouble = NumberFormat.getInstance();

			try {
				label_cost.setText(maxcost_Cal(time,60*60* StringToDouble.parse(working_time.getText()).doubleValue()));
			} catch (ParseException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}	
		}
	}
	
	private void initSelectJRadioButton(String kind,
											JRadioButton rbtn_second,	
											JRadioButton rbtn_minute,
											JRadioButton rbtn_hour,
											JRadioButton rbtn_day){
		if(kind.equals("s")){
			rbtn_second.setSelected( true);
		}
		else if(kind.equals("m")){
			rbtn_minute.setSelected( true);
		}
		else if(kind.equals("h")){
			rbtn_hour.setSelected( true);
		}
		else if(kind.equals("d")){
			rbtn_day.setSelected( true);
		}
	}
	
	private String getKind(JRadioButton rbtn_second,	
							JRadioButton rbtn_minute,
							JRadioButton rbtn_hour,
							JRadioButton rbtn_day){
		if(rbtn_second.isSelected() == true){
			return "s";	
		}
		else if(rbtn_minute.isSelected() == true){
			return "m";	
		}
		else if(rbtn_hour.isSelected() == true){
			return "h";	
		}
		else if(rbtn_day.isSelected() == true){
			return "d";	
		}
		return "s";	
	}

	
	//コスト表示の書き換え
	private void rewrite_cost(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();

		
		//プロジェクトの取得
		Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
		tep.loadXml();
		String[] array_project = tep.get_project();
		
		//プロジェクトのループ
		for(int i=0 ; i<array_project.length ; i++){
    		//********************************************************
   	    	//* 送信　コストダイジェスト 書き換え
   	    	//********************************************************
    		Tool_Cost_Digest_IO tcd = new Tool_Cost_Digest_IO (addr.getDir_current() + 
																addr.getDir_project() + 
																array_project[i] +
																addr.getDir_costsend() +
																addr.getFile_cost_digest());
    		tcd.loadXml();
    		ArrayList<Struct_Cost_Digest> array_Cost_Digest = tcd.getdata();
    		if(array_Cost_Digest != null && array_Cost_Digest.size() > 0){
        		for(int j=0 ; j<array_Cost_Digest.size() ; j++){
    	    		//更新データの取得
    	    		Struct_Cost_Digest scd = array_Cost_Digest.get(j);
    	    		
    		    	//送信コストの再設定
    	    		array_Cost_Digest.get(j).getSend_cost().setMaxvalue(su.getMaxValue(scd.getSend_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getSend_cost().setMode(su.getMode(scd.getSend_cost().getRealvalue()));  		
    	    		
    		    	//受信コストの再設定
    	    		array_Cost_Digest.get(j).getRecieve_cost().setMaxvalue(su.getMaxValue(scd.getRecieve_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getRecieve_cost().setMode(su.getMode(scd.getRecieve_cost().getRealvalue()));  		
    	    		
    		    	//総コストの再設定
    	    		array_Cost_Digest.get(j).getTotal_cost().setMaxvalue(su.getMaxValue(scd.getTotal_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getTotal_cost().setMode(su.getMode(scd.getTotal_cost().getRealvalue()));  		
    	    		
    		    	//評価額の再設定
    	    		array_Cost_Digest.get(j).getEval_value().setMaxvalue(su.getMaxValue(scd.getEval_value().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getEval_value().setMode(su.getMode(scd.getEval_value().getRealvalue()));  		

    		    	//評価後コストの再設定
    	    		array_Cost_Digest.get(j).getAteval_cost().setMaxvalue(su.getMaxValue(scd.getAteval_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getAteval_cost().setMode(su.getMode(scd.getAteval_cost().getRealvalue()));  		

        		}
        		
        		tcd.putdata(array_Cost_Digest);
    			tcd.saveXml();
    			
    		}

    		//********************************************************
   	    	//* 受信　コストダイジェスト 書き換え
   	    	//********************************************************
    		tcd = new Tool_Cost_Digest_IO (addr.getDir_current() + 
																addr.getDir_project() + 
																array_project[i] +
																addr.getDir_costrecive() +
																addr.getFile_cost_digest());
    		tcd.loadXml();
    		array_Cost_Digest = tcd.getdata();
    		if(array_Cost_Digest != null && array_Cost_Digest.size() > 0){
        		for(int j=0 ; j<array_Cost_Digest.size() ; j++){
    	    		//更新データの取得
    	    		Struct_Cost_Digest scd = array_Cost_Digest.get(j);
    	    		
    		    	//送信コストの再設定
    	    		array_Cost_Digest.get(j).getSend_cost().setMaxvalue(su.getMaxValue(scd.getSend_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getSend_cost().setMode(su.getMode(scd.getSend_cost().getRealvalue()));  		
    	    		
    		    	//受信コストの再設定
    	    		array_Cost_Digest.get(j).getRecieve_cost().setMaxvalue(su.getMaxValue(scd.getRecieve_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getRecieve_cost().setMode(su.getMode(scd.getRecieve_cost().getRealvalue()));  		
    	    		
    		    	//総コストの再設定
    	    		array_Cost_Digest.get(j).getTotal_cost().setMaxvalue(su.getMaxValue(scd.getTotal_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getTotal_cost().setMode(su.getMode(scd.getTotal_cost().getRealvalue()));  		
    	    		
    		    	//評価額の再設定
    	    		array_Cost_Digest.get(j).getEval_value().setMaxvalue(su.getMaxValue(scd.getEval_value().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getEval_value().setMode(su.getMode(scd.getEval_value().getRealvalue()));  		

    		    	//評価後コストの再設定
    	    		array_Cost_Digest.get(j).getAteval_cost().setMaxvalue(su.getMaxValue(scd.getAteval_cost().getRealvalue()));  		
    	    		array_Cost_Digest.get(j).getAteval_cost().setMode(su.getMode(scd.getAteval_cost().getRealvalue()));  		

        		}
        		
        		tcd.putdata(array_Cost_Digest);
    			tcd.saveXml();
    			
    		}    		
    		
		}

		
		
	}
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}
	
}
