package report_analysis_cost;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.ArrayList;
import javax.swing.*;
import javax.swing.table.*;

import structure.File_and_Directory_Address;
import structure.Struct_CostBar;
import structure.Struct_Cost_Digest_NumberAdd;
import structure.Struct_Format_Numeric;
import structure.Struct_System_Config;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_LogOut;
import tool.Tool_SortableTableModel;
import tool.Tool_System_Config_IO;


public class Gui_Report_Analysis_Cost_Main extends JFrame implements ComponentListener {
	
    private JPanel contentPane;
    private JScrollPane src;
	
    private JTable table ;
	
    private String mode;
    private String dir;
    private String file;
    private String project;
    private String yyyymm;
	
    private ArrayList arraylist;
	
	//２回クリックを判定
    private int oldrow	=	-2;
    private int nowrow	=	-1;
	
	//ファイル＆ディレクトリ取得
    private File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
    private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
    													addr.getFile_config()).getStruct_System_Config();
	//ログ出力
    private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

    //表示用フォーマット変換
    private Struct_Format_Numeric form_change = new Struct_Format_Numeric(); 
	
	Gui_Report_Analysis_Cost_Main(String mode,		// 1.モード
							String dir,				// 2.ディレクトリ
							String file,			// 3.ファイル
							String project,			// 4.プロジェクト
							String yyyymm){			// 5.集約年月

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}		

		this.setTitle("コスト分析レポート");
		this.setSize(750, 300);
		this.setLocation(50, 50);
		
		this.mode		=	mode;
		this.dir		=	dir;
		this.file		=	file;
		this.project	= project;
		this.yyyymm		=	yyyymm;

		Tool_Cost_Digest_IO t = new Tool_Cost_Digest_IO ( dir 	 + file);
		t.loadXml();
		
		arraylist = t.getdata();
		
		Tool_SortableTableModel sortModel;
		
		//０件データの場合
		if(arraylist == null || arraylist.size() == 0){
		   	sortModel = new Tool_SortableTableModel(new Struct_Cost_Digest_NumberAdd().getColData_short(),0);
		}
		
		//１件以上データがある
		else{

			t.Number_add_Make();
			arraylist = t.Number_add_getdata();
			sortModel = new Tool_SortableTableModel(t.Number_add_getObj_short() ,
								new Struct_Cost_Digest_NumberAdd().getColData_short())	
									{public boolean isCellEditable(int row, int column) 
									//パラメータ：順番
									{	Message_Submit( Integer.valueOf(getValueAt(row, 0).toString()).intValue() -1);
											return false;
								}
							};
		
		
		}

		
		
		table = new JTable();
	   	table.setModel(sortModel);
	   	
	   	//ソート
	   	sortModel.addMouseListenerToHeaderInTable(table);

	   	//*******************************
	   	//* テーブルの表示設定
	   	//*******************************
	   	table_Config(table);


    	if(mode.equals( addr.getNode_send())){
    	   	//*******************************
    	   	//* テーブルの表示設定
    	   	//*******************************
    		if(table.getRowCount() > 0){
    			//書き込みコストのセルに赤枠を付加する
    			Struct_CostBar w_cell = (Struct_CostBar) table.getValueAt(table.getRowCount()-1, 5);
    			w_cell.setOutline((byte) 1);
    		    table.setValueAt(w_cell, table.getRowCount()-1, 5);
    			
    			//評価額のセルに赤枠を付加する
    			w_cell = (Struct_CostBar) table.getValueAt(table.getRowCount()-1, 8);
    			w_cell.setOutline((byte) 1);
    		    table.setValueAt(w_cell, table.getRowCount()-1, 8);
    			
    		}
    		
    		
    	}
    	else{
    	   	//*******************************
    	   	//* テーブルの表示設定
    	   	//*******************************
    		if(table.getRowCount() > 0){
    			//書き込みコストのカラムセルに青枠を付加する
    			Struct_CostBar w_cell = (Struct_CostBar) table.getValueAt(table.getRowCount()-1, 6);
    			w_cell.setOutline((byte) 2);
    		    table.setValueAt(w_cell, table.getRowCount()-1, 6);
    			
    			//評価額のカラムセルに青枠を付加する
    			w_cell = (Struct_CostBar) table.getValueAt(table.getRowCount()-1, 8);
    			w_cell.setOutline((byte) 2);
    		    table.setValueAt(w_cell, table.getRowCount()-1, 8);    			
    		}
    	}
	   	

        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));

		
		//余白
		contentPane.add(Box.createRigidArea(new Dimension(10,10)));

		//ラベル
		JLabel lbl1 = new JLabel();

		if(mode.equals(addr.getNode_send()) ==true){
			lbl1.setText("あなたの送信メールのコストを表示しています");
		}
		else if(mode.equals(addr.getNode_recive()) ==true){
			lbl1.setText("あなたの受信メールのコストを表示しています");
		}
		else{
			lbl1.setText("コスト詳細表示");
		}
		
		lbl1.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(lbl1);
		
		//余白
		contentPane.add(Box.createRigidArea(new Dimension(10,10)));


		//ラベル　送信番号
		JLabel lbl2 = new JLabel();
		lbl2.setText("基準年月：");
		JLabel lbl3 = new JLabel();
		lbl3.setText(yyyymm);

		//送信番号　横連結
		JPanel pnlYyyymm = new JPanel();
		pnlYyyymm.setLayout(new BoxLayout(pnlYyyymm, BoxLayout.LINE_AXIS));
		pnlYyyymm.add(lbl2);
		pnlYyyymm.add(lbl3);
		pnlYyyymm.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlYyyymm);


		
		//単位
		JLabel lbl10 = new JLabel();
		lbl10.setText("単位／円");
		int height = lbl10.getMaximumSize().height;
		lbl10.setPreferredSize(new Dimension(100,height));
		JPanel pnlUnit = new JPanel();
		pnlUnit.setLayout(new BorderLayout());
		pnlUnit.add(lbl10,BorderLayout.EAST);
		pnlUnit.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlUnit);

		
		//プロジェクトを表示		
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
		src = new JScrollPane(table);
		src.setPreferredSize(new Dimension(Short.MAX_VALUE,Short.MAX_VALUE));
		contentPane.add(src);
		
		JLabel statusBar = new JLabel("★カラム名をクリックするとソートします");
		Font font = statusBar.getFont();
		statusBar.setFont(new Font(font.getFontName(), Font.ITALIC, font.getSize()));
		statusBar.setForeground(Color.MAGENTA);
		contentPane.add(statusBar, BorderLayout.SOUTH);
		
		//アイコン表示
		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon() + addr.getIcon_mailcost());
		this.setIconImage(icon.getImage());

		this.addComponentListener(this);
		this.setVisible(true); 
		
	}

/*	
	private void loadXml(){
		Tool_Cost_Digest_IO t = new Tool_Cost_Digest_IO ( dir 	 + file);
		t.loadXml();
		
		arraylist = t.getdata();
    	
	}	
*/	
	//メイン
	public static void main(String[] args){
		
		String mode 			= null;						// 1.モード
		String dir 				= null;						// 2.ディレクトリ
		String file 			= null;						// 3.ファイル
		String project			= null;						// 4.プロジェクト
		String yyyymm			= null;						// 5.集約年月

		for (int i=0; i<args.length; ++i) {
			if ("--mode".equals(args[i])) {
				mode = args[++i];							// 1.モード
            } 
	        else if ("--dir".equals(args[i])) {
	            dir = args[++i];							// 2.ディレクトリ
	        } 
            else if ("--file".equals(args[i])) {
                file = args[++i];							// 3.ファイル
            }
            else if ("--project".equals(args[i])) {
                project = args[++i];						// 4.プロジェクト
            } 
            else if ("--yyyymm".equals(args[i])) {
                yyyymm = args[++i];							// 5.集約年月
            } 
            else {
            	System.out.println("引数指定の誤り：未知の引数が指定されました");
            }
		}
    	JFrame frame = new Gui_Report_Analysis_Cost_Main(mode,
    												dir,
    												file,
    												project,
    												yyyymm);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

	}

	//コンポーネント変化イベント
	public void componentHidden(ComponentEvent arg0) {
	}
	public void componentMoved(ComponentEvent arg0) {
	}
	public void componentResized(ComponentEvent arg0) {
		
	}
	public void componentShown(ComponentEvent arg0) {
	}
	
	
	private void table_Config(JTable table){
	   	//*******************************
	   	//* テーブルの表示設定
	   	//*******************************

		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);
	   	
	   	//*******************************
	   	//* 順番の設定
	   	//*******************************
	   	TableColumn col;
	   	col = table.getColumnModel().getColumn(0);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
	   	//右寄せ
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);

		
	   	//*******************************
	   	//* ＮＯの設定
	   	//*******************************
	   	col = table.getColumnModel().getColumn(2);
		renderer = new DefaultTableCellRenderer();
	   	//右寄せ
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);

	   	//コスト表示
		for(int i=5;i<10;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_CostBar());
			
		}
		
	}
	
	public void Message_Submit(int row){
		oldrow = nowrow;
		nowrow = row;
		if(oldrow == nowrow){
		    Struct_Cost_Digest_NumberAdd scd_add = (Struct_Cost_Digest_NumberAdd) arraylist.get(row);
		    //参照ファイルが存在しない場合
		    if(scd_add.getFilename() == null || scd_add.getFilename().length() == 0){
		    	return;
		    }
		    //****************************
			//* 表示モードの選択
			//****************************
			String mode = null;
		    String selectvalues[] = {"明細を表示", "ユーザーをまとめて表示","表示中止"};
		    int select = JOptionPane.showOptionDialog(this,
		      "表示方法を選択してください", 
		      "コストレポート", 
		      JOptionPane.YES_NO_OPTION,
		      JOptionPane.QUESTION_MESSAGE,
		      null, 
		      selectvalues, 
		      selectvalues[2]
		    );

		    if(select == 0){
		    	mode = "normal";
		    }
		    else if(select == 1){
		    	mode = "user";
		    }
		    else if(select == 2){
		    	return;
		    }

		    //ソート対策として、順番を取得して、行番号を算出する
		    int sort_row = 	Integer.valueOf(table.getValueAt(row, 0).toString()).intValue()-1;
		    
			//*************************************************
			//* 選択行の書き込みコストのセルに黄枠を付加する
			//*************************************************
			//書き込みコスト
			Struct_CostBar w_cell = (Struct_CostBar) table.getValueAt(sort_row, 5);
			w_cell.setOutline((byte) 103);
		    table.setValueAt(w_cell, sort_row, 5);		    
			//読み取りコスト
			w_cell = (Struct_CostBar) table.getValueAt(sort_row, 6);
			w_cell.setOutline((byte) 113);
		    table.setValueAt(w_cell, sort_row, 6);		    
			//総コスト
			w_cell = (Struct_CostBar) table.getValueAt(sort_row, 7);
			w_cell.setOutline((byte) 113);
		    table.setValueAt(w_cell, sort_row, 7);		    
			//評価額
			w_cell = (Struct_CostBar) table.getValueAt(sort_row, 8);
			w_cell.setOutline((byte) 113);
		    table.setValueAt(w_cell, sort_row, 8);		    
			//評価後コスト
			w_cell = (Struct_CostBar) table.getValueAt(sort_row, 9);
			w_cell.setOutline((byte) 123);
		    table.setValueAt(w_cell, sort_row, 9);		    
		    
		    //黄枠の表示
		    table.repaint();
		    
			//****************************
			//* コストレポートの表示
			//****************************
		    File dummy = new File(dir);
		    String dummy_dir;
		    //送信を選択
		    if(this.mode.equals(addr.getNode_send())){
			   dummy_dir = addr.getDir_current() + 
			   				addr.getDir_project() + 
			   				project + 
			   				addr.getDir_costsend() +  addr.getFs() ;
		    }
		    //受信を選択
		    else{
			    dummy_dir = addr.getDir_current() + 
   							addr.getDir_project() + 
   							project +  
   							addr.getDir_costrecive()+  addr.getFs() ;		    
			}
		
		    ProcessBuilder builder = new ProcessBuilder("java", "-jar",
	    			addr.getDir_current()+addr.getPgm_report_cost(),
    				"--mode",mode,									// 1.モード
					"--dir",dummy_dir,								// 2.ディレクトリ
					"--file",scd_add.getFilename(),					// 3.ファイル
					"--project",project,							// 4.プロジェクト
					"--sendnumber",scd_add.getSendnumber_string(),	// 5.送信番号
					"--subject",scd_add.getSubject(),				// 6.件名
					"--senddate",scd_add.getSend_date(),			// 7.送信日付
					"--sender",scd_add.getSender(),					// 8.送信者
					"--yyyymm",yyyymm								// 9.基準年月
		    );
		    

		    
		    
//		    ProcessBuilder builder = new ProcessBuilder("notepad.exe", "test.txt");

/*		    
    		ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
	    			addr.getDir_current() + addr.getPgm_message(),
    				"--mode","write");
*/		    
		    
    		try {
				Process process = builder.start();
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}

			
		}
		
	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}
	
}
