package report_cost;

import java.awt.*;
import java.awt.event.*;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.*;
import javax.swing.table.*;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Report;
import structure.Struct_Cost_Source;
import structure.Struct_Format_Numeric;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Community_Menber_IO;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Report_Calculate;
import tool.Tool_LogOut;
import tool.Tool_SortableTableModel;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_Report_Cost_Main extends JFrame implements ComponentListener {
	
    JPanel contentPane;
	JScrollPane src;
	
	JTable table ;
	
	String dir;
	String file;
	String project;
	String yyyymm;
	
	ArrayList arraylist;
	

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	//表示用フォーマット変換
	Struct_Format_Numeric form_change = new Struct_Format_Numeric(); 
	
	Gui_Report_Cost_Main(String mode,				// 1.モード
							String dir,				// 2.ディレクトリ
							String file,			// 3.ファイル
							String project,			// 4.プロジェクト
							String sendnumber,		// 5.送信番号
							String subject,			// 6.送信日付
							String senddate,		// 7.送信日付
							String sender,			// 8.送信者
							String yyyymm){			// 9.基準年月
		
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}		

		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "mode      :"+mode) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "dir       :"+dir) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "file      :"+file) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "project   :"+project) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "sendnumber:"+sendnumber) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "subject   :"+subject) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "senddate  :"+senddate) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "sender    :"+sender) ;
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "yyyymm    :"+yyyymm) ;

		
		this.setTitle("コストレポート");
		this.setSize(700, 300);
		this.setLocation(100, 100);
		
		
		this.dir	=	dir;
		this.file	=	file;
		this.project	= project;
		this.yyyymm		=	yyyymm;

		loadXml();
		
		Tool_SortableTableModel sortModel;
		
		//基準年月を指定した場合
		if(yyyymm != null && yyyymm.length() > 0){
			//基準年月以外のレコードを削除する
			arraylist = yyyymm_Exclude(arraylist);
		}
		
		
		//０件データの場合
		if(arraylist == null || arraylist.size() == 0){
			sortModel = new Tool_SortableTableModel(new Struct_Cost_Report().getColData(),0);
		}
		
		//１件以上データがある
		else{
			ArrayList outlist = null;

			if(mode.equals("normal") == true){
				outlist = direct_Set(arraylist);
			}
			else{
				outlist = direct_Set(userGroup_Set(arraylist));
			}
			
			Object[][] Objdata = getObj(outlist);
			sortModel = new Tool_SortableTableModel(Objdata ,new Struct_Cost_Report().getColData());
		
		}
		
		table = new JTable();
	   	table.setModel(sortModel);

	   	//ソート
	   	sortModel.addMouseListenerToHeaderInTable(table);
	   	

	   	//*******************************
	   	//* テーブルの表示設定
	   	//*******************************
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);
	   	
	   	//******************************
	   	//* 順番の設定
	   	//******************************
	   	TableColumn col;
	   	col = table.getColumnModel().getColumn(0);
		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
	   	//右寄せ
		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);
	   	
	   	//******************************
	   	//プログレスバーのセル設定
	   	//******************************
		for(int i=3;i<8;i++){
			col = table.getColumnModel().getColumn(i);
			col.setCellRenderer(new Struct_CostBar());
			
		}
		
		if(yyyymm != null && yyyymm.length() > 0){
			//*************************************************
			//* 合計行の書き込みコストのセルに黄枠を付加する
			//*************************************************
			if(table.getRowCount() != 0){
				int row = table.getRowCount()-1;
				//書き込みコスト
				Struct_CostBar w_cell = (Struct_CostBar) table.getValueAt(row, 3);
				w_cell.setOutline((byte) 103);
			    table.setValueAt(w_cell, row, 3);		    
				//読み取りコスト
				w_cell = (Struct_CostBar) table.getValueAt(row, 4);
				w_cell.setOutline((byte) 113);
			    table.setValueAt(w_cell, row, 4);		    
				//総コスト
				w_cell = (Struct_CostBar) table.getValueAt(row, 5);
				w_cell.setOutline((byte) 113);
			    table.setValueAt(w_cell, row, 5);		    
				//評価額
				w_cell = (Struct_CostBar) table.getValueAt(row, 6);
				w_cell.setOutline((byte) 113);
			    table.setValueAt(w_cell, row, 6);		    
				//評価後コスト
				w_cell = (Struct_CostBar) table.getValueAt(row, 7);
				w_cell.setOutline((byte) 123);
			    table.setValueAt(w_cell, row, 7);				
			}
		}
	    
		
		
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
//        contentPane.setLayout(null);


		
/*		Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(dir + "\\"+ file);
		tcd.loadXml();
		ArrayList array_cost_detail = tcd.getArray_cost_detail();
*/		
		//余白
		contentPane.add(Box.createRigidArea(new Dimension(10,10)));

		//ラベル
		JLabel lbl1 = new JLabel();
		lbl1.setText("コスト詳細表示");
		lbl1.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(lbl1);
		
		//余白
		contentPane.add(Box.createRigidArea(new Dimension(10,10)));
		

		//ラベル　送信番号
		JLabel lbl2 = new JLabel();
		lbl2.setText("送信番号：");
		JLabel lbl3 = new JLabel();
		lbl3.setText(sendnumber);

		//送信番号　横連結
		JPanel pnlSendnumber = new JPanel();
		pnlSendnumber.setLayout(new BoxLayout(pnlSendnumber, BoxLayout.LINE_AXIS));
		pnlSendnumber.add(lbl2);
		pnlSendnumber.add(lbl3);
		pnlSendnumber.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlSendnumber);

		//ラベル　送信番号
		JLabel lbl4 = new JLabel();
		lbl4.setText("件名　　：");
		JLabel lbl5 = new JLabel();
		lbl5.setText(subject);

		//送信番号　横連結
		JPanel pnlSubject = new JPanel();
		pnlSubject.setLayout(new BoxLayout(pnlSubject, BoxLayout.LINE_AXIS));
		pnlSubject.add(lbl4);
		pnlSubject.add(lbl5);
		pnlSubject.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlSubject);
		
		//ラベル　送信者
		JLabel lbl8 = new JLabel();
		lbl8.setText("送信者　：");
		JLabel lbl9 = new JLabel();
		lbl9.setText(sender);

		//送信者　横連結
		JPanel pnlSender = new JPanel();
		pnlSender.setLayout(new BoxLayout(pnlSender, BoxLayout.LINE_AXIS));
		pnlSender.add(lbl8);
		pnlSender.add(lbl9);
		pnlSender.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlSender);

		//ラベル　送信日付
		JLabel lbl6 = new JLabel();
		lbl6.setText("送信日付：");
		JLabel lbl7 = new JLabel();
		lbl7.setText(senddate);

		//送信日付　横連結
		JPanel pnlSenddate = new JPanel();
		pnlSenddate.setLayout(new BoxLayout(pnlSenddate, BoxLayout.LINE_AXIS));
		pnlSenddate.add(lbl6);
		pnlSenddate.add(lbl7);
		pnlSenddate.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlSenddate);
		
		//単位
		JLabel lbl10 = new JLabel();
		lbl10.setText("単位／円");
		int height = lbl10.getMaximumSize().height;
		lbl10.setPreferredSize(new Dimension(100,height));
		JPanel pnlUnit = new JPanel();
		pnlUnit.setLayout(new BorderLayout());
		pnlUnit.add(lbl10,BorderLayout.EAST);
		pnlUnit.setAlignmentX(Component.LEFT_ALIGNMENT);
		contentPane.add(pnlUnit);

		
		//プロジェクトを表示		
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
		src = new JScrollPane(table);
		src.setPreferredSize(new Dimension(Short.MAX_VALUE,Short.MAX_VALUE));
		contentPane.add(src);
		
		JLabel statusBar = new JLabel("★カラム名をクリックするとソートします");
		Font font = statusBar.getFont();
		statusBar.setFont(new Font(font.getFontName(), Font.ITALIC, font.getSize()));
		statusBar.setForeground(Color.MAGENTA);
		contentPane.add(statusBar, BorderLayout.SOUTH);
		
		//アイコン表示
		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon() + addr.getIcon_mailcost());
		this.setIconImage(icon.getImage());

		this.addComponentListener(this);
		this.setVisible(true); 
		
	}

	
	private void loadXml(){
		Tool_Cost_Detail_IO t = new Tool_Cost_Detail_IO (dir +  file);
		t.loadXml();
		
		arraylist = t.getArray_cost_detail();
    	
	}	
	
	//メイン
	public static void main(String[] args){
		String mode 			= null;						// 1.モード
		String dir 				= null;						// 2.ディレクトリ
		String file 			= null;						// 3.ファイル
		String project			= null;						// 4.プロジェクト
		String sendnumber		= null;						// 5.送信番号
		String subject			= null;						// 6.件名
		String senddate			= null;						// 7.送信日付
		String sender			= null;						// 8.送信者
		String yyyymm			= null;						// 9.基準年月

		for (int i=0; i<args.length; ++i) {
			if ("--mode".equals(args[i])) {
				mode = args[++i];							// 1.モード
            } 
	        else if ("--dir".equals(args[i])) {
	            dir = args[++i];							// 2.ディレクトリ

	        } 
            else if ("--file".equals(args[i])) {
                file = args[++i];							// 3.ファイル
            }
            else if ("--project".equals(args[i])) {
                project = args[++i];						// 4.プロジェクト
            } 
            else if ("--sendnumber".equals(args[i])) {
                sendnumber = args[++i];						// 5.送信番号
            } 
            else if ("--subject".equals(args[i])) {
                subject = args[++i];						// 6.件名
            } 
            else if ("--senddate".equals(args[i])) {
                senddate = args[++i];						// 7.送信日付
            } 
            else if ("--sender".equals(args[i])) {
                sender = args[++i];							// 8.送信者
            } 
            else if ("--yyyymm".equals(args[i])) {
                yyyymm = args[++i];							// 9.基準年月
            } 
		}
    	JFrame frame = new Gui_Report_Cost_Main(mode,
    												dir,
    												file,
    												project,
    												sendnumber,
    												subject,
    												senddate,
    												sender,
    												yyyymm);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

	}

	//コンポーネント変化イベント
	public void componentHidden(ComponentEvent arg0) {
	}
	public void componentMoved(ComponentEvent arg0) {
	}
	public void componentResized(ComponentEvent arg0) {
		
	}
	public void componentShown(ComponentEvent arg0) {
	}

	private Object[][] getObj(ArrayList arraylist){
		
		Object[][] rtnobj = new Object[arraylist.size()][new Struct_Cost_Report().getColData().length];

		for(int i = 0;i<arraylist.size();i++){
			
			Struct_Cost_Report scr = (Struct_Cost_Report) arraylist.get(i);
			
			rtnobj[i][0] = scr.getNumber();
			rtnobj[i][1] = scr.getName();
			rtnobj[i][2] = scr.getGen_date();
			rtnobj[i][3] = scr.getSend_cost();
			rtnobj[i][4] = scr.getRecieve_cost();
			rtnobj[i][5] = scr.getTotal_cost();
			rtnobj[i][6] = scr.getEval_value();
			rtnobj[i][7] = scr.getAteval_cost();
		
		}
			
		return rtnobj ;
	}	

	//表示結果の設定
	private ArrayList direct_Set(ArrayList arraylist){
		ArrayList outlist = new ArrayList();
		
    	//ユーザー情報
    	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
		
		Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO(addr.getDir_current() + 
																	addr.getDir_project() +
												   					project +  addr.getFs()  +
												   					addr.getFile_com_menber());
		tcm.loadXml();
		ArrayList<Struct_Community_Menber> array_Community_Menber = tcm.getdata();
		
		for(int i = 0 ; i<arraylist.size();i++){
			//入力
			Struct_Cost_Detail scd_in = (Struct_Cost_Detail) arraylist.get(i);
			
			//出力
			Struct_Cost_Report scr_out = new Struct_Cost_Report();

			//順番
			scr_out.setNumber(i+1);
			//ユーザー名称
			for(int j=0 ;j<array_Community_Menber.size();j++){
				if(array_Community_Menber.get(j).getUserid().equals(scd_in.getGeneration_userid()) == true){
					scr_out.setName(array_Community_Menber.get(j).getUser_fullname());
					break;
				}
			}
			
			//発生日
			scr_out.setGen_date(DateFormat.getDateTimeInstance().format(scd_in.getGeneration_date())	);
					
	    	//送信コストの再設定
    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue((int) scd_in.getSend_cost().getCost()));
    		send_cost_bar.setRealvalue((int) scd_in.getSend_cost().getCost());
    		send_cost_bar.setMode(su.getMode((int) scd_in.getSend_cost().getCost()));
    		send_cost_bar.setMongon(form_change.change_format9_doble(scd_in.getSend_cost().getCost()));
			scr_out.setSend_cost(send_cost_bar);
			
	    	//受信コストの再設定
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue((int) scd_in.getRecieve_cost().getCost()));
    		recieve_cost_bar.setRealvalue((int) scd_in.getRecieve_cost().getCost());
    		recieve_cost_bar.setMode(su.getMode((int) scd_in.getRecieve_cost().getCost()));
    		recieve_cost_bar.setMongon(form_change.change_format9_doble(scd_in.getRecieve_cost().getCost()));
			scr_out.setRecieve_cost(recieve_cost_bar);

	    	//総コスト
    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
    		total_cost_bar.setMaxvalue(su.getMaxValue((int) scd_in.getTotal_cost()));
    		total_cost_bar.setRealvalue((int) scd_in.getTotal_cost());
    		total_cost_bar.setMode(su.getMode((int) scd_in.getTotal_cost()));
    		total_cost_bar.setMongon(form_change.change_format9_doble(scd_in.getTotal_cost()));
			scr_out.setTotal_cost(total_cost_bar);

	    	//評価額
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue((int) scd_in.getEval_value()));
    		eval_value_cost_bar.setRealvalue((int) scd_in.getEval_value());
    		eval_value_cost_bar.setMode(su.getMode((int) scd_in.getEval_value()));
    		eval_value_cost_bar.setMongon(form_change.change_format9_doble(scd_in.getEval_value()));
    		scr_out.setEval_value(eval_value_cost_bar);
			
			//評価後コスト
			Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
    		ateval_cost_bar.setMaxvalue(su.getMaxValue((int) scd_in.getAtvalue_cost()));
    		ateval_cost_bar.setRealvalue((int) scd_in.getAtvalue_cost());
    		ateval_cost_bar.setMode(su.getMode((int) scd_in.getAtvalue_cost()));
    		ateval_cost_bar.setMongon(form_change.change_format9_doble(scd_in.getAtvalue_cost()));
    		scr_out.setAteval_cost(ateval_cost_bar);
    		
			outlist.add(scr_out);
		}

		
		
		//********************************
		//* 合計行
		//********************************
		
		//合計の算出
		Tool_Cost_Report_Calculate  tcrc = new Tool_Cost_Report_Calculate (outlist);
		tcrc.Caluculate();

		Struct_Cost_Report scr = new Struct_Cost_Report();

		scr.setNumber(outlist.size()+1);					// 1.順番
		scr.setName("***合計***");						// 2.氏名
//		scd.setSend_date(scd_ref.getSend_date());		// 3.発生日時		
		
		
    	//送信コストの設定
		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
		send_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getSend_cost()));
		send_cost_bar.setRealvalue(tcrc.getSend_cost());
		send_cost_bar.setMode(su.getMode(tcrc.getSend_cost()));
		send_cost_bar.setMongon(form_change.change_format9_doble(tcrc.getSend_cost()));
		scr.setSend_cost(send_cost_bar);										// 4.送信コスト
		
    	//受信コストの設定
		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getRecieve_cost()));
		recieve_cost_bar.setRealvalue(tcrc.getRecieve_cost());
		recieve_cost_bar.setMode(su.getMode(tcrc.getRecieve_cost()));
		recieve_cost_bar.setMongon(form_change.change_format9_doble(tcrc.getRecieve_cost()));
		scr.setRecieve_cost(recieve_cost_bar);									// 5.受信コスト	

		
    	//総コストの設定
		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
		total_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getTotal_cost()));
		total_cost_bar.setRealvalue(tcrc.getTotal_cost());
		total_cost_bar.setMode(su.getMode(tcrc.getTotal_cost()));
		total_cost_bar.setMongon(form_change.change_format9_doble(tcrc.getTotal_cost()));
		scr.setTotal_cost(total_cost_bar);										// 6.総コスト
		
    	//評価額の設定
		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getEval_value()));
		eval_value_cost_bar.setRealvalue(tcrc.getEval_value());
		eval_value_cost_bar.setMode(su.getMode(tcrc.getEval_value()));
		eval_value_cost_bar.setMongon(form_change.change_format9_doble(tcrc.getEval_value()));
		scr.setEval_value(eval_value_cost_bar);									// 7.評価額	

    	//評価後コストの設定
		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getAtvalue_cost()));
		ateval_cost_bar.setRealvalue(tcrc.getAtvalue_cost());
		ateval_cost_bar.setMode(su.getMode(tcrc.getAtvalue_cost()));
		ateval_cost_bar.setMongon(form_change.change_format9_doble(tcrc.getAtvalue_cost()));

		scr.setAteval_cost(ateval_cost_bar);									// 8.評価後コスト	
		
		outlist.add(scr);
		
		
		return outlist;	
		
	}
	
	//ユーザー毎にまとめる
	private ArrayList userGroup_Set(ArrayList arraylist){

		//１レコードの場合は集計しない
		if(arraylist.size() == 1){
			return arraylist;
		}
		
		for(int i = arraylist.size() -1 ; i > 0;i--){
			//入力
			Struct_Cost_Detail scd_add = (Struct_Cost_Detail) arraylist.get(i);

   	    	//重複ユーザーの検索
			int found = -1;
			for(int j = 0 ; j < i ; j++){
				if(((Struct_Cost_Detail)arraylist.get(j)).getGeneration_userid().equals(scd_add.getGeneration_userid()) == true){
					found = j;
					break;
				}
			}
			
			//重複ユーザーをまとめる
			if(found != -1){
				Struct_Cost_Detail scd_src = (Struct_Cost_Detail) arraylist.get(found);
				
				//10.送信コスト
				Struct_Cost_Source send_cost = new Struct_Cost_Source();
				send_cost.setUnitcost(scd_src.getSend_cost().getUnitcost());											//最新の単価を設定
				send_cost.setSecond(scd_src.getSend_cost().getSecond()+scd_add.getSend_cost().getSecond());				//時間を加算
				send_cost.setCost(scd_src.getSend_cost().getCost()+scd_add.getSend_cost().getCost());					//コストを加算
				scd_src.setSend_cost(send_cost);
				
				//11.受信コスト
				Struct_Cost_Source recieve_cost = new Struct_Cost_Source();
				recieve_cost.setUnitcost(scd_src.getRecieve_cost().getUnitcost());										//最新の単価を設定
				recieve_cost.setSecond(scd_src.getRecieve_cost().getSecond()+scd_add.getRecieve_cost().getSecond());	//時間を加算
				recieve_cost.setCost(scd_src.getRecieve_cost().getCost()+scd_add.getRecieve_cost().getCost());			//コストを加算
				scd_src.setRecieve_cost(recieve_cost);
				
				//12.総コストの加算
				scd_src.setTotal_cost(scd_src.getTotal_cost()+ scd_add.getTotal_cost());
				
				//13.評価額の加算
				scd_src.setEval_value(scd_src.getEval_value()+ scd_add.getEval_value());
				
				//14.評価後コストの加算
				scd_src.setAtvalue_cost(scd_src.getAtvalue_cost()+ scd_add.getAtvalue_cost());

				 arraylist.remove(i);
				 arraylist.remove(found);
				 arraylist.add(found, scd_src);
				 
			}
			
		}
		return arraylist;	
		
	}

	private ArrayList yyyymm_Exclude(ArrayList arraylist){
		if( arraylist == null || arraylist.size() == 0){
			return null;
		}
		
		for(int i = 0 ; i <arraylist.size() ; i++){
			//入力
			Struct_Cost_Detail scd = (Struct_Cost_Detail) arraylist.get(i);
	    	//基準年月以外は削除
			DateFormat dfm = new SimpleDateFormat("yyyyMM");
   	    	if(yyyymm.equals(dfm.format(scd.getGeneration_date())) == false){
   	    		arraylist.remove(i);
   	    	}
		}
		return arraylist;
	}
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}
	
}
