package mailcost_main;

import java.awt.*;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_CellRenderer;
import tool.Tool_JList_IO;
import tool.Tool_JTree_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_WindowList extends JInternalFrame  {


	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
												addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	JTree tree;
	DefaultMutableTreeNode root	;

	String 	filename	=	addr.getDir_current() + addr.getFile_windowlist();
	
	
//	ToolJTree_IO t;
	boolean blnaction = false;					//操作時ＯＮ
	
	
	//コンストラクタ
	Gui_WindowList(){
		super("フォルダ一覧",true,true);
		setClosable(false);
//		setSize(300, 200);
		setVisible(true);
		
		setFrameIcon(null);
		
		//ルートノードの作成
		Tool_JTree_IO t;
		t = new Tool_JTree_IO(filename);

		
//		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
//		Struct_User su = user_info.getStruct_User();
		
		
//		String rootnodenm = su.getUser_fullname();
//		t.putRootNode(rootnodenm);
		
//		root = new DefaultMutableTreeNode("長谷川　浩道");

		t.loadXml();
        DefaultTreeModel model;
		model = t.getDefaultTreeModel();
		
		tree = new JTree(model);
		
		root = (DefaultMutableTreeNode)model.getRoot();
		
		tree.setCellRenderer(new Tool_CellRenderer());
		
//   		DefaultMutableTreeNode dummynode = root;
//		dummynode = dummynode.getNextNode();
//		ImageIcon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+"project.gif");
//		System.out.println(addr.getDir_current() + addr.getDir_icon()+"project.gif");
//		JLabel iconProject = new JLabel("aaa");
//	    iconProject.setIcon(icon);
//	    DefaultMutableTreeNode dummynode = new DefaultMutableTreeNode(iconProject);
//	    DefaultMutableTreeNode dummynode = new DefaultMutableTreeNode("aaa");
//		root.add(dummynode);

/*		
		while(true){
   		    JLabel iconProject = new JLabel(dummynode.getUserObject().toString());
   		    iconProject.setIcon(icon);
   			
   			dummynode = new DefaultMutableTreeNode(iconProject);
   			dummynode = dummynode.getNextSibling();
   			if(dummynode == null)break;
   		}
*/		
		

		//ルートメッセージをユーザー名に書き換える	
//		root = (DefaultMutableTreeNode)model.getRoot();
//		if (su.getUser_fullname().equals(root.toString()) == false){
//			root.setUserObject(su.getUser_fullname());
//		}
		
		//閉じる直前の展開状態を復元
		t.expandTree(tree);
		//閉じる直前の選択状態を復元
		t.selectNode(tree);
		
//		tree = new JTree(root);
		
		
		//階層ノードの作成
//		DefaultMutableTreeNode node1 = new DefaultMutableTreeNode("111");
//		root.add(node1);
		//階層ノードの作成
//		node1.add(new DefaultMutableTreeNode("Community"));
//		node1.add(new DefaultMutableTreeNode("Send"));
//		node1.add(new DefaultMutableTreeNode("Draft"));
//		DefaultMutableTreeNode node2 = new DefaultMutableTreeNode("777");
//		root.add(node2);
		
		
		//コミュニティノードの作成
//		node1.add(new DefaultMutableTreeNode("要件定義"));
//		node1.add(new DefaultMutableTreeNode("基本設計"));
//		node1.add(new DefaultMutableTreeNode("プログラマー"));
		//コミュニティノードの展開
//		tree =new JTree(root);
//		tree.expandPath(new TreePath (node1.getPath()));
		
		//複数選択の排除
		tree.getSelectionModel().setSelectionMode(
				TreeSelectionModel.SINGLE_TREE_SELECTION);
		//ルートノードを選択状態にする
//		tree.setSelectionRow(0);

		tree.setRootVisible(true);
		
		JScrollPane scroll = new JScrollPane(tree);
		getContentPane().add(scroll,BorderLayout.CENTER);

		
		//マウスイベント取得
//		tree.addMouseListener(new WindowList_MouseCheck());
		
		//デフォルト枠線の排除
		setBorder(new EmptyBorder(0,0,0,0));

	}

	//プロジェクトの登録・取消を反映する
	public void ProjectNodeReMake(ArrayList  projectname){
		//階層ノードの作成
		DefaultMutableTreeNode node = root;
		//初期値false　ノードがある場合はtrueにする
		if(projectname.isEmpty() ==false){
			boolean found[] = new boolean[projectname.size()];			
		}
		//ノードリストの作成
		ArrayList arrynode = new ArrayList();
		node = node.getNextNode();
		while(true){
			if(node == null){
				break;
			}
			arrynode.add(node.getUserObject());
			node = node.getNextSibling();
		}

		//削除ルーチン
		for(int i=0 ; i<arrynode.size() ; i++){
			if(projectname.isEmpty() ==false){
				//参加プロジェクトが１件以上存在
				if(projectname.contains(arrynode.get(i)) == false){	
					node = root;
					node = node.getNextNode();
					while(true){
						String s1 = (String) arrynode.get(i);
						String s2 = (String) node.getUserObject();
						if(s1.equals(s2) == true){
							break;
						}
						node = node.getNextSibling();
					}
					root.remove(node);
				}
			}	
			else{
				//参加プロジェクトが１件もない	
				node = root;
				node = node.getNextNode();
				root.remove(node);
			}
			
		}

		
		//リフレッシュ
		tree.updateUI();

	}

	
	//コミュニティの登録・取消を反映する
	public void CommunityNodeReMake(ArrayList arrayproject,ArrayList arraycommunity){

		DefaultMutableTreeNode node = root;
		node = node.getNextNode();
		while(true){
			if(node == null){
				break;
			}

			//************************************************************
			//* 削除するコミュニティのプロジェクトではない場合はスキップ
			//************************************************************
			String project = (String) node.getUserObject();
			boolean found = false;
			for(int i=0;i<arrayproject.size();i++){
				if(project.equals(arrayproject.get(i).toString())){
					found = true;
					break;
				}
			}
			if(found == false){
				node = node.getNextSibling();
				continue;
			}
			DefaultMutableTreeNode dummy = (DefaultMutableTreeNode) node.getFirstChild();
			if(dummy.getUserObject().equals("Community")){
				//万が一、コミュニティノードにコミュニティが存在しない場合
				//次のプロジェクトにスキップする
				if(dummy.getChildCount() == 0){
					continue;
				}
				//*コミュニティを取得
				Enumeration e = dummy.children();
				while(e.hasMoreElements()){
					DefaultMutableTreeNode comnode = (DefaultMutableTreeNode) e.nextElement();
	    			found = false;
	    			//削除するコミュニティかを判断する
	    			System.out.println(comnode.getUserObject());
	    			for(int i=0;i<arrayproject.size();i++){
	    				if(project.equals(arrayproject.get(i).toString()) &&
	    					comnode.getUserObject().toString().equals(arraycommunity.get(i).toString())){
	    					//コミュニティ削除
	    					dummy.remove(comnode);
	    					break;
	    				}
	    			}
				}
			
			}
			node = node.getNextSibling();
		}

		
		//リフレッシュ
		tree.updateUI();

	}	
	
/*
	public void doDefaultCloseAction() {
		// TODO 自動生成されたメソッド・スタブ
		//操作済み
    	System.out.println("@@@@@@@@@@@@@@@@@" );
    	System.out.println("@@@@@@@@@@@@@@@@@" );
    	System.out.println("@@@@@@@@@@@@@@@@@" );
		if(blnaction==true){
	    	System.out.println("++++++++++++++++++" );
			ToolJTree_IO t = new ToolJTree_IO(filename);
			t.putJTree(tree);
			t.saveXml();
		}
		
		super.doDefaultCloseAction();
		
	}
*/
	
	//jtreeのセーブ	
	public void saveXml(){
		Tool_JTree_IO t = new Tool_JTree_IO(filename);
		t.putJTree(tree);
		t.saveXml();
	}

	//参加プロジェクトまたは参加コミュニティを変更した場合はオンを返す
//	public boolean nodeAction(){
//		return blnaction;
//	}

	//アクティブ中のプロジェクトを返す
	public String activeProject(){
		//アクティブはノードを取得
		TreePath active_path = tree.getSelectionPath();
		//ノードの階層を取得
		int depth = active_path.getPathCount();
		if(depth == 1){
			//ルートノード
			return null;
		}
		else if(depth > 1){
			//コミュニティノード
			DefaultMutableTreeNode node = 
				(DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
			//コミュニティノードまで、さかのぼる
			for(int i = 0;i<depth-2;i++){
				node = (DefaultMutableTreeNode) node.getParent();
			}
			
			return node.getUserObject().toString();
		}
		//ありえない場合
		return null;
	}

	//アクティブ中のコミュニティを返す
	public String activeCommunity(){
		//アクティブはノードを取得
		TreePath active_path = tree.getSelectionPath();
		//ノードの階層を取得
		int depth = active_path.getPathCount();

		if(depth == 4){
			//コミュニティノード
			DefaultMutableTreeNode node = 
				(DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
			DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode) node.getParent();
			//親ディレクトリはコミュニティディレクトリか？
			if(parentnode.getUserObject().toString().equals("Community") == false){
				return null;
			}
			return node.getUserObject().toString();
		}
		//コミュニティノード以外
		return null;
	}

	public String activeCost(){
		//アクティブはノードを取得
		TreePath active_path = tree.getSelectionPath();
		//ノードの階層を取得
		int depth = active_path.getPathCount();

		if(depth == 4){
			//コストノード
			DefaultMutableTreeNode node = 
				(DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
			DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode) node.getParent();
			//親ディレクトリはコストディレクトリか？
			if(parentnode.getUserObject().toString().equals(addr.getNode_cost()) == false){
				return null;
			}
			
			//送信したコストの場合
			if(node.getUserObject().toString().equals(addr.getNode_send()) ){
				return addr.getDir_costsend();
			}
			//受信したコストの場合
			else if(node.getUserObject().toString().equals(addr.getNode_recive()) ){
				return addr.getDir_costrecive();
			}
			//受信したコストの場合
			else if(node.getUserObject().toString().equals(addr.getNode_analysis()) ){
				return addr.getDir_costanalysis();
			}
		}
		//コストノードノード以外
		return null;
	}

/*	public boolean activeCost(){
		//アクティブはノードを取得
		TreePath active_path = tree.getSelectionPath();
		//ノードの階層を取得
		int depth = active_path.getPathCount();
		if(depth == 3){
			//コストノード
			DefaultMutableTreeNode node = 
				(DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
			System.out.println(node.getUserObject().toString());
			if(node.getUserObject().toString().equals("Cost") ){
				return true;
			}
		}
		//コストノードノード以外
		return false;
	}
*/

	
	
}
