package mailcost_main;


import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_DefaultTableCellRenderer;
import structure.Struct_User;
import tool.Tool_User_IO;

public class Gui_WindowView extends JInternalFrame {
	
	JTable table;
	JScrollPane src;
	

	Struct_Community_Digest scd = new Struct_Community_Digest();
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();


	Gui_WindowView(){
		super("コミュニティ",true,true);
		setClosable(false);
//		setSize(300, 200);
		
		setFrameIcon(null);
		
		setVisible(true);
		setResizable(false);

		table =new JTable(0,scd.getColData_short().length);
		table.setRowSelectionAllowed(true);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
		
		src = new JScrollPane(table);
		getContentPane().add(src);

		//デフォルト枠線の排除
		setBorder(new EmptyBorder(0,0,0,0));
	}
	
	//jtableのロード	
	public void loadXml(String strproject,String strcommunity){
		String 	filedir			=addr.getDir_current() + addr.getDir_project();
    	String filename = filedir + 
    						strproject +  addr.getFs()  + 
    						strcommunity +
    						addr.getFile_community_digest();
    						
    	Tool_JTable_IO t = new Tool_JTable_IO (filename,strproject,strcommunity);
    	t.putColum(scd.getColData_short());
    	t.loadXml();
    	t.blnsubmit = true;				//メッセージ起動可
    	table.setModel(t.tableModel);

	   	//*******************************
	   	//* 自分発信の背景色設定
	   	//*******************************
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		Struct_User su = user_info.getStruct_User();
			
        Struct_DefaultTableCellRenderer ownrenderer = new Struct_DefaultTableCellRenderer(filename,su.getUserid(), scd.getAlignment());
        table.setDefaultRenderer(Object.class, ownrenderer);
//        table.setDefaultRenderer(Integer.class, ownrenderer);
	   	//*******************************
	   	//* テーブルの表示設定
	   	//*******************************
		//ヘッダー入れ替え禁止
		table.getTableHeader().setReorderingAllowed(false);

	   	TableColumn col;
	   	//******************************
	   	//* 状態の設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(0);
//		DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
	   	//中央寄せ
//		renderer.setHorizontalAlignment(SwingConstants.CENTER);
//		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);
		
	   	//******************************
	   	//* ＮＯの設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(2);
//		renderer = new DefaultTableCellRenderer();
	   	//右寄せ
//		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
//		col.setCellRenderer(renderer);
	   	//最適幅
		col.setPreferredWidth(35);
		
	   	//******************************
	   	//* サイズの設定
	   	//******************************
	   	col = table.getColumnModel().getColumn(5);
//		renderer = new DefaultTableCellRenderer();
	   	//右寄せ
//		renderer.setHorizontalAlignment(SwingConstants.RIGHT);
//		col.setCellRenderer(renderer);

		//最適幅
		col.setPreferredWidth(35);

		//再表示
   		getContentPane().removeAll();
		src = new JScrollPane(table);
		getContentPane().add(src);
   	
    	
	}

	//カラム幅を取得するする
	public int[] getColumnWidth(){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();

		int[] columnWidth = new int[columnModel.getColumnCount()];
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
			columnWidth[i] = column.getWidth();
		}
		return columnWidth;
		
	}

	//カラム幅を設定する
	public void setColumnWidth(int[] columnWidth){
		
		DefaultTableColumnModel columnModel
	    = (DefaultTableColumnModel)table.getColumnModel();
		
		TableColumn column = null;
		for (int i = 0 ; i < columnModel.getColumnCount() ; i++){
			column = columnModel.getColumn(i);
	    	column.setPreferredWidth(columnWidth[i]);
		}
		
	}
	
}
