package mailcost_main;

import java.io.File;
import java.util.ArrayList;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileCopy;
import tool.Tool_FileFilter;
import tool.Tool_JList_IO;
import tool.Tool_JTree_IO;

public class InitialNewParameter {

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	
	String file_separator = System.getProperty("file.separator");
	String fs 			  = file_separator + file_separator;
	
	public InitialNewParameter(){
	}
	
	public boolean newParam(){
		
		//**************************
		//* 新パラメータの表示
		//**************************
		if(newParamGet() == false ){
			return false;
		}

		//**************************
		//* 旧パラメータの削除
		//**************************
		oldParamDelete();

		//**************************
		//* 新パラメータの置き換え
		//**************************
		if(newParamReplace() == false ){
			//**************************
			//* 失敗した場合
			//**************************
	   		JOptionPane.showMessageDialog(null, "新パラメータの置き換えに失敗しました.\n" +
					"置き換え前の状態に戻します.", 
						"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
	   		if(oldParamReplace() == false){
		   		JOptionPane.showMessageDialog(null, "復元に失敗しました." , 
							"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
	   		}
			return true;
		}
		//到達不能
		return false;
	}

	
	private boolean newParamGet(){
		//**********************************************************************
		//* 新パラメータの表示
		//**********************************************************************
		File fl = new File(addr.getDir_current());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("new_");
    	ff.setSuffix(".txt");
    	File[] files = fl.listFiles(ff);

    	boolean found = false;
		String newfilename = new String();
    	if(files != null && files.length > 0 ){
    		for(int i=0;i<files.length;i++){
    			if(files[i].getName().indexOf(addr.getFile_project_info().replaceAll(fs, "")) > -1){
    				//プロジェクトファイルは表示対象外
    				continue;
    			}
    			newfilename += files[i].getName().replaceAll("new_", "") + "\n";
    			found = true;
    		}	
    	}

    	//プロジェクトディレクトリから検索
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
		t.loadXml();
		ArrayList<Struct_Entry_Project> al = t.getdata();
		
		for(int i=0;i<al.size();i++){
			//コミュニティファイルの存在チェック
			if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
					"new_"+addr.getFile_com_all().replaceAll(fs, "")).exists()){
				newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_all().replaceAll(fs, "") + "\n";
			}
			//コミュニティメンバーファイルの存在チェック
			if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
					"new_"+addr.getFile_com_menber().replaceAll(fs, "")).exists()){
				newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_menber().replaceAll(fs, "") + "\n";
			}
			//参加コミュニティリストファイルの存在チェック
			if(new File(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
					"new_"+addr.getFile_com_select().replaceAll(fs, "")).exists()){
				newfilename += "[" +al.get(i).getProject() + "]" +addr.getFile_com_select().replaceAll(fs, "") + "\n";
			}
		}
		
		//新パラメータファイルはない
		if(newfilename.length() == 0){
			return false;
		}
		String[] selectvalues = {"更新","キャンセル"};
		int select = JOptionPane.showOptionDialog(null,
    			"新パラメータを更新しますか？\n" +
				"以下、新設定ファイル\n"+
				newfilename, 
				"メール＆コスト",
			      JOptionPane.YES_NO_OPTION,
			      JOptionPane.QUESTION_MESSAGE,
			      null, 
			      selectvalues, 
			      selectvalues[1]
			    );
		
		if(select == 0){
			return true;
		}
		return false;
		
	}
	

	private void oldParamDelete(){
		//**********************************************************************
		//* 旧パラメータの表示
		//**********************************************************************
		File fl = new File(addr.getDir_current());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("old_");
    	ff.setSuffix(".txt");
    	File[] files = fl.listFiles(ff);

		String newfilename = new String();
    	if(files != null && files.length > 0 ){
    		for(int i=0;i<files.length;i++){
    			if(files[i].isFile()){
        			files[i].delete();
    			}
    		}	
    	}

    	//プロジェクトディレクトリから検索
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
		t.loadXml();
		ArrayList<Struct_Entry_Project> al = t.getdata();
		String filename;
		File file;
		for(int i=0;i<al.size();i++){
			//コミュニティファイルの削除チェック
			filename = addr.getDir_current()+addr.getDir_project() + fs + 
								al.get(i).getProject() + fs  +
								"old_"+addr.getFile_com_all().replaceAll(fs, "");
			file = new File(filename);
			if(file.exists() && file.isFile()){
				file.delete();
			}
			//コミュニティメンバーファイルの削除チェック
			filename = addr.getDir_current()+addr.getDir_project() + fs + 
							al.get(i).getProject() + fs  +
							"old_"+addr.getFile_com_menber().replaceAll(fs, "");
			file = new File(filename);
			if(file.exists() && file.isFile()){
				file.delete();
			}
			//参加コミュニティリストファイルの削除チェック
			filename = addr.getDir_current()+addr.getDir_project() + fs + 
							al.get(i).getProject() + fs  +
							"old_"+addr.getFile_com_select().replaceAll(fs, "");
			file = new File(filename);
			if(file.exists() && file.isFile()){
				file.delete();
			}
		}
		
	}

	private boolean newParamReplace(){
		//**********************************************************************
		//* 新パラメータの置き換え
		//**********************************************************************
		File fl = new File(addr.getDir_current());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("new_");
    	ff.setSuffix(".txt");
    	File[] files = fl.listFiles(ff);

    	boolean found = false;
		String newfilename = new String();
		Tool_FileCopy filecopy = new Tool_FileCopy();
		String oldfile;
		String currentfile;
		String newfile;
    	if(files != null && files.length > 0 ){
    		for(int i=0;i<files.length;i++){
    			oldfile = files[i].getParentFile().getPath() + fs + "old_"+files[i].getName().replaceAll("new_", "");
    			currentfile  = files[i].getParentFile().getPath() + fs +files[i].getName().replaceAll("new_", "");
    			newfile  = files[i].getPath() ;
    			//カレントファイル⇒旧ファイル
    			if(filecopy.Tool_FileCopy(currentfile, oldfile) == false){
    				return false;
    			}
    			//新ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(newfile, currentfile) == false){
    				return false;
    			}
    			//新ファイルの削除
    			 files[i].delete();
    		}	
    	}

    	//プロジェクトディレクトリから検索
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
		t.loadXml();
		ArrayList<Struct_Entry_Project> al = t.getdata();
		
		
		//* windowlist オープン
		Tool_JTree_IO windowlist = new Tool_JTree_IO(addr.getDir_current() + addr.getFile_windowlist());
		windowlist.loadXml();
		DefaultTreeModel windowmodel = windowlist.getDefaultTreeModel();
        boolean communitychange = false;

		
		for(int i=0;i<al.size();i++){
			//コミュニティファイルの存在チェック
			newfile =addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"new_"+addr.getFile_com_all().replaceAll(fs, "");

			if(new File(newfile).exists()){
    			oldfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
    						"old_"+addr.getFile_com_all().replaceAll(fs, "");
    			currentfile  = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() +
    							addr.getFile_com_all();
    			//カレントファイル⇒旧ファイル
    			if(filecopy.Tool_FileCopy(currentfile, oldfile) == false){
    				return false;
    			}
    			//新ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(newfile, currentfile) == false){
    				return false;
    			}
    			//新ファイルの削除
    			new File(newfile).delete();
			}
			
			//コミュニティメンバーファイルの存在チェック
			newfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
			"new_"+addr.getFile_com_menber().replaceAll(fs, "");

			if(new File(newfile).exists()){
    			oldfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
    						"old_"+addr.getFile_com_menber().replaceAll(fs, "");
    			currentfile  = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() +
    							addr.getFile_com_menber();
    			//カレントファイル⇒旧ファイル
    			if(filecopy.Tool_FileCopy(currentfile, oldfile) == false){
    				return false;
    			}
    			//新ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(newfile, currentfile) == false){
    				return false;
    			}
    			//新ファイルの削除
    			new File(newfile).delete();
			}

			//参加コミュニティリストファイルの存在チェック
			newfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
			"new_"+addr.getFile_com_select().replaceAll(fs, "");
			if(new File(newfile).exists()){

				//* 新参加コミュニティリストファイルの取得
				Tool_JList_IO tls = new Tool_JList_IO(newfile);	
				tls.loadXml();
				DefaultListModel listModel = tls.getDefaultListModele();

				ArrayList newAL	= new ArrayList();
		        for(int j = 0;j<listModel.getSize();j++){
		        	newAL.add(listModel.getElementAt(j));
		        }

		        //参加コミュニティがない場合
		        if(newAL.size() == 0 ){
		        	return false;
		        }
		        
		        
				//* 現参加コミュニティリストファイルの取得
    			currentfile  = addr.getDir_current()+addr.getDir_project() + al.get(i).getProject() +
								addr.getFile_com_select();

				tls = new Tool_JList_IO(currentfile);	
				tls.loadXml();
				listModel = tls.getDefaultListModele();

				ArrayList currentAL	= new ArrayList();
		        for(int j = 0;j<listModel.getSize();j++){
		        	currentAL.add(listModel.getElementAt(j));
		        }
		        
    			oldfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
				"old_"+addr.getFile_com_select().replaceAll(fs, "");

    			//カレントファイル⇒旧ファイル
    			if(filecopy.Tool_FileCopy(currentfile, oldfile) == false){
    				return false;
    			}
		        
    			//コミュニティ追加
		        for(int j = 0;j<newAL.size();j++){
		        	if(currentAL.indexOf(newAL.get(j)) == -1){
		        		currentAL.add(newAL.get(j));
		        		
		        		String filepath = addr.getDir_current()+addr.getDir_project()  + al.get(i).getProject() + fs + newAL.get(j);
		        		File file = new File(filepath);
		        		if(file.exists()){
			        		//コミュニティディレクトリ生成
							String[] selectvalues = {"リメイク","キャンセル"};
							int select = JOptionPane.showOptionDialog(null,
			        				"["+al.get(i).getProject()+"]プロジェクトの["+currentAL.get(j)+"]コミュニティは既に存在します.\n" +
			        				"今まで蓄積したメールを削除してリメイクしますか？\n"+
			        				"（削除したメールは復元できません）", 
			        				"メール＆コスト",
								      JOptionPane.YES_NO_OPTION,
								      JOptionPane.QUESTION_MESSAGE,
								      null, 
								      selectvalues, 
								      selectvalues[1]
								    );
			        		if(select == 0){
			        			//リメイク
			        			if(new Tool_DirDel(filepath).delete() == false){
				        			return false;
				        		}
				        		if(file.mkdir() == false){
				        			return false;
				        		}
				        		//* windowlist 存在チェック
				        		if(CommunityExists(windowmodel,al.get(i).getProject(),(String) newAL.get(j)) == false){
					        		//* windowlist 追加
					        		if(CommunityAdd(windowmodel,al.get(i).getProject(),(String) newAL.get(j)) == false){
					        			return false;
					        		}
				        		}
			        		}
		        		}else{
			        		if(file.mkdir() == false){
			        			return false;
			        		}
			        		//* windowlist 追加
			        		if(CommunityAdd(windowmodel,al.get(i).getProject(),(String) newAL.get(j)) == false){
			        			return false;
			        		}
		        		}
		        		
		        		communitychange = true;
		        	}
		        }

    			//コミュニティ削除
		        for(int j = 0;j<currentAL.size();j++){
		        	if(newAL.indexOf(currentAL.get(j)) == -1){
		        		if(currentAL.size() == 1){
		        			//参加プロジェクトが０件にはできない
		        			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_project()+addr.getFile_project_info());
		        			tep.loadXml();
		        			if(tep.getdata().size() == 1 ){
		        				//参加プロジェクトが１件の場合はコミュニティを削除できない
		        	    		JOptionPane.showMessageDialog(null,
		        	    				"参加プロジェクトと参加コミュニティが共に１件の場合は削除することができません.\n" +
		        	    				"新たなプロジェクトに参画した時に削除可能です.",
		        	    				"メール＆コスト", JOptionPane.INFORMATION_MESSAGE); 
		        			}else{
		        	    		JOptionPane.showMessageDialog(null,
				        				"["+al.get(i).getProject()+"]に参加コミュニティはありません.\n" +
				        				"プロジェクトには一つ以上の参加コミュニティが必要なため、["+currentAL.get(j)+"]コミュニティは削除できません", 
				        				"メール＆コスト",
		        	    				 JOptionPane.INFORMATION_MESSAGE); 
		        			}

		        			break;
		        		}
		        		
		        		//コミュニティディレクトリ削除
						String[] selectvalues = {"削除","キャンセル"};
						int select = JOptionPane.showOptionDialog(null,
		        				"あなたのユーザーは["+al.get(i).getProject()+"]プロジェクトの["+currentAL.get(j)+"]コミュニティから削除されました.\n" +
		        				"今まで蓄積したメールを削除しますか？\n"+
		        				"（削除後の復元はできません）", 
		        				"メール＆コスト",
							      JOptionPane.YES_NO_OPTION,
							      JOptionPane.QUESTION_MESSAGE,
							      null, 
							      selectvalues, 
							      selectvalues[1]
							    );
		        		if(select == 0){
		        			//コミュニティディレクトリを削除
			        		if(new Tool_DirDel(addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +currentAL.get(j)).delete() == false){
			        			return false;
			        		}
			        		//* windowlist 削除
			        		if(CommunityDelete(windowmodel,al.get(i).getProject(),(String)currentAL.get(j)) == false){
			        			return false;
			        		}
			        		communitychange = true;	        		
		        		}

		        		currentAL.remove(j);
		        		j--;
		        	}
		        }

		        
				//***************************************
				//*カレントファイル保存
				//***************************************
		    	DefaultListModel listmodel = new DefaultListModel();
	        	for(int j=0;j<currentAL.size();j++){
	    	    	listmodel.addElement(currentAL.get(j));
	    		}
		    	JList list = new JList(listmodel);
		        
		    	tls = new Tool_JList_IO(currentfile);	
		        tls.putJList(list);
		        tls.saveXml();

    			//新ファイルの削除
    			new File(newfile).delete();
		        
			}
		
		}
		
		//* windowlist更新
		if(communitychange == true){
			JTree tree = new JTree(windowmodel);
			DefaultMutableTreeNode root = (DefaultMutableTreeNode)windowmodel.getRoot();

			//展開
	   		DefaultMutableTreeNode dummynode = root;
			int row_total = 0;
	   		while(true){
	   			row_total++;
	   			dummynode = dummynode.getNextNode();
	   			if(dummynode == null)break;
	   		}
	   		for(int i=0;i<row_total;i++){
	   			tree.expandRow(i);
	   		}
			
			//コミュニティノードの第一子を選択状態にする
			tree.setSelectionRow(3);
			
			windowlist.putJTree(tree);
			windowlist.saveXml();
		}
		
		return true;
		
	}
	
	private boolean oldParamReplace(){
		//**********************************************************************
		//* 新パラメータの置き換え
		//**********************************************************************
		File fl = new File(addr.getDir_current());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix("old_");
    	ff.setSuffix(".txt");
    	File[] files = fl.listFiles(ff);

    	boolean found = false;
		String newfilename = new String();
		Tool_FileCopy filecopy = new Tool_FileCopy();
		String oldfile;
		String currentfile;
		String newfile;
    	if(files != null && files.length > 0 ){
    		for(int i=0;i<files.length;i++){
    			newfile = files[i].getParentFile().getPath() + fs + "new_"+files[i].getName().replaceAll("old_", "");
    			currentfile  = files[i].getParentFile().getPath() + fs +files[i].getName().replaceAll("old_", "");
    			oldfile  = files[i].getPath() ;
    			
    			//カレントファイル⇒新ファイル
    			if(filecopy.Tool_FileCopy(currentfile, newfile) == false){
    				return false;
    			}
    			//旧ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(oldfile, currentfile) == false){
    				return false;
    			}
    			//旧ファイルの削除
    			 files[i].delete();
    		}	
    	}

    	//プロジェクトディレクトリから検索
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(addr.getDir_current() + addr.getFile_project_info());
		t.loadXml();
		ArrayList<Struct_Entry_Project> al = t.getdata();
		
		for(int i=0;i<al.size();i++){
			//コミュニティファイルの存在チェック
			oldfile =addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"old_"+addr.getFile_com_all().replaceAll(fs, "");

			if(new File(oldfile).exists()){
    			newfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
    						"new_"+addr.getFile_com_all().replaceAll(fs, "");
    			currentfile  = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() +
    							addr.getFile_com_all();
    			//カレントファイル⇒新ファイル
    			if(filecopy.Tool_FileCopy(currentfile, newfile) == false){
    				return false;
    			}
    			//新ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(oldfile, currentfile) == false){
    				return false;
    			}
    			//旧ファイルの削除
    			new File(oldfile).delete();
			}
			
			//コミュニティメンバーファイルの存在チェック
			oldfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
						"old_"+addr.getFile_com_menber().replaceAll(fs, "");

			if(new File(oldfile).exists()){
    			newfile = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() + fs  +
    						"new_"+addr.getFile_com_menber().replaceAll(fs, "");
    			currentfile  = addr.getDir_current()+addr.getDir_project() + fs + al.get(i).getProject() +
    							addr.getFile_com_menber();
    			//カレントファイル⇒新ファイル
    			if(filecopy.Tool_FileCopy(currentfile, newfile) == false){
    				return false;
    			}
    			//旧ファイル⇒カレントファイル
    			if(filecopy.Tool_FileCopy(oldfile, currentfile) == false){
    				return false;
    			}
    			//旧ファイルの削除
    			 new File(oldfile).delete();
			}
		}
		
		return true;
		
	}
	
	public boolean CommunityAdd(DefaultTreeModel model,String project,String community){
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();

		DefaultMutableTreeNode communitynode;
		//プロジェクトノードの検索作成

		DefaultMutableTreeNode node = root;
		if(node.isLeaf() ==true){
			//プロジェクトノードがない
			return false;
		}
		node = node.getNextNode();
		while(true){
			if(node == null){
				//対象のプロジェクトノードがない
				return false;
			}
			if(project.equals(node.getUserObject().toString())){
				//対象のプロジェクトノードを発見	
				node = node.getNextNode();
				String s1 = "Community";
				if(s1.equals(node.getUserObject().toString())){
					//コミュニティノードを発見
					DefaultMutableTreeNode addnode = new DefaultMutableTreeNode(community);
					node.add(addnode);
					
//					communitynode = node;
					break;
				}
				//コミュニティノードがない
				return false;
			}
			node = node.getNextSibling();
		}
		return true;

	}	
	
	
	public boolean CommunityDelete(DefaultTreeModel model,String project,String community){
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();

		DefaultMutableTreeNode communitynode;
		//プロジェクトノードの検索作成

		DefaultMutableTreeNode node = root;
		if(node.isLeaf() ==true){
			//プロジェクトノードがない
			return false;
		}
		node = node.getNextNode();
		boolean delete = false;
		while(true){
			if(node == null){
				//プロジェクトノードがひとつもない
				return false;
			}
			if(project.equals(node.getUserObject().toString())){
				//対象のプロジェクトノードを発見	
				node = node.getNextNode();
				String s1 = "Community";
				if(s1.equals(node.getUserObject().toString())){
					node = (DefaultMutableTreeNode) node.getFirstChild();
					while(true){
						if(node == null){
							//ノードが空
							return false;
						}
						if(community.equals(node.getUserObject().toString())){
							node.removeFromParent();	
//							root.remove(node);
							delete = true;
							break;
						}
						node = node.getNextSibling();
					}
					
					break;
				}
				//コミュニティノードがない
				return false;
			}
			node = node.getNextSibling();
		}
		
		if(delete == true){
			return true;
		}
		return false;
	}		

	public boolean CommunityExists(DefaultTreeModel model,String project,String community){
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();

		DefaultMutableTreeNode communitynode;
		//プロジェクトノードの検索作成

		DefaultMutableTreeNode node = root;
		if(node.isLeaf() ==true){
			//プロジェクトノードがない
			return false;
		}
		node = node.getNextNode();
		while(true){
			if(node == null){
				//プロジェクトノードがひとつもない
				return false;
			}
			if(project.equals(node.getUserObject().toString())){
				//対象のプロジェクトノードを発見	
				node = node.getNextNode();
				String s1 = "Community";
				if(s1.equals(node.getUserObject().toString())){
					node = (DefaultMutableTreeNode) node.getFirstChild();
					while(true){
						if(node == null){
							//ノードが空
							return false;
						}
						if(community.equals(node.getUserObject().toString())){
							return true;
						}
						node = node.getNextSibling();
					}
				}
				//コミュニティノードがない
				return false;
			}
			node = node.getNextSibling();
		}
		
	}		


}
