package mailcost_main;

import java.io.File;
import java.util.ArrayList;

import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import structure.File_and_Directory_Address;
import structure.Struct_Entry_Project;
import structure.Struct_User;
import structure.Struct_UserConfirm;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileCopy;
import tool.Tool_JTree_IO;
import tool.Tool_UserConfirm_IO;
import tool.Tool_User_IO;

public class InitialNewProject {
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	
	String file_separator = System.getProperty("file.separator");
	String fs 			  = file_separator + file_separator;

	Tool_FileCopy filecopy = new Tool_FileCopy();
	
	public InitialNewProject(){
	}

	public void newProject(){
		
		//新プロジェクトを取得
		String newproject = findProject();
		if(newproject == null){
			//存在しない
			return;
		}
		
		//* ユーザー情報の確認
		String userconfirmfilepath =addr.getDir_current() + addr.getDir_project() + newproject + addr.getFile_userconfirm();
		if(userCheck(userconfirmfilepath,newproject) == false){
			//ユーザー情報の不一致
			return;
		}
		
		
		//******************************************
		//* プロジェクトファイルの追加
		//******************************************
		String currentprojectfilepath 	= addr.getDir_current() + addr.getFile_project_info();
		String addprojectfilepath 	= addr.getDir_current() + addr.getDir_project() + 
										newproject + addr.getFile_project_info();
		String oldprojectfilepath 	= addr.getDir_current() + fs  + "old_"+ 
										addr.getFile_project_info().replaceAll(fs, "");
		//既存ファイルの保存
		if(filecopy.Tool_FileCopy(currentprojectfilepath, oldprojectfilepath) == false){
			return ;
		}
		if(projectUpdate(currentprojectfilepath,addprojectfilepath) == false){
			//プロジェクトの追加失敗の場合のリカバリー
			filecopy.Tool_FileCopy(oldprojectfilepath,currentprojectfilepath);
			new File(oldprojectfilepath).delete();
			return;
		}
		
		//******************************************
		//* windowリストファイルの追加
		//******************************************
		String currentlistfilepath = addr.getDir_current() + addr.getFile_windowlist();	
		String addlistfilepath = addr.getDir_current() + addr.getDir_project() + 
									newproject + addr.getFile_windowlist();
		String oldlistfilepath = addr.getDir_current() +  fs  +
									"old_"+ addr.getFile_windowlist().replaceAll(fs, "");	
		//既存ファイルの保存
		if(filecopy.Tool_FileCopy(currentlistfilepath, oldlistfilepath) == false){
			return ;
		}
		if(windwListUpdate(currentlistfilepath,addlistfilepath) == false){
			//プロジェクトの追加失敗のリカバリー
			filecopy.Tool_FileCopy(oldprojectfilepath,currentprojectfilepath);
			new File(oldprojectfilepath).delete();
			filecopy.Tool_FileCopy(oldlistfilepath,currentlistfilepath);
			new File(oldlistfilepath).delete();
			return;
		}

		//* 後始末
		new File(userconfirmfilepath).delete();
		new File(addprojectfilepath).delete();
		new File(addlistfilepath).delete();
		
	}
	
	
	private String findProject(){
		
		File projectdir = new File(addr.getDir_current() + addr.getDir_project());
		File[] filelist = projectdir.listFiles();
		File test;
		for (int i = 0; i < filelist.length; i++) {
			//ディレクトリ以外の場合は無視
			if(filelist[i].isDirectory() == false){
				continue;
			}
			test = new File(filelist[i].getAbsolutePath() +fs + addr.getFile_userconfirm());
			if(test.exists()){
				int ans = JOptionPane.showConfirmDialog(null, 
		    			"新プロジェクト["+filelist[i].getName()+"]を取り込みますか？",
						"メール＆コスト",
		                JOptionPane.YES_NO_OPTION,
		                JOptionPane.QUESTION_MESSAGE);
				if(ans == JOptionPane.YES_OPTION){
					return filelist[i].getName();
				}
			}
		
		}
		
		return null;
		
	}
	
	private boolean userCheck(String userconfirmfilepath,String project){
		//*ユーザー情報の取得
		Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		user_info.loadXml();
		Struct_User su = user_info.getStruct_User();
		
		//*確認ユーザー情報の取得
		Tool_UserConfirm_IO  userconf = new Tool_UserConfirm_IO (userconfirmfilepath);
		if(userconf.loadXml() == false){
    		JOptionPane.showMessageDialog(null,
    				"確認ユーザー情報を取得できません\n" +
    				userconfirmfilepath, 
    				"メール＆コスト",
    				 JOptionPane.WARNING_MESSAGE); 
			return false;
		}
		Struct_UserConfirm suc = userconf.getStruct_UserConfirm();
		
		if(su.getUserid().equals(suc.getUserid()) == false){
    		JOptionPane.showMessageDialog(null,
    				"ユーザーＩＤが一致しません\n" +
    				"あなたのユーザーＩＤ＝"+su.getUserid()+"\n"+ 
    				"新プロジェクトのユーザーＩＤ＝"+su.getUserid(), 
    				"メール＆コスト",
    				 JOptionPane.WARNING_MESSAGE); 
			return false;
		}
		
		if(su.getNode().equals(suc.getNode()) == false){
    		JOptionPane.showMessageDialog(null,
    				"ノードが一致しません\n" +
    				"あなたのノード＝"+su.getNode()+"\n"+ 
    				"新プロジェクトのノード＝"+su.getNode(), 
    				"メール＆コスト",
    				 JOptionPane.WARNING_MESSAGE); 
			return false;
			
		}
		return true;
		
	}
	
	private boolean projectUpdate(String currentprojectfilepath,String newprojectfilepath){
		//プロジェクトファイル取得
		Tool_Entry_Project_IO t = new Tool_Entry_Project_IO(currentprojectfilepath);
		t.loadXml();
		ArrayList<Struct_Entry_Project> al = t.getdata();

		//新プロジェクトファイル取得
		Tool_Entry_Project_IO newt = new Tool_Entry_Project_IO(newprojectfilepath);
		newt.loadXml();
		ArrayList<Struct_Entry_Project> newal = newt.getdata();
		
		for(int i=0;i<al.size();i++){
			if(al.get(i).getProject().equals(newal.get(0).getProject())){
	    		JOptionPane.showMessageDialog(null,
	    				"既に["+newal.get(0).getProject()+"]プロジェクトは存在します" , 
	    				"メール＆コスト",
	    				 JOptionPane.WARNING_MESSAGE); 
				return false;
			}
			if(al.get(i).getUserid().equals(newal.get(0).getUserid())){
	    		JOptionPane.showMessageDialog(null,
	    				"既に["+newal.get(0).getUserid()+"]のプロジェクトユーザーＩＤは存在します" , 
	    				"メール＆コスト",
	    				 JOptionPane.WARNING_MESSAGE); 
				return false;
				
			}
			if(al.get(i).getIp_address().equals(newal.get(0).getIp_address())){
	    		JOptionPane.showMessageDialog(null,
	    				"既に["+newal.get(0).getIp_address()+"]のプロジェクトノードは存在します" , 
	    				"メール＆コスト",
	    				 JOptionPane.WARNING_MESSAGE); 
				return false;
			}
		
		}

		al.add(newal.get(0));

		//* ファイルの保存
		t.putdata(al);
		t.saveXml();
		return true;
		
	}
	
	
	private boolean windwListUpdate(String currentlistfilepath,String newlistfilepath){
		Tool_JTree_IO projectlist = new Tool_JTree_IO(newlistfilepath);
		if(projectlist.projectLoadXml() == false){
    		JOptionPane.showMessageDialog(null,
    				"プロジェクトリストを取得できません\n" +
    				newlistfilepath, 
    				"メール＆コスト",
    				 JOptionPane.WARNING_MESSAGE); 
			return false;
			
		}

		DefaultTreeModel projectmodel = projectlist.getDefaultTreeModel();
		DefaultMutableTreeNode projectnode = (DefaultMutableTreeNode)projectmodel.getRoot();
		
		//* windowlist オープン
		Tool_JTree_IO windowlist = new Tool_JTree_IO(currentlistfilepath);
		windowlist.loadXml();
		DefaultTreeModel windowmodel = windowlist.getDefaultTreeModel();
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)windowmodel.getRoot();
		root.add(projectnode);
		
		JTree tree = new JTree(windowmodel);

		//展開
   		DefaultMutableTreeNode dummynode = root;
		int row_total = 0;
   		while(true){
   			row_total++;
   			dummynode = dummynode.getNextNode();
   			if(dummynode == null)break;
   		}
   		for(int i=0;i<row_total;i++){
   			tree.expandRow(i);
   		}
		
		//コミュニティノードの第一子を選択状態にする
		tree.setSelectionRow(3);
		
		//* ファイルの保存
		windowlist.putJTree(tree);
		windowlist.saveXml();		

		return true;
	}

	
	
}
