package socket_common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Mail_Send {


	//ソケット
	Socket sock;

	//送受信用
	InputStream in;							//入力ストリーム
	OutputStream out;						//出力ストリーム
	
	Struct_SendList data;
	
	boolean direct;
	String dir;
	
//	int filesize;
	

	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
									addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ
	
	
	
	public Mail_Send(Socket sock,
			InputStream in,
			OutputStream out,
			Struct_SendList data,
			boolean direct,
			String dir){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.sock = sock;
		this.in		=	in;
		this.out	=	out;
		this.data	=	data;
		this.direct	=	direct;
		this.dir	=	dir;

	}
	
	
	
	public boolean submit(){
		
		String filename =	data.getFilename(); 			//送信ファイル
		Struct_Community_Digest digest =	data.getScd(); 	//ダイジェスト
	
		byte[] pcu_data = data.getByte();
		int filesize;
		if(direct == true){
			//(010)メール送信許可要求の送信（ダイジェスト）
			filesize = mailSendPermission_Request((short) 10,pcu_data);
			if(filesize == 0){
				return false;
			}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "010 sended mail-send-permission-request OK");
			
		}
		else{
			//(030)メール中継許可要求の送信
			filesize = mailSendPermission_Request((short) 30,pcu_data);
			if(filesize == 0){
				return false;
			}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "030 sended mail-relay-permission-request OK");
		}

		//ダイジェスト送信完了の送信
		if(send_filesize((short) 15,filesize) == false){
			//送信失敗
			return false;
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "015 sended mail-(send or relay)-permission-request-complete OK");

		//(110)メール送信許可の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 waiting mail-send-permission-request anser");
		if(code_Recept((short)110) == false){
			//受信失敗
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 recieved mail-send-permission-request anser OK");
		
		sleep();

		//メールファイル送信
		filesize = send_file(dir +  addr.getFs() + filename);
		
		if(filesize  == 0){
			//送信失敗
			return false;
		}
	

		//メールファイル送信完了の送信
		if(send_filesize((short) 12,filesize) == false){
			//送信失敗
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "012 sended mail-send-complete OK");

		//(112)メールファイル受信完了の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "112 waiting mail-send-complete anser");
		if(code_Recept((short)112) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "112 recieved mail-send-complete anser OK");
		
		return true;
		
	}
	
	
	public int  mailSendPermission_Request(short code,byte[] indata)  {
		int filesize = 0;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
				"mail Send Permission Request start. code:"+code + " length:" + indata.length);
		
		//ストリームデータ送信

	    int len = 0;
	    short edaban = 0;
	    int senddatasize;
	    
	    boolean EOF = false;


	    //初回送信データのサイズ確定	
	    if(indata.length > (sysconfig.getBuffsize() -6)){
			len = sysconfig.getBuffsize() -6;
		}else{
			len = indata.length;
			EOF = true;
		}
			
		//送信ループ
		while (true) {
			byte[] send = new byte[len+6];
		    //コード
			send[0] =  (byte)((code >>> 8) & 0xFF);
			send[1] =  (byte)((code >>> 0) & 0xFF) ;
		    //レングス
			send[2] =  (byte)((len >>> 8) & 0xFF);
			send[3] =  (byte)((len >>> 0) & 0xFF);
		    //枝番
			edaban++;
			send[4] =  (byte)((edaban >>> 8) & 0xFF);
			send[5] =  (byte)((edaban >>> 0) & 0xFF);

			//送信データ作成
			for(int i=0;i<len;i++){
				send[i+6]= indata[i+filesize];
			}
			filesize = filesize + len;
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "15:edaban="+edaban+" filesize:"+filesize);

			if(send_Byte(send) == false){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "mail Send Permission Request send error");
				return 0;
			}
			

			if(EOF == true){
				break;
			}
			
		    //２番目以降の送信データのサイズ確定	
		    if((indata.length - filesize)  > (sysconfig.getBuffsize() -6)){
				len = sysconfig.getBuffsize() -6;
			}else{
				len = indata.length - filesize;
				EOF = true;
			}
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
				"mail Send Permission Request end.");
		return filesize;
	}			
	
	
	
	
	
	
	
	
	
	
	
	
	
	//接続要求１
	public boolean conection_Request(short code,String userid) {
		
		short i =  (short) userid.length();
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		
		byte[] buff =  userid.getBytes();

		for(int j = 0;j<buff.length;j++){
			send[j+4] = buff[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact Request. code="+code + " user="+userid);
		return true;
		
	}

	//接続要求受付
	public boolean code_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
//			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Code Recept:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		catch (Exception e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Code Recept:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
	}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Time Out Error ");
			return false;
		}

		//情報あり？
		if(k != 2){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Data Length is not 2. length:"+k);
			return false;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Code unmatch.  wait code="+code + "  send code="+cd);
			return false;
		}
		return true;
		
	}			


	
	
	public int send_file(String filename)  {
		int filesize = 0;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file start");
		
		//ストリームデータ送信

		FileInputStream fin = null;

		short code = 11;
	    int len = 0;
	    short edaban = 0;

	    byte[] data = new byte[sysconfig.getBuffsize() -6];

		//ファイル設定
		try {
			fin = new FileInputStream(filename);
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return 0;
		}
		
		try {
			//送信ループ
			filesize = 0;
			while ((len = fin.read(data)) != -1) {
				byte[] send = new byte[len+6];
			    //コード
				send[0] =  (byte)((code >>> 8) & 0xFF);
				send[1] =  (byte)((code >>> 0) & 0xFF) ;
			    //レングス
				send[2] =  (byte)((len >>> 8) & 0xFF);
				send[3] =  (byte)((len >>> 0) & 0xFF);
			    //枝番
				edaban++;
				send[4] =  (byte)((edaban >>> 8) & 0xFF);
				send[5] =  (byte)((edaban >>> 0) & 0xFF);

				//送信データ作成
				for(int i=0;i<len;i++){
					send[i+6]= data[i];
				}

//				out.write(send, 0, len+6);
				send_Byte(send);
				filesize = filesize + len;
//				System.out.println("send len:" + send.length);
//				System.out.println("len  len:" + len);
				
				
			}
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return 0;
		}
		


		//おまじない
		try {
			//出力ファイルの掃き出し
			out.flush();
			//入力ファイルの開放
			fin.close();
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file end");
		return filesize;
	}	
	
	public boolean send_Byte(byte[] byte_send)  {
		int j;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send end");
		return true;
	}

	//メールファイル送信完了＆ファイルの大きさを送信
	public boolean send_filesize(short code,int filesize) {
		
		byte send[]= new byte[6];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send[2] =  (byte)((filesize >>> 24)  & 0xFF) ;
		send[3] =  (byte)((filesize >>> 16)  & 0xFF) ;
		send[4] =  (byte)((filesize >>> 8)  & 0xFF) ;
		send[5] =  (byte)((filesize >>> 0)  & 0xFF) ;

		if(send_Byte(send) == false){
			return false;
		}

		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "sended filesize  code="+code + " filesize="+filesize);
		
		return true;
		
	}
	

	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}

	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
}
