package make_analysis_report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_CostBar;
import structure.Struct_Cost_AnalysisBar;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Community_digest_ALL_IO;
import tool.Tool_Cost_Analysis_Digest_IO;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_Calculate;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Make_analysis_report_Main {

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	//ユーザー情報の取得
	Tool_User_IO user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
	Struct_User su = user_info.getStruct_User();

	//メイン
	public static void main(String[] args){

		String yyyymm 			= null;		// 1.基準年月
		String project 			= null;		// 2.プロジェクト
		boolean	timestamp	= false;	// 3.ユーザー情報の前回実行タイムスタンプを更新
															
		//パラメータ解析
		for (int i=0; i<args.length; ++i) {
			if ("--yyyymm".equals(args[i])) {
				yyyymm = args[++i];							// 1.基準年月
            } 
			else if ("--project".equals(args[i])) {
				project = args[++i];						// 2.プロジェクト
            } 
			else if ("--timestamp".equals(args[i])) {
				timestamp = true;						// 3.タイムスタンプ
			} 
            else {
            	System.out.println("引数指定の誤り：未知の引数が指定されました");
            	System.exit(0);
            }
		}

		if(project != null && yyyymm != null){
			//実行
			Make_analysis_report_Main submit = new Make_analysis_report_Main(project,yyyymm);
		}
		else if(yyyymm != null){
			//実行
			Make_analysis_report_Main submit = new Make_analysis_report_Main(yyyymm,timestamp);
			
		}
    	System.exit(0);
	}	

	
	//基準年月のみ指定
	Make_analysis_report_Main(String yyyymm,boolean	timestamp){
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "yyyymm="+yyyymm);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		//参加プロジェクトの取得
		Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
											addr.getFile_project_info());
		tep.loadXml();
		String[] array_project = tep.get_project();

		
		//プロジェクトのループ
		for(int i=0 ; i<array_project.length ; i++){
			make_report(array_project[i],yyyymm);
		}

		//*ユーザー情報　前回実行タイムスタンプの更新
        user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
		user_info.getStruct_User().setLastbatchtimestamp(System.currentTimeMillis());
		user_info.saveXml();
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
		
	}

	//プロジェクトと基準年月のみ指定
	Make_analysis_report_Main(String project, String yyyymm){
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "project=" + project + " yyyymm=" + yyyymm);

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		make_report(project,yyyymm);
		
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end");
		
	}

	
	private void make_report(String project,String yyyymm){
		//********************************
		//* 集約用コスト
		//********************************
		double	sum_write_cost	=	0;		//書き込みコスト
		double	sum_read_cost	=	0;		//読み取りコスト
		double sum_toMe_eval	=	0;		//他人評価額
		double sum_toOther_eval	=	0;		//自己評価額
		
		//********************************
		//* 受信コスト
		//********************************
		
    	//受信コストのファイル設定
		File fl = new File(addr.getDir_current() + addr.getDir_project() + project + addr.getDir_costrecive());
    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix(addr.getFile_cost_suffix());
    	File[] files = fl.listFiles(ff);
    	
    	Tool_Community_digest_ALL_IO com_dig = new Tool_Community_digest_ALL_IO();
		//件名等の参照用
		com_dig = new Tool_Community_digest_ALL_IO (project);
		com_dig.loadXml();
    	
    	//ファイルが存在する場合
    	if(files != null && files.length > 0){
    		//********************************************************
   	    	//* コストダイジェスト 更新
   	    	//********************************************************
    		
    		//作成用
    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (addr.getDir_current() +
																addr.getDir_project() +
																project	+  addr.getFs()  +
																addr.getDir_costanalysis() + addr.getFs() +
																yyyymm + addr.getPrefix_recieve());
    		tt.Initialize();
    		
    		//受信コストのループ
			for(int j=0; j<files.length; j++) {

				//ファイル更新日付を取得
				long lastdate = files[j].lastModified();
	   	    	DateFormat dfm = new SimpleDateFormat("yyyyMM");
	   	    	int yyyymm_int = Integer.valueOf(yyyymm).intValue();
	   	    	int lastdate_int = Integer.valueOf(dfm.format(lastdate)).intValue();
	   	    	//ファイル更新日付が基準年月より前の場合
	   	    	if(yyyymm_int  > lastdate_int){
		   	    	//次のファイルにスキップ
	   	    		continue;
	   	    	}
	    		Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(files[j].getAbsolutePath());
	   	    	tcd.loadXml();

	   	    	//既存のコスト明細を取得
	   	    	ArrayList  arraylist_tcd		 = tcd.getArray_cost_detail();
	   	    	//集約期間のコスト明細のみ取得
	   	    	ArrayList  arraylist_tcd_period =  new ArrayList();
	   	    	
	   	    	//コスト明細のループ
	   	    	for(int k=0 ; k<arraylist_tcd.size() ; k++){
		   	    	Struct_Cost_Detail scd = (Struct_Cost_Detail) arraylist_tcd.get(k);
		   	    	int gendate_int = Integer.valueOf(dfm.format(scd.getGeneration_date())).intValue();
		   	    	//基準年月と発生日時が同じ場合
		   	    	if(yyyymm_int == gendate_int){
		   	    		//受信コスト　⇒　読み取りコスト
		   	    		sum_read_cost		= sum_read_cost + scd.getRecieve_cost().getCost();
		   	    		//評価額　　　⇒　自己評価額
		   	    		sum_toOther_eval	= sum_toOther_eval + scd.getEval_value(); 
			   	    	//集約年月のレコードを取得
			   	    	arraylist_tcd_period.add(scd);
	   	    		}
	   	    	}
//	   	    	if(arraylist_tcd.size() > 0){
	   	    	if(arraylist_tcd_period.size() > 0){
		   	    	//********************************************************
		   	    	//* コスト再計算
		   	    	//********************************************************

		    		Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(arraylist_tcd_period);
		    		tcdc.Caluculate();

		    		//更新データの取得
		    		Struct_Cost_Digest scd = new Struct_Cost_Digest();
		    		
					//コミュニティダイジェストから情報を取得
					Struct_Community_Digest scd_ref = com_dig.getCommunity_Digest(
							((Struct_Cost_Detail)arraylist_tcd_period.get(0)).getUserid(),
							((Struct_Cost_Detail)arraylist_tcd_period.get(0)).getSend_number_original());

					scd.setSender(scd_ref.getSender());				// 1.差出人
					scd.setSendnumber(scd_ref.getSendnumber());		// 2.送信ナンバー
		    		scd.setSubject(scd_ref.getSubject());			// 3.件名
		    		scd.setSend_date(scd_ref.getSend_date());		// 4.送信日時		
		    		
		    		
			    	//送信コストの設定
		    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
		    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
		    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
		    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
		    		scd.setSend_cost(send_cost_bar);										// 5.送信コスト
		    		
			    	//受信コストの設定
		    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
		    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
		    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
		    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
		    		scd.setRecieve_cost(recieve_cost_bar);									// 6.受信コスト	

		    		
			    	//総コストの設定
		    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
		    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
		    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
		    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
		    		scd.setTotal_cost(total_cost_bar);										// 7.総コスト
		    		
			    	//評価額の設定
		    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
		    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
		    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
		    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
		    		scd.setEval_value(eval_value_cost_bar);									// 8.評価額	

			    	//評価後コストの設定
		    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
		    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
		    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
		    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
		    		scd.setAteval_cost(ateval_cost_bar);									// 9.評価後コスト	

		    		scd.setFilename(addr.getFile_cost_suffix()+scd_ref.getFilename());		//11.送信ファイル名称

		    		tt.insertData(scd);		   	    		
	   	    	}
	    		
			}	    		

			//********************************
			//* 合計行
			//********************************
			
			//合計の算出
			Tool_Cost_Digest_Calculate tcdc = new Tool_Cost_Digest_Calculate(tt.getdata());
    		tcdc.Caluculate();

    		Struct_Cost_Digest scd = new Struct_Cost_Digest();

			scd.setSender("***合計***");				// 1.差出人
			scd.setSendnumber("99999");						// 2.送信ナンバー
    		scd.setSubject("***受信メール***");					// 3.件名
//    		scd.setSend_date(scd_ref.getSend_date());		// 4.送信日時		
    		
    		
	    	//送信コストの設定
    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
    		scd.setSend_cost(send_cost_bar);										// 5.送信コスト
    		
	    	//受信コストの設定
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
    		scd.setRecieve_cost(recieve_cost_bar);									// 6.受信コスト	

    		
	    	//総コストの設定
    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
    		scd.setTotal_cost(total_cost_bar);										// 7.総コスト
    		
	    	//評価額の設定
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
    		scd.setEval_value(eval_value_cost_bar);									// 8.評価額	

	    	//評価後コストの設定
    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
    		scd.setAteval_cost(ateval_cost_bar);									// 9.評価後コスト	

//    		scd.setFilename(addr.getFile_cost_suffix()+scd_ref.getFilename());		//11.送信ファイル名称

    		tt.insertLastData(scd);		    		
    		
    		tt.saveXml();		    		
    	
    	}
		//********************************
		//* 送信コスト
		//********************************
    	//送信コストのファイル設定
		fl = new File(addr.getDir_current() + addr.getDir_project() + project + addr.getDir_costsend());
    	ff = new Tool_FileFilter();
    	ff.setPrefix(addr.getFile_cost_suffix());
    	files = fl.listFiles(ff);
		
    	//ファイルが存在する場合
    	if(files != null && files.length > 0){

    		//作成用
    		Tool_Cost_Digest_IO tt = new Tool_Cost_Digest_IO (addr.getDir_current() +
																addr.getDir_project() +
																project	+  addr.getFs() +
																addr.getDir_costanalysis() +  addr.getFs() +
																yyyymm +addr.getPrefix_send());
//    		tt.loadXml();
    		tt.Initialize();
    		
    		//送信コストのループ
			for(int j=0; j<files.length; j++) {
				
				//ファイル更新日付を取得
				long lastdate = files[j].lastModified();
	   	    	DateFormat dfm = new SimpleDateFormat("yyyyMM");
	   	    	int yyyymm_int = Integer.valueOf(yyyymm).intValue();
	   	    	int lastdate_int = Integer.valueOf(dfm.format(lastdate)).intValue();
	   	    	//ファイル更新日付が基準年月より前の場合
	   	    	if(yyyymm_int  > lastdate_int){
		   	    	//次のファイルにスキップ
	   	    		continue;
	   	    	}
	    		Tool_Cost_Detail_IO tcd= new Tool_Cost_Detail_IO(files[j].getAbsolutePath());
	   	    	tcd.loadXml();
	   	    	
	   	    	//既存のコスト明細を取得
	   	    	ArrayList  arraylist_tcd		 = tcd.getArray_cost_detail();
	   	    	//集約期間のコスト明細のみ取得
	   	    	ArrayList  arraylist_tcd_period =  new ArrayList();
	   	    	
	   	    	//コスト明細のループ
	   	    	for(int k=0 ; k<arraylist_tcd.size() ; k++){
		   	    	Struct_Cost_Detail scd = (Struct_Cost_Detail) arraylist_tcd.get(k);
		   	    	int gendate_int = Integer.valueOf(dfm.format(scd.getGeneration_date())).intValue();
		   	    	//基準年月と発生日時が同じ場合
		   	    	if(yyyymm_int == gendate_int){
		   	    		//自分が発生したコスト
		   	    		if(su.getUserid().equals(scd.getGeneration_userid())){
			   	    		//送信コスト　⇒　書き込みコスト
		   	    			sum_write_cost	=	sum_write_cost + scd.getSend_cost().getCost();
			   	    		//受信コスト　⇒　読み取りコスト
			   	    		sum_read_cost		= sum_read_cost + scd.getRecieve_cost().getCost();
		   	    		}
		   	    		//他人が発生したコスト
		   	    		else{
			   	    		//評価額　　　⇒　他人評価額
			   	    		sum_toMe_eval	= sum_toMe_eval + scd.getEval_value(); 
		   	    		}
			   	    	//集約年月のレコードを取得
			   	    	arraylist_tcd_period.add(scd);
		   	    	}
	   	    	}
	   	    	
	   	    	
//	   	    	if(arraylist_tcd.size() > 0){
	   	    	if(arraylist_tcd_period.size() > 0){
		   	    	//********************************************************
		   	    	//* コスト再計算
		   	    	//********************************************************

		    		Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(arraylist_tcd_period);
		    		tcdc.Caluculate();

		    		//更新データの取得
		    		Struct_Cost_Digest scd = new Struct_Cost_Digest();

		    		//コミュニティダイジェストから情報を取得
		    		Struct_Community_Digest scd_ref = com_dig.getCommunity_Digest(
							((Struct_Cost_Detail)arraylist_tcd_period.get(0)).getUserid(),
							((Struct_Cost_Detail)arraylist_tcd_period.get(0)).getSend_number_original());

					scd.setSender(scd_ref.getSender());				// 1.差出人
					scd.setSendnumber(scd_ref.getSendnumber());		// 2.送信ナンバー
		    		scd.setSubject(scd_ref.getSubject());			// 3.件名
		    		scd.setSend_date(scd_ref.getSend_date());		// 4.送信日時		
		    		
		    		
			    	//送信コストの設定
		    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
		    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
		    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
		    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
		    		scd.setSend_cost(send_cost_bar);										// 5.送信コスト
		    		
			    	//受信コストの設定
		    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
		    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
		    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
		    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
		    		scd.setRecieve_cost(recieve_cost_bar);									// 6.受信コスト	

		    		
			    	//総コストの設定
		    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
		    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
		    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
		    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
		    		scd.setTotal_cost(total_cost_bar);										// 7.総コスト
		    		
			    	//評価額の設定
		    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
		    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
		    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
		    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
		    		scd.setEval_value(eval_value_cost_bar);									// 8.評価額	

			    	//評価後コストの設定
		    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
		    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
		    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
		    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
		    		scd.setAteval_cost(ateval_cost_bar);									// 9.評価後コスト	

		    		scd.setFilename(addr.getFile_cost_suffix()+scd_ref.getFilename());		//11.送信ファイル名称
		    		
		    		tt.insertData(scd);		   	    		
	   	    	}		   	    	
	   	    	
			}	    		

			//********************************
			//* 合計行
			//********************************
			
			//合計の算出
			Tool_Cost_Digest_Calculate tcdc = new Tool_Cost_Digest_Calculate(tt.getdata());
    		tcdc.Caluculate();

    		Struct_Cost_Digest scd = new Struct_Cost_Digest();

			scd.setSender("***合計***");				// 1.差出人
			scd.setSendnumber("99999");						// 2.送信ナンバー
    		scd.setSubject("***送信メール***");					// 3.件名
//    		scd.setSend_date(scd_ref.getSend_date());		// 4.送信日時		
    		
    		
	    	//送信コストの設定
    		Struct_CostBar 	send_cost_bar = new Struct_CostBar();
    		send_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getSend_cost()));
    		send_cost_bar.setRealvalue(tcdc.getSend_cost());
    		send_cost_bar.setMode(su.getMode(tcdc.getSend_cost()));
    		scd.setSend_cost(send_cost_bar);										// 5.送信コスト
    		
	    	//受信コストの設定
    		Struct_CostBar 	recieve_cost_bar = new Struct_CostBar();
    		recieve_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getRecieve_cost()));
    		recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
    		recieve_cost_bar.setMode(su.getMode(tcdc.getRecieve_cost()));
    		scd.setRecieve_cost(recieve_cost_bar);									// 6.受信コスト	

    		
	    	//総コストの設定
    		Struct_CostBar 	total_cost_bar = new Struct_CostBar();
    		total_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getTotal_cost()));
    		total_cost_bar.setRealvalue(tcdc.getTotal_cost());
    		total_cost_bar.setMode(su.getMode(tcdc.getTotal_cost()));
    		scd.setTotal_cost(total_cost_bar);										// 7.総コスト
    		
	    	//評価額の設定
    		Struct_CostBar 	eval_value_cost_bar = new Struct_CostBar();
    		eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getEval_value()));
    		eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
    		eval_value_cost_bar.setMode(su.getMode(tcdc.getEval_value()));
    		scd.setEval_value(eval_value_cost_bar);									// 8.評価額	

	    	//評価後コストの設定
    		Struct_CostBar 	ateval_cost_bar = new Struct_CostBar();
    		ateval_cost_bar.setMaxvalue(su.getMaxValue(tcdc.getAtvalue_cost()));
    		ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
    		ateval_cost_bar.setMode(su.getMode(tcdc.getAtvalue_cost()));
    		scd.setAteval_cost(ateval_cost_bar);									// 9.評価後コスト	

//    		scd.setFilename(addr.getFile_cost_suffix()+scd_ref.getFilename());		//11.送信ファイル名称

    		tt.insertLastData(scd);		 				
			
    		tt.saveXml();		    		

    	
    	}

    	

		
		//コスト集計
		double	sum_real_cost	=	sum_write_cost	+	sum_read_cost;		//実コスト
		double sum_cont_cost	=	sum_toMe_eval	-	sum_toOther_eval;	//貢献コスト
		double sum_total_cost	=	sum_real_cost	-	sum_cont_cost;		//総コスト

		//コスト分析ダイジェストレコードの作成
		Struct_Cost_Analysis_Digest scad = new Struct_Cost_Analysis_Digest();
		scad.setYyyymm(yyyymm);										// 1.年月

		Struct_Cost_AnalysisBar write_costBar = new Struct_Cost_AnalysisBar();
		write_costBar.setRealvalue((int) sum_write_cost);
		write_costBar.setMaxvalue(su.getWrite_maxcost());
		scad.setWrite_cost(write_costBar);							// 2.書き込みコスト

		Struct_Cost_AnalysisBar read_costBar = new Struct_Cost_AnalysisBar();
		read_costBar.setRealvalue((int) sum_read_cost);
		read_costBar.setMaxvalue(su.getRead_maxcost());
		scad.setRead_cost(read_costBar);							// 3.読み取りコスト

		Struct_Cost_AnalysisBar real_costBar = new Struct_Cost_AnalysisBar();
		real_costBar.setRealvalue((int) sum_real_cost);
		real_costBar.setMaxvalue(su.getReal_maxcost());
		scad.setReal_cost(real_costBar);							// 4.実コスト
		
		Struct_Cost_AnalysisBar toMe_evalBar = new Struct_Cost_AnalysisBar();
		toMe_evalBar.setRealvalue((int) sum_toMe_eval);
		toMe_evalBar.setMaxvalue(su.getMy_eval_maxcost());
		scad.setToMe_eval(toMe_evalBar);							// 5.他人評価額
		
		Struct_Cost_AnalysisBar toOther_evalBar = new Struct_Cost_AnalysisBar();
		toOther_evalBar.setRealvalue((int) sum_toOther_eval);
		toOther_evalBar.setMaxvalue(su.getOther_eval_maxcost());
		scad.setToOther_eval(toOther_evalBar);						// 6.自己評価額

		Struct_Cost_AnalysisBar cont_costBar = new Struct_Cost_AnalysisBar();
		cont_costBar.setRealvalue((int) sum_cont_cost);
		cont_costBar.setMaxvalue(su.getCont_maxcost());
		scad.setCont_cost(cont_costBar);							// 7.貢献コスト

		Struct_Cost_AnalysisBar total_costBar = new Struct_Cost_AnalysisBar();
		total_costBar.setRealvalue((int) sum_total_cost);
		total_costBar.setMaxvalue(su.getTotal_maxcost());
		scad.setTotal_cost(total_costBar);							// 8.総コスト

		//作成日付
    	long nowtime = System.currentTimeMillis();
		
		scad.setBatch_date(nowtime);								// 9.作成日付
		
		scad.setFilename_send(yyyymm+addr.getPrefix_send());		// 10.送信ファイル（参照）			
		scad.setFilename_recieve(yyyymm+addr.getPrefix_recieve());	// 11.受信ファイル（参照）			

		//コスト分析ダイジェストを取得
		Tool_Cost_Analysis_Digest_IO t = new Tool_Cost_Analysis_Digest_IO (
										addr.getDir_current() + 
										addr.getDir_project() + 
										project + 
										addr.getDir_costanalysis() 	 +
										addr.getFile_cost_digest());
		t.loadXml();
		int search = t.getLine(yyyymm);
		
		//対象年月のコスト分析ダイジェストが存在しない場合
		if(search == -1){
			t.insertData_asc(scad);
		}
		//対象年月のコスト分析ダイジェストが存在する場合
		else{
			t.replaceData(search, scad);
		}
		t.saveXml();		
	}
	
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}	

	
}
