package socket_common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.table.DefaultTableModel;

import mailcost_main.Gui_PanelCommunity;
import mailcost_main.Gui_PanelProject;
import mailcost_main.Tool_JTable_IO;
import message.Tool_SendList_IO;

import structure.File_and_Directory_Address;
import structure.Struct_Cost_SendList;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import tool.RemoveFileExtension;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Recieve {

	//ソケット
	Socket sock = null;

	//送受信用
	InputStream in = null;							//入力ストリーム
	OutputStream out = null;						//出力ストリーム

	
	
    private Struct_SendList sendlist;
    private Struct_Cost_SendList cost_sendlist;
	
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
										addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	private byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ
	private byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	private int j,k;														//送信、受信バイト数
	
	private byte sendkind;//1.mail 2.cost 3.relay mail 4.relay cost
	
	
	public Recieve(Socket sock,
			InputStream in,
			OutputStream out){

		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.sock = sock;
		this.in		=	in;
		this.out	=	out;
		
		
		
	}
	
	
	public boolean submit(){

		//メール送信許可要求の受付
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "010,020,030,040 waiting mail-send-permission-request");
		if(second_Contact() == false){
//			close();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "010,020,030,040 connection Error");
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "010,020,030,040 recieve mail-send-permission-request OK");

		//メール送信許可要求回答通知
		conection_Answer((short) 110);	
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 sended mail-send-permission-request anser  OK");

		
//		String recieve_file;
		//メールファイルの受信
		if(sendkind == 1){
			String recieve_file 	= 	addr.getDir_current() + 
										addr.getDir_buff_recieve() + "\\" +
										sendlist.getFilename();
			String recieve_digest 	= 	addr.getDir_current() + 
										addr.getDir_buff_recieve() + "\\" +
										new RemoveFileExtension().removeFileExtension(sendlist.getFilename())   +
										addr.getFile_digest();
			if(recieve_file(recieve_file) == false){
//				close();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
				return false;
			}
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve OK");
			mail_digest_Make(recieve_digest);
		}
		//コストファイルの受信
		else if(sendkind == 2){
			String recieve_file 	= 	addr.getDir_current() + 
										addr.getDir_buff_recieve() +  addr.getFs()  +
										cost_sendlist.getFilename();
			String recieve_digest 	= 	addr.getDir_current() + 
										addr.getDir_buff_recieve() +  addr.getFs()  +
										new RemoveFileExtension().removeFileExtension(cost_sendlist.getFilename())   +
										addr.getFile_digest();
			if(recieve_file(recieve_file) == false){
//				close();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
				return false;
			}
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve OK");
			cost_digest_Make(recieve_digest);		

		}
		//メールファイルの中継
		else if(sendkind == 3){
			String recieve_file 	= 	addr.getDir_current() + 
										addr.getDir_buff_relay() +  addr.getFs()  +
										sendlist.getFilename();
			String recieve_digest 	= 	addr.getDir_current() + 
										addr.getDir_buff_relay() +  addr.getFs()  +
										new RemoveFileExtension().removeFileExtension(sendlist.getFilename())   +
										addr.getFile_digest();
			if(new File(recieve_file).exists() == false){
				if(recieve_file(recieve_file) == false){
//					close();
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
					return false;
				}
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve OK");
				mail_digest_Make(recieve_digest);
				
			}
			//同じメール、かつ送信先の異なる場合
			else{
				while(true){
					//枝番をランダム作成する準備
		   	    	Random rnd = new Random();
		   	    	DecimalFormat df = new DecimalFormat("000");
		    		int rdnumber = rnd.nextInt(1000);
		    		//有無チェック
		    		String dir = addr.getDir_current() + 
		    						addr.getDir_buff_relay() +  addr.getFs() ; 
		    		String file = new RemoveFileExtension().removeFileExtension(sendlist.getFilename()) + "_" +
									 df.format(rdnumber)+ "_relay.txt";
		    		String digest =  new RemoveFileExtension().removeFileExtension(sendlist.getFilename()) + "_" +
									 df.format(rdnumber)+ "_relay" +
										addr.getFile_digest();
		    		recieve_digest = dir+ digest;
		    		recieve_file = dir + file;
		    		if(new File(recieve_digest).exists() == true	){
						continue;
					}
		    		sendlist.setFilename(file);
		    		if(recieve_file(recieve_file) == false){
//						close();
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
						return false;
					}
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve OK");
					mail_digest_Make(recieve_digest);
					break;
				}
				
			}
			
		}
		//コストファイルの中継
		else if(sendkind == 4){
			String recieve_file 	=	addr.getDir_current() + 
										addr.getDir_buff_relay() +  addr.getFs()  +
										cost_sendlist.getFilename();
			String recieve_digest 	=	addr.getDir_current() + 
										addr.getDir_buff_relay() +  addr.getFs()  +
										new RemoveFileExtension().removeFileExtension(cost_sendlist.getFilename())   +
										addr.getFile_digest();
			if(recieve_file(recieve_file) == false){
//				close();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve Error");
				return false;
			}
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "011 file recieve OK");
			cost_digest_Make(recieve_digest);		
		}
		else{
			return false;
		}
		

		//メールファイル受信完了通知
		conection_Answer((short) 112);	
		
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "112 sended mail-send-complete OK");
		
		return true;
		
	}


	
	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Send Answer code:"+code);
		
	}
	
	public int getport() {
			return sock.getPort();
	}

	
/*	
	public void close() {
		blnswitch = false;
		try {
			//ソケットクローズ
			sock.close();
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "socket close OK");

		} catch (IOException e) {
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "socket close NG");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			e.printStackTrace();
		}
	}
*/	
	
	
	public boolean second_Contact()   {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact start");

		
		boolean first = false;
		ByteBuffer buffer = ByteBuffer.allocate(8192);
			
	    int recvMsgSize = 0;
	    int totalByte = 0;

		short edaban_save = 1;
		try {
			recvMsgSize = in.read(buf_receive);
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		while(true){
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:total file Size:"+ recvMsgSize);
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:      Data Size:"+ (recvMsgSize-6));
		     //Write to file
			short code		= (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );
			
			//接続要求コードではない場合
			if(code == 10 || code == 20 || code == 30 || code == 40){
				short len		= (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
				short edaban	= (short) (   ((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );

				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:recieve mail parts edaban_save:"+ edaban);

				
				if(first == false){
					if(code == 10){
						sendkind = 1;
					}
					else if(code == 20){
						sendkind = 2;
					}
					else if (code == 30){
						sendkind = 3;
					}
					else{
						sendkind = 4;
					}
					first = true;
				}
				
				
				
				//枝番誤り
				if(edaban != edaban_save){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:edaban miss match Error. real edaban:"+ edaban +" vs request edaban:" + edaban_save);
					return false;
				}

				//電文の長さ誤り
				if(recvMsgSize-6 < len){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:DADA too short Error.  real size:"+(recvMsgSize-6) + "  vs  info size:" + len);
					return false;
				}
				
				byte[] data = new byte[len];
				
				for(int i=0 ; i<len ; i++){
					data[i] = buf_receive[i+6] ;
				}

				
				
				totalByte = totalByte + len;
				buffer.put(data);
//						fout.write(data,0,len);
				

				if((recvMsgSize-6) == len){
					recvMsgSize = 0;
					try {
						//ソケット通信から情報を取得
						if((recvMsgSize = in.read(buf_receive)) == -1){
							return false;
						}
					} catch (IOException e) {
						e.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
						return false;
					}
				}
				//連続してデータが届いた場合、
				else{
//					byte[] buf = buf_receive;
//					recvMsgSize = recvMsgSize - (len + 6);
//					for(int i=0 ; i<recvMsgSize ; i++){
//						buf_receive[i] = buf[len + 6 + i] ;
//					}
					byte[] buf = buf_receive;
					//フライングして到着した分をバッファに保存
					int Arrival = recvMsgSize - (len + 6);
					for(int i=0 ; i<Arrival ; i++){
						buf_receive[i] = buf[len + 6 + i] ;
					}
					//ファイルサイズっぽいデータがまるごと含まれていた場合
					if(Arrival == 6){
						recvMsgSize = Arrival;
						continue;
					}
					//未到着分を残りのバッファサイズに確保する
					recvMsgSize = 0;
					try {
						if((recvMsgSize = in.read(buf_receive,Arrival,sysconfig.getBuffsize() - Arrival)) == -1){
							return false;
						}
					} catch (IOException e) {
						e.printStackTrace();
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
						logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
						return false;
					}
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
								"Arrival ahead bytes :Size="+ Arrival);
				
				}
			
				edaban_save++;
			
			}
			else if(code == 15){
				
				int size		= (int) (   ((buf_receive[2]<<24)&0xFF00) + ((buf_receive[3]<<16)&0xFF00) +
											((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:recieved mail. file size:"+ size);
				if(totalByte != size){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:File Length Miss Match Error.  real size:"+totalByte + "  vs  info size:" + size);
					return false;
				}
				break;
			}
			else{
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Code is not 015 Error. code:"+code);
				return false;
			}
			

		  }

		//********************************************		
		//* 読み込みバッファからデータを取得
		//********************************************
		buffer.flip();
		byte[] data = new byte[buffer.limit()];
		buffer.get(data);
		
		
		String target_project;
		String target_community;
		String source_project;
		String source_community;
		String source_user;

		//メール送信の場合
		if(sendkind == 1 || sendkind == 3){
			sendlist = new Struct_SendList();
			sendlist.putByte(data);
			target_project 		= 	sendlist.getTarget_project();
			target_community 	= 	sendlist.getTarget_community();
			source_project		=	sendlist.getSource_project();
			source_community	=	sendlist.getSource_community();
			source_user			= 	sendlist.getSource_user();
		
		}
		//コスト送信の場合
		else if(sendkind == 2|| sendkind == 4){
			cost_sendlist = new Struct_Cost_SendList();
			cost_sendlist.putByte(data);
			target_project 		= 	cost_sendlist.getTarget_project();
			target_community 	= 	cost_sendlist.getTarget_community();
			source_project		=	cost_sendlist.getSource_project();
			source_community	=	cost_sendlist.getSource_community();
			source_user			= 	cost_sendlist.getSource_user();
		}
		else{
			return false;
		}

		//送信先プロジェクトチェック
		Gui_PanelProject pp = new Gui_PanelProject("nopanel"); 
		//*コストが送信できるように脱退プロジェクトも含む
   		ArrayList ppl= pp.getProject();
   		//プロジェクトは参加中？
   		if(	ppl.indexOf(target_project) == -1){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Target Project is not Entry project:"+target_project);
   			return false;
   		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Target Project is Entry project:"+target_project);

		//20071030 
		//直接送信の場合
		if(sendkind == 1 || sendkind == 2){
			//送信先コミュニティチェック
	   		Gui_PanelCommunity pc = new Gui_PanelCommunity("nopanel"); 
	   		ArrayList  pcl = pc.getCommunity(target_project);
	   		if(	pcl.indexOf(target_community) == -1){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Target Community is not Entry community:"+target_community);
	   			return false;
	   		}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Target Community is Entry community:"+target_community);
		}
   		//送信元ユーザーチェック
		String filename =	addr.getDir_current() + 
								addr.getDir_project() + 
								source_project +  
								addr.getFile_com_menber();
		Tool_JTable_IO tc = new Tool_JTable_IO(filename);
		String[] columnames = {"コミュニティ名","USER","ユーザー","NODE"};
		tc.putColum(columnames);
		tc.loadXml();
		DefaultTableModel model = tc.getDefaultTableModele();
    	
		for(int i=0 ; i<model.getRowCount(); i++){
			if(model.getValueAt(i, 0).equals(source_community) && 
					model.getValueAt(i, 1).equals(source_user)    ){
				System.out.println("PROJECT,COMMUNITY,USER認証成功");
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Check Target Project and Community and User OK!");
				
				return true;
			}
		}
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Check Target Project and Community and User NG!");
		return false;			
						
		
		}		
	
/*	
	//メール送信許可要求の受付
	public boolean xsecond_Contact(){
		try {
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Second Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		
		
		//データなし
		if(k<5){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Nothing Data Error");
			return false;
		}

		//コード取得
		short code ;
		code =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );
		

		//接続要求コードではない場合 10:メール送信　20:コスト送信
		if(code != 10 && code != 20 && code != 30 && code != 40){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Code is Not (010,020,030,040) Error. code="+ code);
			return false;
		}
		
		//レングス取得
		short len ;
		System.out.println("debug"+buf_receive[2]);
		System.out.println("debug"+buf_receive[3]);
		len =  (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
		
		//電文の長さ誤り
		if(k-4 != len){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Data Length Unmatch Error. "
					+ "info Length=" + len	+ " Real Length=" + (k-4));
			return false;
		}
		
		//プロジェクト、コミュニティ、ユーザーの設定			
//		Struct_Project_Community_User pcu = new Struct_Project_Community_User();
		byte data[] = new byte[len];
		for(int j = 0;j<len;j++){
			data[j] = buf_receive[j+4];
		}

		String target_project;
		String target_community;
		String source_project;
		String source_community;
		String source_user;

		System.out.println(data[0]);
		//メール送信の場合
		if(code == 10 || code == 30){
			if(code == 10){
				sendkind = 1;
			}
			else{
				sendkind = 3;
			}
			sendlist = new Struct_SendList();
			sendlist.putByte(data);
			target_project 		= 	sendlist.getTarget_project();
			target_community 	= 	sendlist.getTarget_community();
			source_project		=	sendlist.getSource_project();
			source_community	=	sendlist.getSource_community();
			source_user			= 	sendlist.getSource_user();
		
		}
		//コスト送信の場合
		else if(code == 20|| code == 40){
			if(code == 20){
				sendkind = 2;
			}
			else{
				sendkind = 4;
			}
			cost_sendlist = new Struct_Cost_SendList();
			cost_sendlist.putByte(data);
			target_project 		= 	cost_sendlist.getTarget_project();
			target_community 	= 	cost_sendlist.getTarget_community();
			source_project		=	cost_sendlist.getSource_project();
			source_community	=	cost_sendlist.getSource_community();
			source_user			= 	cost_sendlist.getSource_user();
		}
		else{
			return false;
		}

		//送信先プロジェクトチェック
		Gui_PanelProject pp = new Gui_PanelProject("nopanel"); 
   		ArrayList ppl= pp.getProject();
   		//プロジェクトは参加中？
   		if(	ppl.indexOf(target_project) == -1){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Target Project is not Entry project:"+target_project);
   			return false;
   		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Target Project is Entry project:"+target_project);

		//20071030 
		//直接送信の場合
		if(code == 10 || code == 20){
			//送信先コミュニティチェック
	   		Gui_PanelCommunity pc = new Gui_PanelCommunity("nopanel"); 
	   		ArrayList  pcl = pc.getCommunity(target_project);
	   		if(	pcl.indexOf(target_community) == -1){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Target Community is not Entry community:"+target_community);
	   			return false;
	   		}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Target Community is Entry community:"+target_community);
		}


   		//送信元ユーザーチェック
		String filename =	addr.getDir_current() + 
								addr.getDir_project() + 
								source_project +  
								addr.getFile_com_menber();
		Tool_JTable_IO tc = new Tool_JTable_IO(filename);
		String[] columnames = {"コミュニティ名","USER","ユーザー","NODE"};
		tc.putColum(columnames);
		tc.loadXml();
		DefaultTableModel model = tc.getDefaultTableModele();
    	
		for(int i=0 ; i<model.getRowCount(); i++){
			if(model.getValueAt(i, 0).equals(source_community) && 
					model.getValueAt(i, 1).equals(source_user)    ){
				System.out.println("PROJECT,COMMUNITY,USER認証成功");
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Second Contact:Check Target Project and Community and User OK!");
				
				return true;
			}
		}
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Second Contact:Check Target Project and Community and User NG!");
		return false;			
		
	}		
*/
	
	
	public boolean recieve_file(String str_recieve)   {
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file start");


			FileOutputStream fout = null;
			try {
				fout = new FileOutputStream(str_recieve);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "recieve_file:FileOutputStream error");
				return false;
			}

	/*		OutputStreamWriter osw = null;		
			BufferedWriter bw = null;
			try {
				osw = new OutputStreamWriter(fout , "UTF8");
				bw = new BufferedWriter(osw);
			} catch (UnsupportedEncodingException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			}
	*/

			
			
//				byte[] data = new byte[BUFSIZE];
		    int recvMsgSize = 0;
		    int totalByte = 0;

			try {
				short edaban_save = 1;
				recvMsgSize = in.read(buf_receive);
				while(true){
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Packet Total Size="+ recvMsgSize);
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Real   Data  Size="+ (recvMsgSize-6));
				     //Write to file
					short code		= (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

					//接続要求コードではない場合
					if(code == 11){
						short len		= (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
						short edaban	= (short) (   ((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:Data Size Info.  ="+ len);
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:recieve mail parts edaban_save="+ edaban);

						//枝番誤り
						if(edaban != edaban_save){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() , 
									"recieve_file:edaban miss match Error. real edaban="+ edaban +" vs request edaban=" + edaban_save);
							fout.close();
							return false;
						}

						//電文の長さ誤り
						if(recvMsgSize-6 < len){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() ,
									"recieve_file:DADA too short Error.  real size="+(recvMsgSize-6) + "  vs  info size=" + len);
							fout.close();
							return false;
						}
						
						byte[] data = new byte[len];
						
						for(int i=0 ; i<len ; i++){
							data[i] = buf_receive[i+6] ;
						}

						
						
						totalByte = totalByte + len;
						fout.write(data,0,len);
						

	/*					String a = data.toString();
						logout.out("zzz", a);
						bw.write(a);
						bw.newLine();
	*/					
						//
						if((recvMsgSize-6) == len){
							recvMsgSize = 0;
							sleep();
							if((recvMsgSize = in.read(buf_receive)) == -1){
								return false;
							}
						}
						//連続してデータが届いた場合、
						else{
							byte[] buf = buf_receive;
							//フライングして到着した分をバッファに保存
							int Arrival = recvMsgSize - (len + 6);
							for(int i=0 ; i<Arrival ; i++){
								buf_receive[i] = buf[len + 6 + i] ;
							}
							//ファイルサイズっぽいデータがまるごと含まれていた場合
							if(Arrival == 6){
								recvMsgSize = Arrival;
								continue;
							}
							//未到着分を残りのバッファサイズに確保する
							recvMsgSize = 0;
							if((recvMsgSize = in.read(buf_receive,Arrival,sysconfig.getBuffsize() - Arrival)) == -1){
								return false;
							}
							logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
										"Arrival ahead bytes :Size="+ Arrival);
						}
						
					
						edaban_save++;
					
					}
					else if(code == 12){
						int size		= (int) (   ((buf_receive[2]<<24)&0xFF00) + ((buf_receive[3]<<16)&0xFF00) +
													((buf_receive[4]<<8)&0xFF00)   + (buf_receive[5]&0xFF) );
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file:recieved mail. file size:"+ size);
						if(totalByte != size){
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() , 
									"recieve_file:File Length Miss Match Error.  real size="+totalByte + "  vs  info size=" + size);
							return false;
						}
//						bw.close();
						fout.close();
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "recieve_file end");
						return true;
					}
					else{
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "recieve_file:Code is not 012 Error. code="+code);
						fout.close();
						return false;
					}
					

				  }

				
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
				return false;

			}
		
		}	

	public boolean send_Byte(byte[] byte_send)  {
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte end");
		return true;
	}
	
	
	private void mail_digest_Make(String filename){
    	Tool_SendList_IO slm = new Tool_SendList_IO(filename, sendlist);
	    slm.saveXml_direct();
	}


	private void cost_digest_Make(String filename){
		Tool_Cost_SendList_IO slm = new Tool_Cost_SendList_IO(filename, cost_sendlist);
    	slm.saveXml();
	}
	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
}
