package socket_server;

import java.net.*;
import java.util.ArrayList;
import java.util.Properties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import javax.swing.Timer;

import structure.File_and_Directory_Address;
import structure.Struct_System_Config;
import tool.Tool_LogOut;
import tool.Tool_Status_IO;
import tool.Tool_System_Config_IO;

public class Server_Main implements ActionListener {
	//サーバソケット
	ServerSocket servsock = null;
	//ソケット
	ArrayList al_socket	= null;							

//	boolean blnstatus = true;
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	Timer t;

	public   void Server_Main(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
		
		//１秒おきのタイマーをセット
		t = new Timer(sysconfig.getTimer_server(),this);
		t.addActionListener(this);
		t.start();

		while(true){
			try {
				//接続要求待機
				Socket socket = servsock.accept();
				if(al_socket == null){
					al_socket = new ArrayList();
				}
				Server_socket sc = new Server_socket(socket);
				
				al_socket.add(sc);
				sc.start();
			} catch (IOException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Socket Open Error");
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}
		}
		
	}	
	
	public void open(){

		//サーバソケット宣言
		try {
			servsock = new ServerSocket(sysconfig.getPort());
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Server Socket Open Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}
	}
	public void close() {

		int total = getSocketSize();
		if(total != 0)	{
			for(int i=0;i<total;i++){
				Server_socket sock = (Server_socket) al_socket.get(0);
				sock.close();
				sock = null;
				al_socket.remove(0);
			}
		}
//		blnswitch = false;
		
		try {
			//ソケットクローズ
			servsock.close();
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Server Socket Close Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}
	}

	public int getSocketSize(){
		//ソケット数
		if(al_socket == null){
			return 0;
		}
		if(al_socket.isEmpty() == true){
			return 0;
		}
		return al_socket.size();
	}

	public void delete_socket(int i){
		Server_socket sock = (Server_socket) al_socket.get(i);
		sock.close();
		al_socket.remove(i);
	}


	public  static  void main(String[] args){
		 
		Server_Main submit = new Server_Main();
		submit.open();
		submit.Server_Main();
	}

	
	public void actionPerformed(ActionEvent e) {
		int total = getSocketSize();
		if(total == 0)	{
			if(sysconfig.isTestmode() == false){

				Tool_Status_IO st = new Tool_Status_IO(addr.getDir_current() + addr.getFile_status());
			
				//終了まちを取得
				if(st.getEndWait() == true ){
					st.setEnd();
					logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end  ");
					System.exit(0);
				}
				//一時停止を取得
				else if(st.getPauseWait() == true ){
					st.setPause();
					logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "end(Pause)  ");
					System.exit(0);
				}
			}
			return ;
		}
			

		for(int i=0;i<total;i++){
			Server_socket sock = (Server_socket) al_socket.get(i);
			//回線は生きているか？
			if(sock.getblnswitch() == true){
			}else{
//				i++;
				sock.close();
				delete_socket(i);
				//要素数を調整
				if(i<total){
					total--;
				}
			}
		}
		
		
	}

	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (Exception e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}	
	
	
}
