package socket_server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_System_Config;
import tool.Tool_Community_Menber_IO;
import tool.Tool_JList_IO;
import tool.Tool_JTree_IO;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Server_MasterSend {


	//ソケット
	private Socket sock;

	//送受信用
	private InputStream in;						//入力ストリーム
	private OutputStream out;						//出力ストリーム
	
	private String  filepath;
	private long  lastupdate;
	File  masterfile;
	
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = 
		new File_and_Directory_Address ();
	//モード取得
	private Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+
									addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ
	
	
	public Server_MasterSend(Socket sock,
			InputStream in,
			OutputStream out,
			String filepath,
			long lastupdate){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}

		this.sock 	= sock;
		this.in			 =	in;
		this.out		 =	out;
		this.filepath	 =	filepath;
		this.lastupdate =	lastupdate;
	}


	
	public boolean sendcheck(){
		masterfile = new File(filepath);
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , masterfile.getName() + " file llastupdate="+masterfile.lastModified());
		//マスター更新日がクライアントのタイムスタンプを越えている場合
		if(masterfile.exists() && (masterfile.lastModified() > lastupdate)){
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , masterfile.getName() + " file UPDATE");
			return true;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , masterfile.getName() + " file NO UPDATE");
		return false;
	}
	
	
	
	public boolean submit(){
		
		int filesize;
		//(060)マスター送信許可要求の送信
		if(masterfile_Request((short) 60,masterfile.getName()) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "010 sended master-send-permission-request OK");


		//(110)メール送信許可の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 waitingmaster-send-permission-request anser");
		if(code_Recept((short)110) == false){
			//受信失敗
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "110 recieved master-send-permission-request anser OK");
		
		sleep();

		//マスターファイル送信
		filesize = send_file(filepath);
		
		if(filesize  == 0){
			//送信失敗
			return false;
		}
	

		//ファイル送信完了の送信
		if(send_filesize((short) 12,filesize) == false){
			//送信失敗
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "012 sended mail-send-complete OK");

		//(112)ファイル受信完了の受信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "112 waiting mail-send-complete anser");
		if(code_Recept((short)112) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "112 recieved mail-send-complete anser OK");
		
		return true;
		
	}
	
	
	public boolean entryCommunityMake(String masterDir,String project,String userid){

		//*********************************************
		//* コミュニティメンバーの取得
		//*********************************************
		Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO(masterDir +addr.getFile_com_menber());
		tcm.loadXml();
		ArrayList<Struct_Community_Menber> commenData = tcm.getCommunity(userid);
		
		//***************************************
		//*参加コミュニティ追加
		//***************************************
    	DefaultListModel listmodel = new DefaultListModel();
    	if(commenData != null && commenData.size() > 0){
        	for(int i=0;i<commenData.size();i++){
    	    	listmodel.addElement(commenData.get(i).getCommunity());
    		}
    	}
    	JList list = new JList(listmodel);
    	
		//***********************************************
		//* 参加コミュニティの一時保存
		//***********************************************
   		File file = new File(filepath);
   		if(file.exists()){
   			file.delete();
   		}
		Tool_JList_IO tls = new Tool_JList_IO(filepath);	
   		tls.putJList(list);
   		tls.saveXml();

   		//* sendcheck()の補完
		masterfile = new File(filepath);

   		return true;
	}
	
	
	
	
	//マスターファイル送信許可要求
	private boolean masterfile_Request(short code,String filename) {
		
		short i =  (short) filename.length();
		byte[] send = new byte[i+4];			

		//コード
		send[0] =  (byte)((code >>> 8) & 0xFF) ;
		send[1] =  (byte)((code >>> 0) & 0xFF) ;
		//レングス
		send[2] =  (byte)((i >>> 8) & 0xFF);
		send[3] =  (byte)((i >>> 0) & 0xFF);
		
		byte[] buff =  filename.getBytes();

		for(int j = 0;j<buff.length;j++){
			send[j+4] = buff[j];
		}
		
		if(send_Byte(send) == false){
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "First Contact Request. code="+code + " masterfile="+filename);
		return true;
		
	}

	//接続要求受付
	private boolean code_Recept(short code){
		int k;
		try {
			//タイムアウト指定　６０秒
			sock.setSoTimeout(sysconfig.getTimer_out());
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
//			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Code Recept:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		catch (Exception e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Code Recept:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
	}

		//タイムアウトエラー
		if(k < 0){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Time Out Error ");
			return false;
		}

		//情報あり？
		if(k != 2){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Data Length is not 2. length:"+k);
			return false;
		}

		//コード取得
		short cd =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );

		//要求コードではない場合
		if(code != cd){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Code Recept:Code unmatch.  wait code="+code + "  send code="+cd);
			return false;
		}
		return true;
		
	}			


	
	
	private int send_file(String filename)  {
		int filesize = 0;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file start");
		
		//ストリームデータ送信

		FileInputStream fin = null;

		short code = 11;
	    int len = 0;
	    short edaban = 0;

	    byte[] data = new byte[sysconfig.getBuffsize() -6];

		//ファイル設定
		try {
			fin = new FileInputStream(filename);
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return 0;
		}
		
		try {
			//送信ループ
			filesize = 0;
			while ((len = fin.read(data)) != -1) {
				byte[] send = new byte[len+6];
			    //コード
				send[0] =  (byte)((code >>> 8) & 0xFF);
				send[1] =  (byte)((code >>> 0) & 0xFF) ;
			    //レングス
				send[2] =  (byte)((len >>> 8) & 0xFF);
				send[3] =  (byte)((len >>> 0) & 0xFF);
			    //枝番
				edaban++;
				send[4] =  (byte)((edaban >>> 8) & 0xFF);
				send[5] =  (byte)((edaban >>> 0) & 0xFF);

				//送信データ作成
				for(int i=0;i<len;i++){
					send[i+6]= data[i];
				}

//				out.write(send, 0, len+6);
				send_Byte(send);
				filesize = filesize + len;
//				System.out.println("send len:" + send.length);
//				System.out.println("len  len:" + len);
				
				sleep();
			}
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
			return 0;
		}
		


		//おまじない
		try {
			//出力ファイルの掃き出し
			out.flush();
			//入力ファイルの開放
			fin.close();
			
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e1.getStackTrace());
		}
		
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_file end");
		return filesize;
	}	
	
	private boolean send_Byte(byte[] byte_send)  {
		int j;
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "byte_send end");
		return true;
	}

	//メールファイル送信完了＆ファイルの大きさを送信
	private boolean send_filesize(short code,int filesize) {
		
		byte send[]= new byte[6];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send[2] =  (byte)((filesize >>> 24)  & 0xFF) ;
		send[3] =  (byte)((filesize >>> 16)  & 0xFF) ;
		send[4] =  (byte)((filesize >>> 8)  & 0xFF) ;
		send[5] =  (byte)((filesize >>> 0)  & 0xFF) ;
		
		if(send_Byte(send) == false){
			return false;
		}

		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "sended filesize  code="+code + " filesize="+filesize);
		
		return true;
		
	}
	

	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}

	private void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
	
}
