package socket_server;


import java.net.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.io.*;

import javax.swing.table.DefaultTableModel;

import socket_common.Cost_Send;
import socket_common.Mail_Send;
import socket_common.Recieve;
import structure.File_and_Directory_Address;
import structure.Struct_Connect_Digest;
import structure.Struct_Cost_SendList;
import structure.Struct_Entry_Project;
import structure.Struct_MasterFile;
import structure.Struct_SendList;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Cost_SendList_IO;
import tool.Tool_DirDel;
import tool.Tool_Entry_Project_IO;
import tool.Tool_Eval_Rank_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_MasterFile_IO;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;
import mailcost_main.Gui_PanelProject;
import mailcost_main.Tool_JTable_IO;
import message.Tool_SendList_IO;


public class Server_socket{
	
	//ソケット
	Socket sock = null;

	//送受信用
	InputStream in = null;							//入力ストリーム
	OutputStream out = null;						//出力ストリーム

	
    private Tool_User_IO user_info;
    private Struct_User su;
	
	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address ();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
														addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	private byte[] buf_receive = new byte[sysconfig.getBuffsize()];		//受信バッファ
	private byte[] buf_send = new byte[sysconfig.getBuffsize()];			//送信バッファ
	private int j,k;														//送信、受信バイト数

	//上位クラスへの引渡し
	private boolean blnswitch = true;						//ループスイッチ
	

	
	public Server_socket(Socket sock){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "socket open");
		
		this.sock = sock;

		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "+++ Conected Information+++");
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "source      Address"+ sock.getLocalAddress() + " on Port"+ sock.getLocalPort());
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "destination Address"+ sock.getInetAddress() + " on Port"+ sock.getPort());

		try {
			in  = sock.getInputStream();
			out = sock.getOutputStream();
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}
		
		
//		System.out.println("Connected to echo server(from " +
//				sock.getInetAddress().getHostAddress() + " on port" +
//				sock.getPort() + ")");
	}

	public  void start(){

		logout.out(sysconfig.getLogmode3(),this.getClass().getName() , "start");
		
		//クライアント接続要求の受付
		short code = first_Contact();
		if(code < 0){
			close();
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "000 or 050 connection Error");
			return;
		}
		else if(code == 0){
			
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "000 connection OK");

			//クライアント接続要求の回答通知
			conection_Answer((short) 100);
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "000->100 sended client-connection request anser OK ");

			//***************************************************************************
			//* 受信手順開始
			//***************************************************************************
			
			Recieve rcv = new Recieve(sock,in,out);
			if(rcv.submit() == false){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Recieve Error");
				close();
			}
			
			//***************************************************************************
			//* 受信手順終了
			//***************************************************************************			

		}
		else if(code == 50){
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "050 connection OK");

			//クライアント接続要求の回答通知
			conection_Answer((short) 150);
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "050->150 sended client-connection request anser OK ");

			//クライアント認証
			Struct_Connect_Digest scnd = attestation_Answer();
			if(scnd == null){
				close();
				blnswitch = false;
				return;
			}
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , 
						"client request user="+scnd.getSender()+
						"project="+scnd.getProject()+
						"lastupdate="+scnd.getLastupdate());

			//***************************************************************************
			//* マスター送信
			//***************************************************************************
			boolean masterupdate = false;

			//マスターディレクトリの取得
			Tool_MasterFile_IO tmf= new Tool_MasterFile_IO(addr.getDir_current() + addr.getFile_master());
			if(tmf.loadXml() == false){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master File Access Error");
				close();
				return ;
			}
			Struct_MasterFile smf = tmf.getSmf();
			if(smf == null || smf.getMasterdir() == null || smf.getMasterdir().length() == 0){
				logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Dir Error");
				close();
				return ;
			}
			
			String masterdir = smf.getMasterdir();
//			String masterdir = "D:\\mailcost_web\\master\\";

			Server_MasterSend sms;
			//************************************************
			//* ファーストプロジェクトのみ更新可能
			//************************************************
			if(scnd.isFirstproject() == true){
				//コンフィグ
				sms = new Server_MasterSend(sock,in,out,
						masterdir + addr.getFile_config()
						,scnd.getLastupdate());
				if(sms.sendcheck() == true){
					conection_Answer((short) 151,(short)2);
					if(sms.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					masterupdate = true;
				}

				sleep();

				//評価基準
				sms = new Server_MasterSend(sock,in,out,
						masterdir + addr.getFile_eval_rank()
						,scnd.getLastupdate());
				if(sms.sendcheck() == true){
					conection_Answer((short) 151,(short)2);
					if(sms.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					masterupdate = true;
				}

				sleep();
				
				//職種
				sms = new Server_MasterSend(sock,in,out,
						masterdir + addr.getFile_position()
						,scnd.getLastupdate());
				if(sms.sendcheck() == true){
					conection_Answer((short) 151,(short)2);
					if(sms.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					masterupdate = true;
				}

				sleep();

				//職種別単価
				sms = new Server_MasterSend(sock,in,out,
						masterdir + addr.getFile_pos_cost()
						,scnd.getLastupdate());
				if(sms.sendcheck() == true){
					conection_Answer((short) 151,(short)2);
					if(sms.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					masterupdate = true;
				}

				sleep();

				//年間営業日数
				sms = new Server_MasterSend(sock,in,out,
						masterdir + addr.getFile_business_year_days()
						,scnd.getLastupdate());
				if(sms.sendcheck() == true){
					conection_Answer((short) 151,(short)2);
					if(sms.submit() == false){
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
						close();
						return;
					}
					masterupdate = true;
				}

				sleep();				
			}
			


			//コミュニティ
			sms = new Server_MasterSend(sock,in,out,
					masterdir + addr.getFile_com_all()
					,scnd.getLastupdate());
			if(sms.sendcheck() == true){
				conection_Answer((short) 151,(short)2);
				if(sms.submit() == false){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
					close();
					return;
				}
				masterupdate = true;
			}

			sleep();

			//コミュニティメンバー
			boolean com_menber = false;
			sms = new Server_MasterSend(sock,in,out,
					masterdir + addr.getFile_com_menber()
					,scnd.getLastupdate());
			if(sms.sendcheck() == true){
				com_menber = true;
				conection_Answer((short) 151,(short)2);
				if(sms.submit() == false){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
					close();
					return;
				}
				masterupdate = true;
			}

			sleep();

			//参加コミュニティリスト作成
			//（コミュニティメンバー変更時のみ）
			if(com_menber == true){
				//テンポラリーディレクトリ作成
		    	long nowtime = System.currentTimeMillis();
		    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
		    	String tempDir = "temp" + dfm.format(nowtime);
		    	if(new File(addr.getDir_current() + tempDir).mkdir() == false){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Community_select Temporary Directry Make Error");
					close();
					return;
		    	}
				
				String filepath = addr.getDir_current() + tempDir+ addr.getFs() + addr.getFile_com_select();
				sms = new Server_MasterSend(sock,in,out,filepath,0);
				
				if(sms.entryCommunityMake(masterdir,scnd.getProject(),scnd.getSender()) == false){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Community_select Make Error");
					new Tool_DirDel(addr.getDir_current() + tempDir).delete();
					close();
					return;
				}

				conection_Answer((short) 151,(short)2);
				if(sms.submit() == false){
					logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Master Update Error");
					new Tool_DirDel(addr.getDir_current() + tempDir).delete();
					close();
					return;
				}
				new Tool_DirDel(addr.getDir_current() + tempDir).delete();
			}
			
			
			
			//マスター更新がある場合に更新
			if(masterupdate == true){
				Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(masterdir + addr.getFile_project_info());
				tep.loadXml();
				ArrayList<Struct_Entry_Project> array_project = tep.getdata();
				conection_Answer((short) 151,(short)2);
				//タイムスタンプの送信
				if(send_timestamp((short) 61,array_project.get(0).getLastupdate()) == false){
					//送信失敗
					return ;
				}
			}
			
			
			sleep();

			//* 送信終了
			conection_Answer((short) 151,(short)255);
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "051->151 sended NO Data");

			sleep();
			
			//***************************************************************************
			//* メール＆コスト送信開始
			//***************************************************************************
			String dir = addr.getDir_current() + addr.getDir_buff_relay();
			File fl = new File(dir);
	    	Tool_FileFilter ff = new Tool_FileFilter();
	    	ff.setSuffix(addr.getFile_digest());	
	    	File[] files = fl.listFiles(ff);



	    	//送信バッファのループ
			for(int i=0; i<files.length; i++) {
		    	byte sendkind = sendkind(files[i].getName());
				//メール送信
				if(sendkind == 1){
					
					Tool_SendList_IO slm = new Tool_SendList_IO(files[i].getPath());
			    	slm.loadXml();

			    	//リスト内のレコードのループ
			    	for(int j=0 ; j < slm.datacount() ; j++){
			    		Struct_SendList data 	=	slm.getdata(j);	
			    		//既に送信済みの場合はスキップ
			    		if(data.isSendend() == true){
			    			continue;
			    		}

			    		//送信先チェック
			    		if(data.getTarget_user().equals(scnd.getSender()) == false){
			    			continue;
			    		}

			    		//プロジェクトチェック
			    		if(data.getTarget_project().equals(scnd.getProject()) == false){
			    			continue;
			    		}
			    		
			    		//送信データがあることを送信
			    		conection_Answer((short) 151,(short)1);
						logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "051->151 sended attestation anser OK ");
			    		
						//メール送信
			    		Mail_Send ms = new Mail_Send(sock,in,out,data,true,dir);
			    		if(ms.submit() == false) {
							logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Send Error");
							close();
							blnswitch = false;
							return;
			    		}

						//ダイジェストの更新
						data.setSendend(true);
				    	//送信日付
				    	long nowtime = System.currentTimeMillis();
						data.setSend_date(DateFormat.getDateTimeInstance().format(nowtime));
						slm.putdata(data, j);
						slm.saveXml_direct();
			    		
			    	}

			    	//ダイジェスト内のレコードはすべて送信済みか？
			    	if(slm.isAllSend() ==true){
			    		
			   			//送信ファイルの削除
			    		File delfile = new File(slm.deleteFile(true));
			       		if(delfile.delete() == false){
			           		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+delfile.getAbsolutePath());
			       		}
			    		
			    		//ダイジェストの削除
			       		if(files[i].delete() == false){
			           		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+files[i].getAbsolutePath());
			       		}					

			    	}
			    }
				//コスト送信
				else if( sendkind == 2){

					Tool_Cost_SendList_IO cslm = new Tool_Cost_SendList_IO(files[i].getPath());
			    	cslm.loadXml();

					Struct_Cost_SendList data 	=	cslm.getdata();	
					
		    		//送信先チェック
		    		if(data.getTarget_user().equals(scnd.getSender()) == false){
		    			continue;
		    		}
					
					conection_Answer((short) 151,(short)1);
					logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "051->151 sended attestation anser OK ");

					//ダイジェスト送信
					Cost_Send cs = new Cost_Send(sock,in,out,data,true,dir);
		    		if(cs.submit() == false) {
						logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "Send Error");
						close();
						blnswitch = false;
						return;
		    		}

					//送信ファイルの削除
					File delfile = new File(dir +  addr.getFs() + data.getFilename());
			   		if(delfile.delete() == false){
			       		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+delfile.getAbsolutePath());
			   		}
					
					//ダイジェストの削除
			   		if(files[i].delete() == false){
			       		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "File delete failed:"+files[i].getAbsolutePath());
			   		}
					
					
					
				}
				else{
					continue;
				}
				
			}
			//***************************************************************************
			//* メール＆コスト送信終了
			//***************************************************************************
			
			//* 送信終了
			conection_Answer((short) 151,(short)255);
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "051->151 sended NO Data");
		
		}


		blnswitch = false;
		
		
	}
	


	//クライアント接続要求の受付
	public short first_Contact(){
		try {
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			blnswitch = false;
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return -1;
		}

		//NODE情報なし
		if(k<5){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Nothing Data Error");
			return -1;
		}

		//コード取得
		short code ;		
		code =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );
		//接続要求コードではない場合
		if(code != 0 && code != 50){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Code is Not 000 Error. code="+ code);
			return -1;
		}
		
		//レングス取得
		short len ;
		len =  (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
		
		//電文の長さ誤り
		if(k-4 != len){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Data Length Unmatch Error. "
			+ "info Length=" + len	+ " Real Length=" + (k-4));
			return -1;
		}
		
		String userid = new String(buf_receive,4,len)	;	
		
	    //ユーザー情報
	    user_info = new Tool_User_IO(addr.getDir_current() + addr.getFile_user_info());
	    su = user_info.getStruct_User();
    	//送信ユーザー
    	String userown = su.getUserid();
    	

    	if(userown.equals(userid)){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:User Check OK");
    		return code;
    	}
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact:Confermation User Check NG");
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact: My  UserID="+userown);
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "First Contact: Req UserID="+userid);
		return -1;
		
	}
	


	
	//接続要求回答
	public void conection_Answer(short code) {
		
		byte send[]= new byte[2];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		send_Byte(send);
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Send Answer code:"+code);
		
	}

	public void conection_Answer(short code,short kind) {
		
		byte send[]= new byte[4];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;
		
		//種類
		send[2] =  (byte)((kind >>> 8)  & 0xFF) ;
		send[3] =  (byte)((kind >>> 0)  & 0xFF) ;
		send_Byte(send);
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "Send Answer code:" + code + " kind:" + kind);
		
	}

	
	
	/*	
	public int getport() {
			return sock.getPort();
	}
*/	
	public void close() {
		blnswitch = false;
		try {
			//ソケットクローズ
			sock.close();
			logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "socket close OK");

		} catch (IOException e) {
		logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "socket close NG");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			e.printStackTrace();
		}
	}
	
	

	public boolean getblnswitch(){
		return(blnswitch);
	}

	
	public boolean send_Byte(byte[] byte_send)  {
		//送信
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte start");
		//ストリームデータ送信
		j = byte_send.length;
		try {
			//ストリームデータ掃き出し
			out.write(byte_send, 0, j);
			out.flush();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return false;
		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "send_Byte end");
		return true;
	}


	//メール送信許可要求の受付
	public Struct_Connect_Digest attestation_Answer(){
		try {
			//ストリームデータ受信
			k = in.read(buf_receive);
		} catch (IOException e) {
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Second Contact:Server Recieve Error");
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			return null;
		}
		
		
		//データなし
		if(k<5){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "Second Contact:Nothing Data Error");
			return null;
		}

		//コード取得
		short code ;
		code =  (short) (   ((buf_receive[0]<<8)&0xFF00)   + (buf_receive[1]&0xFF) );
		

		//接続要求コードではない場合 10:メール送信　20:コスト送信
		if(code != 51){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "attestation Contact:Code is Not 051 Error. code="+ code);
			return null;
		}
		
		//レングス取得
		short len ;
		len =  (short) (   ((buf_receive[2]<<8)&0xFF00)   + (buf_receive[3]&0xFF) );
		
		//電文の長さ誤り
		if(k-4 != len){
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , "attestation Contact:Data Length Unmatch Error. "
					+ "info Length=" + len	+ " Real Length=" + (k-4));
			return null;
		}
		
		//プロジェクト、ユーザーの設定			
		byte data[] = new byte[len];
		for(int j = 0;j<len;j++){
			data[j] = buf_receive[j+4];
		}

		
		Struct_Connect_Digest scm = new Struct_Connect_Digest();
		scm.putByte(data);

		String project 		= scm.getProject();
		String userid		=	scm.getSender();
		long lastupdate		=	scm.getLastupdate();
			

		//プロジェクトチェック
		Gui_PanelProject pp = new Gui_PanelProject("nopanel"); 
		//*コストが送信できるように脱退プロジェクトも含む
   		ArrayList ppl= pp.getProject();
   		//プロジェクトは参加中？
   		if(	ppl.indexOf(project) == -1){
			logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "attestation Contact:Target Project is not Entry project:"+project);
   			return null;
   		}
		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "attestation Contact:Target Project is Entry project:"+project);

   		//ユーザーチェック
		String filename =	addr.getDir_current() + 
								addr.getDir_project() + 
								project +  
								addr.getFile_com_menber();
		Tool_JTable_IO tc = new Tool_JTable_IO(filename);
		String[] columnames = {"コミュニティ名","USER","ユーザー","NODE"};
		tc.putColum(columnames);
		tc.loadXml();
		DefaultTableModel model = tc.getDefaultTableModele();
    	
		for(int i=0 ; i<model.getRowCount(); i++){
			if(	model.getValueAt(i, 1).equals(userid)    ){
				logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "attestation Contact:Check Target Project and User OK!");
				
				return scm;
			}
		}
		logout.out(sysconfig.getLogmode2(),this.getClass().getName() , "attestation Contact:Check Target Project and User NG!");
		return null;			
		
	}	

	private byte sendkind(String filename){
		//コストの返信
		if(filename.substring(0, 1).equals("C") == true){
			return 2;
		}
		//メールの送信
		else{
			return 1;
		}
	}

	
	//マスターファイル送信完了＆タイムスタンプ送信
	private boolean send_timestamp(short code,long timestamp) {
		
		byte send[]= new byte[10];			

		//コード
		send[0] =  (byte)((code >>> 8)  & 0xFF) ;
		send[1] =  (byte)((code >>> 0)  & 0xFF) ;

		
		
		
		send[2] =  (byte)((timestamp >>> 56)  & 0xFF) ;
		send[3] =  (byte)((timestamp >>> 48)  & 0xFF) ;
		send[4] =  (byte)((timestamp >>> 40)  & 0xFF) ;
		send[5] =  (byte)((timestamp >>> 32)  & 0xFF) ;
		send[6] =  (byte)((timestamp >>> 24)  & 0xFF) ;
		send[7] =  (byte)((timestamp >>> 16)  & 0xFF) ;
		send[8] =  (byte)((timestamp >>> 8)  & 0xFF) ;
		send[9] =  (byte)((timestamp >>> 0)  & 0xFF) ;

		if(send_Byte(send) == false){
			return false;
		}

		logout.out(sysconfig.getLogmode4(),this.getClass().getName() , "sended timestamp  code="+code + " timestamp="+timestamp);
		
		return true;
		
	}
	
	private void sleep(){
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} 
		
	}
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	

	
	
}
