package structure;

import java.io.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Struct_Community_Digest  implements Serializable {

	
	String	status;			// 1.状態
	String	sender;			// 2.差出人
	String	sendnumber;		// 3.送信ナンバー
	String 	subject;		// 4.件名
	String	send_date;		// 5.送信日時		
	String	text_size;		// 6.本文サイズ
	String  userid;			// 7.送信ユーザーＩＤ
	String	node;			// 8.送信ノード	
	String community;		// 9.送信コミュニティ名称
	String project;			//10.送信プロジェクト名称
	String filename;		//11.送信ファイル名称
	String sendcost;		//12.送信コスト
	String reciever_count;	//13.受信者数

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+
											addr.getFile_config()).getStruct_System_Config();

	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());

	
	public Struct_Community_Digest(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
	}

	
	public String[] getColData(){
		
		String[] data = new String[13];
		
		data[0]	=	"状態";				// 1.状態
		data[1]	=	"差出人";			// 2.差出人
		data[2]	=	"NO";				// 3.送信ナンバー
		data[3]	=	"件名";				// 4.件名
		data[4]	=	"送信日時";			// 5.送信日時		
		data[5]	=	"サイズ";			// 6.本文サイズ
		data[6]	=	"USERID";			// 7.送信ユーザーＩＤ
		data[7]	=	"NODE";				// 8.送信ノード	
		data[8]	=	"コミュニティ名称";	// 9.送信コミュニティ名称
		data[9]	=	"プロジェクト名称";	//10.送信プロジェクト名称
		data[10]	=	"FILENAME";		//11.送信ファイル名称		
		data[11]	=	"送信コスト";	//12.送信コスト		
		data[12]	=	"受信者数";		//13.受信者数		
		
		return data;	
		
	}	

	public String[] getColData_short(){

		String[] data = new String[6];
		
		data[0]	=	"状態";				// 1.状態
		data[1]	=	"差出人";			// 2.差出人
		data[2]	=	"NO";				// 3.送信ナンバー
		data[3]	=	"件名";				// 4.件名
		data[4]	=	"送信日時";			// 5.送信日時		
		data[5]	=	"サイズ";			// 6.本文サイズ

		return data;	
		
	}
	
	public byte[] getAlignment(){

		byte[] alignment = new byte[6];
		alignment[0]='C';
		alignment[1]='L';
		alignment[2]='R';
		alignment[3]='L';
		alignment[4]='L';
		alignment[5]='R';

		return alignment;	
		
	}
	
	
	//ゲッター＆セッター
	public String getCommunity() {
		return community;
	}
	public void setCommunity(String community) {
		this.community = community;
	}
	public String getFilename() {
		return filename;
	}
	public void setFilename(String filename) {
		this.filename = filename;
	}
	public String getNode() {
		return node;
	}
	public void setNode(String node) {
		this.node = node;
	}
	public String getProject() {
		return project;
	}
	public void setProject(String project) {
		this.project = project;
	}
	public String getSend_date() {
		return send_date;
	}
	public void setSend_date(String send_date) {
		this.send_date = send_date;
	}
	public String getSender() {
		return sender;
	}
	public void setSender(String sender) {
		this.sender = sender;
	}
	public String getSendnumber() {
		return sendnumber;
	}
	public void setSendnumber(String sendnumber) {
		this.sendnumber = sendnumber;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getText_size() {
		return text_size;
	}
	public void setText_size(String text_size) {
		this.text_size = text_size;
	}
	public String getUserid() {
		return userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}
	public String getReciever_count() {
		return reciever_count;
	}
	public void setReciever_count(String reciever_count) {
		this.reciever_count = reciever_count;
	}
	public String getSendcost() {
		return sendcost;
	}
	public void setSendcost(String sendcost) {
		this.sendcost = sendcost;
	}	
	
	//変換ゲッター
	public int getSendnumber_integer() {
		return 	Integer.valueOf(sendnumber).intValue();
	}
	public long getSend_date_long() {
		Date dt	=	new Date();
		try {
			dt = DateFormat.getDateInstance().parse(send_date);
		} catch (ParseException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
	    	logout.out(sysconfig.getLogmode1(),this.getClass().getName(),e.getStackTrace().toString());
		}
		long rtndt = dt.getTime();
		return rtndt;

	}
	public int getSendcost_integer() {
		return 	Integer.valueOf(sendcost).intValue();
	}
	public int getReciever_count_integer() {
		return 	Integer.valueOf(reciever_count).intValue();
	}

	//変換セッター
	public void setReciever_count_integer(int reciever_count) {
		this.reciever_count = Integer.toString(reciever_count);
	}
	public void setSendcost_integer(int sendcost) {
		
		this.sendcost = Integer.toString(sendcost);
	}	

	
	public String[] getArryData(){
		
		String[] data = new String[13];
		
		data[0]		=	status;			// 1.状態
		data[1]		=	sender;			// 2.差出人
		data[2]		=	sendnumber;		// 3.送信ナンバー
		data[3]		=	subject;		// 4.件名
		data[4]		=	send_date;		// 5.送信日時		
		data[5]		=	text_size;		// 6.本文サイズ
		data[6]		=	userid;			// 7.送信ユーザーＩＤ
		data[7]		=	node;			// 8.送信ノード	
		data[8]		=	community;		// 9.送信コミュニティ名称
		data[9]		=	project;		//10.送信プロジェクト名称
		data[10]	=	filename;		//11.送信ファイル名称		
		data[11]	=	sendcost;		//12.送信コスト
		data[12]	=	reciever_count;	//13.受信者数

		return data;	
		
	}

	public void setArryData(String[] data){
		
		
		status			=	data[0];	// 1.状態
		sender			=	data[1];	// 2.差出人
		sendnumber		=	data[2];	// 3.送信ナンバー
		subject			=	data[3];	// 4.件名
		send_date		=	data[4];	// 5.送信日時		
		text_size		=	data[5];	// 6.本文サイズ
		userid			=	data[6];	// 7.送信ユーザーＩＤ
		node			=	data[7];	// 8.送信ノード	
		community		=	data[8];	// 9.送信コミュニティ名称
		project			=	data[9];	//10.送信プロジェクト名称
		filename		=	data[10];	//11.送信ファイル名称		
		sendcost		=	data[11];	//12.送信コスト
		reciever_count	=	data[12];	//13.受信者数
		
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
			    	logout.out(sysconfig.getLogmode1(),this.getClass().getName(),e.getStackTrace().toString());

			  }
		}
	}


	
	
}
