package structure;

import java.io.Serializable;

public class Struct_Community_Menber implements Serializable{

	
	String community;		// 1.コミュニティ名称
	String userid;			// 2.送信ユーザーＩＤ
	String user_fullname;	// 3.ユーザー名称
	String node;			// 4.送信ノード	
	

	public boolean equals(Object obj){
		if((obj != null) && (obj instanceof Struct_Community_Menber)) {
			Struct_Community_Menber scm = (Struct_Community_Menber)obj;
			if(community.equals(scm.getCommunity())				&&
				userid.equals(scm.getUserid())					&&
				user_fullname.equals(scm.getUser_fullname())	&&
				node.equals(scm.getNode())) {
				return true;
			}
		}
		return false;
	}

	public String[] getColData(){
		
		String[] data = new String[4];
		
		data[0]	=	"コミュニティ名";			
		data[1]	=	"ユーザーＩＤ";				
		data[2]	=	"名称";				
		data[3]	=	"ＩＰアドレス";				
		
		return data;	
		
	}	
	

	public String[] getArryData(){
		
		String[] data = new String[4];
		
		data[0]		=	community;			// 1.コミュニティ名称
		data[1]		=	userid;				// 2.送信ユーザーＩＤ
		data[2]		=	user_fullname;		// 3.ユーザー名称
		data[3]		=	node;				// 4.送信ノード	

		return data;	
		
	}

	public void setArryData(String[] data){
		
		community		=	data[0];	// 1.コミュニティ名称
		userid			=	data[1];	// 2.送信ユーザーＩＤ
		user_fullname	=	data[2];	// 3.ユーザー名称
		node			=	data[3];	// 4.送信ノード	
		
	}	

	//ゲッター＆セッター
	public String getCommunity() {
		return community;
	}
	public void setCommunity(String community) {
		this.community = community;
	}
	public String getNode() {
		return node;
	}
	public void setNode(String node) {
		this.node = node;
	}
	public String getUser_fullname() {
		return user_fullname;
	}
	public void setUser_fullname(String user_fullname) {
		this.user_fullname = user_fullname;
	}
	public String getUserid() {
		return userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}	
	
}
