package structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;

import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;


public class Struct_Connect_Digest implements Serializable{

	private String		sender;			// 1.送信ユーザーＩＤ
	private String		project;		// 2.プロジェクト
	private long		lastupdate;		// 3.タイムスタンプ
	private boolean	firstproject;	// 4.trueの場合、設定情報をダウンロードする

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();

	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();

	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Struct_Connect_Digest(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
	}
	

	public byte[] getByte(){
		
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos;
		try {
			oos = new ObjectOutputStream(baos);
			oos.writeObject(sender);							// 1.送信ユーザーＩＤ
			oos.writeObject(project);							// 2.プロジェクト
			oos.writeObject(String.valueOf(lastupdate));		// 3.タイムスタンプ
			oos.writeBoolean(firstproject);
			
			
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}

		return baos.toByteArray();
		
	}
	
	public void putByte(byte[] data){
		
		ObjectInputStream ois = null;
		
		try {
			ois = new ObjectInputStream(new ByteArrayInputStream(data));
			sender 		= (String)ois.readObject();								// 1.送信ユーザーＩＤ
			project 	= (String) ois.readObject();							// 2.プロジェクト
			lastupdate 	=  Long.valueOf((String)ois.readObject()).longValue();	// 3.タイムスタンプ
			firstproject = ois.readBoolean();		
			
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (ClassNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}
	}	
	
	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace().toString());

			  }
		}
	}
	
	//ゲッター＆セッター
	public long getLastupdate() {
		return lastupdate;
	}
	public void setLastupdate(long lastupdate) {
		this.lastupdate = lastupdate;
	}
	public String getProject() {
		return project;
	}
	public void setProject(String project) {
		this.project = project;
	}
	public String getSender() {
		return sender;
	}
	public void setSender(String sender) {
		this.sender = sender;
	}








	public boolean isFirstproject() {
		return firstproject;
	}








	public void setFirstproject(boolean firstproject) {
		this.firstproject = firstproject;
	}
	
}
