package structure;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

import tool.Tool_CustomBorder;


public class Struct_CostBar extends JProgressBar implements TableCellRenderer  {
	
	int maxvalue;
	int realvalue;
	
	//	枠線の設定		セル		1:セル赤	2：セル青	3:セル黄	
	//					カラム全体	11:カラム赤	12:カラム青	13:カラム黄
	//					範囲行開始	101:赤		102:青		103:黄
	//					範囲行中央	111:赤		112:青		113:黄	
	//					範囲行終了	121:赤		122:青		123:黄
	
	byte outline = 0;	
	
	byte mode;

	String mongon;
	
	public Struct_CostBar(){

		//進捗文字列の表示あり
		setStringPainted(true);
	}
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

		//正数
		if(((Struct_CostBar) value).getMode() > 0){		
			setMinimum(0);
			setMaximum(((Struct_CostBar) value).getMaxvalue());
		}
		//負の数
		else{
			setMinimum(((Struct_CostBar) value).getMaxvalue());
			setMaximum(0);
		}
		setValue(((Struct_CostBar) value).getRealvalue());
			
		//正数
		if(((Struct_CostBar) value).getMode() == 1){
			this.setForeground(Color.CYAN);
			this.setBackground(((Struct_CostBar) value).getBackground());
		}
		else if(((Struct_CostBar) value).getMode() == 2){
			this.setForeground(Color.GREEN);
			this.setBackground(Color.CYAN);
		}
		else if(((Struct_CostBar) value).getMode() == 3){
			this.setForeground(Color.YELLOW);
			this.setBackground(Color.GREEN);
		}
		else if(((Struct_CostBar) value).getMode() == 4){
			this.setForeground(Color.PINK);
			this.setBackground(Color.YELLOW);
		}
		else if(((Struct_CostBar) value).getMode() == 5){
			this.setForeground(Color.MAGENTA);
			this.setBackground(Color.PINK);
		}

		//負の数
		else if(((Struct_CostBar) value).getMode() == -1){
//			this.setForeground(((Struct_CostBar) value).getBackground());
			this.setForeground(((Struct_CostBar) value).getForeground());
			this.setBackground(Color.CYAN);
		}
		else if(((Struct_CostBar) value).getMode() == -2){
			this.setForeground(Color.CYAN);
			this.setBackground(Color.GREEN);
		}
		else if(((Struct_CostBar) value).getMode() == -3){
			this.setForeground(Color.GREEN);
			this.setBackground(Color.YELLOW);
		}
		else if(((Struct_CostBar) value).getMode() == -4){
			this.setForeground(Color.YELLOW);
			this.setBackground(Color.PINK);
		}
		else if(((Struct_CostBar) value).getMode() == -5){
			this.setForeground(Color.PINK);
			this.setBackground(Color.MAGENTA);
		}
		
		//進捗文字の表示
		if(((Struct_CostBar) value).getMongon() != null && 
				((Struct_CostBar) value).getMongon().length() != 0){
			this.setString(((Struct_CostBar) value).getMongon());
		}
		else{
		//標準表示　かつ　その値がマイナスの場合は、百分率を再計算して表示する
			if(((Struct_CostBar) value).getMode() < 0){
				double  val = -((Struct_CostBar) value).getRealvalue() *100 / ((Struct_CostBar) value).getMaxvalue();
				String mongon = Integer.valueOf((int)val).toString() + "%";
				this.setString(mongon);
			}
			
		}

		//*******************************************
		//* 枠線の設定 
		//******************************************* 
		//1:セル赤色
		if(((Struct_CostBar) value).outline == 0){
			//デフォルト枠線の削除
			setBorder(new EmptyBorder(0,0,0,0));
			
		}
		//1:セル赤色
		else if(((Struct_CostBar) value).outline == 1){
			setBorder(new Tool_CustomBorder(Color.RED,(byte) 15));
		}
		//2:セル青色
		else if(((Struct_CostBar) value).outline == 2){
			setBorder(new Tool_CustomBorder(Color.BLUE,(byte) 15));
		}
		//3:セル黄色
		else if(((Struct_CostBar) value).outline == 3){
			setBorder(new Tool_CustomBorder(Color.YELLOW,(byte) 15));
		}
		//1x:カラム全体の枠線
		else if(((Struct_CostBar) value).outline > 10 &&
				((Struct_CostBar) value).outline < 100	){
			Color color;
			if(((Struct_CostBar) value).outline == 11){
				color = Color.RED;
			}
			else if(((Struct_CostBar) value).outline == 12){
				color = Color.BLUE;
			}
			else{
				color = Color.YELLOW;
			}
			//１行のみ
			if(table.getRowCount() ==1){
				setBorder(new Tool_CustomBorder(color,(byte) 15));
			}
			//上
			else if(row == 0){
				setBorder(new Tool_CustomBorder(color,(byte) 7));
			}
			//下
			else if(table.getRowCount() == (row + 1 ) ){
				setBorder(new Tool_CustomBorder(color,(byte) 13));
			}
			//中央
			else{
				setBorder(new Tool_CustomBorder(color,(byte) 5));
			}
		}
		//範囲行開始 赤
		else if(((Struct_CostBar) value).outline == 101){
			setBorder(new Tool_CustomBorder(Color.RED,(byte) 11));
		}
		//範囲行中央 赤
		else if(((Struct_CostBar) value).outline == 111){
			setBorder(new Tool_CustomBorder(Color.RED,(byte) 10));
		}
		//範囲行終了 赤
		else if(((Struct_CostBar) value).outline == 121){
			setBorder(new Tool_CustomBorder(Color.RED,(byte) 14));
		}
		//範囲行開始 青
		else if(((Struct_CostBar) value).outline == 102){
			setBorder(new Tool_CustomBorder(Color.BLUE,(byte) 11));
		}
		//範囲行中央 青
		else if(((Struct_CostBar) value).outline == 112){
			setBorder(new Tool_CustomBorder(Color.BLUE,(byte) 10));
		}
		//範囲行終了 青
		else if(((Struct_CostBar) value).outline == 122){
			setBorder(new Tool_CustomBorder(Color.BLUE,(byte) 14));
		}
		//範囲行開始 黄
		else if(((Struct_CostBar) value).outline == 103){
			setBorder(new Tool_CustomBorder(Color.YELLOW,(byte) 11));
		}
		//範囲行中央 黄
		else if(((Struct_CostBar) value).outline == 113){
			setBorder(new Tool_CustomBorder(Color.YELLOW,(byte) 10));
		}
		//範囲行終了 黄
		else if(((Struct_CostBar) value).outline == 123){
			setBorder(new Tool_CustomBorder(Color.YELLOW,(byte) 14));
		}
		return this;
	}

	
	
	//ゲッター＆セッター
	public int getMaxvalue() {
		return maxvalue;
	}
	public void setMaxvalue(int maxvalue) {
		this.maxvalue = maxvalue;
	}
	public int getRealvalue() {
		return realvalue;
	}
	public void setRealvalue(int realvalue) {
		this.realvalue = realvalue;
	}
	public byte getMode() {
		return mode;
	}
	public void setMode(byte mode) {
		this.mode = mode;
	}
	public String getMongon() {
		return mongon;
	}
	public void setMongon(String mongon) {
		this.mongon = mongon;
	}
	public byte getOutline() {
		return outline;
	}

	public void setOutline(byte outline) {
		this.outline = outline;
	}

	
}
