package structure;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

import tool.Tool_CustomBorder;


public class Struct_Cost_AnalysisBar extends JProgressBar implements TableCellRenderer  {
	
	int maxvalue;
	int realvalue;
	byte outline = 0;	//枠線の設定	1:セル赤	2：セル青	3:カラム赤	4:カラム青
	
	public Struct_Cost_AnalysisBar(){

		//進捗文字列の表示あり
		setStringPainted(true);
	}
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

		//正数
		if(((Struct_Cost_AnalysisBar) value).getRealvalue() >= 0){		
			setMinimum(0);
			setMaximum(((Struct_Cost_AnalysisBar) value).getMaxvalue());
			this.setForeground(Color.GREEN);
			this.setBackground(((Struct_Cost_AnalysisBar) value).getBackground());
			//最大値超過
			if(realvalue > maxvalue){
				this.setForeground(Color.PINK);
			}
		
		}
		//負の数
		else{
			setMinimum(-((Struct_Cost_AnalysisBar) value).getMaxvalue());
			setMaximum(0);
			this.setForeground(((Struct_Cost_AnalysisBar) value).getForeground());
			this.setBackground(Color.GREEN);
			//最大値超過
			if(realvalue > -(maxvalue)){
				this.setBackground(Color.PINK);
			}
		}
		setValue(((Struct_Cost_AnalysisBar) value).getRealvalue());

		//表示用フォーマット変換
		Struct_Format_Numeric form_change = new Struct_Format_Numeric(); 
		//進捗文字の表示
		String mongon = form_change.change_format9_doble(	getValue()	);
		this.setString(mongon);

		//*******************************************
		//* 枠線の設定 
		//******************************************* 
		//1:セル赤色
		if(((Struct_Cost_AnalysisBar) value).outline == 0){
			//デフォルト枠線の削除
			setBorder(new EmptyBorder(0,0,0,0));
			
		}
		//1:セル赤色
		else if(((Struct_Cost_AnalysisBar) value).outline == 1){
			setBorder(new Tool_CustomBorder(Color.RED,(byte) 15));
		}
		//2:セル青色
		else if(((Struct_Cost_AnalysisBar) value).outline == 2){
			setBorder(new Tool_CustomBorder(Color.BLUE,(byte) 15));
		}
		//3,4:カラム全体の枠線
		else if(((Struct_Cost_AnalysisBar) value).outline >= 3){
			Color color;
			if(((Struct_Cost_AnalysisBar) value).outline == 3){
				color = Color.RED;
			}
			else{
				color = Color.BLUE;
			}
			//１行のみ
			if(table.getRowCount() ==1){
				setBorder(new Tool_CustomBorder(color,(byte) 15));
			}
			//上
			else if(row == 0){
				setBorder(new Tool_CustomBorder(color,(byte) 7));
			}
			//下
			else if(table.getRowCount() == (row + 1 ) ){
				setBorder(new Tool_CustomBorder(color,(byte) 13));
			}
			//中央
			else{
				setBorder(new Tool_CustomBorder(color,(byte) 5));
			}
		}
		
		
		return this;
	}

	
	
	//ゲッター＆セッター
	public int getMaxvalue() {
		return maxvalue;
	}
	public void setMaxvalue(int maxvalue) {
		this.maxvalue = maxvalue;
	}
	public int getRealvalue() {
		return realvalue;
	}
	public void setRealvalue(int realvalue) {
		this.realvalue = realvalue;
	}

	public byte getOutline() {
		return outline;
	}

	public void setOutline(byte outline) {
		this.outline = outline;
	}



	
}
