package structure;

import java.io.*;

import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

public class Struct_Cost_SendList implements Serializable {

	String 		source_node;			// 1.送信先NODE
	String 		source_user;			// 2.送信先USERID
	String 		source_project;			// 3.送信先プロジェクト
	String 		source_community;		// 4.送信先コミュニティ

	String 		target_node;			// 5.送信元NODE
	String 		target_user;			// 6.送信元USERID
	String 		target_project;			// 7.送信元プロジェクト
	String 		target_community;		// 8.送信元コミュニティ

	String		sendnumber;				// 9.送信ナンバー
	String 		filename;				//10.送信ファイル名称
	String 		source_filename;		//11.送信元メッセージのファイル名称
	
	
	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = 
		new File_and_Directory_Address ();

	//モード取得
	Struct_System_Config  sysconfig = 
		new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();

	//ログ出力
	Tool_LogOut logout = 
		new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	public Struct_Cost_SendList(){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
	}

	public byte[] getByte(){
		
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos;
		try {
			oos = new ObjectOutputStream(baos);
			oos.writeObject(source_node);			// 1.送信元NODE
			oos.writeObject(source_user);			// 2.送信元USERID
			oos.writeObject(source_project);		// 3.送信元プロジェクト
			oos.writeObject(source_community);		// 4.送信元コミュニティ
			oos.writeObject(target_node);			// 5.送信先NODE
			oos.writeObject(target_user);			// 6.送信先USERID
			oos.writeObject(target_project);		// 7.送信先プロジェクト
			oos.writeObject(target_community);		// 8.送信先コミュニティ
			oos.writeObject(sendnumber);			// 9.送信ナンバー
			oos.writeObject(filename);				//10.送信ファイル名称
			oos.writeObject(source_filename);		//11.送信元メッセージのファイル名称
		
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}

		return baos.toByteArray();
		
	}
	
	public void putByte(byte[] data){
		
		ObjectInputStream ois = null;
		
		try {
			ois = new ObjectInputStream(new ByteArrayInputStream(data));
			source_node 	= (String)ois.readObject();		// 1.送信元NODE
			source_user 	= (String) ois.readObject();	// 2.送信元USERID
			source_project	= (String) ois.readObject();	// 3.送信元プロジェクト
			source_community= (String) ois.readObject();	// 4.送信元コミュニティ
			target_node		= (String) ois.readObject();	// 5.送信先NODE
			target_user		= (String) ois.readObject();	// 6.送信先USERID
			target_project	= (String) ois.readObject();	// 7.送信先プロジェクト
			target_community= (String) ois.readObject();	// 8.送信先コミュニティ
			sendnumber		= (String) ois.readObject();	// 9.送信ナンバー
			filename		= (String) ois.readObject();	//10.送信ファイル名称
			source_filename = (String) ois.readObject();	//11.送信元メッセージのファイル名称
			
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (ClassNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}
	}

	
	//ゲッター＆セッター
	public String getFilename() {
		return filename;
	}
	public void setFilename(String filename) {
		this.filename = filename;
	}
	public String getSource_community() {
		return source_community;
	}
	public void setSource_community(String source_community) {
		this.source_community = source_community;
	}
	public String getSource_node() {
		return source_node;
	}
	public void setSource_node(String source_node) {
		this.source_node = source_node;
	}
	public String getSource_project() {
		return source_project;
	}
	public void setSource_project(String source_project) {
		this.source_project = source_project;
	}
	public String getSource_user() {
		return source_user;
	}
	public void setSource_user(String source_user) {
		this.source_user = source_user;
	}
	public String getTarget_community() {
		return target_community;
	}
	public void setTarget_community(String target_community) {
		this.target_community = target_community;
	}
	public String getTarget_node() {
		return target_node;
	}
	public void setTarget_node(String target_node) {
		this.target_node = target_node;
	}
	public String getTarget_project() {
		return target_project;
	}
	public void setTarget_project(String target_project) {
		this.target_project = target_project;
	}
	public String getTarget_user() {
		return target_user;
	}
	public void setTarget_user(String target_user) {
		this.target_user = target_user;
	}
	public String getSendnumber() {
		return sendnumber;
	}
	public void setSendnumber(String sendnumber) {
		this.sendnumber = sendnumber;
	}
	public String getSource_filename() {
		return source_filename;
	}
	public void setSource_filename(String source_filename) {
		this.source_filename = source_filename;
	}	

	
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}

	
}
