package structure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import mailcost_main.Tool_JTable_IO;

public class Struct_DefaultTableCellRenderer extends DefaultTableCellRenderer{

	boolean[] ownsend = null;	//自分が送信したメールはtrue
	byte[] alignment = null;	//L:左寄せ C:中央寄せ R:右寄せ

	
	//	ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();
	
	private static final Color ec = new Color(240, 240, 255);
    public Struct_DefaultTableCellRenderer() {
        super();
        setOpaque(true);
        setBorder(BorderFactory.createEmptyBorder(0,5,0,5));
    }
    public Struct_DefaultTableCellRenderer(String filename,String userid,byte[] alignment) {
        super();
        setOpaque(true);
        setBorder(BorderFactory.createEmptyBorder(0,5,0,5));

    	Tool_JTable_IO t = new Tool_JTable_IO (filename);
    	String[] dummy = t.loadXmlUserid();
    	if(dummy != null){
        	ownsend = new boolean[dummy.length];
        	
        	for(int i=0;i<dummy.length;i++){
        		if(userid.equals(dummy[i])){
        			ownsend[i]=true;
        		}
        	}
    	}

    	this.alignment = alignment;
    	
    }

    public Component getTableCellRendererComponent(JTable table, Object value,
                                                   boolean isSelected, boolean hasFocus,
                                                   int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if(isSelected) {
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());
        }else{
        	if(ownsend[row]== true){
                setForeground(table.getForeground());
                setBackground(ec);
        	}else{
                setForeground(table.getForeground());
                setBackground(table.getBackground());
        	}
        	
        }
        
        if(alignment[column] == 'L'){
            setHorizontalAlignment(LEFT);
        }
        else if(alignment[column] == 'C'){
            setHorizontalAlignment(CENTER);
        }
        else if(alignment[column] == 'R'){
            setHorizontalAlignment(RIGHT);
        }

        
        if(table.getValueAt(row, 0).equals("未読") || 
        		table.getValueAt(row, 0).equals("未送")){
            this.setFont(new Font(this.getFont().getFontName(), Font.BOLD, this.getFont().getSize()));
            if(column == 0){
    			Icon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_incompleteness());
    			setIcon(icon);
    			setText(null);
            }else{
    			setIcon(null);
            }
        }else if(table.getValueAt(row, 0).equals("未評")){
            if(column == 0){
    			Icon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_noteval());
    			setIcon(icon);
    			setText(null);
            }else{
    			setIcon(null);
            }
            	
        }else{
            if(column == 0){
    			setText(null);
            }
        	
        }
        
		
	
        
        //        setHorizontalAlignment((value instanceof Number)?RIGHT:LEFT);
        return this;
    }

	
}
