package structure;

import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class Struct_JCheckBox extends JCheckBox implements TableCellRenderer  {
	
	
	private boolean onoff;

	public Struct_JCheckBox(){
	   	//中央寄せ
		this.setHorizontalAlignment(SwingConstants.CENTER);
	}
	public Struct_JCheckBox(boolean onoff){
		//選択状態を取得する
		this.onoff = onoff;
	}
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		
		//チェックボックスのＯＮ／ＯＦＦを保管する
		if(value instanceof Boolean){
			onoff = (Boolean) value;
			//valueはStruct_JCheckBoxではないのでリターンする
			return this;
		}
		

		if(((Struct_JCheckBox)value).isOnoff()){
			this.setSelected(true);
		}else{
			this.setSelected(false);
		}
		
		return this;
	}

	
	public boolean isOnoff() {
		return onoff;
	}

	public void setOnoff(boolean onoff) {
		this.onoff = onoff;
	}

}
