package tool;

import java.beans.*;
import java.io.*;
import java.text.*;

import structure.File_and_Directory_Address;
import structure.Struct_Business_Year_days;
import structure.Struct_System_Config;

public class Tool_Business_Year_days_IO {

	private String				filename;
	private Struct_Business_Year_days[] sbyd;
	
	private boolean blnload = false;

	
	//ファイル＆ディレクトリ取得
	private File_and_Directory_Address addr = new File_and_Directory_Address();
	//モード取得
	private Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	//ログ出力
	private Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Business_Year_days_IO(String filename){
		if(sysconfig.isStandardmode() == true){
			setStandard();
		}
		this.filename=filename;
	}

	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			sbyd = new Struct_Business_Year_days[1];
			sbyd[0].init();
			blnload = true;
			return;
		}
		

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

			 sbyd = (Struct_Business_Year_days[]) xml.readObject();

			 
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	
	//セーブ	
	public void saveXml(){
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(filename);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);
	   		
	   		xml.writeObject(sbyd);
		  
		} catch (FileNotFoundException e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		} catch (Exception e) {
 	        e.printStackTrace();
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
			logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
	}

	
	public Struct_Business_Year_days getStruct_Business_Year_days(){

		if(blnload == false){
			loadXml();
		}
		
    	//送信日付
    	long nowtime = System.currentTimeMillis();
    	//送信ユーザー
    	
    	//送信日付のフォーマット変換
    	DateFormat dfm_year = new SimpleDateFormat("yyyy");	
    	DateFormat dfm_month = new SimpleDateFormat("MM");	
    	
    	//現在日時取得
    	int year =  Integer.valueOf(dfm_year.format(nowtime)).intValue();   ;
    	int month =  Integer.valueOf(dfm_month.format(nowtime)).intValue();   ;

    	//年度補正
    	if(month < 4){
    		year++;
    	}
    	
    	for(int i=0;i<sbyd.length;i++){
    		if(sbyd[i].getYear() == month){
    			return sbyd[i];
    		}
    	}
		
    	//見当たらない場合は最新を返す
    	return sbyd[sbyd.length -1];
	}

	
	public void setStruct_Business_Year_days(Struct_Business_Year_days[] getdata){
		
		sbyd = getdata;
	}
	
	
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (Exception e) {
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			  }
		}
	}	
	
}
