package tool;

import java.awt.Color;
import java.awt.Component;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

import structure.File_and_Directory_Address;
import structure.Struct_AbstractAction;


public class Tool_CellRenderer extends DefaultTreeCellRenderer {

//	ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();

	public Component getTreeCellRendererComponent(JTree tree,Object value,
													boolean isSelected,
													boolean expanded,
													boolean leaf,
													int row,
													boolean hasFoucus){

		
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
		Object obj = node.getUserObject();

		if(isSelected){
			setForeground(Color.black);
			setBackground(Color.lightGray);
		}else{
			setForeground(Color.black);
			setBackground(Color.white);
		}
		
		TreePath path = tree.getPathForRow(row);
		
		//************************************************
		//* プロジェクト
		//************************************************
		if(path != null && path.getPathCount() == 2){
			//参加プロジェクトの取得
			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
												addr.getFile_project_info());
			tep.loadXml();
			Icon icon;
			if(tep.liveProject(node.getUserObject().toString())){
				icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_project());
			}else{
				icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_dead_suffix()+addr.getIcon_project());
			}
			
			setIcon(icon);
			setText((String) obj);
			setOpaque(true);
			
			return(this);
		}
		//************************************************
		//* コミュニティ
		//************************************************
		else if(path != null && path.getPathCount() == 4 && 
					((DefaultMutableTreeNode) node.getParent()).getUserObject().toString().equals("Community")){
			DefaultMutableTreeNode communitynode = (DefaultMutableTreeNode) node.getParent();
			DefaultMutableTreeNode projectnode = (DefaultMutableTreeNode) communitynode.getParent();

			//参加プロジェクトの取得
			Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(addr.getDir_current() + 
												addr.getFile_project_info());
			tep.loadXml();
			Icon icon;
			
			//* プロジェクトから離脱状態の場合は、すべて非参加とする
			if(tep.liveProject(projectnode.getUserObject().toString()) == false){
				icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_dead_suffix()+addr.getIcon_community());
				setIcon(icon);
				setText((String) obj);
				setOpaque(true);
				
				return(this);
			}
			
			//参加コミュニティかを確認
			Tool_JList_IO tls;
	   		String com_sel_file 	=	addr.getDir_current() + 
										addr.getDir_project() +
										projectnode.getUserObject()  +
										addr.getFile_com_select();
			tls = new Tool_JList_IO(com_sel_file);	
			String[] comary =  tls.loadXml2();
			boolean found = false;
			for(int i=0;i<comary.length;i++){
				if(node.getUserObject().equals(comary[i])){
					found = true;
					break;
				}
			}

			if(found == true){
				//コミュニティは参加中
				icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_community());
			}else{
				//コミュニティは非参加中
				icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_dead_suffix()+addr.getIcon_community());
			}
			
			setIcon(icon);
			setText((String) obj);
			setOpaque(true);
			
			return(this);
		}
		//************************************************
		//* コスト	send
		//************************************************
		else if(node.getUserObject().toString().equals(addr.getNode_send()) &&
				path != null && path.getPathCount() == 4 && 
				((DefaultMutableTreeNode) node.getParent()).getUserObject().toString().equals(addr.getNode_cost())){
			Icon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_sendcost());
			
			setIcon(icon);
			setText((String) obj);
			setOpaque(true);
			
			return(this);
		}
		//************************************************
		//* コスト	recieve
		//************************************************
		else if(node.getUserObject().toString().equals(addr.getNode_recive()) &&
				path != null && path.getPathCount() == 4 && 
				((DefaultMutableTreeNode) node.getParent()).getUserObject().toString().equals(addr.getNode_cost())){
			Icon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_recievecost());
			
			setIcon(icon);
			setText((String) obj);
			setOpaque(true);
			
			return(this);
		}
		//************************************************
		//* コスト	analysis
		//************************************************
		else if(node.getUserObject().toString().equals(addr.getNode_analysis()) &&
				path != null && path.getPathCount() == 4 && 
				((DefaultMutableTreeNode) node.getParent()).getUserObject().toString().equals(addr.getNode_cost())){
			Icon icon = new ImageIcon(addr.getDir_current() + addr.getDir_icon()+addr.getIcon_analysiscost());
			
			setIcon(icon);
			setText((String) obj);
			setOpaque(true);
			
			return(this);
		}
		
/*		
		if(obj instanceof Struct_AbstractAction){
			Struct_AbstractAction action = (Struct_AbstractAction)obj;
			setText((String)action.getValue(action.NAME));
			setIcon((Icon)action.getValue(action.SMALL_ICON));
			setOpaque(true);
			
			if(isSelected){
				setForeground(Color.red);
				setBackground(Color.cyan);
			}else{
				setForeground(Color.black);
				setBackground(Color.white);
			}
			return(this);
		}
*/		
		Component comp = super.getTreeCellRendererComponent(tree, value, isSelected, 
												expanded, leaf, row, hasFoucus);
		return comp;
	
	}
	
}
