package tool;

import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import javax.swing.table.DefaultTableModel;

import mailcost_main.Tool_JTable_IO;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_System_Config;

public class Tool_Community_Diject_Status_Update {


	String project;			//プロジェクト
	String community;		//コミュニティ
	long nowtime;			//送信日時
	int send_number;		//送信番号

	String send_number_string;	//送信番号
	String send_userid;			//送信ユーザーＩＤ

	
	String status_sended = "完送";
	String status_notsend = "未送";
	String status_notread = "未読";
	String status_notevaluate = "未評";
	String status_evaluated = "完評";
	
	
	File[] files;

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address ();

	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();
	
	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	
	//コンストラクタ　ステータス提供用
	public Tool_Community_Diject_Status_Update(){
	}

	
	
	public Tool_Community_Diject_Status_Update(String project,String community,long nowtime,int send_number){
		this.project = project;
		this.community = community;
		this.nowtime = nowtime;
		this.send_number = send_number;
		
    	//送信日付のフォーマット変換
    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
    	//送信番号のフォーマット変換
    	DecimalFormat df = new DecimalFormat("00000");

    	String dir = addr.getDir_current() + addr.getDir_buff_send();
    	String prefix = dfm.format(nowtime) + "_" +df.format(send_number) ;

    	File fl = new File(dir);

    	Tool_FileFilter ff = new Tool_FileFilter();
    	ff.setPrefix(prefix);
    	ff.setSuffix(addr.getFile_digest());	
    	
    	files = fl.listFiles(ff);
	
	}
	
	public void sendCheck(){
		//送信済み：送信バッファからダイジェストが削除
		
		if(files.length == 0){
   			//ダイジェスト更新
			status_Update(status_sended);
		}
		else if(files.length > 0){
			status_Update(status_notsend);
			
		}
		
	}

	
	
	private void status_Update(String status){
    	Struct_Community_Digest com_dig_data = new Struct_Community_Digest();			
		String[] columnames = com_dig_data.getColData();
    	Tool_JTable_IO t = new Tool_JTable_IO (addr.getDir_current() + 
    											addr.getDir_project()+
    											project + addr.getFs() + 
    											community + 
    											addr.getFile_community_digest());
    	t.putColum(columnames);
    	t.loadXml();

    	
    	for(int i = 0;i< t.getTableCount();i++){
    		//１行を取得してダイジェスト構造体に変換
    		com_dig_data.setArryData((String[])t.getData(i));
 
    		//チェック対象の送信番号を取得？
    		if(send_number	==	Integer.valueOf(com_dig_data.getSendnumber()).intValue()){
    			com_dig_data.setStatus(status);
        		//ダイジェスト構造体を配列に変換してテーブルに格納
    			t.replaceData(i,(String[])com_dig_data.getArryData());
    			break;
    		}
    	}
    	t.saveXml2();		
	}

	
	
	//************************************************************************
	//ステータス更新 セットで使うこと！！！
	//************************************************************************
	public Tool_Community_Diject_Status_Update(String project,
												String community,
												String send_userid,
												String send_number){
		this.project 				= project;
		this.community 				= community;
		this.send_userid			= send_userid;
		this.send_number_string		= send_number;
		
	}
	public  void status_change(String status){
    	Struct_Community_Digest com_dig_data = new Struct_Community_Digest();			
		String[] columnames = com_dig_data.getColData();
    	Tool_JTable_IO t = new Tool_JTable_IO (addr.getDir_current() + 
    											addr.getDir_project()+
    											project + addr.getFs() + 
    											community + 
    											addr.getFile_community_digest());
    	t.putColum(columnames);
    	t.loadXml();
    	
    	for(int i = 0;i< t.getTableCount();i++){
    		//１行を取得してダイジェスト構造体に変換
    		com_dig_data.setArryData((String[])t.getData(i));
    		
    		
    		//チェック対象の送信番号を取得？
    		if(send_number_string.equals(com_dig_data.getSendnumber()) &&
    				send_userid.equals(com_dig_data.getUserid())	){
    			com_dig_data.setStatus(status);
        		//ダイジェスト構造体を配列に変換してテーブルに格納
    			t.replaceData(i,(String[])com_dig_data.getArryData());
    			break;
    		}
    	}
    	t.saveXml2();		
	}
	
	
	
	
	
	//ゲッター
	public String getStatus_evaluated() {
		return status_evaluated;
	}
	public String getStatus_notevaluate() {
		return status_notevaluate;
	}
	public String getStatus_notread() {
		return status_notread;
	}
	public String getStatus_notsend() {
		return status_notsend;
	}
	public String getStatus_sended() {
		return status_sended;
	}
}
