package tool;

import java.beans.XMLDecoder;
import java.io.*;
import java.util.ArrayList;

import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_System_Config;

public class Tool_Community_Menber_IO {

	String				filename;
	
	String[]			columnames;

//	ArrayList<Struct_Cost_Digest> array_Cost_Digest;
	ArrayList array_Community_Menber;
	
	boolean blnload = false;

	
	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();

	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	
	public Tool_Community_Menber_IO(String filename){
		this.filename=filename;

	
	}

	public void putColum(String[] columnames){
		this.columnames = columnames;
	}

	
	//ロード	
	public void loadXml(){
		FileInputStream is = null;
		BufferedInputStream bis = null;
		XMLDecoder xml = null;

		File fl = new File(filename);

		//初回は保存データがない
		if(fl.exists()==false){
			array_Community_Menber = new ArrayList();
			blnload = true;
			return;
		}
		

		 try {
			 is = new FileInputStream(filename);
			 bis = new BufferedInputStream(is);
			 xml = new XMLDecoder(bis);

		   		Object data[][] ;
		   		
		   		data = (Object[][])xml.readObject();
		   		array_Community_Menber = new  ArrayList();
				for(int i=0;i<data.length;i++){	
					Struct_Community_Menber scd = new Struct_Community_Menber();
				
					scd.setCommunity(data[i][0].toString());
					scd.setUserid(data[i][1].toString());
					scd.setUser_fullname(data[i][2].toString());
					try {
						scd.setNode(data[i][3].toString());
					} catch (NullPointerException s) {
						//AllMenberはノードがNULLのための措置
					}
					
					array_Community_Menber.add(scd);
				}

			 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
			}
		}
		blnload = true;
	}
	


	
	
	public ArrayList getdata(){

		if(blnload == false){
			loadXml();
		}
		

		return array_Community_Menber;
	}

/*	public  void putdata(ArrayList array_Cost_Digest){
		this.array_Cost_Digest = array_Cost_Digest;
		return;
	}
*/
	
	public ArrayList getCommunity(String menber){
		if(array_Community_Menber == null || array_Community_Menber.size() == 0){
			return null;
		}
		ArrayList dummy = new ArrayList();
		for(int i=0 ; i<array_Community_Menber.size() ; i++){
			String data = ((Struct_Community_Menber)array_Community_Menber.get(i)).getUserid();
			if(data.equals(menber)){
				dummy.add(array_Community_Menber.get(i));
			}
		}
		return dummy;
	}
	
	//本番時の標準出力、エラー出力を抽出
	public void setStandard(){
		if(sysconfig.isTestmode() == false){
			  try {
					System.setOut(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stdout(), true))); 
					System.setErr(new PrintStream(new java.io.FileOutputStream(addr.getDir_current() + addr.getFile_stderr(), true))); 
					
			  } catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());

			  }
		}
	}	
	
}
