package tool;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;


import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_System_Config;


public class Tool_Community_digest_ALL_IO {

	String project;
	
	ArrayList arrayy_scd = new ArrayList();

	//ファイル＆ディレクトリ取得
	File_and_Directory_Address addr = new File_and_Directory_Address();
	
	//モード取得
	Struct_System_Config  sysconfig = new Tool_System_Config_IO(addr.getDir_current()+addr.getFile_config()).getStruct_System_Config();

	//ログ出力
	Tool_LogOut logout = new Tool_LogOut(addr.getDir_current()+addr.getFile_log());
	
	//初期化用
	public Tool_Community_digest_ALL_IO(){
	}

	public Tool_Community_digest_ALL_IO(String project){
		this.project 	= project;
	}
	
	
	public void loadXml(){
		String 	filedir			=	addr.getDir_current() + addr.getDir_project();
		
		Tool_JList_IO tls;
   		String com_all_file 	=	filedir + project  + addr.getFile_com_all();

		tls = new Tool_JList_IO(com_all_file);	
		String[] community =  tls.loadXml2();

		for(int i=0 ; i<community.length ; i++){
			//コミュニティに参加中もしくは過去参加してメールが残っている可能性がある
			//コミュニティを対象とする。
			//つまりコミュニティディレクトリが存在する場合は対象とする
			String communityDir = filedir + project + addr.getFs() + community[i];
			File file = new File(communityDir);
			if(file.exists() == false || file.isDirectory() == false){
				continue;
			}

			String filename = communityDir + addr.getFile_community_digest();

			FileInputStream is = null;
			BufferedInputStream bis = null;
			XMLDecoder xml = null;

			File fl = new File(filename);
			
			//初回は保存データがない
			if(fl.exists()==false){
				continue;
			}
			
			try {
				is = new FileInputStream(filename);
				bis = new BufferedInputStream(is);
				xml = new XMLDecoder(bis);
			
				Object data[][] ;
				data = (Object[][])xml.readObject();
			
				//コミュニティダイジェストのレコード取得
				for(int j=0 ; j<data.length ; j++){
					Struct_Community_Digest	scd = new Struct_Community_Digest();
			
					scd.setStatus((String) data[j][0]);			// 1.状態
					scd.setSender((String) data[j][1]);			// 2.差出人
					scd.setSendnumber((String) data[j][2]);		// 3.送信ナンバー
					scd.setSubject((String) data[j][3]);		// 4.件名
					scd.setSend_date((String) data[j][4]);		// 5.送信日時		
					scd.setText_size((String) data[j][5]);		// 6.本文サイズ
					scd.setUserid((String) data[j][6]);			// 7.送信ユーザーＩＤ
					scd.setNode((String) data[j][7]);			// 8.送信ノード	
					scd.setCommunity((String) data[j][8]);		// 9.送信コミュニティ名称
					scd.setProject((String) data[j][9]);			//10.送信プロジェクト名称
					scd.setFilename((String) data[j][10]);		//11.送信ファイル名称
					scd.setSendcost((String) data[j][11]);		//12.送信コスト
					scd.setReciever_count((String) data[j][12]);	//13.受信者数
			
					arrayy_scd.add(scd);
				}
				//コミュニティダイジェストループ終端
			
			
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getMessage());
				logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e.getStackTrace());
			}finally{
				try{
					xml.close();
				} catch(Exception e2){
					e2.printStackTrace();
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getMessage());
					logout.out(sysconfig.getLogmode1(),this.getClass().getName() , e2.getStackTrace());
				}
			}   			

		}
		//communityループ終端
	
	}

	public Struct_Community_Digest getCommunity_Digest(String userid,String number){
		for(int i=0 ; i<arrayy_scd.size() ; i++  ){
			Struct_Community_Digest scd = (Struct_Community_Digest)arrayy_scd.get(i);
			if(userid.equals(scd.getUserid()) &&
				number.equals(scd.getSendnumber())){
				return scd;
				
			}
		}
		return null;
	}
	
	public Struct_Community_Digest getCommunity_Digest(String userid,int number){
		
		for(int i=0 ; i<arrayy_scd.size() ; i++  ){
			Struct_Community_Digest scd = (Struct_Community_Digest)arrayy_scd.get(i);
			if(userid.equals(scd.getUserid()) &&
				number == scd.getSendnumber_integer()){
				return scd;
				
			}
		}
		return null;
	}
	
}
